/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.Session;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.SqlDate;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestDate {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testLiteral() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DATE '2001-1-22'")))).hasType((Type)DateType.DATE).isEqualTo(TestDate.toDate(new DateTime(2001, 1, 22, 0, 0, DateTimeZone.UTC)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DATE '2013-02-02'")))).hasType((Type)DateType.DATE).isEqualTo(TestDate.toDate(new DateTime(2013, 2, 2, 0, 0, 0, 0, DateTimeZone.UTC)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DATE '2013-2-02'")))).hasType((Type)DateType.DATE).isEqualTo(TestDate.toDate(new DateTime(2013, 2, 2, 0, 0, 0, 0, DateTimeZone.UTC)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DATE '2013-02-2'")))).hasType((Type)DateType.DATE).isEqualTo(TestDate.toDate(new DateTime(2013, 2, 2, 0, 0, 0, 0, DateTimeZone.UTC)));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("DATE '2013-02-002'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL}).hasMessage("line 1:12: '2013-02-002' is not a valid DATE literal");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("DATE '2013-002-02'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL}).hasMessage("line 1:12: '2013-002-02' is not a valid DATE literal");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DATE '02013-02-02'")))).hasType((Type)DateType.DATE).isEqualTo(TestDate.toDate(new DateTime(2013, 2, 2, 0, 0, 0, 0, DateTimeZone.UTC)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DATE '0013-02-02'")))).hasType((Type)DateType.DATE).isEqualTo(TestDate.toDate(new DateTime(13, 2, 2, 0, 0, 0, 0, DateTimeZone.UTC)));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("DATE '2013-02-29'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL}).hasMessage("line 1:12: '2013-02-29' is not a valid DATE literal");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DATE '  2013-02-02  '")))).hasType((Type)DateType.DATE).isEqualTo(TestDate.toDate(new DateTime(2013, 2, 2, 0, 0, 0, 0, DateTimeZone.UTC)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DATE ' \t\n\u000b\f\r\u001c\u001d\u001e\u001f 2013-02-02 \t\n\u000b\f\n\u001c\u001d\u001e\u001f '")))).hasType((Type)DateType.DATE).isEqualTo(TestDate.toDate(new DateTime(2013, 2, 2, 0, 0, 0, 0, DateTimeZone.UTC)));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("DATE '2013 -02-02'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL}).hasMessage("line 1:12: '2013 -02-02' is not a valid DATE literal");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("DATE '2013- 2-02'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL}).hasMessage("line 1:12: '2013- 2-02' is not a valid DATE literal");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("DATE '5881580-07-12'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL}).hasMessage("line 1:12: '5881580-07-12' is not a valid DATE literal");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("DATE '392251590-07-12'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL}).hasMessage("line 1:12: '392251590-07-12' is not a valid DATE literal");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DATE '+2013-02-02'")))).hasType((Type)DateType.DATE).isEqualTo(TestDate.toDate(new DateTime(2013, 2, 2, 0, 0, 0, 0, DateTimeZone.UTC)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DATE '-2013-02-02'")))).hasType((Type)DateType.DATE).isEqualTo(TestDate.toDate(new DateTime(-2013, 2, 2, 0, 0, 0, 0, DateTimeZone.UTC)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DATE ' +2013-02-02'")))).hasType((Type)DateType.DATE).isEqualTo(TestDate.toDate(new DateTime(2013, 2, 2, 0, 0, 0, 0, DateTimeZone.UTC)));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("DATE '+ 2013-02-02'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL}).hasMessage("line 1:12: '+ 2013-02-02' is not a valid DATE literal");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("DATE ' + 2013-02-02'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL}).hasMessage("line 1:12: ' + 2013-02-02' is not a valid DATE literal");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DATE ' -2013-02-02'")))).hasType((Type)DateType.DATE).isEqualTo(TestDate.toDate(new DateTime(-2013, 2, 2, 0, 0, 0, 0, DateTimeZone.UTC)));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("DATE '- 2013-02-02'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL}).hasMessage("line 1:12: '- 2013-02-02' is not a valid DATE literal");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.expression("DATE ' - 2013-02-02'")::evaluate).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL}).hasMessage("line 1:12: ' - 2013-02-02' is not a valid DATE literal");
    }

    @Test
    public void testEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DATE '2001-1-22'", "DATE '2001-1-22'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DATE '2001-1-22'", "DATE '2001-1-22'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DATE '2001-1-22'", "DATE '2001-1-23'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DATE '2001-1-22'", "DATE '2001-1-11'")))).isEqualTo(false);
    }

    @Test
    public void testNotEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "DATE '2001-1-22'").binding("b", "DATE '2001-1-23'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "DATE '2001-1-22'").binding("b", "DATE '2001-1-11'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a <> b").binding("a", "DATE '2001-1-22'").binding("b", "DATE '2001-1-22'")))).isEqualTo(false);
    }

    @Test
    public void testLessThan() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DATE '2001-1-22'", "DATE '2001-1-23'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DATE '2001-1-22'", "DATE '2001-1-22'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DATE '2001-1-22'", "DATE '2001-1-20'")))).isEqualTo(false);
    }

    @Test
    public void testLessThanOrEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DATE '2001-1-22'", "DATE '2001-1-22'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DATE '2001-1-22'", "DATE '2001-1-23'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN_OR_EQUAL, "DATE '2001-1-22'", "DATE '2001-1-20'")))).isEqualTo(false);
    }

    @Test
    public void testGreaterThan() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DATE '2001-1-22'").binding("b", "DATE '2001-1-11'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DATE '2001-1-22'").binding("b", "DATE '2001-1-22'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DATE '2001-1-22'").binding("b", "DATE '2001-1-23'")))).isEqualTo(false);
    }

    @Test
    public void testGreaterThanOrEqual() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DATE '2001-1-22'").binding("b", "DATE '2001-1-22'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DATE '2001-1-22'").binding("b", "DATE '2001-1-11'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a >= b").binding("a", "DATE '2001-1-22'").binding("b", "DATE '2001-1-23'")))).isEqualTo(false);
    }

    @Test
    public void testBetween() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DATE '2001-1-22'").binding("low", "DATE '2001-1-11'").binding("high", "DATE '2001-1-23'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DATE '2001-1-22'").binding("low", "DATE '2001-1-11'").binding("high", "DATE '2001-1-22'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DATE '2001-1-22'").binding("low", "DATE '2001-1-22'").binding("high", "DATE '2001-1-23'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DATE '2001-1-22'").binding("low", "DATE '2001-1-22'").binding("high", "DATE '2001-1-22'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DATE '2001-1-22'").binding("low", "DATE '2001-1-11'").binding("high", "DATE '2001-1-12'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DATE '2001-1-22'").binding("low", "DATE '2001-1-23'").binding("high", "DATE '2001-1-24'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("value BETWEEN low AND high").binding("value", "DATE '2001-1-22'").binding("low", "DATE '2001-1-23'").binding("high", "DATE '2001-1-11'")))).isEqualTo(false);
    }

    @Test
    public void testCastToTimestamp() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as timestamp)").binding("a", "DATE '2001-1-22'")))).matches("TIMESTAMP '2001-01-22 00:00:00.000'");
    }

    @Test
    public void testCastToTimestampWithTimeZone() {
        Session session = TestingSession.testSessionBuilder().setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)"Europe/Berlin")).build();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(DATE '2001-1-22' AS timestamp with time zone)", session)))).matches("TIMESTAMP '2001-01-22 00:00:00.000 Europe/Berlin'");
    }

    @Test
    public void testCastToVarchar() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar)").binding("a", "DATE '2001-1-22'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("2001-01-22");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar)").binding("a", "DATE '2013-02-02'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("2013-02-02");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar)").binding("a", "DATE '13-2-2'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("0013-02-02");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar(50))").binding("a", "DATE '2013-02-02'")))).hasType((Type)VarcharType.createVarcharType((int)50)).isEqualTo("2013-02-02");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar(10))").binding("a", "DATE '2013-02-02'")))).hasType((Type)VarcharType.createVarcharType((int)10)).isEqualTo("2013-02-02");
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as varchar(9))").binding("a", "DATE '2013-02-02'").evaluate()).hasMessage("Value 2013-02-02 cannot be represented as varchar(9)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testCastFromVarchar() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as date)").binding("a", "'2001-1-22'")))).matches("DATE '2001-01-22'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as date)").binding("a", "'\n\t 2001-1-22'")))).matches("DATE '2001-01-22'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as date)").binding("a", "'2001-1-22 \t\n'")))).matches("DATE '2001-01-22'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as date)").binding("a", "'\n\t 2001-1-22 \t\n'")))).matches("DATE '2001-01-22'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as date)").binding("a", "'2013-02-02'")))).matches("DATE '2013-02-02'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as date)").binding("a", "'2013-2-02'")))).matches("DATE '2013-02-02'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as date)").binding("a", "'2013-02-2'")))).matches("DATE '2013-02-02'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as date)").binding("a", "'2013-02-002'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT}).hasMessage("Value cannot be cast to date: 2013-02-002");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as date)").binding("a", "'2013-002-02'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT}).hasMessage("Value cannot be cast to date: 2013-002-02");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as date)").binding("a", "'02013-02-02'")))).matches("DATE '2013-02-02'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as date)").binding("a", "'0013-02-02'")))).matches("DATE '13-02-02'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as date)").binding("a", "'2013-02-29'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT}).hasMessage("Value cannot be cast to date: 2013-02-29");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as date)").binding("a", "'  2013-02-02  '")))).matches("DATE '2013-02-02'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as date)").binding("a", "' \t\n\u000b\f\r\u001c\u001d\u001e\u001f 2013-02-02 \t\n\u000b\f\n\u001c\u001d\u001e\u001f '")))).matches("DATE '2013-02-02'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as date)").binding("a", "'2013 -02-02'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT}).hasMessage("Value cannot be cast to date: 2013 -02-02");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as date)").binding("a", "'2013- 2-02'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT}).hasMessage("Value cannot be cast to date: 2013- 2-02");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as date)").binding("a", "'5881580-07-12'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT}).hasMessage("Value cannot be cast to date: 5881580-07-12");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as date)").binding("a", "'392251590-07-12'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT}).hasMessage("Value cannot be cast to date: 392251590-07-12");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as date)").binding("a", "'+2013-02-02'")))).matches("DATE '2013-02-02'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as date)").binding("a", "'-2013-02-02'")))).matches("DATE '-2013-02-02'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as date)").binding("a", "' +2013-02-02'")))).matches("DATE '2013-02-02'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as date)").binding("a", "'+ 2013-02-02'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT}).hasMessage("Value cannot be cast to date: + 2013-02-02");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as date)").binding("a", "' + 2013-02-02'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT}).hasMessage("Value cannot be cast to date:  + 2013-02-02");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as date)").binding("a", "' -2013-02-02'")))).matches("DATE '-2013-02-02'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as date)").binding("a", "'- 2013-02-02'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT}).hasMessage("Value cannot be cast to date: - 2013-02-02");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as date)").binding("a", "' - 2013-02-02'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT}).hasMessage("Value cannot be cast to date:  - 2013-02-02");
    }

    @Test
    public void testGreatest() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "DATE '2013-03-30'", "DATE '2012-05-23'")))).matches("DATE '2013-03-30'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("greatest", "DATE '2013-03-30'", "DATE '2012-05-23'", "DATE '2012-06-01'")))).matches("DATE '2013-03-30'");
    }

    @Test
    public void testLeast() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "DATE '2013-03-30'", "DATE '2012-05-23'")))).matches("DATE '2012-05-23'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("least", "DATE '2013-03-30'", "DATE '2012-05-23'", "DATE '2012-06-01'")))).matches("DATE '2012-05-23'");
    }

    @Test
    public void testIndeterminate() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "CAST(NULL AS DATE)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "DATE '2013-10-27'")))).isEqualTo(false);
    }

    @Test
    public void testIdentical() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IDENTICAL, "CAST(NULL AS DATE)", "CAST(NULL AS DATE)")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IDENTICAL, "DATE '2013-10-27'", "TIMESTAMP '2013-10-27 00:00:00'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IDENTICAL, "DATE '2013-10-27'", "TIMESTAMP '2013-10-28 00:00:00'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IDENTICAL, "NULL", "DATE '2013-10-27'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IDENTICAL, "DATE '2013-10-27'", "NULL")))).isEqualTo(false);
    }

    @Test
    public void testDateToTimestampCoercing() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "DATE '2013-10-27'", "TIMESTAMP '2013-10-27 00:00:00'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.LESS_THAN, "DATE '2013-10-27'", "TIMESTAMP '2013-10-27 00:00:01'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a > b").binding("a", "DATE '2013-10-27'").binding("b", "TIMESTAMP '2013-10-26 23:59:59'")))).isEqualTo(true);
    }

    @Test
    public void testDateToTimestampWithZoneCoercing() {
        Session session = this.assertions.sessionBuilder().setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)"Europe/Berlin")).build();
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DATE '2013-10-27' = TIMESTAMP '2013-10-27 00:00:00 Europe/Berlin'", session)))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DATE '2013-10-27' < TIMESTAMP '2013-10-27 00:00:01 Europe/Berlin'", session)))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("DATE '2013-10-27' > TIMESTAMP '2013-10-26 23:59:59 Europe/Berlin'", session)))).isEqualTo(true);
    }

    @Test
    public void testMinusInterval() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.SUBTRACT, "DATE '2001-1-22'", "INTERVAL '3' day")))).matches("DATE '2001-01-19'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.SUBTRACT, "DATE '2001-1-22'", "INTERVAL '3' hour")::evaluate).hasMessage("Cannot subtract hour, minutes or seconds from a date");
    }

    @Test
    public void testPlusInterval() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "DATE '2001-1-22'", "INTERVAL '3' day")))).matches("DATE '2001-01-25'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "INTERVAL '3' day", "DATE '2001-1-22'")))).matches("DATE '2001-01-25'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "DATE '2001-1-22'", "INTERVAL '3' month")))).matches("DATE '2001-04-22'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "INTERVAL '3' month", "DATE '2001-1-22'")))).matches("DATE '2001-04-22'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "DATE '2001-1-22'", "INTERVAL '3' year")))).matches("DATE '2004-01-22'");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.ADD, "INTERVAL '3' year", "DATE '2001-1-22'")))).matches("DATE '2004-01-22'");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.ADD, "DATE '2001-1-22'", "INTERVAL '3' hour")::evaluate).hasMessage("Cannot add hour, minutes or seconds to a date");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(this.assertions.operator(OperatorType.ADD, "INTERVAL '3' hour", "DATE '2001-1-22'")::evaluate).hasMessage("Cannot add hour, minutes or seconds to a date");
    }

    private static SqlDate toDate(DateTime dateTime) {
        return new SqlDate((int)TimeUnit.MILLISECONDS.toDays(dateTime.getMillis()));
    }
}

