/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.ParameterExtractor;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.ViewColumn;
import io.trino.metadata.ViewDefinition;
import io.trino.metadata.ViewPropertyManager;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.CatalogHandle;
import io.trino.sql.PlannerContext;
import io.trino.sql.SqlFormatterUtil;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.AnalyzerFactory;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.tree.CreateView;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CreateViewTask
implements DataDefinitionTask<CreateView> {
    private final PlannerContext plannerContext;
    private final AccessControl accessControl;
    private final SqlParser sqlParser;
    private final AnalyzerFactory analyzerFactory;
    private final ViewPropertyManager viewPropertyManager;

    @Inject
    public CreateViewTask(PlannerContext plannerContext, AccessControl accessControl, SqlParser sqlParser, AnalyzerFactory analyzerFactory, ViewPropertyManager viewPropertyManager) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.analyzerFactory = Objects.requireNonNull(analyzerFactory, "analyzerFactory is null");
        this.viewPropertyManager = Objects.requireNonNull(viewPropertyManager, "viewPropertyManager is null");
    }

    @Override
    public String getName() {
        return "CREATE VIEW";
    }

    @Override
    public ListenableFuture<Void> execute(CreateView statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Metadata metadata = this.plannerContext.getMetadata();
        Map<NodeRef<Parameter>, Expression> parameterLookup = ParameterExtractor.bindParameters((Statement)statement, parameters);
        Session session = stateMachine.getSession();
        QualifiedObjectName name = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName());
        this.accessControl.checkCanCreateView(session.toSecurityContext(), name);
        if (metadata.isMaterializedView(session, name)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_ALREADY_EXISTS, (Node)statement, "Materialized view already exists: '%s'", name);
        }
        if (metadata.isView(session, name)) {
            if (!statement.isReplace()) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_ALREADY_EXISTS, (Node)statement, "View already exists: '%s'", name);
            }
        } else if (metadata.getTableHandle(session, name).isPresent()) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_ALREADY_EXISTS, (Node)statement, "Table already exists: '%s'", name);
        }
        String sql = SqlFormatterUtil.getFormattedSql((Statement)statement.getQuery(), this.sqlParser);
        Analysis analysis = this.analyzerFactory.createAnalyzer(session, parameters, parameterLookup, stateMachine.getWarningCollector(), stateMachine.getPlanOptimizersStatsCollector()).analyze((Statement)statement);
        List columns = (List)analysis.getOutputDescriptor((Node)statement.getQuery()).getVisibleFields().stream().map(field -> new ViewColumn(field.getName().get(), field.getType().getTypeId(), Optional.empty())).collect(ImmutableList.toImmutableList());
        Optional<Object> owner = Optional.of(session.getIdentity());
        if (statement.getSecurity().orElse(null) == CreateView.Security.INVOKER) {
            owner = Optional.empty();
        }
        String catalogName = name.catalogName();
        CatalogHandle catalogHandle = MetadataUtil.getRequiredCatalogHandle(metadata, session, (Node)statement, catalogName);
        Map properties = this.viewPropertyManager.getProperties(name.catalogName(), catalogHandle, (Iterable)statement.getProperties(), session, this.plannerContext, this.accessControl, (Map)parameterLookup, true);
        ViewDefinition definition = new ViewDefinition(sql, session.getCatalog(), session.getSchema(), columns, statement.getComment(), owner, (List)session.getPath().getPath().stream().filter(element -> !element.getCatalogName().equals("system")).collect(ImmutableList.toImmutableList()));
        metadata.createView(session, name, definition, properties, statement.isReplace());
        stateMachine.setOutput(analysis.getTarget());
        stateMachine.setReferencedTables(analysis.getReferencedTables());
        return Futures.immediateVoidFuture();
    }
}

