/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import io.airlift.compress.v3.Compressor;
import io.airlift.compress.v3.Decompressor;
import io.airlift.compress.v3.lz4.Lz4Compressor;
import io.airlift.compress.v3.lz4.Lz4Decompressor;
import io.airlift.compress.v3.zstd.ZstdCompressor;
import io.airlift.compress.v3.zstd.ZstdDecompressor;
import io.trino.execution.buffer.CompressionCodec;
import io.trino.execution.buffer.PageDeserializer;
import io.trino.execution.buffer.PageSerializer;
import io.trino.spi.block.BlockEncodingSerde;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import javax.crypto.SecretKey;

public class PagesSerdeFactory {
    private static final int SERIALIZED_PAGE_DEFAULT_BLOCK_SIZE_IN_BYTES = 65536;
    private static final Map<CompressionCodec, OptionalInt> MAX_COMPRESSED_LENGTH = Map.of(CompressionCodec.NONE, CompressionCodec.NONE.maxCompressedLength(65536), CompressionCodec.LZ4, CompressionCodec.LZ4.maxCompressedLength(65536), CompressionCodec.ZSTD, CompressionCodec.ZSTD.maxCompressedLength(65536));
    private final BlockEncodingSerde blockEncodingSerde;
    private final CompressionCodec compressionCodec;

    public PagesSerdeFactory(BlockEncodingSerde blockEncodingSerde, CompressionCodec compressionCodec) {
        this.blockEncodingSerde = Objects.requireNonNull(blockEncodingSerde, "blockEncodingSerde is null");
        this.compressionCodec = Objects.requireNonNull(compressionCodec, "compressionCodec is null");
    }

    public PageSerializer createSerializer(Optional<SecretKey> encryptionKey) {
        return new PageSerializer(this.blockEncodingSerde, PagesSerdeFactory.createCompressor(this.compressionCodec), encryptionKey, 65536, MAX_COMPRESSED_LENGTH.get((Object)this.compressionCodec));
    }

    public PageDeserializer createDeserializer(Optional<SecretKey> encryptionKey) {
        return new PageDeserializer(this.blockEncodingSerde, PagesSerdeFactory.createDecompressor(this.compressionCodec), encryptionKey, 65536, MAX_COMPRESSED_LENGTH.get((Object)this.compressionCodec));
    }

    public static Optional<Compressor> createCompressor(CompressionCodec compressionCodec) {
        return switch (compressionCodec) {
            default -> throw new MatchException(null, null);
            case CompressionCodec.NONE -> Optional.empty();
            case CompressionCodec.LZ4 -> Optional.of(Lz4Compressor.create());
            case CompressionCodec.ZSTD -> Optional.of(ZstdCompressor.create());
        };
    }

    public static Optional<Decompressor> createDecompressor(CompressionCodec compressionCodec) {
        return switch (compressionCodec) {
            default -> throw new MatchException(null, null);
            case CompressionCodec.NONE -> Optional.empty();
            case CompressionCodec.LZ4 -> Optional.of(Lz4Decompressor.create());
            case CompressionCodec.ZSTD -> Optional.of(ZstdDecompressor.create());
        };
    }
}

