/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.resourcegroups;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.math.LongMath;
import com.google.errorprone.annotations.ThreadSafe;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.airlift.stats.CounterStat;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.SystemSessionProperties;
import io.trino.execution.ManagedQueryExecution;
import io.trino.execution.resourcegroups.FifoQueue;
import io.trino.execution.resourcegroups.IndexedPriorityQueue;
import io.trino.execution.resourcegroups.QueryQueueFullException;
import io.trino.execution.resourcegroups.Queue;
import io.trino.execution.resourcegroups.ResourceUsage;
import io.trino.execution.resourcegroups.StochasticPriorityQueue;
import io.trino.execution.resourcegroups.UpdateablePriorityQueue;
import io.trino.execution.resourcegroups.WeightedFairQueue;
import io.trino.server.QueryStateInfo;
import io.trino.server.ResourceGroupInfo;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.resourcegroups.ResourceGroup;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.resourcegroups.ResourceGroupState;
import io.trino.spi.resourcegroups.SchedulingPolicy;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@ThreadSafe
public class InternalResourceGroup
implements ResourceGroup {
    public static final int DEFAULT_WEIGHT = 1;
    private final InternalResourceGroup root;
    private final Optional<InternalResourceGroup> parent;
    private final ResourceGroupId id;
    private final BiConsumer<InternalResourceGroup, Boolean> jmxExportListener;
    private final Executor executor;
    @GuardedBy(value="root")
    private long softMemoryLimitBytes = Long.MAX_VALUE;
    @GuardedBy(value="root")
    private int softConcurrencyLimit;
    @GuardedBy(value="root")
    private int hardConcurrencyLimit;
    @GuardedBy(value="root")
    private int maxQueuedQueries;
    @GuardedBy(value="root")
    private long softCpuLimitMillis = Long.MAX_VALUE;
    @GuardedBy(value="root")
    private long hardCpuLimitMillis = Long.MAX_VALUE;
    @GuardedBy(value="root")
    private long cpuQuotaGenerationMillisPerSecond = Long.MAX_VALUE;
    @GuardedBy(value="root")
    private int schedulingWeight = 1;
    @GuardedBy(value="root")
    private SchedulingPolicy schedulingPolicy = SchedulingPolicy.FAIR;
    @GuardedBy(value="root")
    private boolean jmxExport;
    @GuardedBy(value="root")
    private boolean disabled;
    @GuardedBy(value="root")
    private final Map<String, InternalResourceGroup> subGroups = new HashMap<String, InternalResourceGroup>();
    @GuardedBy(value="root")
    private Queue<InternalResourceGroup> eligibleSubGroups = new FifoQueue<InternalResourceGroup>();
    @GuardedBy(value="root")
    private final Set<InternalResourceGroup> dirtySubGroups = new HashSet<InternalResourceGroup>();
    @GuardedBy(value="root")
    private UpdateablePriorityQueue<ManagedQueryExecution> queuedQueries = new FifoQueue<ManagedQueryExecution>();
    @GuardedBy(value="root")
    private final Map<ManagedQueryExecution, ResourceUsage> runningQueries = new HashMap<ManagedQueryExecution, ResourceUsage>();
    @GuardedBy(value="root")
    private int descendantRunningQueries;
    @GuardedBy(value="root")
    private int descendantQueuedQueries;
    @GuardedBy(value="root")
    private ResourceUsage cachedResourceUsage = new ResourceUsage(0L, 0L);
    @GuardedBy(value="root")
    private long lastStartMillis;
    private final CounterStat timeBetweenStartsSec = new CounterStat();

    public InternalResourceGroup(String name, BiConsumer<InternalResourceGroup, Boolean> jmxExportListener, Executor executor) {
        this(Optional.empty(), name, jmxExportListener, executor);
    }

    private InternalResourceGroup(Optional<InternalResourceGroup> parent, String name, BiConsumer<InternalResourceGroup, Boolean> jmxExportListener, Executor executor) {
        this.parent = Objects.requireNonNull(parent, "parent is null");
        this.jmxExportListener = Objects.requireNonNull(jmxExportListener, "jmxExportListener is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        Objects.requireNonNull(name, "name is null");
        if (parent.isPresent()) {
            this.id = new ResourceGroupId(parent.get().id, name);
            this.root = parent.get().root;
        } else {
            this.id = new ResourceGroupId(name);
            this.root = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceGroupInfo getFullInfo() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return new ResourceGroupInfo(this.id, this.getState(), this.schedulingPolicy, this.schedulingWeight, DataSize.succinctBytes((long)this.softMemoryLimitBytes), this.softConcurrencyLimit, this.hardConcurrencyLimit, this.maxQueuedQueries, DataSize.succinctBytes((long)this.cachedResourceUsage.getMemoryUsageBytes()), Duration.succinctDuration((double)this.cachedResourceUsage.getCpuUsageMillis(), (TimeUnit)TimeUnit.MILLISECONDS), this.getQueuedQueries(), this.getRunningQueries(), this.eligibleSubGroups.size(), Optional.of((List)this.subGroups.values().stream().filter(group -> group.getRunningQueries() + group.getQueuedQueries() > 0).map(InternalResourceGroup::getSummaryInfo).collect(ImmutableList.toImmutableList())), Optional.of(this.getAggregatedRunningQueriesInfo()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceGroupInfo getInfo() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return new ResourceGroupInfo(this.id, this.getState(), this.schedulingPolicy, this.schedulingWeight, DataSize.succinctBytes((long)this.softMemoryLimitBytes), this.softConcurrencyLimit, this.hardConcurrencyLimit, this.maxQueuedQueries, DataSize.succinctBytes((long)this.cachedResourceUsage.getMemoryUsageBytes()), Duration.succinctDuration((double)this.cachedResourceUsage.getCpuUsageMillis(), (TimeUnit)TimeUnit.MILLISECONDS), this.getQueuedQueries(), this.getRunningQueries(), this.eligibleSubGroups.size(), Optional.of((List)this.subGroups.values().stream().filter(group -> group.getRunningQueries() + group.getQueuedQueries() > 0).map(InternalResourceGroup::getSummaryInfo).collect(ImmutableList.toImmutableList())), Optional.empty());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceGroupInfo getSummaryInfo() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return new ResourceGroupInfo(this.id, this.getState(), this.schedulingPolicy, this.schedulingWeight, DataSize.succinctBytes((long)this.softMemoryLimitBytes), this.softConcurrencyLimit, this.hardConcurrencyLimit, this.maxQueuedQueries, DataSize.succinctBytes((long)this.cachedResourceUsage.getMemoryUsageBytes()), Duration.succinctDuration((double)this.cachedResourceUsage.getCpuUsageMillis(), (TimeUnit)TimeUnit.MILLISECONDS), this.getQueuedQueries(), this.getRunningQueries(), this.eligibleSubGroups.size(), Optional.empty(), Optional.empty());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceGroupState getState() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            if (this.canRunMore()) {
                return ResourceGroupState.CAN_RUN;
            }
            if (this.canQueueMore()) {
                return ResourceGroupState.CAN_QUEUE;
            }
            return ResourceGroupState.FULL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<QueryStateInfo> getAggregatedRunningQueriesInfo() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            List thisGroupRunningQueries = (List)this.runningQueries.keySet().stream().map(ManagedQueryExecution::getBasicQueryInfo).map(queryInfo -> QueryStateInfo.createQueryStateInfo(queryInfo, Optional.of(this.id))).collect(ImmutableList.toImmutableList());
            List subGroupsRunningQueries = (List)this.subGroups.values().stream().map(InternalResourceGroup::getAggregatedRunningQueriesInfo).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
            return ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)thisGroupRunningQueries, (Iterable)subGroupsRunningQueries));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResourceGroupInfo> getPathToRoot() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            ImmutableList.Builder builder = ImmutableList.builder();
            InternalResourceGroup group = this;
            while (group != null) {
                builder.add((Object)group.getInfo());
                group = group.parent.orElse(null);
            }
            return builder.build();
        }
    }

    public ResourceGroupId getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public int getRunningQueries() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.runningQueries.size() + this.descendantRunningQueries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public int getQueuedQueries() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.queuedQueries.size() + this.descendantQueuedQueries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public int getWaitingQueuedQueries() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            if (this.isLeafGroup()) {
                return this.queuedQueries.size();
            }
            int waitingQueuedQueries = 0;
            for (InternalResourceGroup subGroup : this.subGroups.values()) {
                if (!subGroup.canRunMore()) continue;
                waitingQueuedQueries += Math.min(subGroup.getQueuedQueries(), subGroup.getHardConcurrencyLimit() - subGroup.getRunningQueries());
            }
            return waitingQueuedQueries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueriesQueuedOnInternal() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            if (this.isLeafGroup()) {
                return Math.min(this.getQueuedQueries(), this.softConcurrencyLimit - this.getRunningQueries());
            }
            int queriesQueuedInternal = 0;
            for (InternalResourceGroup subGroup : this.subGroups.values()) {
                queriesQueuedInternal += subGroup.getQueriesQueuedOnInternal();
            }
            return queriesQueuedInternal;
        }
    }

    @Managed
    public long getCpuUsageMillis() {
        return this.getResourceUsageSnapshot().getCpuUsageMillis();
    }

    @Managed
    public long getMemoryUsageBytes() {
        return this.getResourceUsageSnapshot().getMemoryUsageBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public long getSoftMemoryLimitBytes() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.softMemoryLimitBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSoftMemoryLimitBytes(long limit) {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            boolean oldCanRun = this.canRunMore();
            this.softMemoryLimitBytes = limit;
            if (this.canRunMore() != oldCanRun) {
                this.updateEligibility();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public long getSoftCpuLimitMillis() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.softCpuLimitMillis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.time.Duration getSoftCpuLimit() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return java.time.Duration.ofMillis(this.softCpuLimitMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSoftCpuLimit(java.time.Duration limit) {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            if (limit.toMillis() > this.hardCpuLimitMillis) {
                this.setHardCpuLimit(limit);
            }
            boolean oldCanRun = this.canRunMore();
            this.softCpuLimitMillis = limit.toMillis();
            if (this.canRunMore() != oldCanRun) {
                this.updateEligibility();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public long getHardCpuLimitMillis() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.hardCpuLimitMillis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.time.Duration getHardCpuLimit() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return java.time.Duration.ofMillis(this.hardCpuLimitMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHardCpuLimit(java.time.Duration limit) {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            if (limit.toMillis() < this.softCpuLimitMillis) {
                this.setSoftCpuLimit(limit);
            }
            boolean oldCanRun = this.canRunMore();
            this.hardCpuLimitMillis = limit.toMillis();
            if (this.canRunMore() != oldCanRun) {
                this.updateEligibility();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public long getCpuQuotaGenerationMillisPerSecond() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.cpuQuotaGenerationMillisPerSecond;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCpuQuotaGenerationMillisPerSecond(long rate) {
        Preconditions.checkArgument((rate > 0L ? 1 : 0) != 0, (Object)"Cpu quota generation must be positive");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            this.cpuQuotaGenerationMillisPerSecond = rate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public int getSoftConcurrencyLimit() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.softConcurrencyLimit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSoftConcurrencyLimit(int softConcurrencyLimit) {
        Preconditions.checkArgument((softConcurrencyLimit >= 0 ? 1 : 0) != 0, (Object)"softConcurrencyLimit is negative");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            boolean oldCanRun = this.canRunMore();
            this.softConcurrencyLimit = softConcurrencyLimit;
            if (this.canRunMore() != oldCanRun) {
                this.updateEligibility();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public int getHardConcurrencyLimit() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.hardConcurrencyLimit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public void setHardConcurrencyLimit(int hardConcurrencyLimit) {
        Preconditions.checkArgument((hardConcurrencyLimit >= 0 ? 1 : 0) != 0, (Object)"hardConcurrencyLimit is negative");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            boolean oldCanRun = this.canRunMore();
            this.hardConcurrencyLimit = hardConcurrencyLimit;
            if (this.canRunMore() != oldCanRun) {
                this.updateEligibility();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public int getMaxQueuedQueries() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.maxQueuedQueries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public void setMaxQueuedQueries(int maxQueuedQueries) {
        Preconditions.checkArgument((maxQueuedQueries >= 0 ? 1 : 0) != 0, (Object)"maxQueuedQueries is negative");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            this.maxQueuedQueries = maxQueuedQueries;
        }
    }

    @Managed
    @Nested
    public CounterStat getTimeBetweenStartsSec() {
        return this.timeBetweenStartsSec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public int getSchedulingWeight() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.schedulingWeight;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSchedulingWeight(int weight) {
        Preconditions.checkArgument((weight > 0 ? 1 : 0) != 0, (Object)"weight must be positive");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            this.schedulingWeight = weight;
            if (this.parent.isPresent() && this.parent.get().schedulingPolicy == SchedulingPolicy.WEIGHTED && this.parent.get().eligibleSubGroups.contains(this)) {
                this.parent.get().addOrUpdateSubGroup(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public SchedulingPolicy getSchedulingPolicy() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.schedulingPolicy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSchedulingPolicy(SchedulingPolicy policy) {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            FifoQueue<InternalResourceGroup> queue;
            if (policy == this.schedulingPolicy) {
                return;
            }
            if (this.parent.isPresent() && this.parent.get().schedulingPolicy == SchedulingPolicy.QUERY_PRIORITY) {
                Preconditions.checkArgument((policy == SchedulingPolicy.QUERY_PRIORITY ? 1 : 0) != 0, (String)"Parent of %s uses query priority scheduling, so %s must also", (Object)this.id, (Object)this.id);
            }
            UpdateablePriorityQueue<ManagedQueryExecution> queryQueue = switch (policy) {
                case SchedulingPolicy.FAIR -> {
                    queue = new FifoQueue();
                    yield new FifoQueue();
                }
                case SchedulingPolicy.WEIGHTED -> {
                    queue = new StochasticPriorityQueue();
                    yield new StochasticPriorityQueue();
                }
                case SchedulingPolicy.WEIGHTED_FAIR -> {
                    queue = new WeightedFairQueue();
                    yield new IndexedPriorityQueue();
                }
                case SchedulingPolicy.QUERY_PRIORITY -> {
                    for (InternalResourceGroup group : this.subGroups.values()) {
                        group.setSchedulingPolicy(SchedulingPolicy.QUERY_PRIORITY);
                    }
                    queue = new IndexedPriorityQueue();
                    yield new IndexedPriorityQueue();
                }
                default -> throw new UnsupportedOperationException("Unsupported scheduling policy: " + String.valueOf(policy));
            };
            this.schedulingPolicy = policy;
            while (!this.eligibleSubGroups.isEmpty()) {
                InternalResourceGroup group = this.eligibleSubGroups.poll();
                this.addOrUpdateSubGroup(queue, group);
            }
            this.eligibleSubGroups = queue;
            while (!this.queuedQueries.isEmpty()) {
                ManagedQueryExecution query = (ManagedQueryExecution)this.queuedQueries.poll();
                queryQueue.addOrUpdate(query, SystemSessionProperties.getQueryPriority(query.getSession()));
            }
            this.queuedQueries = queryQueue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getJmxExport() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.jmxExport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJmxExport(boolean export) {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            this.jmxExport = export;
        }
        this.jmxExportListener.accept(this, export);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisabled() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.disabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisabled(boolean disabled) {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            this.disabled = disabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalResourceGroup getOrCreateSubGroup(String name) {
        Objects.requireNonNull(name, "name is null");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            Preconditions.checkArgument((boolean)this.queuedQueries.isEmpty(), (String)"Cannot add sub group to '%s' while queries are queued", (Object)this.id);
            if (this.subGroups.containsKey(name)) {
                return this.subGroups.get(name);
            }
            InternalResourceGroup subGroup = new InternalResourceGroup(Optional.of(this), name, this.jmxExportListener, this.executor);
            if (this.schedulingPolicy == SchedulingPolicy.QUERY_PRIORITY) {
                subGroup.setSchedulingPolicy(SchedulingPolicy.QUERY_PRIORITY);
            }
            this.subGroups.put(name, subGroup);
            return subGroup;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ManagedQueryExecution query) {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            if (!this.isLeafGroup()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_RESOURCE_GROUP, String.format("Cannot add queries to '%s'. It is not a leaf group.", this.id));
            }
            InternalResourceGroup group = this;
            boolean canQueue = true;
            boolean canRun = true;
            while (true) {
                canQueue = canQueue && group.canQueueMore();
                boolean bl = canRun = canRun && group.canRunMore();
                if (group.parent.isEmpty()) break;
                group = group.parent.get();
            }
            if (!canQueue && !canRun) {
                query.fail((Throwable)((Object)new QueryQueueFullException(this.id)));
                return;
            }
            if (canRun) {
                this.startInBackground(query);
            } else {
                this.enqueueQuery(query);
            }
            query.addStateChangeListener(state -> {
                if (state.isDone()) {
                    this.queryFinished(query);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueQuery(ManagedQueryExecution query) {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock to enqueue a query");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            this.queuedQueries.addOrUpdate(query, SystemSessionProperties.getQueryPriority(query.getSession()));
            InternalResourceGroup group = this;
            while (group.parent.isPresent()) {
                ++group.parent.get().descendantQueuedQueries;
                group = group.parent.get();
            }
            this.updateEligibility();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEligibility() {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock to update eligibility");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            if (this.parent.isEmpty()) {
                return;
            }
            if (this.isEligibleToStartNext()) {
                this.parent.get().addOrUpdateSubGroup(this);
            } else {
                this.parent.get().eligibleSubGroups.remove(this);
                this.lastStartMillis = 0L;
            }
            this.parent.get().updateEligibility();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startInBackground(ManagedQueryExecution query) {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock to start a query");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            this.runningQueries.put(query, new ResourceUsage(0L, 0L));
            InternalResourceGroup group = this;
            while (group.parent.isPresent()) {
                ++group.parent.get().descendantRunningQueries;
                group.parent.get().dirtySubGroups.add(group);
                group = group.parent.get();
            }
            this.updateEligibility();
            this.executor.execute(query::startWaitingForResources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGroupsAndProcessQueuedQueries() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            this.updateResourceUsageAndGetDelta();
            while (this.internalStartNext()) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateCpuQuota(long elapsedSeconds) {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            if (elapsedSeconds > 0L) {
                this.internalGenerateCpuQuota(elapsedSeconds);
            }
        }
    }

    @VisibleForTesting
    public void triggerProcessQueuedQueries() {
        this.updateGroupsAndProcessQueuedQueries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryFinished(ManagedQueryExecution query) {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            if (!this.runningQueries.containsKey(query) && !this.queuedQueries.contains(query)) {
                return;
            }
            ResourceUsage lastUsage = this.runningQueries.get(query);
            if (lastUsage != null) {
                ResourceUsage finalUsage = new ResourceUsage(query.getTotalCpuTime().toMillis(), 0L);
                ResourceUsage delta = finalUsage.subtract(lastUsage);
                this.runningQueries.remove(query);
                InternalResourceGroup group = this;
                while (group != null) {
                    group.cachedResourceUsage = group.cachedResourceUsage.add(delta);
                    InternalResourceGroup parent = group.parent.orElse(null);
                    if (parent != null) {
                        --parent.descendantRunningQueries;
                        if (parent.descendantRunningQueries == 0) {
                            parent.dirtySubGroups.remove(group);
                        }
                    }
                    group = parent;
                }
            } else {
                this.queuedQueries.remove(query);
                InternalResourceGroup group = this;
                while (group.parent.isPresent()) {
                    --group.parent.get().descendantQueuedQueries;
                    group = group.parent.get();
                }
            }
            this.updateEligibility();
            this.root.triggerProcessQueuedQueries();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceUsage updateResourceUsageAndGetDelta() {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock to refresh stats");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            ResourceUsage groupUsageDelta = new ResourceUsage(0L, 0L);
            for (Map.Entry<ManagedQueryExecution, ResourceUsage> entry : this.runningQueries.entrySet()) {
                ManagedQueryExecution query = entry.getKey();
                ResourceUsage oldResourceUsage = entry.getValue();
                ResourceUsage newResourceUsage = new ResourceUsage(query.getTotalCpuTime().toMillis(), query.getTotalMemoryReservation().toBytes());
                ResourceUsage queryUsageDelta = newResourceUsage.subtract(oldResourceUsage);
                entry.setValue(newResourceUsage);
                groupUsageDelta = groupUsageDelta.add(queryUsageDelta);
            }
            this.cachedResourceUsage = this.cachedResourceUsage.add(groupUsageDelta);
            for (InternalResourceGroup subGroup : this.dirtySubGroups) {
                ResourceUsage subGroupUsageDelta = subGroup.updateResourceUsageAndGetDelta();
                groupUsageDelta = groupUsageDelta.add(subGroupUsageDelta);
                this.cachedResourceUsage = this.cachedResourceUsage.add(subGroupUsageDelta);
                if (subGroupUsageDelta.equals(new ResourceUsage(0L, 0L))) continue;
                subGroup.updateEligibility();
            }
            return groupUsageDelta;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalGenerateCpuQuota(long elapsedSeconds) {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock to generate cpu quota");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            long newQuota = LongMath.saturatedMultiply((long)elapsedSeconds, (long)this.cpuQuotaGenerationMillisPerSecond);
            long oldUsageMillis = this.cachedResourceUsage.getCpuUsageMillis();
            long newCpuUsageMillis = LongMath.saturatedSubtract((long)oldUsageMillis, (long)newQuota);
            if (newCpuUsageMillis < 0L || newCpuUsageMillis == Long.MAX_VALUE) {
                newCpuUsageMillis = 0L;
            }
            this.cachedResourceUsage = new ResourceUsage(newCpuUsageMillis, this.cachedResourceUsage.getMemoryUsageBytes());
            if (newCpuUsageMillis < this.hardCpuLimitMillis && oldUsageMillis >= this.hardCpuLimitMillis || newCpuUsageMillis < this.softCpuLimitMillis && oldUsageMillis >= this.softCpuLimitMillis) {
                this.updateEligibility();
            }
            for (InternalResourceGroup group : this.subGroups.values()) {
                group.internalGenerateCpuQuota(elapsedSeconds);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean internalStartNext() {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock to find next query");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            if (!this.canRunMore()) {
                return false;
            }
            ManagedQueryExecution query = (ManagedQueryExecution)this.queuedQueries.poll();
            if (query != null) {
                this.startInBackground(query);
                return true;
            }
            InternalResourceGroup subGroup = this.eligibleSubGroups.poll();
            if (subGroup == null) {
                return false;
            }
            boolean started = subGroup.internalStartNext();
            Preconditions.checkState((boolean)started, (Object)"Eligible sub group had no queries to run");
            long currentTime = System.currentTimeMillis();
            if (this.lastStartMillis != 0L) {
                this.timeBetweenStartsSec.update(Math.max(0L, (currentTime - this.lastStartMillis) / 1000L));
            }
            this.lastStartMillis = currentTime;
            --this.descendantQueuedQueries;
            if (subGroup.isEligibleToStartNext()) {
                this.addOrUpdateSubGroup(subGroup);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOrUpdateSubGroup(Queue<InternalResourceGroup> queue, InternalResourceGroup group) {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            if (this.schedulingPolicy == SchedulingPolicy.WEIGHTED_FAIR) {
                ((WeightedFairQueue)queue).addOrUpdate(group, new WeightedFairQueue.Usage(group.getSchedulingWeight(), group.getRunningQueries()));
            } else {
                ((UpdateablePriorityQueue)queue).addOrUpdate(group, InternalResourceGroup.getSubGroupSchedulingPriority(this.schedulingPolicy, group));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOrUpdateSubGroup(InternalResourceGroup group) {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            this.addOrUpdateSubGroup(this.eligibleSubGroups, group);
        }
    }

    private static long getSubGroupSchedulingPriority(SchedulingPolicy policy, InternalResourceGroup group) {
        if (policy == SchedulingPolicy.QUERY_PRIORITY) {
            return group.getHighestQueryPriority();
        }
        return group.computeSchedulingWeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long computeSchedulingWeight() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            if (this.runningQueries.size() + this.descendantRunningQueries >= this.softConcurrencyLimit) {
                return this.schedulingWeight;
            }
            return Integer.MAX_VALUE * (long)this.schedulingWeight;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEligibleToStartNext() {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            if (!this.canRunMore()) {
                return false;
            }
            return !this.queuedQueries.isEmpty() || !this.eligibleSubGroups.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getHighestQueryPriority() {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            Preconditions.checkState((boolean)(this.queuedQueries instanceof IndexedPriorityQueue), (Object)"Queued queries not ordered");
            if (this.queuedQueries.isEmpty()) {
                return 0;
            }
            return SystemSessionProperties.getQueryPriority(((ManagedQueryExecution)this.queuedQueries.peek()).getSession());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canQueueMore() {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.descendantQueuedQueries + this.queuedQueries.size() < this.maxQueuedQueries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canRunMore() {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock");
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            long cpuUsageMillis = this.cachedResourceUsage.getCpuUsageMillis();
            long memoryUsageBytes = this.cachedResourceUsage.getMemoryUsageBytes();
            if (cpuUsageMillis >= this.hardCpuLimitMillis || memoryUsageBytes > this.softMemoryLimitBytes) {
                return false;
            }
            int hardConcurrencyLimit = this.hardConcurrencyLimit;
            if (cpuUsageMillis >= this.softCpuLimitMillis) {
                double penalty = (double)(cpuUsageMillis - this.softCpuLimitMillis) / (double)(this.hardCpuLimitMillis - this.softCpuLimitMillis);
                hardConcurrencyLimit = (int)Math.floor((double)hardConcurrencyLimit * (1.0 - penalty));
                hardConcurrencyLimit = Math.min(this.hardConcurrencyLimit - 1, hardConcurrencyLimit);
                hardConcurrencyLimit = Math.max(1, hardConcurrencyLimit);
            }
            return this.runningQueries.size() + this.descendantRunningQueries < hardConcurrencyLimit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLeafGroup() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.subGroups.values().stream().allMatch(subGroup -> subGroup.isDisabled() && subGroup.getQueuedQueries() == 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    ResourceUsage getResourceUsageSnapshot() {
        InternalResourceGroup internalResourceGroup = this.root;
        synchronized (internalResourceGroup) {
            return this.cachedResourceUsage;
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InternalResourceGroup)) {
            return false;
        }
        InternalResourceGroup that = (InternalResourceGroup)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

