/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.Duration;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

@DefunctConfig(value={"node-scheduler.allocator-type", "node-scheduler.location-aware-scheduling-enabled", "node-scheduler.multiple-tasks-per-node-enabled", "node-scheduler.max-fraction-full-nodes-per-query", "node-scheduler.max-absolute-full-nodes-per-query"})
public class NodeSchedulerConfig {
    private int minCandidates = 10;
    private boolean includeCoordinator = true;
    private int maxSplitsPerNode = 256;
    private int minPendingSplitsPerTask = 16;
    private int maxAdjustedPendingSplitsWeightPerTask = 2000;
    private NodeSchedulerPolicy nodeSchedulerPolicy = NodeSchedulerPolicy.UNIFORM;
    private boolean optimizedLocalScheduling = true;
    private SplitsBalancingPolicy splitsBalancingPolicy = SplitsBalancingPolicy.STAGE;
    private int maxUnacknowledgedSplitsPerTask = 2000;
    private Duration allowedNoMatchingNodePeriod = new Duration(2.0, TimeUnit.MINUTES);
    private Duration exhaustedNodeWaitPeriod = new Duration(2.0, TimeUnit.MINUTES);

    @NotNull
    public NodeSchedulerPolicy getNodeSchedulerPolicy() {
        return this.nodeSchedulerPolicy;
    }

    @LegacyConfig(value={"node-scheduler.network-topology"})
    @Config(value="node-scheduler.policy")
    public NodeSchedulerConfig setNodeSchedulerPolicy(String nodeSchedulerPolicy) {
        this.nodeSchedulerPolicy = NodeSchedulerConfig.toNodeSchedulerPolicy(nodeSchedulerPolicy);
        return this;
    }

    private static NodeSchedulerPolicy toNodeSchedulerPolicy(String nodeSchedulerPolicy) {
        return switch (nodeSchedulerPolicy.toLowerCase(Locale.ENGLISH)) {
            case "legacy", "uniform" -> NodeSchedulerPolicy.UNIFORM;
            case "flat", "topology" -> NodeSchedulerPolicy.TOPOLOGY;
            default -> throw new IllegalArgumentException("Unknown node scheduler policy: " + nodeSchedulerPolicy);
        };
    }

    @Min(value=1L)
    public @Min(value=1L) int getMinCandidates() {
        return this.minCandidates;
    }

    @Config(value="node-scheduler.min-candidates")
    public NodeSchedulerConfig setMinCandidates(int candidates) {
        this.minCandidates = candidates;
        return this;
    }

    public boolean isIncludeCoordinator() {
        return this.includeCoordinator;
    }

    @Config(value="node-scheduler.include-coordinator")
    public NodeSchedulerConfig setIncludeCoordinator(boolean includeCoordinator) {
        this.includeCoordinator = includeCoordinator;
        return this;
    }

    @Config(value="node-scheduler.min-pending-splits-per-task")
    @LegacyConfig(value={"node-scheduler.max-pending-splits-per-task", "node-scheduler.max-pending-splits-per-node-per-task", "node-scheduler.max-pending-splits-per-node-per-stage"})
    public NodeSchedulerConfig setMinPendingSplitsPerTask(int minPendingSplitsPerTask) {
        this.minPendingSplitsPerTask = minPendingSplitsPerTask;
        return this;
    }

    public int getMinPendingSplitsPerTask() {
        return this.minPendingSplitsPerTask;
    }

    @Config(value="node-scheduler.max-adjusted-pending-splits-per-task")
    public NodeSchedulerConfig setMaxAdjustedPendingSplitsWeightPerTask(int maxAdjustedPendingSplitsWeightPerTask) {
        this.maxAdjustedPendingSplitsWeightPerTask = maxAdjustedPendingSplitsWeightPerTask;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getMaxAdjustedPendingSplitsWeightPerTask() {
        return this.maxAdjustedPendingSplitsWeightPerTask;
    }

    public int getMaxSplitsPerNode() {
        return this.maxSplitsPerNode;
    }

    @Config(value="node-scheduler.max-splits-per-node")
    public NodeSchedulerConfig setMaxSplitsPerNode(int maxSplitsPerNode) {
        this.maxSplitsPerNode = maxSplitsPerNode;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxUnacknowledgedSplitsPerTask() {
        return this.maxUnacknowledgedSplitsPerTask;
    }

    @Config(value="node-scheduler.max-unacknowledged-splits-per-task")
    @ConfigDescription(value="Maximum number of leaf splits not yet delivered to a given task")
    public NodeSchedulerConfig setMaxUnacknowledgedSplitsPerTask(int maxUnacknowledgedSplitsPerTask) {
        this.maxUnacknowledgedSplitsPerTask = maxUnacknowledgedSplitsPerTask;
        return this;
    }

    @NotNull
    public SplitsBalancingPolicy getSplitsBalancingPolicy() {
        return this.splitsBalancingPolicy;
    }

    @Config(value="node-scheduler.splits-balancing-policy")
    @ConfigDescription(value="Strategy for balancing new splits on worker nodes")
    public NodeSchedulerConfig setSplitsBalancingPolicy(SplitsBalancingPolicy splitsBalancingPolicy) {
        this.splitsBalancingPolicy = splitsBalancingPolicy;
        return this;
    }

    public boolean getOptimizedLocalScheduling() {
        return this.optimizedLocalScheduling;
    }

    @Config(value="node-scheduler.optimized-local-scheduling")
    public NodeSchedulerConfig setOptimizedLocalScheduling(boolean optimizedLocalScheduling) {
        this.optimizedLocalScheduling = optimizedLocalScheduling;
        return this;
    }

    @Config(value="node-scheduler.allowed-no-matching-node-period")
    @ConfigDescription(value="How long scheduler should wait before failing a query for which hard task requirements (e.g. node exposing specific catalog) cannot be satisfied. Relevant for TASK retry policy only.")
    public NodeSchedulerConfig setAllowedNoMatchingNodePeriod(Duration allowedNoMatchingNodePeriod) {
        this.allowedNoMatchingNodePeriod = allowedNoMatchingNodePeriod;
        return this;
    }

    public Duration getAllowedNoMatchingNodePeriod() {
        return this.allowedNoMatchingNodePeriod;
    }

    @Config(value="node-scheduler.exhausted-node-wait-period")
    @ConfigDescription(value="Maximum time to wait for resource availability on preferred nodes before scheduling a remotely accessible split on other nodes. Relevant for TASK retry policy only.")
    public NodeSchedulerConfig setExhaustedNodeWaitPeriod(Duration exhaustedNodeWaitPeriod) {
        this.exhaustedNodeWaitPeriod = exhaustedNodeWaitPeriod;
        return this;
    }

    public Duration getExhaustedNodeWaitPeriod() {
        return this.exhaustedNodeWaitPeriod;
    }

    public static enum NodeSchedulerPolicy {
        UNIFORM,
        TOPOLOGY;

    }

    public static enum SplitsBalancingPolicy {
        NODE,
        STAGE;

    }
}

