/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler.faulttolerant;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.execution.StageId;
import io.trino.execution.scheduler.faulttolerant.EventDrivenFaultTolerantQueryScheduler;
import io.trino.execution.scheduler.faulttolerant.OutputStatsEstimator;
import io.trino.execution.scheduler.faulttolerant.OutputStatsEstimatorFactory;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class CompositeOutputStatsEstimator
implements OutputStatsEstimator {
    private final List<OutputStatsEstimator> estimators;

    private CompositeOutputStatsEstimator(List<OutputStatsEstimator> estimators) {
        this.estimators = ImmutableList.copyOf(estimators);
    }

    @Override
    public Optional<OutputStatsEstimator.OutputStatsEstimateResult> getEstimatedOutputStats(EventDrivenFaultTolerantQueryScheduler.StageExecution stageExecution, Function<StageId, EventDrivenFaultTolerantQueryScheduler.StageExecution> stageExecutionLookup, boolean parentEager) {
        for (OutputStatsEstimator estimator : this.estimators) {
            Optional<OutputStatsEstimator.OutputStatsEstimateResult> result = estimator.getEstimatedOutputStats(stageExecution, stageExecutionLookup, parentEager);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @BindingAnnotation
    public static @interface ForCompositeOutputDataSizeEstimator {
    }

    public static class Factory
    implements OutputStatsEstimatorFactory {
        private final List<OutputStatsEstimatorFactory> delegateFactories;

        @Inject
        public Factory(@ForCompositeOutputDataSizeEstimator List<OutputStatsEstimatorFactory> delegateFactories) {
            Preconditions.checkArgument((!delegateFactories.isEmpty() ? 1 : 0) != 0, (Object)"Got empty list of delegates");
            this.delegateFactories = ImmutableList.copyOf(delegateFactories);
        }

        @Override
        public OutputStatsEstimator create(Session session) {
            List estimators = (List)this.delegateFactories.stream().map(factory -> factory.create(session)).collect(ImmutableList.toImmutableList());
            return new CompositeOutputStatsEstimator(estimators);
        }
    }
}

