/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.trino.execution.TaskId;
import io.trino.execution.TaskInfo;
import io.trino.memory.KillTarget;
import io.trino.memory.LowMemoryKiller;
import io.trino.memory.MemoryInfo;
import io.trino.operator.RetryPolicy;
import io.trino.spi.QueryId;
import io.trino.spi.memory.MemoryPoolInfo;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class TotalReservationOnBlockedNodesTaskLowMemoryKiller
implements LowMemoryKiller {
    @Override
    public Optional<KillTarget> chooseTargetToKill(List<LowMemoryKiller.RunningQueryInfo> runningQueries, List<MemoryInfo> nodes) {
        Set queriesWithTaskRetryPolicy = (Set)runningQueries.stream().filter(query -> query.getRetryPolicy() == RetryPolicy.TASK).map(LowMemoryKiller.RunningQueryInfo::getQueryId).collect(ImmutableSet.toImmutableSet());
        if (queriesWithTaskRetryPolicy.isEmpty()) {
            return Optional.empty();
        }
        ImmutableMap runningQueriesById = Maps.uniqueIndex(runningQueries, LowMemoryKiller.RunningQueryInfo::getQueryId);
        ImmutableSet.Builder tasksToKillBuilder = ImmutableSet.builder();
        for (MemoryInfo node : nodes) {
            MemoryPoolInfo memoryPool = node.getPool();
            if (memoryPool == null || memoryPool.getFreeBytes() + memoryPool.getReservedRevocableBytes() > 0L) continue;
            TotalReservationOnBlockedNodesTaskLowMemoryKiller.findBiggestTask((Map<QueryId, LowMemoryKiller.RunningQueryInfo>)runningQueriesById, memoryPool, true).or(() -> TotalReservationOnBlockedNodesTaskLowMemoryKiller.lambda$chooseTargetToKill$1((Map)runningQueriesById, memoryPool)).ifPresent(arg_0 -> ((ImmutableSet.Builder)tasksToKillBuilder).add(arg_0));
        }
        ImmutableSet tasksToKill = tasksToKillBuilder.build();
        if (tasksToKill.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(KillTarget.selectedTasks((Set<TaskId>)tasksToKill));
    }

    private static Optional<TaskId> findBiggestTask(Map<QueryId, LowMemoryKiller.RunningQueryInfo> runningQueries, MemoryPoolInfo memoryPool, boolean onlySpeculative) {
        Stream<AbstractMap.SimpleEntry> stream = memoryPool.getTaskMemoryReservations().entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<TaskId, Long>(TaskId.valueOf((String)entry.getKey()), (Long)entry.getValue())).filter(entry -> runningQueries.containsKey(((TaskId)entry.getKey()).getQueryId())).filter(entry -> ((LowMemoryKiller.RunningQueryInfo)runningQueries.get(((TaskId)entry.getKey()).getQueryId())).getRetryPolicy() == RetryPolicy.TASK);
        if (onlySpeculative) {
            stream = stream.filter(entry -> {
                TaskInfo taskInfo = ((LowMemoryKiller.RunningQueryInfo)runningQueries.get(((TaskId)entry.getKey()).getQueryId())).getTaskInfos().get(entry.getKey());
                if (taskInfo == null) {
                    return false;
                }
                return taskInfo.taskStatus().isSpeculative();
            });
        }
        return stream.max(Map.Entry.comparingByValue()).map(AbstractMap.SimpleEntry::getKey);
    }

    private static /* synthetic */ Optional lambda$chooseTargetToKill$1(Map runningQueriesById, MemoryPoolInfo memoryPool) {
        return TotalReservationOnBlockedNodesTaskLowMemoryKiller.findBiggestTask(runningQueriesById, memoryPool, false);
    }
}

