/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import io.trino.Session;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.QualifiedTablePrefix;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.EntityKindAndName;
import io.trino.spi.connector.EntityPrivilege;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.security.GrantInfo;
import io.trino.spi.security.Identity;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.security.TrinoPrincipal;
import java.util.Optional;
import java.util.Set;

public interface SystemSecurityMetadata {
    public boolean roleExists(Session var1, String var2);

    public void createRole(Session var1, String var2, Optional<TrinoPrincipal> var3);

    public void dropRole(Session var1, String var2);

    public Set<String> listRoles(Session var1);

    public Set<RoleGrant> listRoleGrants(Session var1, TrinoPrincipal var2);

    public void grantRoles(Session var1, Set<String> var2, Set<TrinoPrincipal> var3, boolean var4, Optional<TrinoPrincipal> var5);

    public void revokeRoles(Session var1, Set<String> var2, Set<TrinoPrincipal> var3, boolean var4, Optional<TrinoPrincipal> var5);

    public Set<RoleGrant> listApplicableRoles(Session var1, TrinoPrincipal var2);

    public Set<String> listEnabledRoles(Identity var1);

    public void grantSchemaPrivileges(Session var1, CatalogSchemaName var2, Set<Privilege> var3, TrinoPrincipal var4, boolean var5);

    public void denySchemaPrivileges(Session var1, CatalogSchemaName var2, Set<Privilege> var3, TrinoPrincipal var4);

    public void revokeSchemaPrivileges(Session var1, CatalogSchemaName var2, Set<Privilege> var3, TrinoPrincipal var4, boolean var5);

    public void grantTablePrivileges(Session var1, QualifiedObjectName var2, Set<Privilege> var3, TrinoPrincipal var4, boolean var5);

    public void denyTablePrivileges(Session var1, QualifiedObjectName var2, Set<Privilege> var3, TrinoPrincipal var4);

    public void revokeTablePrivileges(Session var1, QualifiedObjectName var2, Set<Privilege> var3, TrinoPrincipal var4, boolean var5);

    public Set<GrantInfo> listTablePrivileges(Session var1, QualifiedTablePrefix var2);

    default public Set<EntityPrivilege> getAllEntityKindPrivileges(String entityKind) {
        throw new UnsupportedOperationException();
    }

    default public void grantEntityPrivileges(Session session, EntityKindAndName entity, Set<EntityPrivilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        throw new UnsupportedOperationException();
    }

    default public void denyEntityPrivileges(Session session, EntityKindAndName entity, Set<EntityPrivilege> privileges, TrinoPrincipal grantee) {
        throw new UnsupportedOperationException();
    }

    default public void revokeEntityPrivileges(Session session, EntityKindAndName entity, Set<EntityPrivilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        throw new UnsupportedOperationException();
    }

    default public void validateEntityKindAndPrivileges(Session session, String entityKind, Set<String> privileges) {
        throw new UnsupportedOperationException();
    }

    public Optional<TrinoPrincipal> getSchemaOwner(Session var1, CatalogSchemaName var2);

    public void setSchemaOwner(Session var1, CatalogSchemaName var2, TrinoPrincipal var3);

    public void setTableOwner(Session var1, CatalogSchemaTableName var2, TrinoPrincipal var3);

    public Optional<Identity> getViewRunAsIdentity(Session var1, CatalogSchemaTableName var2);

    public void setViewOwner(Session var1, CatalogSchemaTableName var2, TrinoPrincipal var3);

    public Optional<Identity> getFunctionRunAsIdentity(Session var1, CatalogSchemaFunctionName var2);

    public void schemaCreated(Session var1, CatalogSchemaName var2);

    public void schemaRenamed(Session var1, CatalogSchemaName var2, CatalogSchemaName var3);

    public void schemaDropped(Session var1, CatalogSchemaName var2);

    public void tableCreated(Session var1, CatalogSchemaTableName var2);

    public void tableRenamed(Session var1, CatalogSchemaTableName var2, CatalogSchemaTableName var3);

    public void tableDropped(Session var1, CatalogSchemaTableName var2);

    public void columnCreated(Session var1, CatalogSchemaTableName var2, String var3);

    public void columnRenamed(Session var1, CatalogSchemaTableName var2, String var3, String var4);

    public void columnDropped(Session var1, CatalogSchemaTableName var2, String var3);

    public void columnTypeChanged(Session var1, CatalogSchemaTableName var2, String var3, String var4, String var5);

    public void columnNotNullConstraintDropped(Session var1, CatalogSchemaTableName var2, String var3);
}

