/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import io.trino.operator.MergeRowChangeProcessor;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ChangeOnlyUpdatedColumnsMergeProcessor
implements MergeRowChangeProcessor {
    private static final Block INSERT_FROM_UPDATE_BLOCK = Utils.nativeValueToBlock((Type)TinyintType.TINYINT, (Object)0L);
    private final int rowIdChannel;
    private final int mergeRowChannel;
    private final List<Integer> dataColumnChannels;
    private final int writeRedistributionColumnCount;

    public ChangeOnlyUpdatedColumnsMergeProcessor(int rowIdChannel, int mergeRowChannel, List<Integer> dataColumnChannels, List<Integer> redistributionColumnChannels) {
        this.rowIdChannel = rowIdChannel;
        this.mergeRowChannel = mergeRowChannel;
        this.dataColumnChannels = Objects.requireNonNull(dataColumnChannels, "dataColumnChannels is null");
        this.writeRedistributionColumnCount = redistributionColumnChannels.size();
    }

    @Override
    public Page transformPage(Page inputPage) {
        Objects.requireNonNull(inputPage, "inputPage is null");
        int inputChannelCount = inputPage.getChannelCount();
        Preconditions.checkArgument((inputChannelCount >= 2 + this.writeRedistributionColumnCount ? 1 : 0) != 0, (String)"inputPage channelCount (%s) should be >= 2 + %s", (int)inputChannelCount, (int)this.writeRedistributionColumnCount);
        int positionCount = inputPage.getPositionCount();
        Preconditions.checkArgument((positionCount > 0 ? 1 : 0) != 0, (String)"positionCount should be > 0, but is %s", (int)positionCount);
        Block mergeRow = inputPage.getBlock(this.mergeRowChannel).getLoadedBlock();
        List fields = RowBlock.getRowFieldsFromBlock((Block)mergeRow);
        ArrayList<Block> builder = new ArrayList<Block>(this.dataColumnChannels.size() + 3);
        for (int channel : this.dataColumnChannels) {
            builder.add((Block)fields.get(channel));
        }
        Block operationChannelBlock = (Block)fields.get(fields.size() - 2);
        builder.add(operationChannelBlock);
        builder.add(inputPage.getBlock(this.rowIdChannel));
        builder.add(RunLengthEncodedBlock.create((Block)INSERT_FROM_UPDATE_BLOCK, (int)positionCount));
        Page result = new Page((Block[])builder.toArray(Block[]::new));
        int defaultCaseCount = 0;
        for (int position = 0; position < positionCount; ++position) {
            if (!mergeRow.isNull(position)) continue;
            ++defaultCaseCount;
        }
        if (defaultCaseCount == 0) {
            return result;
        }
        int usedCases = 0;
        int[] positions = new int[positionCount - defaultCaseCount];
        for (int position = 0; position < positionCount; ++position) {
            if (mergeRow.isNull(position)) continue;
            positions[usedCases] = position;
            ++usedCases;
        }
        Preconditions.checkArgument((usedCases + defaultCaseCount == positionCount ? 1 : 0) != 0, (String)"usedCases (%s) + defaultCaseCount (%s) != positionCount (%s)", (Object)usedCases, (Object)defaultCaseCount, (Object)positionCount);
        return result.getPositions(positions, 0, usedCases);
    }
}

