/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.trino.operator.HashGenerator;
import io.trino.operator.OperatorInfo;
import io.trino.operator.ProcessorContext;
import io.trino.operator.WorkProcessor;
import io.trino.operator.WorkProcessorOperator;
import io.trino.operator.join.DefaultPageJoiner;
import io.trino.operator.join.JoinProbe;
import io.trino.operator.join.JoinStatisticsCounter;
import io.trino.operator.join.LookupJoinOperatorFactory;
import io.trino.operator.join.LookupSourceFactory;
import io.trino.operator.join.LookupSourceProvider;
import io.trino.operator.join.PageJoiner;
import io.trino.operator.join.SpillingJoinProcessor;
import io.trino.spi.Page;
import io.trino.spi.type.Type;
import io.trino.spiller.PartitioningSpillerFactory;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.Executor;

public class LookupJoinOperator
implements WorkProcessorOperator {
    private final ListenableFuture<LookupSourceProvider> lookupSourceProviderFuture;
    private final WorkProcessor<Page> pages;
    private final SpillingJoinProcessor joinProcessor;
    private final JoinStatisticsCounter statisticsCounter;

    LookupJoinOperator(List<Type> probeTypes, List<Type> buildOutputTypes, LookupJoinOperatorFactory.JoinType joinType, boolean outputSingleMatch, boolean waitForBuild, LookupSourceFactory lookupSourceFactory, JoinProbe.JoinProbeFactory joinProbeFactory, Runnable afterClose, OptionalInt lookupJoinsCount, HashGenerator hashGenerator, PartitioningSpillerFactory partitioningSpillerFactory, ProcessorContext processorContext, WorkProcessor<Page> sourcePages) {
        this.statisticsCounter = new JoinStatisticsCounter(joinType);
        this.lookupSourceProviderFuture = lookupSourceFactory.createLookupSourceProvider();
        PageJoiner.PageJoinerFactory pageJoinerFactory = (lookupSourceProvider, joinerPartitioningSpillerFactory, savedRows) -> new DefaultPageJoiner(processorContext, probeTypes, buildOutputTypes, joinType, outputSingleMatch, hashGenerator, joinProbeFactory, lookupSourceFactory, (ListenableFuture<LookupSourceProvider>)lookupSourceProvider, joinerPartitioningSpillerFactory, this.statisticsCounter, savedRows);
        this.joinProcessor = new SpillingJoinProcessor(afterClose, lookupJoinsCount, waitForBuild, lookupSourceFactory, this.lookupSourceProviderFuture, partitioningSpillerFactory, pageJoinerFactory, sourcePages);
        WorkProcessor pages = WorkProcessor.flatten(WorkProcessor.create(this.joinProcessor));
        if (waitForBuild) {
            pages = pages.blocking(() -> Futures.transform(this.lookupSourceProviderFuture, ignored -> null, (Executor)MoreExecutors.directExecutor()));
        }
        this.pages = pages;
    }

    @Override
    public WorkProcessor<Page> getOutputPages() {
        return this.pages;
    }

    @Override
    public Optional<OperatorInfo> getOperatorInfo() {
        return Optional.of(this.statisticsCounter.get());
    }

    @Override
    public void close() {
        this.joinProcessor.close();
    }
}

