/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.operator.scalar.ObjectToBooleanFunction;
import io.trino.spi.block.Block;
import io.trino.spi.function.Convention;
import io.trino.spi.function.Description;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import java.lang.invoke.MethodHandle;

@Description(value="Returns true if all elements of the array match the given predicate")
@ScalarFunction(value="all_match")
public final class ArrayAllMatchFunction {
    private ArrayAllMatchFunction() {
    }

    @TypeParameter(value="T")
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean allMatch(@OperatorDependency(operator=OperatorType.READ_VALUE, argumentTypes={"T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle readValue, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="function(T, boolean)") ObjectToBooleanFunction function) throws Throwable {
        boolean hasNullResult = false;
        int positionCount = arrayBlock.getPositionCount();
        for (int i = 0; i < positionCount; ++i) {
            Boolean match;
            Object element = null;
            if (!arrayBlock.isNull(i)) {
                element = readValue.invoke(arrayBlock, i);
            }
            if (Boolean.FALSE.equals(match = function.apply(element))) {
                return false;
            }
            if (match != null) continue;
            hasNullResult = true;
        }
        if (hasNullResult) {
            return null;
        }
        return true;
    }
}

