/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamptz;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.function.Description;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;

@Description(value="Time zone of the given timestamp")
@ScalarFunction(value="timezone")
public final class TimeZone {
    private TimeZone() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="varchar")
    public static Slice extractTimeZoneFromTimestamp(@SqlType(value="timestamp(p) with time zone") long timestampWithTimeZone) {
        TimeZoneKey timeZoneKey = DateTimeEncoding.unpackZoneKey((long)timestampWithTimeZone);
        return Slices.utf8Slice((String)timeZoneKey.getId());
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="varchar")
    public static Slice extractTimeZoneFromTimestamp(@SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestampWithTimeZone) {
        TimeZoneKey zoneKey = TimeZoneKey.getTimeZoneKey((short)timestampWithTimeZone.getTimeZoneKey());
        return Slices.utf8Slice((String)zoneKey.getId());
    }
}

