/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.window;

import com.google.common.base.MoreObjects;
import io.trino.sql.planner.plan.FrameBoundType;
import io.trino.sql.planner.plan.WindowFrameType;
import java.util.Objects;
import java.util.Optional;

public class FrameInfo {
    private final WindowFrameType type;
    private final FrameBoundType startType;
    private final int startChannel;
    private final int sortKeyChannelForStartComparison;
    private final FrameBoundType endType;
    private final int endChannel;
    private final int sortKeyChannelForEndComparison;
    private final int sortKeyChannel;
    private final Optional<Ordering> ordering;

    public FrameInfo(WindowFrameType type, FrameBoundType startType, Optional<Integer> startChannel, Optional<Integer> sortKeyChannelForStartComparison, FrameBoundType endType, Optional<Integer> endChannel, Optional<Integer> sortKeyChannelForEndComparison, Optional<Integer> sortKeyChannel, Optional<Ordering> ordering) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.startType = Objects.requireNonNull(startType, "startType is null");
        this.startChannel = startChannel.orElse(-1);
        this.sortKeyChannelForStartComparison = sortKeyChannelForStartComparison.orElse(-1);
        this.endType = Objects.requireNonNull(endType, "endType is null");
        this.endChannel = endChannel.orElse(-1);
        this.sortKeyChannelForEndComparison = sortKeyChannelForEndComparison.orElse(-1);
        this.sortKeyChannel = sortKeyChannel.orElse(-1);
        this.ordering = Objects.requireNonNull(ordering, "ordering is null");
    }

    public WindowFrameType getType() {
        return this.type;
    }

    public FrameBoundType getStartType() {
        return this.startType;
    }

    public int getStartChannel() {
        return this.startChannel;
    }

    public int getSortKeyChannelForStartComparison() {
        return this.sortKeyChannelForStartComparison;
    }

    public FrameBoundType getEndType() {
        return this.endType;
    }

    public int getEndChannel() {
        return this.endChannel;
    }

    public int getSortKeyChannelForEndComparison() {
        return this.sortKeyChannelForEndComparison;
    }

    public int getSortKeyChannel() {
        return this.sortKeyChannel;
    }

    public Optional<Ordering> getOrdering() {
        return this.ordering;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.startType, this.startChannel, this.sortKeyChannelForStartComparison, this.endType, this.endChannel, this.sortKeyChannelForEndComparison, this.sortKeyChannel, this.ordering});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FrameInfo other = (FrameInfo)obj;
        return this.type == other.type && this.startType == other.startType && this.startChannel == other.startChannel && this.sortKeyChannelForStartComparison == other.sortKeyChannelForStartComparison && this.endType == other.endType && this.endChannel == other.endChannel && this.sortKeyChannelForEndComparison == other.sortKeyChannelForEndComparison && this.sortKeyChannel == other.sortKeyChannel && Objects.equals(this.ordering, other.ordering);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("startType", (Object)this.startType).add("startChannel", this.startChannel).add("sortKeyChannelForStartComparison", this.sortKeyChannelForStartComparison).add("endType", (Object)this.endType).add("endChannel", this.endChannel).add("sortKeyChannelForEndComparison", this.sortKeyChannelForEndComparison).add("sortKeyChannel", this.sortKeyChannel).add("ordering", this.ordering).toString();
    }

    public static enum Ordering {
        ASCENDING,
        DESCENDING;

    }
}

