/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.FormatMethod;
import com.google.inject.Inject;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.client.ProtocolDetectionException;
import io.trino.client.ProtocolHeaders;
import io.trino.metadata.Metadata;
import io.trino.security.AccessControl;
import io.trino.server.ProtocolConfig;
import io.trino.server.ServletSecurityUtils;
import io.trino.server.SessionContext;
import io.trino.server.protocol.PreparedStatementEncoder;
import io.trino.server.protocol.spooling.QueryDataEncoder;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.GroupProvider;
import io.trino.spi.security.Identity;
import io.trino.spi.security.SelectedRole;
import io.trino.spi.session.ResourceEstimates;
import io.trino.sql.parser.ParsingException;
import io.trino.sql.parser.SqlParser;
import io.trino.transaction.TransactionId;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MultivaluedMap;
import java.lang.runtime.SwitchBootstraps;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class HttpRequestSessionContextFactory {
    private final PreparedStatementEncoder preparedStatementEncoder;
    private final Metadata metadata;
    private final GroupProvider groupProvider;
    private final AccessControl accessControl;
    private final Optional<String> alternateHeaderName;
    private final QueryDataEncoder.EncoderSelector encoderSelector;

    @Inject
    public HttpRequestSessionContextFactory(PreparedStatementEncoder preparedStatementEncoder, Metadata metadata, GroupProvider groupProvider, AccessControl accessControl, ProtocolConfig protocolConfig, QueryDataEncoder.EncoderSelector encoderSelector) {
        this.alternateHeaderName = protocolConfig.getAlternateHeaderName();
        this.preparedStatementEncoder = Objects.requireNonNull(preparedStatementEncoder, "preparedStatementEncoder is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.groupProvider = Objects.requireNonNull(groupProvider, "groupProvider is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.encoderSelector = Objects.requireNonNull(encoderSelector, "encoderSelector is null");
    }

    /*
     * Loose catch block
     */
    public SessionContext createSessionContext(MultivaluedMap<String, String> headers, Optional<String> remoteAddress, Optional<Identity> authenticatedIdentity) {
        ProtocolHeaders protocolHeaders;
        try {
            protocolHeaders = ProtocolHeaders.detectProtocol(this.alternateHeaderName, (Set)headers.keySet());
        }
        catch (ProtocolDetectionException e) {
            throw new BadRequestException(e.getMessage());
        }
        Optional<String> catalog = Optional.ofNullable(HttpRequestSessionContextFactory.trimEmptyToNull((String)headers.getFirst((Object)protocolHeaders.requestCatalog())));
        Optional<String> schema = Optional.ofNullable(HttpRequestSessionContextFactory.trimEmptyToNull((String)headers.getFirst((Object)protocolHeaders.requestSchema())));
        Optional<String> path = Optional.ofNullable(HttpRequestSessionContextFactory.trimEmptyToNull((String)headers.getFirst((Object)protocolHeaders.requestPath())));
        HttpRequestSessionContextFactory.assertRequest(catalog.isPresent() || schema.isEmpty(), "Schema is set but catalog is not", new Object[0]);
        Objects.requireNonNull(authenticatedIdentity, "authenticatedIdentity is null");
        Identity identity = this.buildSessionIdentity(authenticatedIdentity, protocolHeaders, headers);
        Identity originalIdentity = this.buildSessionOriginalIdentity(identity, protocolHeaders, headers);
        SelectedRole selectedRole = HttpRequestSessionContextFactory.parseSystemRoleHeaders(protocolHeaders, headers);
        Optional<String> source = Optional.ofNullable((String)headers.getFirst((Object)protocolHeaders.requestSource()));
        Optional<String> traceToken = Optional.ofNullable(HttpRequestSessionContextFactory.trimEmptyToNull((String)headers.getFirst((Object)protocolHeaders.requestTraceToken())));
        Optional<String> userAgent = Optional.ofNullable((String)headers.getFirst((Object)"User-Agent"));
        Optional<String> remoteUserAddress = Objects.requireNonNull(remoteAddress, "remoteAddress is null");
        Optional<String> timeZoneId = Optional.ofNullable((String)headers.getFirst((Object)protocolHeaders.requestTimeZone()));
        Optional<String> language = Optional.ofNullable((String)headers.getFirst((Object)protocolHeaders.requestLanguage()));
        Optional<String> clientInfo = Optional.ofNullable((String)headers.getFirst((Object)protocolHeaders.requestClientInfo()));
        Optional<String> queryDataEncoding = Optional.ofNullable((String)headers.getFirst((Object)protocolHeaders.requestQueryDataEncoding())).map(arg_0 -> ((Splitter)Splitter.on((char)',').trimResults().omitEmptyStrings()).splitToList(arg_0)).flatMap(this.encoderSelector::select).map(QueryDataEncoder.Factory::encoding);
        Set<String> clientTags = HttpRequestSessionContextFactory.parseClientTags(protocolHeaders, headers);
        Set<String> clientCapabilities = HttpRequestSessionContextFactory.parseClientCapabilities(protocolHeaders, headers);
        ResourceEstimates resourceEstimates = HttpRequestSessionContextFactory.parseResourceEstimate(protocolHeaders, headers);
        ImmutableMap.Builder systemProperties = ImmutableMap.builder();
        HashMap<String, Map<String, String>> catalogSessionProperties = new HashMap();
        block11: for (Map.Entry<String, String> entry2 : HttpRequestSessionContextFactory.parseSessionHeaders(protocolHeaders, headers).entrySet()) {
            String fullPropertyName = entry2.getKey();
            String propertyValue = entry2.getValue();
            Objects.requireNonNull(HttpRequestSessionContextFactory.parseSessionPropertyName(fullPropertyName));
            int n = 0;
            block12: while (true) {
                ParsedSessionPropertyName parsedSessionPropertyName;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ParsedSessionPropertyName.class, ParsedSessionPropertyName.class}, (ParsedSessionPropertyName)parsedSessionPropertyName, n)) {
                    case 0: {
                        Object object;
                        ParsedSessionPropertyName parsedSessionPropertyName2 = parsedSessionPropertyName;
                        Object catalogName = object = parsedSessionPropertyName2.catalog();
                        Object propertyName = object = parsedSessionPropertyName2.name();
                        if (!((Optional)catalogName).isEmpty()) {
                            n = 1;
                            continue block12;
                        }
                        HttpRequestSessionContextFactory.assertRequest(!((String)propertyName).isEmpty(), "Invalid %s header", protocolHeaders.requestSession());
                        systemProperties.put(propertyName, (Object)propertyValue);
                        continue block11;
                    }
                    case 1: {
                        Object object = parsedSessionPropertyName;
                        Object object2 = ((ParsedSessionPropertyName)object).catalog();
                        Optional<String> catalogName = object2;
                        Object propertyName = object2 = ((ParsedSessionPropertyName)object).name();
                        HttpRequestSessionContextFactory.assertRequest(!catalogName.orElseThrow().isEmpty(), "Invalid %s header", protocolHeaders.requestSession());
                        HttpRequestSessionContextFactory.assertRequest(!((String)propertyName).isEmpty(), "Invalid %s header", protocolHeaders.requestSession());
                        catalogSessionProperties.computeIfAbsent(catalogName.orElseThrow(), id -> new HashMap()).put(propertyName, propertyValue);
                        continue block11;
                    }
                }
                break;
            }
            throw new BadRequestException(String.format("Invalid %s header", protocolHeaders.requestSession()));
        }
        Objects.requireNonNull(catalogSessionProperties, "catalogSessionProperties is null");
        catalogSessionProperties = (Map)catalogSessionProperties.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ImmutableMap.copyOf((Map)((Map)entry.getValue()))));
        Map<String, String> preparedStatements = this.parsePreparedStatementsHeaders(protocolHeaders, headers);
        String transactionIdHeader = (String)headers.getFirst((Object)protocolHeaders.requestTransactionId());
        boolean clientTransactionSupport = transactionIdHeader != null;
        Optional<TransactionId> transactionId = HttpRequestSessionContextFactory.parseTransactionId(transactionIdHeader);
        return new SessionContext(protocolHeaders, catalog, schema, path, authenticatedIdentity, identity, originalIdentity, selectedRole, source, traceToken, userAgent, remoteUserAddress, timeZoneId, language, clientTags, clientCapabilities, resourceEstimates, (Map<String, String>)systemProperties.buildOrThrow(), catalogSessionProperties, preparedStatements, transactionId, clientTransactionSupport, clientInfo, queryDataEncoding);
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    public Identity extractAuthorizedIdentity(HttpServletRequest servletRequest, HttpHeaders httpHeaders) {
        return this.extractAuthorizedIdentity(ServletSecurityUtils.authenticatedIdentity(servletRequest), (MultivaluedMap<String, String>)httpHeaders.getRequestHeaders());
    }

    public Identity extractAuthorizedIdentity(Optional<Identity> optionalAuthenticatedIdentity, MultivaluedMap<String, String> headers) throws AccessDeniedException {
        ProtocolHeaders protocolHeaders;
        try {
            protocolHeaders = ProtocolHeaders.detectProtocol(this.alternateHeaderName, (Set)headers.keySet());
        }
        catch (ProtocolDetectionException e) {
            throw new BadRequestException(e.getMessage());
        }
        Identity identity = this.buildSessionIdentity(optionalAuthenticatedIdentity, protocolHeaders, headers);
        Identity originalIdentity = this.buildSessionOriginalIdentity(identity, protocolHeaders, headers);
        this.accessControl.checkCanSetUser(originalIdentity.getPrincipal(), originalIdentity.getUser());
        optionalAuthenticatedIdentity.ifPresent(authenticatedIdentity -> {
            if (!authenticatedIdentity.getUser().equals(originalIdentity.getUser())) {
                authenticatedIdentity = Identity.from((Identity)authenticatedIdentity).withEnabledRoles(this.metadata.listEnabledRoles((Identity)authenticatedIdentity)).build();
                this.accessControl.checkCanImpersonateUser((Identity)authenticatedIdentity, originalIdentity.getUser());
            }
        });
        if (!originalIdentity.getUser().equals(identity.getUser())) {
            this.accessControl.checkCanSetUser(originalIdentity.getPrincipal(), identity.getUser());
            this.accessControl.checkCanImpersonateUser(originalIdentity, identity.getUser());
        }
        return HttpRequestSessionContextFactory.addEnabledRoles(identity, HttpRequestSessionContextFactory.parseSystemRoleHeaders(protocolHeaders, headers), this.metadata);
    }

    public static Identity addEnabledRoles(Identity identity, SelectedRole selectedRole, Metadata metadata) {
        if (selectedRole.getType() == SelectedRole.Type.NONE) {
            return identity;
        }
        ImmutableSet enabledRoles = metadata.listEnabledRoles(identity);
        if (selectedRole.getType() == SelectedRole.Type.ROLE) {
            String role = (String)selectedRole.getRole().orElseThrow();
            if (!enabledRoles.contains(role)) {
                AccessDeniedException.denySetRole((String)role);
            }
            enabledRoles = ImmutableSet.of((Object)role);
        }
        return Identity.from((Identity)identity).withEnabledRoles(enabledRoles).build();
    }

    private Identity buildSessionIdentity(Optional<Identity> authenticatedIdentity, ProtocolHeaders protocolHeaders, MultivaluedMap<String, String> headers) {
        String trinoUser = HttpRequestSessionContextFactory.trimEmptyToNull((String)headers.getFirst((Object)protocolHeaders.requestUser()));
        String user = trinoUser != null ? trinoUser : (String)authenticatedIdentity.map(Identity::getUser).orElse(null);
        HttpRequestSessionContextFactory.assertRequest(user != null, "User must be set", new Object[0]);
        SelectedRole systemRole = HttpRequestSessionContextFactory.parseSystemRoleHeaders(protocolHeaders, headers);
        ImmutableSet.Builder systemEnabledRoles = ImmutableSet.builder();
        if (systemRole.getType() == SelectedRole.Type.ROLE) {
            systemEnabledRoles.add((Object)((String)systemRole.getRole().orElseThrow()));
        }
        return authenticatedIdentity.map(identity -> Identity.from((Identity)identity).withUser(user)).orElseGet(() -> Identity.forUser((String)user)).withEnabledRoles((Set)systemEnabledRoles.build()).withAdditionalConnectorRoles(HttpRequestSessionContextFactory.parseConnectorRoleHeaders(protocolHeaders, headers)).withAdditionalExtraCredentials(HttpRequestSessionContextFactory.parseExtraCredentials(protocolHeaders, headers)).withAdditionalGroups(this.groupProvider.getGroups(user)).build();
    }

    private Identity buildSessionOriginalIdentity(Identity identity, ProtocolHeaders protocolHeaders, MultivaluedMap<String, String> headers) {
        Optional<String> optionalOriginalUser = Optional.ofNullable(HttpRequestSessionContextFactory.trimEmptyToNull((String)headers.getFirst((Object)protocolHeaders.requestOriginalUser())));
        Identity originalIdentity = optionalOriginalUser.map(originalUser -> Identity.from((Identity)identity).withUser(originalUser).withExtraCredentials(new HashMap()).withGroups(this.groupProvider.getGroups(originalUser)).build()).orElse(identity);
        return originalIdentity;
    }

    private static List<String> splitHttpHeader(MultivaluedMap<String, String> headers, String name) {
        List values = (List)MoreObjects.firstNonNull((Object)((List)headers.get((Object)name)), (Object)ImmutableList.of());
        Splitter splitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
        return (List)values.stream().map(arg_0 -> ((Splitter)splitter).splitToList(arg_0)).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
    }

    private static Map<String, String> parseSessionHeaders(ProtocolHeaders protocolHeaders, MultivaluedMap<String, String> headers) {
        return HttpRequestSessionContextFactory.parseProperty(headers, protocolHeaders.requestSession());
    }

    private static SelectedRole parseSystemRoleHeaders(ProtocolHeaders protocolHeaders, MultivaluedMap<String, String> headers) {
        return HttpRequestSessionContextFactory.parseProperty(headers, protocolHeaders.requestRole()).entrySet().stream().filter(entry -> ((String)entry.getKey()).equalsIgnoreCase("system")).map(Map.Entry::getValue).map(role -> HttpRequestSessionContextFactory.toSelectedRole(protocolHeaders, role)).findFirst().orElse(new SelectedRole(SelectedRole.Type.ALL, Optional.empty()));
    }

    private static Map<String, SelectedRole> parseConnectorRoleHeaders(ProtocolHeaders protocolHeaders, MultivaluedMap<String, String> headers) {
        ImmutableMap.Builder roles = ImmutableMap.builder();
        HttpRequestSessionContextFactory.parseProperty(headers, protocolHeaders.requestRole()).forEach((key, value) -> {
            if (key.equalsIgnoreCase("system")) {
                return;
            }
            roles.put(key, (Object)HttpRequestSessionContextFactory.toSelectedRole(protocolHeaders, value));
        });
        return roles.buildOrThrow();
    }

    private static SelectedRole toSelectedRole(ProtocolHeaders protocolHeaders, String value) {
        SelectedRole role;
        try {
            role = SelectedRole.valueOf((String)value);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(String.format("Invalid %s header", protocolHeaders.requestRole()));
        }
        return role;
    }

    private static Map<String, String> parseExtraCredentials(ProtocolHeaders protocolHeaders, MultivaluedMap<String, String> headers) {
        Map<String, String> credentials = HttpRequestSessionContextFactory.parseProperty(headers, protocolHeaders.requestExtraCredential());
        for (String name : credentials.keySet()) {
            HttpRequestSessionContextFactory.assertRequest(!name.startsWith("internal$"), "Invalid extra credential name: %s", name);
        }
        return credentials;
    }

    private static Map<String, String> parseProperty(MultivaluedMap<String, String> headers, String headerName) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (String header : HttpRequestSessionContextFactory.splitHttpHeader(headers, headerName)) {
            List nameValue = Splitter.on((char)'=').trimResults().splitToList((CharSequence)header);
            HttpRequestSessionContextFactory.assertRequest(nameValue.size() == 2, "Invalid %s header", headerName);
            try {
                properties.put((String)nameValue.get(0), HttpRequestSessionContextFactory.urlDecode((String)nameValue.get(1)));
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException(String.format("Invalid %s header: %s", headerName, e));
            }
        }
        return properties;
    }

    private static Set<String> parseClientTags(ProtocolHeaders protocolHeaders, MultivaluedMap<String, String> headers) {
        Splitter splitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
        return ImmutableSet.copyOf((Iterable)splitter.split((CharSequence)Strings.nullToEmpty((String)((String)headers.getFirst((Object)protocolHeaders.requestClientTags())))));
    }

    private static Set<String> parseClientCapabilities(ProtocolHeaders protocolHeaders, MultivaluedMap<String, String> headers) {
        Splitter splitter = Splitter.on((char)',').trimResults().omitEmptyStrings();
        return ImmutableSet.copyOf((Iterable)splitter.split((CharSequence)Strings.nullToEmpty((String)((String)headers.getFirst((Object)protocolHeaders.requestClientCapabilities())))));
    }

    private static ResourceEstimates parseResourceEstimate(ProtocolHeaders protocolHeaders, MultivaluedMap<String, String> headers) {
        Session.ResourceEstimateBuilder builder = new Session.ResourceEstimateBuilder();
        HttpRequestSessionContextFactory.parseProperty(headers, protocolHeaders.requestResourceEstimate()).forEach((name, value) -> {
            try {
                switch (name.toUpperCase(Locale.ENGLISH)) {
                    case "EXECUTION_TIME": {
                        builder.setExecutionTime(Duration.valueOf((String)value));
                        return;
                    }
                    case "CPU_TIME": {
                        builder.setCpuTime(Duration.valueOf((String)value));
                        return;
                    }
                    case "PEAK_MEMORY": {
                        builder.setPeakMemory(DataSize.valueOf((String)value));
                        return;
                    }
                }
                throw new BadRequestException(String.format("Unsupported resource name %s", name));
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException(String.format("Unsupported format for resource estimate '%s': %s", value, e));
            }
        });
        return builder.build();
    }

    private static ParsedSessionPropertyName parseSessionPropertyName(String value) {
        int lastDotIndex = value.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return new ParsedSessionPropertyName(Optional.empty(), value);
        }
        return new ParsedSessionPropertyName(Optional.of(value.substring(0, lastDotIndex)), value.substring(lastDotIndex + 1));
    }

    @FormatMethod
    private static void assertRequest(boolean expression, String format, Object ... args) {
        if (!expression) {
            throw new BadRequestException(String.format(format, args));
        }
    }

    private Map<String, String> parsePreparedStatementsHeaders(ProtocolHeaders protocolHeaders, MultivaluedMap<String, String> headers) {
        ImmutableMap.Builder preparedStatements = ImmutableMap.builder();
        HttpRequestSessionContextFactory.parseProperty(headers, protocolHeaders.requestPreparedStatement()).forEach((key, value) -> {
            String statementName;
            try {
                statementName = HttpRequestSessionContextFactory.urlDecode(key);
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException(String.format("Invalid %s header: %s", protocolHeaders.requestPreparedStatement(), e.getMessage()));
            }
            String sqlString = this.preparedStatementEncoder.decodePreparedStatementFromHeader((String)value);
            SqlParser sqlParser = new SqlParser();
            try {
                sqlParser.createStatement(sqlString);
            }
            catch (ParsingException e) {
                throw new BadRequestException(String.format("Invalid %s header: %s", protocolHeaders.requestPreparedStatement(), e.getMessage()));
            }
            preparedStatements.put((Object)statementName, (Object)sqlString);
        });
        return preparedStatements.buildOrThrow();
    }

    private static Optional<TransactionId> parseTransactionId(String transactionId) {
        if ((transactionId = HttpRequestSessionContextFactory.trimEmptyToNull(transactionId)) == null || transactionId.equalsIgnoreCase("none")) {
            return Optional.empty();
        }
        try {
            return Optional.of(TransactionId.valueOf(transactionId));
        }
        catch (Exception e) {
            throw new BadRequestException(e.getMessage());
        }
    }

    private static String trimEmptyToNull(String value) {
        return Strings.emptyToNull((String)Strings.nullToEmpty((String)value).trim());
    }

    private static String urlDecode(String value) {
        return URLDecoder.decode(value, StandardCharsets.UTF_8);
    }

    private record ParsedSessionPropertyName(Optional<String> catalog, String name) {
        ParsedSessionPropertyName {
            Objects.requireNonNull(catalog, "catalog is null");
            Objects.requireNonNull(name, "name is null");
        }
    }
}

