/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol.spooling.encoding;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.CountingOutputStream;
import com.google.inject.Inject;
import io.airlift.slice.Slice;
import io.trino.Session;
import io.trino.client.spooling.DataAttribute;
import io.trino.client.spooling.DataAttributes;
import io.trino.plugin.base.util.JsonUtils;
import io.trino.server.protocol.OutputColumn;
import io.trino.server.protocol.spooling.QueryDataEncoder;
import io.trino.server.protocol.spooling.encoding.Lz4QueryDataEncoder;
import io.trino.server.protocol.spooling.encoding.ZstdQueryDataEncoder;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.SqlDate;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.SqlTime;
import io.trino.spi.type.SqlTimeWithTimeZone;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.SqlTimestampWithTimeZone;
import io.trino.spi.type.SqlVarbinary;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.type.SqlIntervalDayTime;
import io.trino.type.SqlIntervalYearMonth;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class JsonQueryDataEncoder
implements QueryDataEncoder {
    private static final String ENCODING = "json";
    private final Session session;
    private final List<OutputColumn> columns;
    private final ObjectMapper mapper;

    public JsonQueryDataEncoder(ObjectMapper mapper, Session session, List<OutputColumn> columns) {
        this.mapper = Objects.requireNonNull(mapper, "mapper is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.columns = Objects.requireNonNull(columns, "columns is null");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public DataAttributes encodeTo(OutputStream output, List<Page> pages) throws IOException {
        JsonFactory jsonFactory = JsonUtils.jsonFactory();
        ConnectorSession connectorSession = this.session.toConnectorSession();
        try (CountingOutputStream wrapper = new CountingOutputStream(output);){
            DataAttributes dataAttributes;
            block21: {
                JsonGenerator generator = jsonFactory.createGenerator((OutputStream)wrapper);
                try {
                    generator.writeStartArray();
                    for (Page page : pages) {
                        for (int position = 0; position < page.getPositionCount(); ++position) {
                            generator.writeStartArray();
                            block18: for (OutputColumn column : this.columns) {
                                Type type;
                                Block block = page.getBlock(column.sourcePageChannel());
                                if (block.isNull(position)) {
                                    generator.writeNull();
                                    continue;
                                }
                                Objects.requireNonNull(column.type());
                                int n = 0;
                                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VarcharType.class, CharType.class}, (Type)type, n)) {
                                    case 0: {
                                        VarcharType varcharType = (VarcharType)type;
                                        JsonQueryDataEncoder.writeSliceToRawUtf8(generator, varcharType.getSlice(block, position));
                                        continue block18;
                                    }
                                    case 1: {
                                        CharType charType = (CharType)type;
                                        JsonQueryDataEncoder.writeSliceToRawUtf8(generator, Chars.padSpaces((Slice)charType.getSlice(block, position), (int)charType.getLength()));
                                        continue block18;
                                    }
                                }
                                JsonQueryDataEncoder.writeValue(this.mapper, generator, column.type().getObjectValue(connectorSession, block, position));
                            }
                            generator.writeEndArray();
                        }
                    }
                    generator.writeEndArray();
                    generator.flush();
                    dataAttributes = DataAttributes.builder().set(DataAttribute.SEGMENT_SIZE, (Object)Math.toIntExact(wrapper.getCount())).build();
                    if (generator == null) break block21;
                }
                catch (Throwable throwable) {
                    if (generator != null) {
                        try {
                            generator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                generator.close();
            }
            return dataAttributes;
        }
        catch (JsonProcessingException e) {
            throw new IOException("Could not serialize to JSON", e);
        }
    }

    private static void writeValue(ObjectMapper mapper, JsonGenerator generator, Object value) throws IOException {
        Object object = value;
        int n = 0;
        block28: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, Double.class, Double.class, Float.class, Float.class, Float.class, Double.class, Integer.class, Long.class, BigInteger.class, Byte.class, BigDecimal.class, SqlDate.class, SqlDecimal.class, SqlIntervalDayTime.class, SqlIntervalYearMonth.class, SqlTime.class, SqlTimeWithTimeZone.class, SqlTimestamp.class, SqlTimestampWithTimeZone.class, SqlVarbinary.class, String.class, byte[].class, List.class, Map.class}, (Object)object, n)) {
                case -1: {
                    generator.writeNull();
                    break block28;
                }
                case 0: {
                    Boolean booleanValue = (Boolean)object;
                    generator.writeBoolean(booleanValue.booleanValue());
                    break block28;
                }
                case 1: {
                    Double doubleValue = (Double)object;
                    if (!doubleValue.isInfinite()) {
                        n = 2;
                        continue block28;
                    }
                    generator.writeString(doubleValue.toString());
                    break block28;
                }
                case 2: {
                    Double doubleValue = (Double)object;
                    if (!doubleValue.isNaN()) {
                        n = 3;
                        continue block28;
                    }
                    generator.writeString("NaN");
                    break block28;
                }
                case 3: {
                    Float floatValue = (Float)object;
                    if (!floatValue.isInfinite()) {
                        n = 4;
                        continue block28;
                    }
                    generator.writeString(floatValue.toString());
                    break block28;
                }
                case 4: {
                    Float floatValue = (Float)object;
                    if (!floatValue.isNaN()) {
                        n = 5;
                        continue block28;
                    }
                    generator.writeString("NaN");
                    break block28;
                }
                case 5: {
                    Float floatValue = (Float)object;
                    generator.writeNumber(floatValue.floatValue());
                    break block28;
                }
                case 6: {
                    Double doubleValue = (Double)object;
                    generator.writeNumber(doubleValue.doubleValue());
                    break block28;
                }
                case 7: {
                    Integer integerValue = (Integer)object;
                    generator.writeNumber(integerValue.intValue());
                    break block28;
                }
                case 8: {
                    Long longValue = (Long)object;
                    generator.writeNumber(longValue.longValue());
                    break block28;
                }
                case 9: {
                    BigInteger bigIntegerValue = (BigInteger)object;
                    generator.writeNumber(bigIntegerValue);
                    break block28;
                }
                case 10: {
                    Byte byteValue = (Byte)object;
                    generator.writeNumber((short)byteValue.byteValue());
                    break block28;
                }
                case 11: {
                    BigDecimal bigDecimalValue = (BigDecimal)object;
                    generator.writeNumber(bigDecimalValue);
                    break block28;
                }
                case 12: {
                    SqlDate dateValue = (SqlDate)object;
                    generator.writeString(dateValue.toString());
                    break block28;
                }
                case 13: {
                    SqlDecimal decimalValue = (SqlDecimal)object;
                    generator.writeString(decimalValue.toString());
                    break block28;
                }
                case 14: {
                    SqlIntervalDayTime intervalValue = (SqlIntervalDayTime)object;
                    generator.writeString(intervalValue.toString());
                    break block28;
                }
                case 15: {
                    SqlIntervalYearMonth intervalValue = (SqlIntervalYearMonth)object;
                    generator.writeString(intervalValue.toString());
                    break block28;
                }
                case 16: {
                    SqlTime timeValue = (SqlTime)object;
                    generator.writeString(timeValue.toString());
                    break block28;
                }
                case 17: {
                    SqlTimeWithTimeZone timeWithTimeZone = (SqlTimeWithTimeZone)object;
                    generator.writeString(timeWithTimeZone.toString());
                    break block28;
                }
                case 18: {
                    SqlTimestamp timestamp = (SqlTimestamp)object;
                    generator.writeString(timestamp.toString());
                    break block28;
                }
                case 19: {
                    SqlTimestampWithTimeZone timestampWithTimeZone = (SqlTimestampWithTimeZone)object;
                    generator.writeString(timestampWithTimeZone.toString());
                    break block28;
                }
                case 20: {
                    SqlVarbinary varbinaryValue = (SqlVarbinary)object;
                    generator.writeBinary(varbinaryValue.getBytes());
                    break block28;
                }
                case 21: {
                    String stringValue = (String)object;
                    generator.writeString(stringValue);
                    break block28;
                }
                case 22: {
                    byte[] binaryValue = (byte[])object;
                    generator.writeBinary(binaryValue);
                    break block28;
                }
                case 23: {
                    List listValue = (List)object;
                    generator.writeStartArray();
                    for (Object element : listValue) {
                        JsonQueryDataEncoder.writeValue(mapper, generator, element);
                    }
                    generator.writeEndArray();
                    break block28;
                }
                case 24: {
                    Map mapValue = (Map)object;
                    generator.writeStartObject();
                    for (Map.Entry entry : mapValue.entrySet()) {
                        generator.writeFieldName(entry.getKey().toString());
                        JsonQueryDataEncoder.writeValue(mapper, generator, entry.getValue());
                    }
                    generator.writeEndObject();
                    break block28;
                }
                default: {
                    mapper.writeValue(generator, value);
                    break block28;
                }
            }
            break;
        }
    }

    private static void writeSliceToRawUtf8(JsonGenerator generator, Slice slice) throws IOException {
        generator.writeUTF8String(slice.byteArray(), slice.byteArrayOffset(), slice.length());
    }

    @Override
    public String encoding() {
        return ENCODING;
    }

    public static class Lz4Factory
    extends Factory {
        @Inject
        public Lz4Factory(ObjectMapper mapper) {
            super(mapper);
        }

        @Override
        public QueryDataEncoder create(Session session, List<OutputColumn> columns) {
            return new Lz4QueryDataEncoder(super.create(session, columns));
        }

        @Override
        public String encoding() {
            return super.encoding() + "+lz4";
        }
    }

    public static class ZstdFactory
    extends Factory {
        @Inject
        public ZstdFactory(ObjectMapper mapper) {
            super(mapper);
        }

        @Override
        public QueryDataEncoder create(Session session, List<OutputColumn> columns) {
            return new ZstdQueryDataEncoder(super.create(session, columns));
        }

        @Override
        public String encoding() {
            return super.encoding() + "+zstd";
        }
    }

    public static class Factory
    implements QueryDataEncoder.Factory {
        protected final JsonFactory factory = JsonUtils.jsonFactory();
        private final ObjectMapper mapper;

        @Inject
        public Factory(ObjectMapper mapper) {
            this.mapper = Objects.requireNonNull(mapper, "mapper is null");
        }

        @Override
        public QueryDataEncoder create(Session session, List<OutputColumn> columns) {
            return new JsonQueryDataEncoder(this.mapper, session, columns);
        }

        @Override
        public String encoding() {
            return JsonQueryDataEncoder.ENCODING;
        }
    }
}

