/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol.spooling.encoding;

import io.airlift.compress.v3.lz4.Lz4Compressor;
import io.trino.server.protocol.spooling.QueryDataEncoder;
import io.trino.server.protocol.spooling.encoding.CompressedQueryDataEncoder;
import java.io.IOException;
import java.io.OutputStream;

public class Lz4QueryDataEncoder
extends CompressedQueryDataEncoder {
    private static final int COMPRESSION_THRESHOLD = 8192;

    public Lz4QueryDataEncoder(QueryDataEncoder delegate) {
        super(delegate, 8192);
    }

    @Override
    protected int compress(byte[] buffer, int uncompressedSize, OutputStream output) throws IOException {
        Lz4Compressor compressor = Lz4Compressor.create();
        byte[] compressed = new byte[compressor.maxCompressedLength(uncompressedSize)];
        int compressedSize = compressor.compress(buffer, 0, uncompressedSize, compressed, 0, compressed.length);
        output.write(compressed, 0, compressedSize);
        return compressedSize;
    }

    @Override
    public String encoding() {
        return this.delegate.encoding() + "+lz4";
    }
}

