/*
 * Decompiled with CFR 0.152.
 */
package io.trino.split;

import com.google.common.base.Preconditions;
import io.trino.execution.TaskId;
import io.trino.spi.connector.ConnectorPageSinkId;

public class PageSinkId
implements ConnectorPageSinkId {
    private final long id;

    public static PageSinkId fromTaskId(TaskId taskId) {
        long stageId = taskId.getStageId().getId();
        long partitionId = taskId.getPartitionId();
        Preconditions.checkArgument((partitionId == (partitionId & 0xFFFFFFL) ? 1 : 0) != 0, (Object)"partitionId is out of allowable range");
        long attemptId = taskId.getAttemptId();
        Preconditions.checkArgument((attemptId == (attemptId & 0xFFL) ? 1 : 0) != 0, (Object)"attemptId is out of allowable range");
        long id = (stageId << 32) + (partitionId << 8) + attemptId;
        return new PageSinkId(id);
    }

    private PageSinkId(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }
}

