/*
 * Decompiled with CFR 0.152.
 */
package io.trino.split;

import com.google.common.base.MoreObjects;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.trino.spi.connector.CatalogHandle;
import io.trino.split.SplitSource;
import io.trino.tracing.TrinoAttributes;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;

public class TracingSplitSource
implements SplitSource {
    private final SplitSource source;
    private final Tracer tracer;
    private final Optional<Span> parentSpan;
    private final String spanName;

    public TracingSplitSource(SplitSource source, Tracer tracer, Optional<Span> parentSpan, String spanName) {
        this.source = Objects.requireNonNull(source, "source is null");
        this.tracer = Objects.requireNonNull(tracer, "tracer is null");
        this.parentSpan = Objects.requireNonNull(parentSpan, "parentSpan is null");
        this.spanName = Objects.requireNonNull(spanName, "spanName is null");
    }

    @Override
    public CatalogHandle getCatalogHandle() {
        return this.source.getCatalogHandle();
    }

    @Override
    public ListenableFuture<SplitSource.SplitBatch> getNextBatch(int maxSize) {
        ListenableFuture<SplitSource.SplitBatch> future;
        final Span span = this.tracer.spanBuilder(this.spanName).setParent(this.parentSpan.map(arg_0 -> ((Context)Context.current()).with(arg_0)).orElse(Context.current())).setAttribute(TrinoAttributes.SPLIT_BATCH_MAX_SIZE, (Object)maxSize).startSpan();
        try (Scope scope = span.makeCurrent();){
            future = this.source.getNextBatch(maxSize);
        }
        catch (Throwable t) {
            span.end();
            throw t;
        }
        Futures.addCallback(future, (FutureCallback)new FutureCallback<SplitSource.SplitBatch>(this){

            public void onSuccess(SplitSource.SplitBatch batch) {
                span.setAttribute(TrinoAttributes.SPLIT_BATCH_RESULT_SIZE, batch.getSplits().size());
                span.end();
            }

            public void onFailure(Throwable t) {
                span.end();
            }
        }, (Executor)MoreExecutors.directExecutor());
        return future;
    }

    @Override
    public void close() {
        try (SplitSource splitSource = this.source;){
            this.parentSpan.ifPresent(Span::end);
        }
    }

    @Override
    public boolean isFinished() {
        return this.source.isFinished();
    }

    @Override
    public Optional<List<Object>> getTableExecuteSplitsInfo() {
        return this.source.getTableExecuteSplitsInfo();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("source", (Object)this.source).toString();
    }
}

