/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen.columnar;

import io.trino.operator.project.SelectedPositions;
import io.trino.spi.Page;
import io.trino.spi.connector.ConnectorSession;
import io.trino.sql.gen.columnar.ColumnarFilter;
import io.trino.sql.gen.columnar.FilterEvaluator;
import java.util.Objects;

public final class ColumnarFilterEvaluator
implements FilterEvaluator {
    private final ColumnarFilter filter;
    private int[] outputPositions = new int[0];

    public ColumnarFilterEvaluator(ColumnarFilter filter) {
        this.filter = Objects.requireNonNull(filter, "filter is null");
    }

    @Override
    public FilterEvaluator.SelectionResult evaluate(ConnectorSession session, SelectedPositions activePositions, Page page) {
        int outputPositionsCount;
        if (activePositions.isEmpty()) {
            return new FilterEvaluator.SelectionResult(activePositions, 0L);
        }
        Page loadedPage = this.filter.getInputChannels().getInputChannels(page);
        if (this.outputPositions.length < activePositions.size()) {
            this.outputPositions = new int[activePositions.size()];
        }
        long start = System.nanoTime();
        if (activePositions.isList()) {
            outputPositionsCount = this.filter.filterPositionsList(session, this.outputPositions, activePositions.getPositions(), activePositions.getOffset(), activePositions.size(), loadedPage);
        } else {
            outputPositionsCount = this.filter.filterPositionsRange(session, this.outputPositions, activePositions.getOffset(), activePositions.size(), loadedPage);
            if (outputPositionsCount == activePositions.size()) {
                return new FilterEvaluator.SelectionResult(SelectedPositions.positionsRange(activePositions.getOffset(), outputPositionsCount), System.nanoTime() - start);
            }
        }
        return new FilterEvaluator.SelectionResult(SelectedPositions.positionsList(this.outputPositions, 0, outputPositionsCount), System.nanoTime() - start);
    }
}

