/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.rewrite;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.QualifiedObjectName;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.FixedWidthType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.QueryUtil;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.Analyzer;
import io.trino.sql.analyzer.AnalyzerFactory;
import io.trino.sql.analyzer.Field;
import io.trino.sql.analyzer.QueryType;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.rewrite.StatementRewrite;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.DescribeOutput;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Limit;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeRef;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.Query;
import io.trino.sql.tree.Relation;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.Select;
import io.trino.sql.tree.Statement;
import io.trino.sql.tree.StringLiteral;
import io.trino.type.TypeUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class DescribeOutputRewrite
implements StatementRewrite.Rewrite {
    private final SqlParser parser;

    @Inject
    public DescribeOutputRewrite(SqlParser parser) {
        this.parser = Objects.requireNonNull(parser, "parser is null");
    }

    @Override
    public Statement rewrite(AnalyzerFactory analyzerFactory, Session session, Statement node, List<Expression> parameters, Map<NodeRef<Parameter>, Expression> parameterLookup, WarningCollector warningCollector, PlanOptimizersStatsCollector planOptimizersStatsCollector) {
        return (Statement)new Visitor(session, this.parser, analyzerFactory, parameters, parameterLookup, warningCollector, planOptimizersStatsCollector).process((Node)node, null);
    }

    private static final class Visitor
    extends AstVisitor<Node, Void> {
        private static final Query EMPTY_OUTPUT = Visitor.createDesctibeOutputQuery(new Row[]{QueryUtil.row((Expression[])new Expression[]{new Cast((Expression)new NullLiteral(), TypeSignatureTranslator.toSqlType((Type)VarcharType.VARCHAR)), new Cast((Expression)new NullLiteral(), TypeSignatureTranslator.toSqlType((Type)VarcharType.VARCHAR)), new Cast((Expression)new NullLiteral(), TypeSignatureTranslator.toSqlType((Type)VarcharType.VARCHAR)), new Cast((Expression)new NullLiteral(), TypeSignatureTranslator.toSqlType((Type)VarcharType.VARCHAR)), new Cast((Expression)new NullLiteral(), TypeSignatureTranslator.toSqlType((Type)VarcharType.VARCHAR)), new Cast((Expression)new NullLiteral(), TypeSignatureTranslator.toSqlType((Type)BigintType.BIGINT)), new Cast((Expression)new NullLiteral(), TypeSignatureTranslator.toSqlType((Type)BooleanType.BOOLEAN))})}, Optional.of(new Limit((Expression)new LongLiteral("0"))));
        private final Session session;
        private final SqlParser parser;
        private final AnalyzerFactory analyzerFactory;
        private final List<Expression> parameters;
        private final Map<NodeRef<Parameter>, Expression> parameterLookup;
        private final WarningCollector warningCollector;
        private final PlanOptimizersStatsCollector planOptimizersStatsCollector;

        public Visitor(Session session, SqlParser parser, AnalyzerFactory analyzerFactory, List<Expression> parameters, Map<NodeRef<Parameter>, Expression> parameterLookup, WarningCollector warningCollector, PlanOptimizersStatsCollector planOptimizersStatsCollector) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.parser = Objects.requireNonNull(parser, "parser is null");
            this.analyzerFactory = analyzerFactory;
            this.parameters = parameters;
            this.parameterLookup = parameterLookup;
            this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
            this.planOptimizersStatsCollector = Objects.requireNonNull(planOptimizersStatsCollector, "planOptimizersStatsCollector is null");
        }

        protected Node visitDescribeOutput(DescribeOutput node, Void context) {
            String sqlString = this.session.getPreparedStatement(node.getName().getValue());
            Statement statement = this.parser.createStatement(sqlString);
            Analyzer analyzer = this.analyzerFactory.createAnalyzer(this.session, this.parameters, this.parameterLookup, this.warningCollector, this.planOptimizersStatsCollector);
            Analysis analysis = analyzer.analyze(statement, QueryType.DESCRIBE);
            Optional<Node> limit = Optional.empty();
            Row[] rows = (Row[])analysis.getRootScope().getRelationType().getVisibleFields().stream().map(field -> this.createDescribeOutputRow((Field)field, analysis)).toArray(Row[]::new);
            if (rows.length == 0) {
                return EMPTY_OUTPUT;
            }
            return Visitor.createDesctibeOutputQuery(rows, limit);
        }

        private static Query createDesctibeOutputQuery(Row[] rows, Optional<Node> limit) {
            return QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{QueryUtil.identifier((String)"Column Name"), QueryUtil.identifier((String)"Catalog"), QueryUtil.identifier((String)"Schema"), QueryUtil.identifier((String)"Table"), QueryUtil.identifier((String)"Type"), QueryUtil.identifier((String)"Type Size"), QueryUtil.identifier((String)"Aliased")}), (Relation)QueryUtil.aliased((Relation)QueryUtil.values((Row[])rows), (String)"Statement Output", (List)ImmutableList.of((Object)"Column Name", (Object)"Catalog", (Object)"Schema", (Object)"Table", (Object)"Type", (Object)"Type Size", (Object)"Aliased")), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), limit);
        }

        private Row createDescribeOutputRow(Field field, Analysis analysis) {
            Object columnName;
            LongLiteral typeSize = new LongLiteral("0");
            if (field.getType() instanceof FixedWidthType) {
                typeSize = new LongLiteral(String.valueOf(((FixedWidthType)field.getType()).getFixedSize()));
            }
            if (field.getName().isPresent()) {
                columnName = field.getName().get();
            } else {
                int columnIndex = ImmutableList.copyOf(analysis.getOutputDescriptor().getVisibleFields()).indexOf((Object)field);
                columnName = "_col" + columnIndex;
            }
            Optional<QualifiedObjectName> originTable = field.getOriginTable();
            return QueryUtil.row((Expression[])new Expression[]{new StringLiteral((String)columnName), new StringLiteral(originTable.map(QualifiedObjectName::catalogName).orElse("")), new StringLiteral(originTable.map(QualifiedObjectName::schemaName).orElse("")), new StringLiteral(originTable.map(QualifiedObjectName::objectName).orElse("")), new StringLiteral(TypeUtils.getDisplayLabel(field.getType(), SystemSessionProperties.isOmitDateTimeTypePrecision(this.session))), typeSize, new BooleanLiteral(String.valueOf(field.isAliased()))});
        }

        protected Node visitNode(Node node, Void context) {
            return node;
        }
    }
}

