/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.trino.array.LongBigArray;
import io.trino.operator.RowIdHashStrategy;
import io.trino.operator.RowReference;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.Objects;

public class TopNPeerGroupLookup {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(TopNPeerGroupLookup.class);
    private Buffer buffer;
    private long mask;
    private final RowIdHashStrategy strategy;
    private long tableSize;
    private long maxFill;
    private final float fillFactor;
    private long entryCount;
    private final long unmappedGroupId;
    private final long defaultReturnValue;

    public TopNPeerGroupLookup(long expected, float fillFactor, RowIdHashStrategy strategy, long unmappedGroupId, long defaultReturnValue) {
        Preconditions.checkArgument((expected >= 0L ? 1 : 0) != 0, (Object)"The expected number of elements must be nonnegative");
        Preconditions.checkArgument((fillFactor > 0.0f && fillFactor <= 1.0f ? 1 : 0) != 0, (Object)"Load factor must be greater than 0 and smaller than or equal to 1");
        this.fillFactor = fillFactor;
        this.strategy = Objects.requireNonNull(strategy, "strategy is null");
        this.unmappedGroupId = unmappedGroupId;
        this.defaultReturnValue = defaultReturnValue;
        this.tableSize = HashCommon.bigArraySize((long)expected, (float)fillFactor);
        this.mask = this.tableSize - 1L;
        this.maxFill = HashCommon.maxFill((long)this.tableSize, (float)fillFactor);
        this.buffer = new Buffer(this.tableSize, unmappedGroupId);
    }

    public TopNPeerGroupLookup(long expected, RowIdHashStrategy strategy, long unmappedGroupId, long defaultReturnValue) {
        this(expected, 0.75f, strategy, unmappedGroupId, defaultReturnValue);
    }

    public long sizeOf() {
        return (long)INSTANCE_SIZE + this.buffer.sizeOf();
    }

    public long size() {
        return this.entryCount;
    }

    public boolean isEmpty() {
        return this.entryCount == 0L;
    }

    public long get(long groupId, long rowId) {
        Preconditions.checkArgument((groupId != this.unmappedGroupId ? 1 : 0) != 0, (Object)"Group ID cannot be the unmapped group ID");
        long hash = this.hash(groupId, rowId);
        long index = hash & this.mask;
        if (this.buffer.isEmptySlot(index)) {
            return this.defaultReturnValue;
        }
        if (hash == this.buffer.getPrecomputedHash(index) && this.equals(groupId, rowId, index)) {
            return this.buffer.getValue(index);
        }
        do {
            if (!this.buffer.isEmptySlot(index = index + 1L & this.mask)) continue;
            return this.defaultReturnValue;
        } while (hash != this.buffer.getPrecomputedHash(index) || !this.equals(groupId, rowId, index));
        return this.buffer.getValue(index);
    }

    public long get(long groupId, RowReference rowReference) {
        Preconditions.checkArgument((groupId != this.unmappedGroupId ? 1 : 0) != 0, (Object)"Group ID cannot be the unmapped group ID");
        long hash = this.hash(groupId, rowReference);
        long index = hash & this.mask;
        if (this.buffer.isEmptySlot(index)) {
            return this.defaultReturnValue;
        }
        if (hash == this.buffer.getPrecomputedHash(index) && this.equals(groupId, rowReference, index)) {
            return this.buffer.getValue(index);
        }
        do {
            if (!this.buffer.isEmptySlot(index = index + 1L & this.mask)) continue;
            return this.defaultReturnValue;
        } while (hash != this.buffer.getPrecomputedHash(index) || !this.equals(groupId, rowReference, index));
        return this.buffer.getValue(index);
    }

    public long put(long groupId, long rowId, long value) {
        Preconditions.checkArgument((groupId != this.unmappedGroupId ? 1 : 0) != 0, (Object)"Group ID cannot be the unmapped group ID");
        long hash = this.hash(groupId, rowId);
        long index = this.find(groupId, rowId, hash);
        if (index < 0L) {
            this.insert(TopNPeerGroupLookup.twosComplement(index), groupId, rowId, hash, value);
            return this.defaultReturnValue;
        }
        long oldValue = this.buffer.getValue(index);
        this.buffer.setValue(index, value);
        return oldValue;
    }

    private long hash(long groupId, long rowId) {
        return HashCommon.mix((long)(groupId * 31L + this.strategy.hashCode(rowId)));
    }

    private long hash(long groupId, RowReference rowReference) {
        return HashCommon.mix((long)(groupId * 31L + rowReference.hash(this.strategy)));
    }

    private boolean equals(long groupId, long rowId, long index) {
        return groupId == this.buffer.getGroupId(index) && this.strategy.equals(rowId, this.buffer.getRowId(index));
    }

    private boolean equals(long groupId, RowReference rowReference, long index) {
        return groupId == this.buffer.getGroupId(index) && rowReference.equals(this.strategy, this.buffer.getRowId(index));
    }

    private void insert(long index, long groupId, long rowId, long precomputedHash, long value) {
        this.buffer.set(index, groupId, rowId, precomputedHash, value);
        ++this.entryCount;
        if (this.entryCount > this.maxFill) {
            this.rehash(HashCommon.bigArraySize((long)(this.entryCount + 1L), (float)this.fillFactor));
        }
    }

    private long find(long groupId, long rowId, long precomputedHash) {
        long index = precomputedHash & this.mask;
        if (this.buffer.isEmptySlot(index)) {
            return TopNPeerGroupLookup.twosComplement(index);
        }
        if (precomputedHash == this.buffer.getPrecomputedHash(index) && this.equals(groupId, rowId, index)) {
            return index;
        }
        do {
            if (!this.buffer.isEmptySlot(index = index + 1L & this.mask)) continue;
            return TopNPeerGroupLookup.twosComplement(index);
        } while (precomputedHash != this.buffer.getPrecomputedHash(index) || !this.equals(groupId, rowId, index));
        return index;
    }

    public long remove(long groupId, long rowId) {
        Preconditions.checkArgument((groupId != this.unmappedGroupId ? 1 : 0) != 0, (Object)"Group ID cannot be the unmapped group ID");
        long hash = this.hash(groupId, rowId);
        long index = hash & this.mask;
        if (this.buffer.isEmptySlot(index)) {
            return this.defaultReturnValue;
        }
        if (hash == this.buffer.getPrecomputedHash(index) && this.equals(groupId, rowId, index)) {
            return this.removeEntry(index);
        }
        do {
            if (!this.buffer.isEmptySlot(index = index + 1L & this.mask)) continue;
            return this.defaultReturnValue;
        } while (hash != this.buffer.getPrecomputedHash(index) || !this.equals(groupId, rowId, index));
        return this.removeEntry(index);
    }

    private long removeEntry(long index) {
        long oldValue = this.buffer.getValue(index);
        --this.entryCount;
        this.shiftKeys(index);
        return oldValue;
    }

    private void shiftKeys(long index) {
        while (true) {
            long currentHash;
            long initialIndex = index;
            index = index + 1L & this.mask;
            while (true) {
                if (this.buffer.isEmptySlot(index)) {
                    this.buffer.clear(initialIndex);
                    return;
                }
                currentHash = this.buffer.getPrecomputedHash(index);
                long slot = currentHash & this.mask;
                if (initialIndex <= index ? initialIndex >= slot || slot > index : initialIndex >= slot && slot > index) break;
                index = index + 1L & this.mask;
            }
            this.buffer.set(initialIndex, this.buffer.getGroupId(index), this.buffer.getRowId(index), currentHash, this.buffer.getValue(index));
        }
    }

    private void rehash(long newTableSize) {
        long newMask = newTableSize - 1L;
        Buffer newBuffer = new Buffer(newTableSize, this.unmappedGroupId);
        long index = this.tableSize;
        for (long i = this.entryCount; i > 0L; --i) {
            --index;
            while (this.buffer.isEmptySlot(index)) {
                --index;
            }
            long hash = this.buffer.getPrecomputedHash(index);
            long newIndex = hash & newMask;
            if (!newBuffer.isEmptySlot(newIndex)) {
                newIndex = newIndex + 1L & newMask;
                while (!newBuffer.isEmptySlot(newIndex)) {
                    newIndex = newIndex + 1L & newMask;
                }
            }
            newBuffer.set(newIndex, this.buffer.getGroupId(index), this.buffer.getRowId(index), hash, this.buffer.getValue(index));
        }
        this.tableSize = newTableSize;
        this.mask = newMask;
        this.maxFill = HashCommon.maxFill((long)this.tableSize, (float)this.fillFactor);
        this.buffer = newBuffer;
    }

    private static long twosComplement(long value) {
        return -(value + 1L);
    }

    private static class Buffer {
        private static final long INSTANCE_SIZE = SizeOf.instanceSize(Buffer.class);
        private static final int POSITIONS_PER_ENTRY = 4;
        private static final int ROW_ID_OFFSET = 1;
        private static final int PRECOMPUTED_HASH_OFFSET = 2;
        private static final int VALUE_OFFSET = 3;
        private final LongBigArray buffer;
        private final long unmappedGroupId;

        public Buffer(long positions, long unmappedGroupId) {
            this.buffer = new LongBigArray(unmappedGroupId);
            this.buffer.ensureCapacity(positions * 4L);
            this.unmappedGroupId = unmappedGroupId;
        }

        public void set(long index, long groupId, long rowId, long precomputedHash, long value) {
            this.buffer.set(index * 4L, groupId);
            this.buffer.set(index * 4L + 1L, rowId);
            this.buffer.set(index * 4L + 2L, precomputedHash);
            this.buffer.set(index * 4L + 3L, value);
        }

        public void clear(long index) {
            this.buffer.set(index * 4L, this.unmappedGroupId);
        }

        public boolean isEmptySlot(long index) {
            return this.getGroupId(index) == this.unmappedGroupId;
        }

        public long getGroupId(long index) {
            return this.buffer.get(index * 4L);
        }

        public long getRowId(long index) {
            return this.buffer.get(index * 4L + 1L);
        }

        public long getPrecomputedHash(long index) {
            return this.buffer.get(index * 4L + 2L);
        }

        public long getValue(long index) {
            return this.buffer.get(index * 4L + 3L);
        }

        public void setValue(long index, long value) {
            this.buffer.set(index * 4L + 3L, value);
        }

        public long sizeOf() {
            return INSTANCE_SIZE + this.buffer.sizeOf();
        }
    }
}

