/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol;

import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Verify;
import io.airlift.slice.Slice;
import io.trino.Session;
import io.trino.client.ClientCapabilities;
import io.trino.server.protocol.OutputColumn;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.SqlMap;
import io.trino.spi.block.SqlRow;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.SqlDate;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.SqlTime;
import io.trino.spi.type.SqlTimeWithTimeZone;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.SqlTimestampWithTimeZone;
import io.trino.spi.type.SqlVarbinary;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.type.SqlIntervalDayTime;
import io.trino.type.SqlIntervalYearMonth;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class JsonEncodingUtils {
    private static final BigintEncoder BIGINT_ENCODER = new BigintEncoder();
    private static final BooleanEncoder BOOLEAN_ENCODER = new BooleanEncoder();
    private static final IntegerEncoder INTEGER_ENCODER = new IntegerEncoder();
    private static final SmallintEncoder SMALLINT_ENCODER = new SmallintEncoder();
    private static final DoubleEncoder DOUBLE_ENCODER = new DoubleEncoder();
    private static final RealEncoder REAL_ENCODER = new RealEncoder();
    private static final TinyintEncoder TINYINT_ENCODER = new TinyintEncoder();
    private static final VarcharEncoder VARCHAR_ENCODER = new VarcharEncoder();
    private static final VarbinaryEncoder VARBINARY_ENCODER = new VarbinaryEncoder();

    private JsonEncodingUtils() {
    }

    public static TypeEncoder[] createTypeEncoders(Session session, List<OutputColumn> columns) {
        Verify.verify((!columns.isEmpty() ? 1 : 0) != 0, (String)"Columns must not be empty", (Object[])new Object[0]);
        boolean supportsParametricDateTime = Objects.requireNonNull(session, "session is null").getClientCapabilities().contains(ClientCapabilities.PARAMETRIC_DATETIME.toString());
        return (TypeEncoder[])columns.stream().map(column -> JsonEncodingUtils.createTypeEncoder(column.type(), supportsParametricDateTime)).toArray(TypeEncoder[]::new);
    }

    public static TypeEncoder createTypeEncoder(Type type, boolean supportsParametricDateTime) {
        Type type2 = type;
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BigintType.class, BooleanType.class, IntegerType.class, SmallintType.class, DoubleType.class, RealType.class, TinyintType.class, VarcharType.class, VarbinaryType.class, CharType.class, ArrayType.class, MapType.class, RowType.class, Type.class}, (Type)type3, n)) {
            case 0 -> BIGINT_ENCODER;
            case 1 -> BOOLEAN_ENCODER;
            case 2 -> INTEGER_ENCODER;
            case 3 -> SMALLINT_ENCODER;
            case 4 -> DOUBLE_ENCODER;
            case 5 -> REAL_ENCODER;
            case 6 -> TINYINT_ENCODER;
            case 7 -> VARCHAR_ENCODER;
            case 8 -> VARBINARY_ENCODER;
            case 9 -> {
                CharType charType = (CharType)type3;
                yield new CharEncoder(charType.getLength());
            }
            case 10 -> {
                ArrayType arrayType = (ArrayType)type3;
                yield new ArrayEncoder(arrayType, JsonEncodingUtils.createTypeEncoder(arrayType.getElementType(), supportsParametricDateTime));
            }
            case 11 -> {
                MapType mapType = (MapType)type3;
                yield new MapEncoder(mapType, JsonEncodingUtils.createTypeEncoder(mapType.getValueType(), supportsParametricDateTime));
            }
            case 12 -> {
                RowType rowType = (RowType)type3;
                yield new RowEncoder(rowType, (TypeEncoder[])rowType.getTypeParameters().stream().map(elementType -> JsonEncodingUtils.createTypeEncoder(elementType, supportsParametricDateTime)).toArray(TypeEncoder[]::new));
            }
            default -> new TypeObjectValueEncoder(type, supportsParametricDateTime);
        };
    }

    public static void writePagesToJsonGenerator(ConnectorSession connectorSession, Consumer<TrinoException> throwableConsumer, JsonGenerator generator, TypeEncoder[] typeEncoders, int[] sourcePageChannels, List<Page> pages) {
        Verify.verify((typeEncoders.length == sourcePageChannels.length ? 1 : 0) != 0, (String)"Source page channels and type encoders must have the same length", (Object[])new Object[0]);
        try {
            generator.writeStartArray();
            for (Page page : pages) {
                for (int position = 0; position < page.getPositionCount(); ++position) {
                    generator.writeStartArray();
                    for (int column = 0; column < typeEncoders.length; ++column) {
                        typeEncoders[column].encode(generator, connectorSession, page.getBlock(sourcePageChannels[column]), position);
                    }
                    generator.writeEndArray();
                }
            }
            generator.writeEndArray();
            generator.flush();
        }
        catch (Exception e) {
            throwableConsumer.accept(new TrinoException((ErrorCodeSupplier)StandardErrorCode.SERIALIZATION_ERROR, "Could not serialize data to JSON", (Throwable)e));
        }
    }

    public static interface TypeEncoder {
        public void encode(JsonGenerator var1, ConnectorSession var2, Block var3, int var4) throws IOException;
    }

    private static class BigintEncoder
    implements TypeEncoder {
        private BigintEncoder() {
        }

        @Override
        public void encode(JsonGenerator generator, ConnectorSession session, Block block, int position) throws IOException {
            if (block.isNull(position)) {
                generator.writeNull();
                return;
            }
            generator.writeNumber(BigintType.BIGINT.getLong(block, position));
        }
    }

    private static class BooleanEncoder
    implements TypeEncoder {
        private BooleanEncoder() {
        }

        @Override
        public void encode(JsonGenerator generator, ConnectorSession session, Block block, int position) throws IOException {
            if (block.isNull(position)) {
                generator.writeNull();
                return;
            }
            generator.writeBoolean(BooleanType.BOOLEAN.getBoolean(block, position));
        }
    }

    private static class IntegerEncoder
    implements TypeEncoder {
        private IntegerEncoder() {
        }

        @Override
        public void encode(JsonGenerator generator, ConnectorSession session, Block block, int position) throws IOException {
            if (block.isNull(position)) {
                generator.writeNull();
                return;
            }
            generator.writeNumber(IntegerType.INTEGER.getInt(block, position));
        }
    }

    private static class SmallintEncoder
    implements TypeEncoder {
        private SmallintEncoder() {
        }

        @Override
        public void encode(JsonGenerator generator, ConnectorSession session, Block block, int position) throws IOException {
            if (block.isNull(position)) {
                generator.writeNull();
                return;
            }
            generator.writeNumber(SmallintType.SMALLINT.getShort(block, position));
        }
    }

    private static class DoubleEncoder
    implements TypeEncoder {
        private DoubleEncoder() {
        }

        @Override
        public void encode(JsonGenerator generator, ConnectorSession session, Block block, int position) throws IOException {
            if (block.isNull(position)) {
                generator.writeNull();
                return;
            }
            generator.writeNumber(DoubleType.DOUBLE.getDouble(block, position));
        }
    }

    private static class RealEncoder
    implements TypeEncoder {
        private RealEncoder() {
        }

        @Override
        public void encode(JsonGenerator generator, ConnectorSession session, Block block, int position) throws IOException {
            if (block.isNull(position)) {
                generator.writeNull();
                return;
            }
            generator.writeNumber(RealType.REAL.getFloat(block, position));
        }
    }

    private static class TinyintEncoder
    implements TypeEncoder {
        private TinyintEncoder() {
        }

        @Override
        public void encode(JsonGenerator generator, ConnectorSession session, Block block, int position) throws IOException {
            if (block.isNull(position)) {
                generator.writeNull();
                return;
            }
            generator.writeNumber((short)TinyintType.TINYINT.getByte(block, position));
        }
    }

    private static class VarcharEncoder
    implements TypeEncoder {
        private VarcharEncoder() {
        }

        @Override
        public void encode(JsonGenerator generator, ConnectorSession session, Block block, int position) throws IOException {
            if (block.isNull(position)) {
                generator.writeNull();
                return;
            }
            Slice slice = VarcharType.VARCHAR.getSlice(block, position);
            generator.writeString(slice.toStringUtf8());
        }
    }

    private static class VarbinaryEncoder
    implements TypeEncoder {
        private VarbinaryEncoder() {
        }

        @Override
        public void encode(JsonGenerator generator, ConnectorSession session, Block block, int position) throws IOException {
            if (block.isNull(position)) {
                generator.writeNull();
                return;
            }
            Slice slice = VarbinaryType.VARBINARY.getSlice(block, position);
            generator.writeBinary(slice.byteArray(), slice.byteArrayOffset(), slice.length());
        }
    }

    private static class CharEncoder
    implements TypeEncoder {
        private final int length;

        private CharEncoder(int length) {
            this.length = length;
        }

        @Override
        public void encode(JsonGenerator generator, ConnectorSession session, Block block, int position) throws IOException {
            if (block.isNull(position)) {
                generator.writeNull();
                return;
            }
            Slice slice = Chars.padSpaces((Slice)VarcharType.VARCHAR.getSlice(block, position), (int)this.length);
            generator.writeString(slice.toStringUtf8());
        }
    }

    private static class ArrayEncoder
    implements TypeEncoder {
        private final ArrayType arrayType;
        private final TypeEncoder typeEncoder;

        public ArrayEncoder(ArrayType arrayType, TypeEncoder typeEncoder) {
            this.arrayType = Objects.requireNonNull(arrayType, "arrayType is null");
            this.typeEncoder = Objects.requireNonNull(typeEncoder, "typeEncoder is null");
        }

        @Override
        public void encode(JsonGenerator generator, ConnectorSession session, Block block, int position) throws IOException {
            if (block.isNull(position)) {
                generator.writeNull();
                return;
            }
            Block arrayBlock = this.arrayType.getObject(block, position);
            generator.writeStartArray();
            for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
                this.typeEncoder.encode(generator, session, arrayBlock, i);
            }
            generator.writeEndArray();
        }
    }

    private static class MapEncoder
    implements TypeEncoder {
        private final MapType mapType;
        private final TypeEncoder valueEncoder;

        public MapEncoder(MapType mapType, TypeEncoder valueEncoder) {
            this.mapType = Objects.requireNonNull(mapType, "mapType is null");
            this.valueEncoder = Objects.requireNonNull(valueEncoder, "valueEncoder is null");
        }

        @Override
        public void encode(JsonGenerator generator, ConnectorSession session, Block block, int position) throws IOException {
            if (block.isNull(position)) {
                generator.writeNull();
                return;
            }
            SqlMap map = this.mapType.getObject(block, position);
            int offset = map.getRawOffset();
            Block keyBlock = map.getRawKeyBlock();
            Block valueBlock = map.getRawValueBlock();
            Verify.verify((keyBlock.getPositionCount() == valueBlock.getPositionCount() ? 1 : 0) != 0, (String)"Key and value blocks have different number of positions", (Object[])new Object[0]);
            generator.writeStartObject();
            for (int i = 0; i < map.getSize(); ++i) {
                generator.writeFieldName(this.mapType.getKeyType().getObjectValue(session, keyBlock, offset + i).toString());
                this.valueEncoder.encode(generator, session, valueBlock, offset + i);
            }
            generator.writeEndObject();
        }
    }

    private static class RowEncoder
    implements TypeEncoder {
        private final RowType rowType;
        private final TypeEncoder[] fieldEncoders;

        public RowEncoder(RowType rowType, TypeEncoder[] fieldEncoders) {
            this.rowType = Objects.requireNonNull(rowType, "rowType is null");
            this.fieldEncoders = Objects.requireNonNull(fieldEncoders, "fieldEncoders is null");
        }

        @Override
        public void encode(JsonGenerator generator, ConnectorSession session, Block block, int position) throws IOException {
            if (block.isNull(position)) {
                generator.writeNull();
                return;
            }
            SqlRow row = this.rowType.getObject(block, position);
            generator.writeStartArray();
            for (int i = 0; i < row.getFieldCount(); ++i) {
                this.fieldEncoders[i].encode(generator, session, row.getRawFieldBlock(i), row.getRawIndex());
            }
            generator.writeEndArray();
        }
    }

    private static class TypeObjectValueEncoder
    implements TypeEncoder {
        private final Type type;
        private final boolean supportsParametricDateTime;

        public TypeObjectValueEncoder(Type type, boolean supportsParametricDateTime) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.supportsParametricDateTime = supportsParametricDateTime;
        }

        @Override
        public void encode(JsonGenerator generator, ConnectorSession session, Block block, int position) throws IOException {
            Object value;
            if (block.isNull(position)) {
                generator.writeNull();
                return;
            }
            Object object = value = this.roundParametricTypes(this.type.getObjectValue(session, block, position));
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BigDecimal.class, SqlDate.class, SqlDecimal.class, SqlIntervalDayTime.class, SqlIntervalYearMonth.class, SqlTime.class, SqlTimeWithTimeZone.class, SqlTimestamp.class, SqlTimestampWithTimeZone.class, SqlVarbinary.class}, (Object)object2, n)) {
                case 0: {
                    BigDecimal bigDecimalValue = (BigDecimal)object2;
                    generator.writeNumber(bigDecimalValue);
                    break;
                }
                case 1: {
                    SqlDate dateValue = (SqlDate)object2;
                    generator.writeString(dateValue.toString());
                    break;
                }
                case 2: {
                    SqlDecimal decimalValue = (SqlDecimal)object2;
                    generator.writeString(decimalValue.toString());
                    break;
                }
                case 3: {
                    SqlIntervalDayTime intervalValue = (SqlIntervalDayTime)object2;
                    generator.writeString(intervalValue.toString());
                    break;
                }
                case 4: {
                    SqlIntervalYearMonth intervalValue = (SqlIntervalYearMonth)object2;
                    generator.writeString(intervalValue.toString());
                    break;
                }
                case 5: {
                    SqlTime timeValue = (SqlTime)object2;
                    generator.writeString(timeValue.toString());
                    break;
                }
                case 6: {
                    SqlTimeWithTimeZone timeWithTimeZone = (SqlTimeWithTimeZone)object2;
                    generator.writeString(timeWithTimeZone.toString());
                    break;
                }
                case 7: {
                    SqlTimestamp timestamp = (SqlTimestamp)object2;
                    generator.writeString(timestamp.toString());
                    break;
                }
                case 8: {
                    SqlTimestampWithTimeZone timestampWithTimeZone = (SqlTimestampWithTimeZone)object2;
                    generator.writeString(timestampWithTimeZone.toString());
                    break;
                }
                case 9: {
                    SqlVarbinary sqlVarbinary = (SqlVarbinary)object2;
                    generator.writeBinary(sqlVarbinary.getBytes());
                    break;
                }
                default: {
                    generator.writePOJO(value);
                }
            }
        }

        private Object roundParametricTypes(Object value) {
            if (this.supportsParametricDateTime) {
                return value;
            }
            Object object = value;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SqlTimestamp.class, SqlTimestampWithTimeZone.class, SqlTime.class, SqlTimeWithTimeZone.class}, (Object)object2, n)) {
                case 0 -> {
                    SqlTimestamp sqlTimestamp = (SqlTimestamp)object2;
                    yield sqlTimestamp.roundTo(3);
                }
                case 1 -> {
                    SqlTimestampWithTimeZone sqlTimestampWithTimeZone = (SqlTimestampWithTimeZone)object2;
                    yield sqlTimestampWithTimeZone.roundTo(3);
                }
                case 2 -> {
                    SqlTime sqlTime = (SqlTime)object2;
                    yield sqlTime.roundTo(3);
                }
                case 3 -> {
                    SqlTimeWithTimeZone sqlTimeWithTimeZone = (SqlTimeWithTimeZone)object2;
                    yield sqlTimeWithTimeZone.roundTo(3);
                }
                default -> value;
            };
        }
    }
}

