/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol.spooling;

import com.google.common.base.Verify;
import com.google.inject.Inject;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.Duration;
import io.trino.server.protocol.spooling.SpoolingConfig;
import io.trino.server.protocol.spooling.SpoolingManagerRegistry;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.protocol.SpooledLocation;
import io.trino.spi.protocol.SpooledSegmentHandle;
import io.trino.spi.protocol.SpoolingContext;
import io.trino.spi.protocol.SpoolingManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.TimeUnit;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public class SpoolingManagerBridge
implements SpoolingManager {
    private final SpoolingManagerRegistry registry;
    private final SecretKey secretKey;
    private final SpoolingConfig.SegmentRetrievalMode retrievalMode;
    private final OptionalInt maxDirectPassThroughTtl;

    @Inject
    public SpoolingManagerBridge(SpoolingConfig spoolingConfig, SpoolingManagerRegistry registry) {
        this.registry = Objects.requireNonNull(registry, "registry is null");
        Objects.requireNonNull(spoolingConfig, "spoolingConfig is null");
        this.retrievalMode = spoolingConfig.getRetrievalMode();
        this.secretKey = spoolingConfig.getSharedSecretKey().orElseThrow(() -> new IllegalArgumentException("protocol.spooling.shared-secret-key is not set"));
        this.maxDirectPassThroughTtl = SpoolingManagerBridge.fromDuration(spoolingConfig.getStorageRedirectTtl());
    }

    public SpooledSegmentHandle create(SpoolingContext context) {
        return this.delegate().create(context);
    }

    public OutputStream createOutputStream(SpooledSegmentHandle handle) throws IOException {
        return this.delegate().createOutputStream(handle);
    }

    public InputStream openInputStream(SpooledSegmentHandle handle) throws IOException {
        return this.delegate().openInputStream(handle);
    }

    public void acknowledge(SpooledSegmentHandle handle) throws IOException {
        this.delegate().acknowledge(handle);
    }

    public SpooledLocation location(SpooledSegmentHandle handle) throws IOException {
        return switch (this.retrievalMode) {
            default -> throw new MatchException(null, null);
            case SpoolingConfig.SegmentRetrievalMode.STORAGE -> SpoolingManagerBridge.toUri(this.secretKey, this.directLocation(handle, OptionalInt.empty()).orElseThrow(() -> new IllegalStateException("Retrieval mode is DIRECT but cannot generate pre-signed URI")));
            case SpoolingConfig.SegmentRetrievalMode.COORDINATOR_STORAGE_REDIRECT, SpoolingConfig.SegmentRetrievalMode.WORKER_PROXY, SpoolingConfig.SegmentRetrievalMode.COORDINATOR_PROXY -> {
                SpooledLocation v1 = this.delegate().location(handle);
                Objects.requireNonNull(v1);
                SpooledLocation var2_2 = v1;
                int var3_3 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SpooledLocation.DirectLocation.class, SpooledLocation.CoordinatorLocation.class}, (SpooledLocation)var2_2, var3_3)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        throw new IllegalStateException("Expected coordinator location but got direct one");
                    }
                    case 1: 
                }
                SpooledLocation.CoordinatorLocation coordinatorLocation = (SpooledLocation.CoordinatorLocation)var2_2;
                yield SpooledLocation.coordinatorLocation((Slice)SpoolingManagerBridge.toUri(this.secretKey, coordinatorLocation.identifier()), (Map)coordinatorLocation.headers());
            }
        };
    }

    public Optional<SpooledLocation.DirectLocation> directLocation(SpooledSegmentHandle handle, OptionalInt ttlSeconds) throws IOException {
        Verify.verify((boolean)ttlSeconds.isEmpty(), (String)"Method is expected to be called with empty TTL", (Object[])new Object[0]);
        return switch (this.retrievalMode) {
            default -> throw new MatchException(null, null);
            case SpoolingConfig.SegmentRetrievalMode.STORAGE -> this.delegate().directLocation(handle, ttlSeconds);
            case SpoolingConfig.SegmentRetrievalMode.COORDINATOR_STORAGE_REDIRECT -> this.delegate().directLocation(handle, this.maxDirectPassThroughTtl);
            case SpoolingConfig.SegmentRetrievalMode.WORKER_PROXY, SpoolingConfig.SegmentRetrievalMode.COORDINATOR_PROXY -> throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.CONFIGURATION_INVALID, "Retrieval mode doesn't allow for direct storage access");
        };
    }

    public SpooledSegmentHandle handle(Slice identifier, Map<String, List<String>> headers) {
        return this.delegate().handle(SpoolingManagerBridge.fromUri(this.secretKey, identifier), headers);
    }

    private SpoolingManager delegate() {
        return this.registry.getSpoolingManager().orElseThrow(() -> new IllegalStateException("Spooling manager is not loaded"));
    }

    private static Slice toUri(SecretKey secretKey, Slice input) {
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, secretKey);
            return Slices.utf8Slice((String)Base64.getUrlEncoder().encodeToString(cipher.doFinal(input.getBytes())));
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Could not encode segment identifier to URI", e);
        }
    }

    private static SpooledLocation.DirectLocation toUri(SecretKey secretKey, SpooledLocation.DirectLocation location) {
        return new SpooledLocation.DirectLocation(SpoolingManagerBridge.toUri(secretKey, location.identifier()), location.directUri(), location.headers());
    }

    private static Slice fromUri(SecretKey secretKey, Slice input) {
        try {
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, secretKey);
            return Slices.wrappedBuffer((byte[])cipher.doFinal(Base64.getUrlDecoder().decode(input.getBytes())));
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Could not decode segment identifier from URI", e);
        }
    }

    private static OptionalInt fromDuration(Optional<Duration> duration) {
        return duration.map(value -> OptionalInt.of((int)value.getValue(TimeUnit.SECONDS))).orElseGet(OptionalInt::empty);
    }
}

