/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import io.airlift.tracing.Tracing;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.Session;
import io.trino.client.NodeVersion;
import io.trino.cost.CachingTableStatsProvider;
import io.trino.cost.CostCalculator;
import io.trino.cost.StatsCalculator;
import io.trino.execution.ParameterExtractor;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.server.ServerConfig;
import io.trino.server.protocol.spooling.SpoolingEnabledConfig;
import io.trino.server.protocol.spooling.SpoolingManagerRegistry;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.sql.PlannerContext;
import io.trino.sql.SqlFormatter;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.Analyzer;
import io.trino.sql.analyzer.AnalyzerFactory;
import io.trino.sql.analyzer.QueryType;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.PlanFragmenter;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.PlanOptimizersFactory;
import io.trino.sql.planner.SubPlan;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.planprinter.IoPlanPrinter;
import io.trino.sql.planner.planprinter.PlanPrinter;
import io.trino.sql.tree.CreateCatalog;
import io.trino.sql.tree.CreateMaterializedView;
import io.trino.sql.tree.CreateSchema;
import io.trino.sql.tree.CreateTable;
import io.trino.sql.tree.CreateView;
import io.trino.sql.tree.DropCatalog;
import io.trino.sql.tree.DropSchema;
import io.trino.sql.tree.ExplainType;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Prepare;
import io.trino.sql.tree.Statement;
import io.trino.util.StatementUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class QueryExplainer {
    private final List<PlanOptimizer> planOptimizers;
    private final PlanFragmenter planFragmenter;
    private final PlannerContext plannerContext;
    private final AnalyzerFactory analyzerFactory;
    private final StatsCalculator statsCalculator;
    private final CostCalculator costCalculator;
    private final NodeVersion version;

    QueryExplainer(PlanOptimizersFactory planOptimizersFactory, PlanFragmenter planFragmenter, PlannerContext plannerContext, AnalyzerFactory analyzerFactory, StatsCalculator statsCalculator, CostCalculator costCalculator, NodeVersion version) {
        this.planOptimizers = Objects.requireNonNull(planOptimizersFactory.getPlanOptimizers(), "planOptimizers is null");
        this.planFragmenter = Objects.requireNonNull(planFragmenter, "planFragmenter is null");
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.analyzerFactory = Objects.requireNonNull(analyzerFactory, "analyzerFactory is null");
        this.statsCalculator = Objects.requireNonNull(statsCalculator, "statsCalculator is null");
        this.costCalculator = Objects.requireNonNull(costCalculator, "costCalculator is null");
        this.version = Objects.requireNonNull(version, "version is null");
    }

    public void validate(Session session, Statement statement, List<Expression> parameters, WarningCollector warningCollector, PlanOptimizersStatsCollector planOptimizersStatsCollector) {
        this.analyze(session, statement, parameters, warningCollector, planOptimizersStatsCollector);
    }

    public String getPlan(Session session, Statement statement, ExplainType.Type planType, List<Expression> parameters, WarningCollector warningCollector, PlanOptimizersStatsCollector planOptimizersStatsCollector) {
        Optional<String> explain = QueryExplainer.explainDataDefinition(statement, parameters);
        if (explain.isPresent()) {
            return explain.get();
        }
        return switch (planType) {
            case ExplainType.Type.LOGICAL -> {
                Plan plan = this.getLogicalPlan(session, statement, parameters, warningCollector, planOptimizersStatsCollector);
                yield PlanPrinter.textLogicalPlan(plan.getRoot(), this.plannerContext.getMetadata(), this.plannerContext.getFunctionManager(), plan.getStatsAndCosts(), session, 0, false, Optional.of(this.version));
            }
            case ExplainType.Type.DISTRIBUTED -> PlanPrinter.textDistributedPlan(this.getDistributedPlan(session, statement, parameters, warningCollector, planOptimizersStatsCollector), this.plannerContext.getMetadata(), this.plannerContext.getFunctionManager(), session, false, this.version);
            case ExplainType.Type.IO -> IoPlanPrinter.textIoPlan(this.getLogicalPlan(session, statement, parameters, warningCollector, planOptimizersStatsCollector), this.plannerContext, session);
            default -> throw new IllegalArgumentException("Unhandled plan type: " + String.valueOf(planType));
        };
    }

    public String getGraphvizPlan(Session session, Statement statement, ExplainType.Type planType, List<Expression> parameters, WarningCollector warningCollector, PlanOptimizersStatsCollector planOptimizersStatsCollector) {
        Optional<String> explain = QueryExplainer.explainDataDefinition(statement, parameters);
        if (explain.isPresent()) {
            return explain.get();
        }
        return switch (planType) {
            case ExplainType.Type.LOGICAL -> {
                Plan plan = this.getLogicalPlan(session, statement, parameters, warningCollector, planOptimizersStatsCollector);
                yield PlanPrinter.graphvizLogicalPlan(plan.getRoot());
            }
            case ExplainType.Type.DISTRIBUTED -> PlanPrinter.graphvizDistributedPlan(this.getDistributedPlan(session, statement, parameters, warningCollector, planOptimizersStatsCollector));
            default -> throw new IllegalArgumentException("Unhandled plan type: " + String.valueOf(planType));
        };
    }

    public String getJsonPlan(Session session, Statement statement, ExplainType.Type planType, List<Expression> parameters, WarningCollector warningCollector, PlanOptimizersStatsCollector planOptimizersStatsCollector) {
        Optional<String> explain = QueryExplainer.explainDataDefinition(statement, parameters);
        if (explain.isPresent()) {
            return explain.get();
        }
        return switch (planType) {
            case ExplainType.Type.IO -> IoPlanPrinter.textIoPlan(this.getLogicalPlan(session, statement, parameters, warningCollector, planOptimizersStatsCollector), this.plannerContext, session);
            case ExplainType.Type.LOGICAL -> {
                Plan plan = this.getLogicalPlan(session, statement, parameters, warningCollector, planOptimizersStatsCollector);
                yield PlanPrinter.jsonLogicalPlan(plan.getRoot(), session, this.plannerContext.getMetadata(), this.plannerContext.getFunctionManager(), plan.getStatsAndCosts());
            }
            case ExplainType.Type.DISTRIBUTED -> PlanPrinter.jsonDistributedPlan(this.getDistributedPlan(session, statement, parameters, warningCollector, planOptimizersStatsCollector), this.plannerContext.getMetadata(), this.plannerContext.getFunctionManager(), session);
            default -> throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported explain plan type %s for JSON format", planType));
        };
    }

    public Plan getLogicalPlan(Session session, Statement statement, List<Expression> parameters, WarningCollector warningCollector, PlanOptimizersStatsCollector planOptimizersStatsCollector) {
        Analysis analysis = this.analyze(session, statement, parameters, warningCollector, planOptimizersStatsCollector);
        PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
        LogicalPlanner logicalPlanner = new LogicalPlanner(session, this.planOptimizers, idAllocator, this.plannerContext, new SpoolingManagerRegistry(new ServerConfig(), new SpoolingEnabledConfig(), OpenTelemetry.noop(), Tracing.noopTracer()), this.statsCalculator, this.costCalculator, warningCollector, planOptimizersStatsCollector, new CachingTableStatsProvider(this.plannerContext.getMetadata(), session));
        return logicalPlanner.plan(analysis, LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, true);
    }

    private Analysis analyze(Session session, Statement statement, List<Expression> parameters, WarningCollector warningCollector, PlanOptimizersStatsCollector planOptimizersStatsCollector) {
        Analyzer analyzer = this.analyzerFactory.createAnalyzer(session, parameters, ParameterExtractor.bindParameters(statement, parameters), warningCollector, planOptimizersStatsCollector);
        return analyzer.analyze(statement, QueryType.EXPLAIN);
    }

    private SubPlan getDistributedPlan(Session session, Statement statement, List<Expression> parameters, WarningCollector warningCollector, PlanOptimizersStatsCollector planOptimizersStatsCollector) {
        Plan plan = this.getLogicalPlan(session, statement, parameters, warningCollector, planOptimizersStatsCollector);
        return this.planFragmenter.createSubPlans(session, plan, false, warningCollector);
    }

    private static <T extends Statement> Optional<String> explainDataDefinition(T statement, List<Expression> parameters) {
        if (!StatementUtils.isDataDefinitionStatement(statement.getClass())) {
            return Optional.empty();
        }
        T t = statement;
        Objects.requireNonNull(t);
        T t2 = t;
        int n = 0;
        return Optional.of(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CreateCatalog.class, DropCatalog.class, CreateSchema.class, DropSchema.class, CreateTable.class, CreateView.class, CreateMaterializedView.class, Prepare.class}, t2, n)) {
            case 0 -> {
                CreateCatalog createCatalog = (CreateCatalog)t2;
                yield "CREATE CATALOG " + String.valueOf(createCatalog.getCatalogName());
            }
            case 1 -> {
                DropCatalog dropCatalog = (DropCatalog)t2;
                yield "DROP CATALOG " + String.valueOf(dropCatalog.getCatalogName());
            }
            case 2 -> {
                CreateSchema createSchema = (CreateSchema)t2;
                yield "CREATE SCHEMA " + String.valueOf(createSchema.getSchemaName());
            }
            case 3 -> {
                DropSchema dropSchema = (DropSchema)t2;
                yield "DROP SCHEMA " + String.valueOf(dropSchema.getSchemaName());
            }
            case 4 -> {
                CreateTable createTable = (CreateTable)t2;
                yield "CREATE TABLE " + String.valueOf(createTable.getName());
            }
            case 5 -> {
                CreateView createView = (CreateView)t2;
                yield "CREATE VIEW " + String.valueOf(createView.getName());
            }
            case 6 -> {
                CreateMaterializedView createMaterializedView = (CreateMaterializedView)t2;
                yield "CREATE MATERIALIZED VIEW " + String.valueOf(createMaterializedView.getName());
            }
            case 7 -> {
                Prepare prepare = (Prepare)t2;
                yield "PREPARE " + String.valueOf(prepare.getName());
            }
            default -> {
                StringBuilder builder = new StringBuilder();
                builder.append(SqlFormatter.formatSql(statement));
                if (!parameters.isEmpty()) {
                    builder.append("\n").append("Parameters: ").append(parameters);
                }
                yield builder.toString();
            }
        });
    }
}

