/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import io.trino.sql.planner.OptimizerStatsRecorder;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.plan.PlanNode;
import java.util.Objects;

public final class StatsRecordingPlanOptimizer
implements PlanOptimizer {
    private final OptimizerStatsRecorder stats;
    private final PlanOptimizer delegate;

    public StatsRecordingPlanOptimizer(OptimizerStatsRecorder stats, PlanOptimizer delegate) {
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        stats.register(delegate);
    }

    @Override
    public PlanNode optimize(PlanNode plan, PlanOptimizer.Context context) {
        long duration;
        PlanNode result;
        try {
            long start = System.nanoTime();
            result = this.delegate.optimize(plan, context);
            duration = System.nanoTime() - start;
            context.planOptimizersStatsCollector().recordOptimizer(this.delegate, duration);
        }
        catch (RuntimeException e) {
            this.stats.recordFailure(this.delegate);
            context.planOptimizersStatsCollector().recordFailure(this.delegate);
            throw e;
        }
        this.stats.record(this.delegate, duration);
        return result;
    }
}

