/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.dispatcher.DispatchManager;
import io.trino.dispatcher.DispatchQuery;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryManager;
import io.trino.execution.QueryState;
import io.trino.operator.DirectExchangeClientSupplier;
import io.trino.server.ResultQueryInfo;
import io.trino.server.SessionContext;
import io.trino.server.protocol.ProtocolUtil;
import io.trino.spi.Page;
import io.trino.spi.QueryId;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.testing.DirectTrinoClient;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedRow;
import io.trino.testing.QueryFailedException;
import io.trino.util.MoreLists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import org.intellij.lang.annotations.Language;

public class TestingDirectTrinoClient {
    private final DirectTrinoClient directTrinoClient;

    public TestingDirectTrinoClient(DispatchManager dispatchManager, QueryManager queryManager, DirectExchangeClientSupplier directExchangeClientSupplier, BlockEncodingSerde blockEncodingSerde) {
        this.directTrinoClient = new DirectTrinoClient(dispatchManager, queryManager, directExchangeClientSupplier, blockEncodingSerde);
    }

    public Result execute(Session session, @Language(value="SQL") String sql) {
        return this.execute(SessionContext.fromSession(session), sql);
    }

    public Result execute(SessionContext sessionContext, @Language(value="SQL") String sql) {
        MaterializedQueryResultsListener queryResultsListener = new MaterializedQueryResultsListener();
        DispatchQuery dispatchQuery = this.directTrinoClient.execute(sessionContext, sql, queryResultsListener);
        return new Result(dispatchQuery.getQueryId(), TestingDirectTrinoClient.toMaterializedRows(dispatchQuery, queryResultsListener.columnTypes(), queryResultsListener.columnNames(), queryResultsListener.pages()));
    }

    private static MaterializedResult toMaterializedRows(DispatchQuery dispatchQuery, List<Type> columnTypes, List<String> columnNames, List<Page> pages) {
        Number value;
        QueryInfo queryInfo = dispatchQuery.getFullQueryInfo();
        ConnectorSession session = dispatchQuery.getSession().toConnectorSession();
        if (queryInfo.getState() != QueryState.FINISHED) {
            if (queryInfo.getFailureInfo() == null) {
                throw new QueryFailedException(queryInfo.getQueryId(), "Query failed without failure info");
            }
            RuntimeException remoteException = queryInfo.getFailureInfo().toException();
            throw new QueryFailedException(queryInfo.getQueryId(), Optional.ofNullable(remoteException.getMessage()).orElseGet(remoteException::toString), remoteException);
        }
        if (pages.isEmpty() && columnTypes == null) {
            return new MaterializedResult((List<MaterializedRow>)ImmutableList.of(), (List<? extends Type>)ImmutableList.of(), (List<String>)ImmutableList.of(), Optional.empty(), queryInfo.getSetSessionProperties(), queryInfo.getResetSessionProperties(), Optional.ofNullable(queryInfo.getUpdateType()), OptionalLong.empty(), MoreLists.mappedCopy(queryInfo.getWarnings(), ProtocolUtil::toClientWarning), Optional.of(ProtocolUtil.toStatementStats(new ResultQueryInfo(queryInfo))));
        }
        List<MaterializedRow> materializedRows = TestingDirectTrinoClient.toMaterializedRows(session, columnTypes, pages);
        OptionalLong updateCount = OptionalLong.empty();
        if (queryInfo.getUpdateType() != null && materializedRows.size() == 1 && columnTypes.size() == 1 && columnTypes.get(0).equals((Object)BigintType.BIGINT) && (value = (Number)materializedRows.get(0).getField(0)) != null) {
            updateCount = OptionalLong.of(value.longValue());
        }
        return new MaterializedResult(materializedRows, columnTypes, columnNames, Optional.empty(), queryInfo.getSetSessionProperties(), queryInfo.getResetSessionProperties(), Optional.ofNullable(queryInfo.getUpdateType()), updateCount, MoreLists.mappedCopy(queryInfo.getWarnings(), ProtocolUtil::toClientWarning), Optional.of(ProtocolUtil.toStatementStats(new ResultQueryInfo(queryInfo))));
    }

    private static List<MaterializedRow> toMaterializedRows(ConnectorSession session, List<Type> types, List<Page> pages) {
        ImmutableList.Builder rows = ImmutableList.builder();
        for (Page page : pages) {
            Preconditions.checkArgument((page.getChannelCount() == types.size() ? 1 : 0) != 0, (String)"Expected a page with %s columns, but got %s columns", (int)types.size(), (int)page.getChannelCount());
            for (int position = 0; position < page.getPositionCount(); ++position) {
                ArrayList<Object> values = new ArrayList(page.getChannelCount());
                for (int channel = 0; channel < page.getChannelCount(); ++channel) {
                    Type type = types.get(channel);
                    Block block = page.getBlock(channel);
                    values.add(type.getObjectValue(session, block, position));
                }
                values = Collections.unmodifiableList(values);
                rows.add((Object)new MaterializedRow(5, values));
            }
        }
        return rows.build();
    }

    record Result(QueryId queryId, MaterializedResult result) {
        Result {
            Objects.requireNonNull(queryId, "queryId is null");
            Objects.requireNonNull(result, "result is null");
        }
    }

    private static class MaterializedQueryResultsListener
    implements DirectTrinoClient.QueryResultsListener {
        private List<String> columnNames;
        private List<Type> columnTypes;
        private List<Page> pages = new ArrayList<Page>();

        private MaterializedQueryResultsListener() {
        }

        @Override
        public void setOutputColumns(List<String> columnNames, List<Type> columnTypes) {
            this.columnNames = Objects.requireNonNull(columnNames, "columnNames is null");
            this.columnTypes = Objects.requireNonNull(columnTypes, "columnTypes is null");
        }

        @Override
        public void consumeOutputPage(Page page) {
            this.pages.add(page);
        }

        public List<String> columnNames() {
            return this.columnNames;
        }

        public List<Type> columnTypes() {
            return this.columnTypes;
        }

        public List<Page> pages() {
            return this.pages;
        }
    }
}

