/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.trino.operator;

import io.trino.spi.Page;
import io.trino.spi.connector.ConnectorMergeSink;

public interface MergeRowChangeProcessor
{
    /**
     * Transform a page generated by an SQL MERGE operation into page of data columns and
     * operations. The SQL MERGE input page consists of the following:
     * <ul>
     *     <li>The write redistribution columns, if any</li>
     *     <li>For partitioned or bucketed tables, a hash value column</li>
     *     <li>The rowId column for the row from the target table if matched, or null if not matched</li>
     *     <li>The merge case row block</li>
     * </ul>
     * The output page consists of the following:
     * <ul>
     *     <li>All data columns, in table column order</li>
     *     <li>{@link ConnectorMergeSink#storeMergedRows The operation block}</li>
     *     <li>The rowId block</li>
     *     <li>The last column in the resulting page is 1 if the row is an insert
     *         derived from an update, and zero otherwise.</li>
     * </ul>
     * <p>
     * The {@link DeleteAndInsertMergeProcessor} implementation will transform each UPDATE
     * row into multiple rows: an INSERT row and a DELETE row.
     */
    Page transformPage(Page inputPage);
}
