/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provider;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.stats.Distribution;
import io.airlift.stats.TDigest;
import io.airlift.tracing.SpanSerialization;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.trino.SessionTestUtils;
import io.trino.client.NodeVersion;
import io.trino.execution.BasicStageInfo;
import io.trino.execution.Column;
import io.trino.execution.DistributionSnapshot;
import io.trino.execution.ExecutionFailureInfo;
import io.trino.execution.Input;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryState;
import io.trino.execution.QueryStats;
import io.trino.execution.StageId;
import io.trino.execution.StageInfo;
import io.trino.execution.StageState;
import io.trino.execution.StageStats;
import io.trino.execution.TestQueryStats;
import io.trino.operator.RetryPolicy;
import io.trino.plugin.base.metrics.TDigestHistogram;
import io.trino.server.BasicQueryStats;
import io.trino.server.ResultQueryInfo;
import io.trino.spi.QueryId;
import io.trino.spi.TrinoWarning;
import io.trino.spi.WarningCode;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.eventlistener.StageGcStatistics;
import io.trino.spi.metrics.Distribution;
import io.trino.spi.resourcegroups.QueryType;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.security.SelectedRole;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolKeyDeserializer;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.transaction.TransactionId;
import io.trino.type.TypeSignatureDeserializer;
import io.trino.type.TypeSignatureKeyDeserializer;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTime;
import org.junit.jupiter.api.Test;

public class TestQueryInfo {
    private static final TypeManager TYPE_MANAGER = new TestingTypeManager();

    @Test
    public void testQueryInfoRoundTrip() {
        JsonCodec codec = new JsonCodecFactory((Provider)new ObjectMapperProvider().withJsonSerializers(Map.of(Span.class, new SpanSerialization.SpanSerializer(OpenTelemetry.noop()))).withJsonDeserializers(Map.of(Span.class, new SpanSerialization.SpanDeserializer(OpenTelemetry.noop()), TypeSignature.class, new TypeSignatureDeserializer())).withKeyDeserializers(Map.of(TypeSignature.class, new TypeSignatureKeyDeserializer(), Symbol.class, new SymbolKeyDeserializer(TYPE_MANAGER)))).jsonCodec(QueryInfo.class);
        QueryInfo expected = TestQueryInfo.createQueryInfo(Optional.empty());
        QueryInfo actual = (QueryInfo)codec.fromJson(codec.toJsonBytes((Object)expected));
        Assertions.assertThat((Object)actual.getQueryId()).isEqualTo((Object)expected.getQueryId());
        Assertions.assertThat((Comparable)actual.getState()).isEqualTo((Object)expected.getState());
        Assertions.assertThat((boolean)actual.isScheduled()).isEqualTo(expected.isScheduled());
        Assertions.assertThat((OptionalDouble)actual.getProgressPercentage()).isEqualTo((Object)expected.getProgressPercentage());
        Assertions.assertThat((OptionalDouble)actual.getRunningPercentage()).isEqualTo((Object)expected.getRunningPercentage());
        Assertions.assertThat((URI)actual.getSelf()).isEqualTo((Object)expected.getSelf());
        Assertions.assertThat((List)actual.getFieldNames()).isEqualTo((Object)expected.getFieldNames());
        Assertions.assertThat((String)actual.getQuery()).isEqualTo(expected.getQuery());
        Assertions.assertThat((Optional)actual.getPreparedQuery()).isEqualTo((Object)expected.getPreparedQuery());
        TestQueryStats.assertExpectedQueryStats(actual.getQueryStats());
        Assertions.assertThat((Optional)actual.getSetCatalog()).isEqualTo((Object)expected.getSetCatalog());
        Assertions.assertThat((Optional)actual.getSetSchema()).isEqualTo((Object)expected.getSetSchema());
        Assertions.assertThat((Optional)actual.getSetPath()).isEqualTo((Object)expected.getSetPath());
        Assertions.assertThat((Map)actual.getSetSessionProperties()).isEqualTo((Object)expected.getSetSessionProperties());
        Assertions.assertThat((Collection)actual.getResetSessionProperties()).isEqualTo((Object)expected.getResetSessionProperties());
        Assertions.assertThat((Map)actual.getSetRoles()).isEqualTo((Object)expected.getSetRoles());
        Assertions.assertThat((Map)actual.getAddedPreparedStatements()).isEqualTo((Object)expected.getAddedPreparedStatements());
        Assertions.assertThat((Collection)actual.getDeallocatedPreparedStatements()).isEqualTo((Object)expected.getDeallocatedPreparedStatements());
        Assertions.assertThat((Optional)actual.getStartedTransactionId()).isEqualTo((Object)expected.getStartedTransactionId());
        Assertions.assertThat((boolean)actual.isClearTransactionId()).isEqualTo(expected.isClearTransactionId());
        Assertions.assertThat((String)actual.getUpdateType()).isEqualTo(expected.getUpdateType());
        Assertions.assertThat((Optional)actual.getOutputStage()).isEqualTo((Object)expected.getOutputStage());
        Assertions.assertThat((Object)actual.getFailureInfo()).isEqualTo((Object)expected.getFailureInfo());
        Assertions.assertThat((Object)actual.getErrorCode()).isEqualTo((Object)expected.getErrorCode());
        Assertions.assertThat((List)actual.getWarnings()).isEqualTo((Object)expected.getWarnings());
        Assertions.assertThat((Collection)actual.getInputs()).isEqualTo((Object)expected.getInputs());
        Assertions.assertThat((Optional)actual.getOutput()).isEqualTo((Object)expected.getOutput());
        Assertions.assertThat((List)actual.getReferencedTables()).isEqualTo((Object)expected.getReferencedTables());
        Assertions.assertThat((List)actual.getRoutines()).isEqualTo((Object)expected.getRoutines());
        Assertions.assertThat((boolean)actual.isFinalQueryInfo()).isEqualTo(expected.isFinalQueryInfo());
        Assertions.assertThat((Optional)actual.getResourceGroupId()).isEqualTo((Object)expected.getResourceGroupId());
        Assertions.assertThat((Optional)actual.getQueryType()).isEqualTo((Object)expected.getQueryType());
        Assertions.assertThat((Comparable)actual.getRetryPolicy()).isEqualTo((Object)expected.getRetryPolicy());
    }

    @Test
    public void testQueryInfoToResultQueryInfoConversion() {
        QueryInfo queryInfo = TestQueryInfo.createQueryInfo(Optional.of(TestQueryInfo.createStageInfo(1, StageState.FINISHED, 1)));
        QueryStats queryStats = queryInfo.getQueryStats();
        BasicQueryStats basicQueryStats = new BasicQueryStats(queryStats);
        StageInfo stageInfo = (StageInfo)queryInfo.getOutputStage().get();
        BasicStageInfo basicStageInfo = new BasicStageInfo(stageInfo);
        ResultQueryInfo resultQueryInfo = new ResultQueryInfo(queryInfo);
        Assertions.assertThat((Object)queryInfo.getQueryId()).isEqualTo((Object)resultQueryInfo.queryId());
        Assertions.assertThat((Comparable)queryInfo.getState()).isEqualTo((Object)resultQueryInfo.state());
        Assertions.assertThat((boolean)queryInfo.isScheduled()).isEqualTo(resultQueryInfo.scheduled());
        Assertions.assertThat((String)queryInfo.getUpdateType()).isEqualTo(resultQueryInfo.updateType());
        Assertions.assertThat((Object)queryInfo.getErrorCode()).isEqualTo((Object)resultQueryInfo.errorCode());
        Assertions.assertThat((boolean)queryInfo.isFinalQueryInfo()).isEqualTo(resultQueryInfo.finalQueryInfo());
        Assertions.assertThat((Object)queryInfo.getFailureInfo()).isEqualTo((Object)resultQueryInfo.failureInfo());
        Assertions.assertThat((Optional)queryInfo.getSetCatalog()).isEqualTo((Object)resultQueryInfo.setCatalog());
        Assertions.assertThat((Optional)queryInfo.getSetSchema()).isEqualTo((Object)resultQueryInfo.setSchema());
        Assertions.assertThat((Optional)queryInfo.getSetPath()).isEqualTo((Object)resultQueryInfo.setPath());
        Assertions.assertThat((Optional)queryInfo.getSetAuthorizationUser()).isEqualTo((Object)resultQueryInfo.setAuthorizationUser());
        Assertions.assertThat((boolean)queryInfo.isResetAuthorizationUser()).isEqualTo(resultQueryInfo.resetAuthorizationUser());
        Assertions.assertThat((Object)queryInfo.getErrorCode()).isEqualTo((Object)resultQueryInfo.errorCode());
        Assertions.assertThat((Map)queryInfo.getSetRoles()).isEqualTo((Object)resultQueryInfo.setRoles());
        Assertions.assertThat((Map)queryInfo.getSetSessionProperties()).isEqualTo((Object)resultQueryInfo.setSessionProperties());
        Assertions.assertThat((Collection)queryInfo.getResetSessionProperties()).isEqualTo((Object)resultQueryInfo.resetSessionProperties());
        Assertions.assertThat((Map)queryInfo.getAddedPreparedStatements()).isEqualTo((Object)resultQueryInfo.addedPreparedStatements());
        Assertions.assertThat((Collection)queryInfo.getDeallocatedPreparedStatements()).isEqualTo((Object)resultQueryInfo.deallocatedPreparedStatements());
        Assertions.assertThat((Optional)queryInfo.getStartedTransactionId()).isEqualTo((Object)resultQueryInfo.startedTransactionId());
        Assertions.assertThat((boolean)queryInfo.isClearTransactionId()).isEqualTo(resultQueryInfo.clearTransactionId());
        Assertions.assertThat((List)queryInfo.getWarnings()).isEqualTo((Object)resultQueryInfo.warnings());
        Assertions.assertThat((Comparable)queryStats.getCreateTime()).isEqualTo((Object)basicQueryStats.getCreateTime());
        Assertions.assertThat((Comparable)queryStats.getEndTime()).isEqualTo((Object)basicQueryStats.getEndTime());
        Assertions.assertThat((Comparable)queryStats.getQueuedTime()).isEqualTo((Object)basicQueryStats.getQueuedTime());
        Assertions.assertThat((Comparable)queryStats.getElapsedTime()).isEqualTo((Object)basicQueryStats.getElapsedTime());
        Assertions.assertThat((Comparable)queryStats.getExecutionTime()).isEqualTo((Object)basicQueryStats.getExecutionTime());
        Assertions.assertThat((int)queryStats.getFailedTasks()).isEqualTo(basicQueryStats.getFailedTasks());
        Assertions.assertThat((int)queryStats.getTotalDrivers()).isEqualTo(basicQueryStats.getTotalDrivers());
        Assertions.assertThat((int)queryStats.getQueuedDrivers()).isEqualTo(basicQueryStats.getQueuedDrivers());
        Assertions.assertThat((int)queryStats.getCompletedDrivers()).isEqualTo(basicQueryStats.getCompletedDrivers());
        Assertions.assertThat((int)queryStats.getRunningDrivers()).isEqualTo(basicQueryStats.getRunningDrivers());
        Assertions.assertThat((int)queryStats.getBlockedDrivers()).isEqualTo(basicQueryStats.getBlockedDrivers());
        Assertions.assertThat((long)queryStats.getRawInputPositions()).isEqualTo(basicQueryStats.getRawInputPositions());
        Assertions.assertThat((Comparable)queryStats.getRawInputDataSize()).isEqualTo((Object)basicQueryStats.getRawInputDataSize());
        Assertions.assertThat((Comparable)queryStats.getPhysicalInputDataSize()).isEqualTo((Object)basicQueryStats.getPhysicalInputDataSize());
        Assertions.assertThat((Comparable)queryStats.getPhysicalWrittenDataSize()).isEqualTo((Object)basicQueryStats.getPhysicalWrittenDataSize());
        Assertions.assertThat((Comparable)queryStats.getSpilledDataSize()).isEqualTo((Object)basicQueryStats.getSpilledDataSize());
        Assertions.assertThat((double)queryStats.getCumulativeUserMemory()).isEqualTo(basicQueryStats.getCumulativeUserMemory());
        Assertions.assertThat((double)queryStats.getFailedCumulativeUserMemory()).isEqualTo(basicQueryStats.getFailedCumulativeUserMemory());
        Assertions.assertThat((Comparable)queryStats.getUserMemoryReservation()).isEqualTo((Object)basicQueryStats.getUserMemoryReservation());
        Assertions.assertThat((Comparable)queryStats.getTotalMemoryReservation()).isEqualTo((Object)basicQueryStats.getTotalMemoryReservation());
        Assertions.assertThat((Comparable)queryStats.getPeakUserMemoryReservation()).isEqualTo((Object)basicQueryStats.getPeakUserMemoryReservation());
        Assertions.assertThat((Comparable)queryStats.getPeakTotalMemoryReservation()).isEqualTo((Object)basicQueryStats.getPeakTotalMemoryReservation());
        Assertions.assertThat((Comparable)queryStats.getTotalCpuTime()).isEqualTo((Object)basicQueryStats.getTotalCpuTime());
        Assertions.assertThat((boolean)queryStats.isFullyBlocked()).isEqualTo(basicQueryStats.isFullyBlocked());
        Assertions.assertThat((Comparable)queryStats.getTotalCpuTime()).isEqualTo((Object)basicQueryStats.getTotalCpuTime());
        Assertions.assertThat((Comparable)queryStats.getFailedCpuTime()).isEqualTo((Object)basicQueryStats.getFailedCpuTime());
        Assertions.assertThat((Comparable)queryStats.getTotalScheduledTime()).isEqualTo((Object)basicQueryStats.getTotalScheduledTime());
        Assertions.assertThat((Comparable)queryStats.getFailedScheduledTime()).isEqualTo((Object)basicQueryStats.getFailedScheduledTime());
        Assertions.assertThat((Collection)queryStats.getBlockedReasons()).isEqualTo((Object)basicQueryStats.getBlockedReasons());
        Assertions.assertThat((OptionalDouble)queryStats.getProgressPercentage()).isEqualTo((Object)basicQueryStats.getProgressPercentage());
        Assertions.assertThat((OptionalDouble)queryStats.getRunningPercentage()).isEqualTo((Object)basicQueryStats.getRunningPercentage());
        Assertions.assertThat((Object)stageInfo.getStageId()).isEqualTo((Object)basicStageInfo.getStageId());
        Assertions.assertThat((Comparable)stageInfo.getState()).isEqualTo((Object)basicStageInfo.getState());
        Assertions.assertThat((boolean)stageInfo.isCoordinatorOnly()).isEqualTo(basicStageInfo.isCoordinatorOnly());
        Assertions.assertThat((List)stageInfo.getTasks()).isEqualTo((Object)basicStageInfo.getTasks());
        Assertions.assertThat((int)stageInfo.getStageStats().getFailedTasks()).isEqualTo(basicStageInfo.getStageStats().getFailedTasks());
        Assertions.assertThat((int)stageInfo.getStageStats().getTotalDrivers()).isEqualTo(basicStageInfo.getStageStats().getTotalDrivers());
        Assertions.assertThat((int)stageInfo.getStageStats().getQueuedDrivers()).isEqualTo(basicStageInfo.getStageStats().getQueuedDrivers());
        Assertions.assertThat((int)stageInfo.getStageStats().getBlockedDrivers()).isEqualTo(basicStageInfo.getStageStats().getBlockedDrivers());
        Assertions.assertThat((Comparable)stageInfo.getStageStats().getPhysicalWrittenDataSize()).isEqualTo((Object)basicStageInfo.getStageStats().getPhysicalWrittenDataSize());
    }

    private static QueryInfo createQueryInfo(Optional<StageInfo> stageInfo) {
        return new QueryInfo(new QueryId("0"), SessionTestUtils.TEST_SESSION.toSessionRepresentation(), QueryState.FINISHED, URI.create("1"), (List)ImmutableList.of((Object)"number"), "SELECT 1 as number", Optional.of("prepared_query"), TestQueryStats.EXPECTED, Optional.of("set_catalog"), Optional.of("set_schema"), Optional.of("set_path"), Optional.of("set_authorization_user"), false, (Map)ImmutableMap.of((Object)"set_property", (Object)"set_value"), (Set)ImmutableSet.of((Object)"reset_property"), (Map)ImmutableMap.of((Object)"set_roles", (Object)new SelectedRole(SelectedRole.Type.ROLE, Optional.of("role"))), (Map)ImmutableMap.of((Object)"added_prepared_statement", (Object)"statement"), (Set)ImmutableSet.of((Object)"deallocated_prepared_statement", (Object)"statement"), Optional.of(TransactionId.create()), true, "42", stageInfo, null, null, (List)ImmutableList.of((Object)new TrinoWarning(new WarningCode(1, "name"), "message")), (Set)ImmutableSet.of((Object)new Input("catalog", new CatalogHandle.CatalogVersion("default"), "schema", "talble", Optional.empty(), (List)ImmutableList.of((Object)new Column("name", "type")), new PlanFragmentId("id"), new PlanNodeId("1"))), Optional.empty(), (List)ImmutableList.of(), (List)ImmutableList.of(), true, Optional.of(new ResourceGroupId("groupId")), Optional.of(QueryType.SELECT), RetryPolicy.TASK, false, new NodeVersion("test"));
    }

    private static StageInfo createStageInfo(int count, StageState state, int baseValue) {
        return new StageInfo(StageId.valueOf((List)ImmutableList.of((Object)"s", (Object)String.valueOf(count))), state, null, false, (List)ImmutableList.of((Object)BigintType.BIGINT), TestQueryInfo.createStageStats(baseValue), (List)ImmutableList.of(), (List)(count == 1 ? ImmutableList.of() : ImmutableList.of((Object)TestQueryInfo.createStageInfo(count - 1, state, baseValue))), (Map)ImmutableMap.of(), new ExecutionFailureInfo("", "", null, (List)ImmutableList.of(), (List)ImmutableList.of(), null, null, null));
    }

    private static StageStats createStageStats(int value) {
        return new StageStats(new DateTime((long)value), new Distribution.DistributionSnapshot((double)value, (double)value, (double)value, (double)value, (double)value, (double)value, (double)value, (double)value, (double)value, (double)value, (double)value, (double)value, (double)value, (double)value), value, value, value, value, value, value, value, value, value, (double)value, (double)value, DataSize.succinctBytes((long)value), DataSize.succinctBytes((long)value), DataSize.succinctBytes((long)value), DataSize.succinctBytes((long)value), DataSize.succinctBytes((long)value), Duration.succinctDuration((double)value, (TimeUnit)TimeUnit.SECONDS), Duration.succinctDuration((double)value, (TimeUnit)TimeUnit.SECONDS), Duration.succinctDuration((double)value, (TimeUnit)TimeUnit.SECONDS), Duration.succinctDuration((double)value, (TimeUnit)TimeUnit.SECONDS), Duration.succinctDuration((double)value, (TimeUnit)TimeUnit.SECONDS), false, (Set)ImmutableSet.of(), DataSize.succinctBytes((long)value), DataSize.succinctBytes((long)value), (long)value, (long)value, Duration.succinctDuration((double)value, (TimeUnit)TimeUnit.SECONDS), Duration.succinctDuration((double)value, (TimeUnit)TimeUnit.SECONDS), DataSize.succinctBytes((long)value), DataSize.succinctBytes((long)value), (long)value, (long)value, DataSize.succinctBytes((long)value), DataSize.succinctBytes((long)value), (long)value, (long)value, DataSize.succinctBytes((long)value), DataSize.succinctBytes((long)value), (long)value, (long)value, Duration.succinctDuration((double)value, (TimeUnit)TimeUnit.SECONDS), Duration.succinctDuration((double)value, (TimeUnit)TimeUnit.SECONDS), DataSize.succinctBytes((long)value), Optional.of(new DistributionSnapshot((Distribution)new TDigestHistogram(new TDigest()))), DataSize.succinctBytes((long)value), DataSize.succinctBytes((long)value), (long)value, (long)value, Duration.succinctDuration((double)value, (TimeUnit)TimeUnit.NANOSECONDS), Duration.succinctDuration((double)value, (TimeUnit)TimeUnit.NANOSECONDS), DataSize.succinctBytes((long)value), DataSize.succinctBytes((long)value), new StageGcStatistics(value, value, value, value, value, value, value), (List)ImmutableList.of());
    }
}

