/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.airlift.concurrent.MoreFutures;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.secrets.SecretsResolver;
import io.airlift.testing.TestingTicker;
import io.airlift.tracing.Tracing;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.client.FailureInfo;
import io.trino.client.NodeVersion;
import io.trino.eventlistener.EventListenerManager;
import io.trino.execution.BasicStageInfo;
import io.trino.execution.BasicStageStats;
import io.trino.execution.Column;
import io.trino.execution.ExecutionFailureInfo;
import io.trino.execution.Input;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryState;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.QueryStats;
import io.trino.execution.StageId;
import io.trino.execution.StageState;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.DefaultWarningCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.execution.warnings.WarningCollectorConfig;
import io.trino.metadata.Metadata;
import io.trino.metadata.TestMetadataManager;
import io.trino.plugin.base.security.AllowAllSystemAccessControl;
import io.trino.security.AccessControl;
import io.trino.security.AccessControlConfig;
import io.trino.security.AccessControlManager;
import io.trino.server.BasicQueryInfo;
import io.trino.server.BasicQueryStats;
import io.trino.server.ResultQueryInfo;
import io.trino.spi.ErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.ErrorType;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.TrinoWarning;
import io.trino.spi.WarningCode;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.resourcegroups.QueryType;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.security.SelectedRole;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.Output;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.TestingEventListenerManager;
import io.trino.tracing.TracingMetadata;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionId;
import io.trino.transaction.TransactionManager;
import java.io.IOException;
import java.net.URI;
import java.sql.SQLException;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestQueryStateMachine {
    private static final String QUERY = "sql";
    private static final URI LOCATION = URI.create("fake://fake-query");
    private static final List<Input> INPUTS = ImmutableList.of((Object)new Input("connector", new CatalogHandle.CatalogVersion("default"), "schema", "table", Optional.empty(), (List)ImmutableList.of((Object)new Column("a", "varchar")), new PlanFragmentId("fragment"), new PlanNodeId("plan-node")));
    private static final Optional<Output> OUTPUT = Optional.empty();
    private static final List<String> OUTPUT_FIELD_NAMES = ImmutableList.of((Object)"a", (Object)"b", (Object)"c");
    private static final List<Type> OUTPUT_FIELD_TYPES = ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT);
    private static final String UPDATE_TYPE = "update type";
    private static final Map<String, String> SET_SESSION_PROPERTIES = ImmutableMap.builder().put((Object)"fruit", (Object)"apple").put((Object)"drink", (Object)"coffee").buildOrThrow();
    private static final List<String> RESET_SESSION_PROPERTIES = ImmutableList.of((Object)"candy");
    private static final Optional<QueryType> QUERY_TYPE = Optional.of(QueryType.SELECT);
    private ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "=%s")));

    @AfterAll
    public void tearDown() {
        this.executor.shutdownNow();
        this.executor = null;
    }

    @Test
    public void testBasicStateChanges() {
        QueryStateMachine stateMachine = this.createQueryStateMachine();
        TestQueryStateMachine.assertState(stateMachine, QueryState.QUEUED);
        Assertions.assertThat((boolean)stateMachine.transitionToDispatching()).isTrue();
        TestQueryStateMachine.assertState(stateMachine, QueryState.DISPATCHING);
        Assertions.assertThat((boolean)stateMachine.transitionToPlanning()).isTrue();
        TestQueryStateMachine.assertState(stateMachine, QueryState.PLANNING);
        Assertions.assertThat((boolean)stateMachine.transitionToStarting()).isTrue();
        TestQueryStateMachine.assertState(stateMachine, QueryState.STARTING);
        Assertions.assertThat((boolean)stateMachine.transitionToRunning()).isTrue();
        TestQueryStateMachine.assertState(stateMachine, QueryState.RUNNING);
        Assertions.assertThat((boolean)stateMachine.transitionToFinishing()).isTrue();
        TestQueryStateMachine.assertState(stateMachine, QueryState.FINISHING);
        stateMachine.resultsConsumed();
        MoreFutures.tryGetFutureValue((Future)stateMachine.getStateChange(QueryState.FINISHING), (int)2, (TimeUnit)TimeUnit.SECONDS);
        TestQueryStateMachine.assertState(stateMachine, QueryState.FINISHED);
    }

    @Test
    public void testStateChangesWithResourceWaiting() {
        QueryStateMachine stateMachine = this.createQueryStateMachine();
        TestQueryStateMachine.assertState(stateMachine, QueryState.QUEUED);
        Assertions.assertThat((boolean)stateMachine.transitionToWaitingForResources()).isTrue();
        TestQueryStateMachine.assertState(stateMachine, QueryState.WAITING_FOR_RESOURCES);
        Assertions.assertThat((boolean)stateMachine.transitionToDispatching()).isTrue();
        TestQueryStateMachine.assertState(stateMachine, QueryState.DISPATCHING);
        Assertions.assertThat((boolean)stateMachine.transitionToPlanning()).isTrue();
        TestQueryStateMachine.assertState(stateMachine, QueryState.PLANNING);
        Assertions.assertThat((boolean)stateMachine.transitionToStarting()).isTrue();
        TestQueryStateMachine.assertState(stateMachine, QueryState.STARTING);
        Assertions.assertThat((boolean)stateMachine.transitionToRunning()).isTrue();
        TestQueryStateMachine.assertState(stateMachine, QueryState.RUNNING);
        Assertions.assertThat((boolean)stateMachine.transitionToFinishing()).isTrue();
        stateMachine.resultsConsumed();
        MoreFutures.tryGetFutureValue((Future)stateMachine.getStateChange(QueryState.FINISHING), (int)2, (TimeUnit)TimeUnit.SECONDS);
        TestQueryStateMachine.assertState(stateMachine, QueryState.FINISHED);
    }

    @Test
    public void testQueued() {
        this.assertAllTimeSpentInQueueing(QueryState.QUEUED, queryStateMachine -> {});
        this.assertAllTimeSpentInQueueing(QueryState.WAITING_FOR_RESOURCES, QueryStateMachine::transitionToWaitingForResources);
        this.assertAllTimeSpentInQueueing(QueryState.DISPATCHING, QueryStateMachine::transitionToDispatching);
        this.assertAllTimeSpentInQueueing(QueryState.PLANNING, QueryStateMachine::transitionToPlanning);
        this.assertAllTimeSpentInQueueing(QueryState.STARTING, QueryStateMachine::transitionToStarting);
        this.assertAllTimeSpentInQueueing(QueryState.RUNNING, QueryStateMachine::transitionToRunning);
        this.assertAllTimeSpentInQueueing(QueryState.FINISHED, stateMachine -> {
            stateMachine.resultsConsumed();
            stateMachine.transitionToFinishing();
            MoreFutures.tryGetFutureValue((Future)stateMachine.getStateChange(QueryState.FINISHING), (int)2, (TimeUnit)TimeUnit.SECONDS);
        });
        this.assertAllTimeSpentInQueueing(QueryState.FAILED, stateMachine -> stateMachine.transitionToFailed((Throwable)TestQueryStateMachine.newFailedCause()));
    }

    private void assertAllTimeSpentInQueueing(QueryState expectedState, Consumer<QueryStateMachine> stateTransition) {
        TestingTicker ticker = new TestingTicker();
        QueryStateMachine stateMachine = this.queryStateMachine().withTicker((Ticker)ticker).build();
        ticker.increment(7L, TimeUnit.MILLISECONDS);
        stateTransition.accept(stateMachine);
        Assertions.assertThat((Comparable)stateMachine.getQueryState()).isEqualTo((Object)expectedState);
        QueryStats queryStats = stateMachine.getQueryInfo(Optional.empty()).getQueryStats();
        Assertions.assertThat((Comparable)queryStats.getQueuedTime()).isEqualTo((Object)new Duration(7.0, TimeUnit.MILLISECONDS));
        Assertions.assertThat((Comparable)queryStats.getResourceWaitingTime()).isEqualTo((Object)new Duration(0.0, TimeUnit.MILLISECONDS));
        Assertions.assertThat((Comparable)queryStats.getDispatchingTime()).isEqualTo((Object)new Duration(0.0, TimeUnit.MILLISECONDS));
        Assertions.assertThat((Comparable)queryStats.getPlanningTime()).isEqualTo((Object)new Duration(0.0, TimeUnit.MILLISECONDS));
        Assertions.assertThat((Comparable)queryStats.getExecutionTime()).isEqualTo((Object)new Duration(0.0, TimeUnit.MILLISECONDS));
        Assertions.assertThat((Comparable)queryStats.getFinishingTime()).isEqualTo((Object)new Duration(0.0, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testPlanning() {
        QueryStateMachine stateMachine = this.createQueryStateMachine();
        Assertions.assertThat((boolean)stateMachine.transitionToPlanning()).isTrue();
        TestQueryStateMachine.assertState(stateMachine, QueryState.PLANNING);
        Assertions.assertThat((boolean)stateMachine.transitionToDispatching()).isFalse();
        TestQueryStateMachine.assertState(stateMachine, QueryState.PLANNING);
        Assertions.assertThat((boolean)stateMachine.transitionToPlanning()).isFalse();
        TestQueryStateMachine.assertState(stateMachine, QueryState.PLANNING);
        Assertions.assertThat((boolean)stateMachine.transitionToStarting()).isTrue();
        TestQueryStateMachine.assertState(stateMachine, QueryState.STARTING);
        stateMachine = this.createQueryStateMachine();
        stateMachine.transitionToPlanning();
        Assertions.assertThat((boolean)stateMachine.transitionToRunning()).isTrue();
        TestQueryStateMachine.assertState(stateMachine, QueryState.RUNNING);
        stateMachine = this.createQueryStateMachine();
        stateMachine.transitionToPlanning();
        Assertions.assertThat((boolean)stateMachine.transitionToFinishing()).isTrue();
        stateMachine.resultsConsumed();
        MoreFutures.tryGetFutureValue((Future)stateMachine.getStateChange(QueryState.FINISHING), (int)2, (TimeUnit)TimeUnit.SECONDS);
        TestQueryStateMachine.assertState(stateMachine, QueryState.FINISHED);
        stateMachine = this.createQueryStateMachine();
        stateMachine.transitionToPlanning();
        Assertions.assertThat((boolean)stateMachine.transitionToFailed((Throwable)TestQueryStateMachine.newFailedCause())).isTrue();
        TestQueryStateMachine.assertState(stateMachine, QueryState.FAILED, TestQueryStateMachine.newFailedCause());
    }

    @Test
    public void testStarting() {
        QueryStateMachine stateMachine = this.createQueryStateMachine();
        Assertions.assertThat((boolean)stateMachine.transitionToStarting()).isTrue();
        TestQueryStateMachine.assertState(stateMachine, QueryState.STARTING);
        Assertions.assertThat((boolean)stateMachine.transitionToDispatching()).isFalse();
        TestQueryStateMachine.assertState(stateMachine, QueryState.STARTING);
        Assertions.assertThat((boolean)stateMachine.transitionToPlanning()).isFalse();
        TestQueryStateMachine.assertState(stateMachine, QueryState.STARTING);
        Assertions.assertThat((boolean)stateMachine.transitionToStarting()).isFalse();
        TestQueryStateMachine.assertState(stateMachine, QueryState.STARTING);
        Assertions.assertThat((boolean)stateMachine.transitionToRunning()).isTrue();
        TestQueryStateMachine.assertState(stateMachine, QueryState.RUNNING);
        stateMachine = this.createQueryStateMachine();
        stateMachine.transitionToStarting();
        stateMachine.resultsConsumed();
        Assertions.assertThat((boolean)stateMachine.transitionToFinishing()).isTrue();
        MoreFutures.tryGetFutureValue((Future)stateMachine.getStateChange(QueryState.FINISHING), (int)2, (TimeUnit)TimeUnit.SECONDS);
        TestQueryStateMachine.assertState(stateMachine, QueryState.FINISHED);
        stateMachine = this.createQueryStateMachine();
        stateMachine.transitionToStarting();
        Assertions.assertThat((boolean)stateMachine.transitionToFailed((Throwable)TestQueryStateMachine.newFailedCause())).isTrue();
        TestQueryStateMachine.assertState(stateMachine, QueryState.FAILED, TestQueryStateMachine.newFailedCause());
    }

    @Test
    public void testRunning() {
        QueryStateMachine stateMachine = this.createQueryStateMachine();
        Assertions.assertThat((boolean)stateMachine.transitionToRunning()).isTrue();
        TestQueryStateMachine.assertState(stateMachine, QueryState.RUNNING);
        Assertions.assertThat((boolean)stateMachine.transitionToDispatching()).isFalse();
        TestQueryStateMachine.assertState(stateMachine, QueryState.RUNNING);
        Assertions.assertThat((boolean)stateMachine.transitionToPlanning()).isFalse();
        TestQueryStateMachine.assertState(stateMachine, QueryState.RUNNING);
        Assertions.assertThat((boolean)stateMachine.transitionToStarting()).isFalse();
        TestQueryStateMachine.assertState(stateMachine, QueryState.RUNNING);
        Assertions.assertThat((boolean)stateMachine.transitionToRunning()).isFalse();
        TestQueryStateMachine.assertState(stateMachine, QueryState.RUNNING);
        stateMachine.resultsConsumed();
        Assertions.assertThat((boolean)stateMachine.transitionToFinishing()).isTrue();
        MoreFutures.tryGetFutureValue((Future)stateMachine.getStateChange(QueryState.FINISHING), (int)2, (TimeUnit)TimeUnit.SECONDS);
        TestQueryStateMachine.assertState(stateMachine, QueryState.FINISHED);
        stateMachine = this.createQueryStateMachine();
        stateMachine.transitionToRunning();
        Assertions.assertThat((boolean)stateMachine.transitionToFailed((Throwable)TestQueryStateMachine.newFailedCause())).isTrue();
        TestQueryStateMachine.assertState(stateMachine, QueryState.FAILED, TestQueryStateMachine.newFailedCause());
    }

    @Test
    public void testFinished() {
        QueryStateMachine stateMachine = this.createQueryStateMachine();
        Assertions.assertThat((boolean)stateMachine.transitionToFinishing()).isTrue();
        TestQueryStateMachine.assertState(stateMachine, QueryState.FINISHING);
        stateMachine.resultsConsumed();
        MoreFutures.tryGetFutureValue((Future)stateMachine.getStateChange(QueryState.FINISHING), (int)2, (TimeUnit)TimeUnit.SECONDS);
        TestQueryStateMachine.assertFinalState(stateMachine, QueryState.FINISHED);
    }

    @Test
    public void testFailed() {
        QueryStateMachine stateMachine = this.createQueryStateMachine();
        Assertions.assertThat((boolean)stateMachine.transitionToFailed((Throwable)TestQueryStateMachine.newFailedCause())).isTrue();
        TestQueryStateMachine.assertFinalState(stateMachine, QueryState.FAILED, TestQueryStateMachine.newFailedCause());
    }

    @Test
    public void testCanceled() {
        QueryStateMachine stateMachine = this.createQueryStateMachine();
        Assertions.assertThat((boolean)stateMachine.transitionToCanceled()).isTrue();
        TestQueryStateMachine.assertFinalState(stateMachine, QueryState.FAILED, (Exception)((Object)new TrinoException((ErrorCodeSupplier)StandardErrorCode.USER_CANCELED, "canceled")));
    }

    @Test
    public void testPlanningTimeDuration() {
        TestingTicker mockTicker = new TestingTicker();
        QueryStateMachine stateMachine = this.queryStateMachine().withTicker((Ticker)mockTicker).build();
        TestQueryStateMachine.assertState(stateMachine, QueryState.QUEUED);
        mockTicker.increment(25L, TimeUnit.MILLISECONDS);
        Assertions.assertThat((boolean)stateMachine.transitionToWaitingForResources()).isTrue();
        TestQueryStateMachine.assertState(stateMachine, QueryState.WAITING_FOR_RESOURCES);
        mockTicker.increment(50L, TimeUnit.MILLISECONDS);
        Assertions.assertThat((boolean)stateMachine.transitionToDispatching()).isTrue();
        TestQueryStateMachine.assertState(stateMachine, QueryState.DISPATCHING);
        mockTicker.increment(100L, TimeUnit.MILLISECONDS);
        Assertions.assertThat((boolean)stateMachine.transitionToPlanning()).isTrue();
        TestQueryStateMachine.assertState(stateMachine, QueryState.PLANNING);
        mockTicker.increment(200L, TimeUnit.MILLISECONDS);
        Assertions.assertThat((boolean)stateMachine.transitionToStarting()).isTrue();
        TestQueryStateMachine.assertState(stateMachine, QueryState.STARTING);
        mockTicker.increment(300L, TimeUnit.MILLISECONDS);
        Assertions.assertThat((boolean)stateMachine.transitionToRunning()).isTrue();
        TestQueryStateMachine.assertState(stateMachine, QueryState.RUNNING);
        mockTicker.increment(400L, TimeUnit.MILLISECONDS);
        Assertions.assertThat((boolean)stateMachine.transitionToFinishing()).isTrue();
        stateMachine.resultsConsumed();
        MoreFutures.tryGetFutureValue((Future)stateMachine.getStateChange(QueryState.FINISHING), (int)2, (TimeUnit)TimeUnit.SECONDS);
        TestQueryStateMachine.assertState(stateMachine, QueryState.FINISHED);
        QueryStats queryStats = stateMachine.getQueryInfo(Optional.empty()).getQueryStats();
        Assertions.assertThat((long)queryStats.getElapsedTime().toMillis()).isEqualTo(1075L);
        Assertions.assertThat((long)queryStats.getQueuedTime().toMillis()).isEqualTo(25L);
        Assertions.assertThat((long)queryStats.getResourceWaitingTime().toMillis()).isEqualTo(50L);
        Assertions.assertThat((long)queryStats.getDispatchingTime().toMillis()).isEqualTo(100L);
        Assertions.assertThat((long)queryStats.getPlanningTime().toMillis()).isEqualTo(200L);
        Assertions.assertThat((long)queryStats.getFinishingTime().toMillis()).isEqualTo(0L);
        Assertions.assertThat((long)queryStats.getExecutionTime().toMillis()).isEqualTo(900L);
    }

    @Test
    public void testUpdateMemoryUsage() {
        QueryStateMachine stateMachine = this.createQueryStateMachine();
        stateMachine.updateMemoryUsage(5L, 15L, 10L, 1L, 5L, 3L);
        Assertions.assertThat((long)stateMachine.getPeakUserMemoryInBytes()).isEqualTo(5L);
        Assertions.assertThat((long)stateMachine.getPeakTotalMemoryInBytes()).isEqualTo(10L);
        Assertions.assertThat((long)stateMachine.getPeakRevocableMemoryInBytes()).isEqualTo(15L);
        Assertions.assertThat((long)stateMachine.getPeakTaskUserMemory()).isEqualTo(1L);
        Assertions.assertThat((long)stateMachine.getPeakTaskTotalMemory()).isEqualTo(3L);
        Assertions.assertThat((long)stateMachine.getPeakTaskRevocableMemory()).isEqualTo(5L);
        stateMachine.updateMemoryUsage(0L, 0L, 0L, 2L, 2L, 2L);
        Assertions.assertThat((long)stateMachine.getPeakUserMemoryInBytes()).isEqualTo(5L);
        Assertions.assertThat((long)stateMachine.getPeakTotalMemoryInBytes()).isEqualTo(10L);
        Assertions.assertThat((long)stateMachine.getPeakRevocableMemoryInBytes()).isEqualTo(15L);
        Assertions.assertThat((long)stateMachine.getPeakTaskUserMemory()).isEqualTo(2L);
        Assertions.assertThat((long)stateMachine.getPeakTaskTotalMemory()).isEqualTo(3L);
        Assertions.assertThat((long)stateMachine.getPeakTaskRevocableMemory()).isEqualTo(5L);
        stateMachine.updateMemoryUsage(1L, 1L, 1L, 1L, 10L, 5L);
        Assertions.assertThat((long)stateMachine.getPeakUserMemoryInBytes()).isEqualTo(6L);
        Assertions.assertThat((long)stateMachine.getPeakTotalMemoryInBytes()).isEqualTo(11L);
        Assertions.assertThat((long)stateMachine.getPeakRevocableMemoryInBytes()).isEqualTo(16L);
        Assertions.assertThat((long)stateMachine.getPeakTaskUserMemory()).isEqualTo(2L);
        Assertions.assertThat((long)stateMachine.getPeakTaskTotalMemory()).isEqualTo(5L);
        Assertions.assertThat((long)stateMachine.getPeakTaskRevocableMemory()).isEqualTo(10L);
        stateMachine.updateMemoryUsage(3L, 3L, 3L, 5L, 1L, 2L);
        Assertions.assertThat((long)stateMachine.getPeakUserMemoryInBytes()).isEqualTo(9L);
        Assertions.assertThat((long)stateMachine.getPeakTotalMemoryInBytes()).isEqualTo(14L);
        Assertions.assertThat((long)stateMachine.getPeakRevocableMemoryInBytes()).isEqualTo(19L);
        Assertions.assertThat((long)stateMachine.getPeakTaskUserMemory()).isEqualTo(5L);
        Assertions.assertThat((long)stateMachine.getPeakTaskTotalMemory()).isEqualTo(5L);
        Assertions.assertThat((long)stateMachine.getPeakTaskRevocableMemory()).isEqualTo(10L);
    }

    @Test
    public void testPreserveFirstFailure() throws Exception {
        final CountDownLatch cleanup = new CountDownLatch(1);
        QueryStateMachine queryStateMachine = this.queryStateMachine().withMetadata((Metadata)new TracingMetadata(this, Tracing.noopTracer(), (Metadata)TestMetadataManager.createTestMetadataManager()){

            public void cleanupQuery(Session session) {
                cleanup.countDown();
                super.cleanupQuery(session);
            }
        }).build();
        Future<?> anotherThread = this.executor.submit(() -> {
            Preconditions.checkState((boolean)Uninterruptibles.awaitUninterruptibly((CountDownLatch)cleanup, (long)10L, (TimeUnit)TimeUnit.SECONDS), (Object)"Timed out waiting for cleanup latch");
            queryStateMachine.transitionToFailed((Throwable)new IllegalStateException("Second exception"));
        });
        Future<?> failingThread = this.executor.submit(() -> queryStateMachine.transitionToFailed((Throwable)new TrinoException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, "First exception")));
        failingThread.get(10L, TimeUnit.SECONDS);
        anotherThread.get(10L, TimeUnit.SECONDS);
        ExecutionFailureInfo failureInfo = ((QueryInfo)queryStateMachine.getFinalQueryInfo().orElseThrow()).getFailureInfo();
        Assertions.assertThat((Object)failureInfo).isNotNull();
        Assertions.assertThat((Object)failureInfo.getErrorCode()).isEqualTo((Object)StandardErrorCode.TYPE_MISMATCH.toErrorCode());
        Assertions.assertThat((String)failureInfo.getMessage()).isEqualTo("First exception");
        BasicQueryInfo basicQueryInfo = queryStateMachine.getBasicQueryInfo(Optional.empty());
        Assertions.assertThat((Object)basicQueryInfo.getErrorCode()).isEqualTo((Object)StandardErrorCode.TYPE_MISMATCH.toErrorCode());
    }

    @Test
    public void testPreserveCancellation() throws Exception {
        final CountDownLatch cleanup = new CountDownLatch(1);
        QueryStateMachine queryStateMachine = this.queryStateMachine().withMetadata((Metadata)new TracingMetadata(this, Tracing.noopTracer(), (Metadata)TestMetadataManager.createTestMetadataManager()){

            public void cleanupQuery(Session session) {
                cleanup.countDown();
                super.cleanupQuery(session);
            }
        }).build();
        Future<?> anotherThread = this.executor.submit(() -> {
            Preconditions.checkState((boolean)Uninterruptibles.awaitUninterruptibly((CountDownLatch)cleanup, (long)10L, (TimeUnit)TimeUnit.SECONDS), (Object)"Timed out waiting for cleanup latch");
            queryStateMachine.transitionToFailed((Throwable)new IllegalStateException("Second exception"));
        });
        Future<Boolean> cancellingThread = this.executor.submit(() -> ((QueryStateMachine)queryStateMachine).transitionToCanceled());
        cancellingThread.get(10L, TimeUnit.SECONDS);
        anotherThread.get(10L, TimeUnit.SECONDS);
        ExecutionFailureInfo failureInfo = ((QueryInfo)queryStateMachine.getFinalQueryInfo().orElseThrow()).getFailureInfo();
        Assertions.assertThat((Object)failureInfo).isNotNull();
        Assertions.assertThat((Object)failureInfo.getErrorCode()).isEqualTo((Object)StandardErrorCode.USER_CANCELED.toErrorCode());
        Assertions.assertThat((String)failureInfo.getMessage()).isEqualTo("Query was canceled");
        BasicQueryInfo basicQueryInfo = queryStateMachine.getBasicQueryInfo(Optional.empty());
        Assertions.assertThat((Object)basicQueryInfo.getErrorCode()).isEqualTo((Object)StandardErrorCode.USER_CANCELED.toErrorCode());
    }

    @Test
    public void testGetResultQueryInfo() {
        ImmutableList trinoWarnings = ImmutableList.of((Object)new TrinoWarning(new WarningCode(0, "name"), "message"));
        TransactionId transactionId = TransactionId.valueOf((String)UUID.randomUUID().toString());
        int stageCount = 4;
        int baseStatValue = 1;
        QueryStateMachine stateMachine = this.queryStateMachine().withSetPath("path").withSetCatalog("catalog").withSetSchema("schema").withSetRoles((Map<String, SelectedRole>)ImmutableMap.of((Object)"role", (Object)SelectedRole.valueOf((String)"NONE"))).withWarningCollector((WarningCollector)new DefaultWarningCollector(new WarningCollectorConfig())).withSetAuthorizationUser("user").withWarnings((List<TrinoWarning>)trinoWarnings).withAddPreparedStatements((Map<String, String>)ImmutableMap.of((Object)"ps", (Object)"ps")).withTransactionId(transactionId).build();
        stateMachine.resultsConsumed();
        BasicStageInfo rootStage = this.createBasicStageInfo(stageCount, StageState.FINISHED, baseStatValue);
        ResultQueryInfo queryInfo = stateMachine.getResultQueryInfo(Optional.of(rootStage));
        BasicQueryStats stats = queryInfo.queryStats();
        Assertions.assertThat((Comparable)queryInfo.state()).isEqualTo((Object)QueryState.QUEUED);
        Assertions.assertThat((boolean)queryInfo.scheduled()).isTrue();
        Assertions.assertThat((String)queryInfo.updateType()).isEqualTo(UPDATE_TYPE);
        Assertions.assertThat((boolean)queryInfo.finalQueryInfo()).isFalse();
        Assertions.assertThat((Object)queryInfo.errorCode()).isNull();
        Assertions.assertThat((Object)((BasicStageInfo)queryInfo.outputStage().get())).isEqualTo((Object)rootStage);
        Assertions.assertThat((Object)queryInfo.failureInfo()).isNull();
        Assertions.assertThat((String)((String)queryInfo.setPath().get())).isEqualTo("path");
        Assertions.assertThat((String)((String)queryInfo.setCatalog().get())).isEqualTo("catalog");
        Assertions.assertThat((String)((String)queryInfo.setSchema().get())).isEqualTo("schema");
        Assertions.assertThat((String)((String)queryInfo.setAuthorizationUser().get())).isEqualTo("user");
        Assertions.assertThat((boolean)queryInfo.resetAuthorizationUser()).isFalse();
        Assertions.assertThat((Map)queryInfo.setSessionProperties()).isEqualTo((Object)ImmutableMap.of((Object)"drink", (Object)"coffee", (Object)"fruit", (Object)"apple"));
        Assertions.assertThat((Collection)queryInfo.resetSessionProperties()).isEqualTo((Object)ImmutableSet.of((Object)"candy"));
        Assertions.assertThat((Map)queryInfo.setRoles()).isEqualTo((Object)ImmutableMap.of((Object)"role", (Object)SelectedRole.valueOf((String)"NONE")));
        Assertions.assertThat((Map)queryInfo.addedPreparedStatements()).isEqualTo((Object)ImmutableMap.of((Object)"ps", (Object)"ps"));
        Assertions.assertThat((Collection)queryInfo.deallocatedPreparedStatements()).isEmpty();
        Assertions.assertThat((Object)((TransactionId)queryInfo.startedTransactionId().get())).isEqualTo((Object)transactionId);
        Assertions.assertThat((boolean)queryInfo.clearTransactionId()).isFalse();
        Assertions.assertThat((List)queryInfo.warnings()).isEqualTo((Object)trinoWarnings);
        this.assertStats(stats, baseStatValue * stageCount);
        stateMachine.transitionToFailed((Throwable)new TrinoException(() -> new ErrorCode(0, "", ErrorType.EXTERNAL), "", (Throwable)new IOException()));
        queryInfo = stateMachine.getResultQueryInfo(Optional.of(rootStage));
        Assertions.assertThat((Object)queryInfo.failureInfo()).isNotNull();
        Assertions.assertThat((int)queryInfo.errorCode().getCode()).isEqualTo(0);
        Assertions.assertThat((boolean)queryInfo.finalQueryInfo()).isTrue();
        Assertions.assertThat((Comparable)queryInfo.state()).isEqualTo((Object)QueryState.FAILED);
    }

    private void assertStats(BasicQueryStats stats, int expectedStatsValue) {
        Assertions.assertThat((Comparable)stats.getCreateTime()).isNotNull();
        Assertions.assertThat((Comparable)stats.getEndTime()).isNull();
        Assertions.assertThat((Comparable)stats.getQueuedTime()).isNotNull();
        Assertions.assertThat((Comparable)stats.getElapsedTime()).isNotNull();
        Assertions.assertThat((Comparable)stats.getExecutionTime()).isNotNull();
        Assertions.assertThat((int)stats.getFailedTasks()).isEqualTo(expectedStatsValue);
        Assertions.assertThat((int)stats.getTotalDrivers()).isEqualTo(expectedStatsValue);
        Assertions.assertThat((int)stats.getQueuedDrivers()).isEqualTo(expectedStatsValue);
        Assertions.assertThat((int)stats.getRunningDrivers()).isEqualTo(expectedStatsValue);
        Assertions.assertThat((int)stats.getCompletedDrivers()).isEqualTo(expectedStatsValue);
        Assertions.assertThat((int)stats.getBlockedDrivers()).isEqualTo(expectedStatsValue);
        Assertions.assertThat((Comparable)stats.getRawInputDataSize()).isEqualTo((Object)DataSize.succinctBytes((long)expectedStatsValue));
        Assertions.assertThat((long)stats.getRawInputPositions()).isEqualTo((long)expectedStatsValue);
        Assertions.assertThat((Comparable)stats.getPhysicalInputDataSize()).isEqualTo((Object)DataSize.succinctBytes((long)expectedStatsValue));
        Assertions.assertThat((Comparable)stats.getPhysicalWrittenDataSize()).isEqualTo((Object)DataSize.succinctBytes((long)expectedStatsValue));
        Assertions.assertThat((Comparable)stats.getSpilledDataSize()).isEqualTo((Object)DataSize.succinctBytes((long)expectedStatsValue));
        Assertions.assertThat((double)stats.getCumulativeUserMemory()).isEqualTo((double)expectedStatsValue);
        Assertions.assertThat((double)stats.getFailedCumulativeUserMemory()).isEqualTo((double)expectedStatsValue);
        Assertions.assertThat((Comparable)stats.getUserMemoryReservation()).isEqualTo((Object)DataSize.succinctBytes((long)expectedStatsValue));
        Assertions.assertThat((Comparable)stats.getTotalMemoryReservation()).isEqualTo((Object)DataSize.succinctBytes((long)expectedStatsValue));
        Assertions.assertThat((Comparable)stats.getPeakTotalMemoryReservation()).isEqualTo((Object)DataSize.succinctBytes((long)0L));
        Assertions.assertThat((Comparable)stats.getPeakUserMemoryReservation()).isEqualTo((Object)DataSize.succinctBytes((long)0L));
        Assertions.assertThat((Comparable)stats.getTotalCpuTime()).isEqualTo((Object)Duration.succinctDuration((double)expectedStatsValue, (TimeUnit)TimeUnit.SECONDS));
        Assertions.assertThat((Comparable)stats.getFailedCpuTime()).isEqualTo((Object)Duration.succinctDuration((double)expectedStatsValue, (TimeUnit)TimeUnit.SECONDS));
        Assertions.assertThat((Comparable)stats.getTotalScheduledTime()).isEqualTo((Object)Duration.succinctDuration((double)expectedStatsValue, (TimeUnit)TimeUnit.SECONDS));
        Assertions.assertThat((Comparable)stats.getFailedScheduledTime()).isEqualTo((Object)Duration.succinctDuration((double)expectedStatsValue, (TimeUnit)TimeUnit.SECONDS));
        Assertions.assertThat((boolean)stats.isFullyBlocked()).isFalse();
        Assertions.assertThat((Collection)stats.getBlockedReasons()).isEmpty();
        Assertions.assertThat((OptionalDouble)stats.getProgressPercentage()).isEmpty();
        Assertions.assertThat((OptionalDouble)stats.getRunningPercentage()).isEmpty();
    }

    private BasicStageInfo createBasicStageInfo(int count, StageState state, int baseValue) {
        return new BasicStageInfo(StageId.valueOf((List)ImmutableList.of((Object)"s", (Object)String.valueOf(count))), state, false, this.createBasicStageStats(baseValue), (List)(count == 1 ? ImmutableList.of() : ImmutableList.of((Object)this.createBasicStageInfo(count - 1, state, baseValue))), (List)ImmutableList.of());
    }

    private BasicStageStats createBasicStageStats(int value) {
        return new BasicStageStats(false, value, value, value, value, value, value, DataSize.of((long)value, (DataSize.Unit)DataSize.Unit.BYTE), (long)value, Duration.succinctDuration((double)value, (TimeUnit)TimeUnit.SECONDS), DataSize.of((long)value, (DataSize.Unit)DataSize.Unit.BYTE), DataSize.of((long)value, (DataSize.Unit)DataSize.Unit.BYTE), (long)value, DataSize.of((long)value, (DataSize.Unit)DataSize.Unit.BYTE), (long)value, DataSize.of((long)value, (DataSize.Unit)DataSize.Unit.BYTE), (double)value, (double)value, DataSize.of((long)value, (DataSize.Unit)DataSize.Unit.BYTE), DataSize.succinctBytes((long)value), Duration.succinctDuration((double)value, (TimeUnit)TimeUnit.SECONDS), Duration.succinctDuration((double)value, (TimeUnit)TimeUnit.SECONDS), Duration.succinctDuration((double)value, (TimeUnit)TimeUnit.SECONDS), Duration.succinctDuration((double)value, (TimeUnit)TimeUnit.SECONDS), false, (Set)ImmutableSet.of(), OptionalDouble.of(value), OptionalDouble.of(value));
    }

    private static void assertFinalState(QueryStateMachine stateMachine, QueryState expectedState) {
        TestQueryStateMachine.assertFinalState(stateMachine, expectedState, null);
    }

    private static void assertFinalState(QueryStateMachine stateMachine, QueryState expectedState, Exception expectedException) {
        Assertions.assertThat((boolean)expectedState.isDone()).isTrue();
        TestQueryStateMachine.assertState(stateMachine, expectedState, expectedException);
        Assertions.assertThat((boolean)stateMachine.transitionToDispatching()).isFalse();
        TestQueryStateMachine.assertState(stateMachine, expectedState, expectedException);
        Assertions.assertThat((boolean)stateMachine.transitionToPlanning()).isFalse();
        TestQueryStateMachine.assertState(stateMachine, expectedState, expectedException);
        Assertions.assertThat((boolean)stateMachine.transitionToStarting()).isFalse();
        TestQueryStateMachine.assertState(stateMachine, expectedState, expectedException);
        Assertions.assertThat((boolean)stateMachine.transitionToRunning()).isFalse();
        TestQueryStateMachine.assertState(stateMachine, expectedState, expectedException);
        Assertions.assertThat((boolean)stateMachine.transitionToFinishing()).isFalse();
        TestQueryStateMachine.assertState(stateMachine, expectedState, expectedException);
        Assertions.assertThat((boolean)stateMachine.transitionToFailed((Throwable)TestQueryStateMachine.newFailedCause())).isFalse();
        TestQueryStateMachine.assertState(stateMachine, expectedState, expectedException);
        Assertions.assertThat((boolean)stateMachine.transitionToFailed((Throwable)new IOException("failure after finish"))).isFalse();
        TestQueryStateMachine.assertState(stateMachine, expectedState, expectedException);
    }

    private static void assertState(QueryStateMachine stateMachine, QueryState expectedState) {
        TestQueryStateMachine.assertState(stateMachine, expectedState, null);
    }

    private static void assertState(QueryStateMachine stateMachine, QueryState expectedState, Exception expectedException) {
        Assertions.assertThat((Object)stateMachine.getQueryId()).isEqualTo((Object)SessionTestUtils.TEST_SESSION.getQueryId());
        TestQueryStateMachine.assertEqualSessionsWithoutTransactionId(stateMachine.getSession(), SessionTestUtils.TEST_SESSION);
        Assertions.assertThat((Map)stateMachine.getSetSessionProperties()).isEqualTo(SET_SESSION_PROPERTIES);
        Assertions.assertThat((Collection)stateMachine.getResetSessionProperties()).containsExactlyElementsOf(RESET_SESSION_PROPERTIES);
        QueryInfo queryInfo = stateMachine.getQueryInfo(Optional.empty());
        Assertions.assertThat((Object)queryInfo.getQueryId()).isEqualTo((Object)SessionTestUtils.TEST_SESSION.getQueryId());
        Assertions.assertThat((URI)queryInfo.getSelf()).isEqualTo((Object)LOCATION);
        Assertions.assertThat((Optional)queryInfo.getOutputStage()).isEmpty();
        Assertions.assertThat((String)queryInfo.getQuery()).isEqualTo(QUERY);
        Assertions.assertThat((Collection)queryInfo.getInputs()).containsExactlyElementsOf(INPUTS);
        Assertions.assertThat((Optional)queryInfo.getOutput()).isEqualTo(OUTPUT);
        Assertions.assertThat((List)queryInfo.getFieldNames()).containsExactlyElementsOf(OUTPUT_FIELD_NAMES);
        Assertions.assertThat((String)queryInfo.getUpdateType()).isEqualTo(UPDATE_TYPE);
        Assertions.assertThat((Optional)queryInfo.getQueryType()).isPresent();
        Assertions.assertThat((Comparable)((QueryType)queryInfo.getQueryType().get())).isEqualTo((Object)QUERY_TYPE.get());
        QueryStats queryStats = queryInfo.getQueryStats();
        Assertions.assertThat((Comparable)queryStats.getElapsedTime()).isNotNull();
        Assertions.assertThat((Comparable)queryStats.getQueuedTime()).isNotNull();
        Assertions.assertThat((Comparable)queryStats.getResourceWaitingTime()).isNotNull();
        Assertions.assertThat((Comparable)queryStats.getDispatchingTime()).isNotNull();
        Assertions.assertThat((Comparable)queryStats.getExecutionTime()).isNotNull();
        Assertions.assertThat((Comparable)queryStats.getPlanningTime()).isNotNull();
        Assertions.assertThat((Comparable)queryStats.getPlanningCpuTime()).isNotNull();
        Assertions.assertThat((Comparable)queryStats.getFinishingTime()).isNotNull();
        Assertions.assertThat((Comparable)queryStats.getCreateTime()).isNotNull();
        if (queryInfo.getState() == QueryState.QUEUED || queryInfo.getState() == QueryState.WAITING_FOR_RESOURCES || queryInfo.getState() == QueryState.DISPATCHING) {
            Assertions.assertThat((Comparable)queryStats.getExecutionStartTime()).isNull();
        } else {
            Assertions.assertThat((Comparable)queryStats.getExecutionStartTime()).isNotNull();
        }
        if (queryInfo.getState().isDone()) {
            Assertions.assertThat((Comparable)queryStats.getEndTime()).isNotNull();
        } else {
            Assertions.assertThat((Comparable)queryStats.getEndTime()).isNull();
        }
        Assertions.assertThat((Comparable)stateMachine.getQueryState()).isEqualTo((Object)expectedState);
        Assertions.assertThat((Comparable)queryInfo.getState()).isEqualTo((Object)expectedState);
        Assertions.assertThat((boolean)stateMachine.isDone()).isEqualTo(expectedState.isDone());
        if (expectedState == QueryState.FAILED) {
            Assertions.assertThat((Object)queryInfo.getFailureInfo()).isNotNull();
            FailureInfo failure = queryInfo.getFailureInfo().toFailureInfo();
            Assertions.assertThat((Object)failure).isNotNull();
            Assertions.assertThat((String)failure.getType()).isEqualTo(expectedException.getClass().getName());
            if (expectedException instanceof TrinoException) {
                Assertions.assertThat((Object)queryInfo.getErrorCode()).isEqualTo((Object)((TrinoException)((Object)expectedException)).getErrorCode());
            } else {
                Assertions.assertThat((Object)queryInfo.getErrorCode()).isEqualTo((Object)StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode());
            }
        } else {
            Assertions.assertThat((Object)queryInfo.getFailureInfo()).isNull();
        }
    }

    private QueryStateMachine createQueryStateMachine() {
        return this.queryStateMachine().build();
    }

    private QueryStateMachineBuilder queryStateMachine() {
        return new QueryStateMachineBuilder();
    }

    private static void assertEqualSessionsWithoutTransactionId(Session actual, Session expected) {
        Assertions.assertThat((Object)actual.getQueryId()).isEqualTo((Object)expected.getQueryId());
        Assertions.assertThat((Object)actual.getIdentity()).isEqualTo((Object)expected.getIdentity());
        Assertions.assertThat((Optional)actual.getSource()).isEqualTo((Object)expected.getSource());
        Assertions.assertThat((Optional)actual.getCatalog()).isEqualTo((Object)expected.getCatalog());
        Assertions.assertThat((Optional)actual.getSchema()).isEqualTo((Object)expected.getSchema());
        Assertions.assertThat((Object)actual.getTimeZoneKey()).isEqualTo((Object)expected.getTimeZoneKey());
        Assertions.assertThat((Object)actual.getLocale()).isEqualTo((Object)expected.getLocale());
        Assertions.assertThat((Optional)actual.getRemoteUserAddress()).isEqualTo((Object)expected.getRemoteUserAddress());
        Assertions.assertThat((Optional)actual.getUserAgent()).isEqualTo((Object)expected.getUserAgent());
        Assertions.assertThat((Instant)actual.getStart()).isEqualTo((Object)expected.getStart());
        Assertions.assertThat((Map)actual.getSystemProperties()).isEqualTo((Object)expected.getSystemProperties());
        Assertions.assertThat((Map)actual.getCatalogProperties()).isEqualTo((Object)expected.getCatalogProperties());
    }

    private static SQLException newFailedCause() {
        return new SQLException("FAILED");
    }

    private class QueryStateMachineBuilder {
        private Ticker ticker = Ticker.systemTicker();
        private Metadata metadata;
        private WarningCollector warningCollector = WarningCollector.NOOP;
        private String setCatalog;
        private String setPath;
        private String setSchema;
        private Map<String, SelectedRole> setRoles = ImmutableMap.of();
        private List<TrinoWarning> warnings = ImmutableList.of();
        private String setAuthorizationUser;
        private TransactionId transactionId;
        private ImmutableMap<String, String> addPreparedStatements = ImmutableMap.of();

        private QueryStateMachineBuilder() {
        }

        @CanIgnoreReturnValue
        public QueryStateMachineBuilder withTicker(Ticker ticker) {
            this.ticker = ticker;
            return this;
        }

        @CanIgnoreReturnValue
        public QueryStateMachineBuilder withMetadata(Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public QueryStateMachineBuilder withWarningCollector(WarningCollector warningCollector) {
            this.warningCollector = warningCollector;
            return this;
        }

        public QueryStateMachineBuilder withSetPath(String setPath) {
            this.setPath = setPath;
            return this;
        }

        public QueryStateMachineBuilder withSetCatalog(String setCatalog) {
            this.setCatalog = setCatalog;
            return this;
        }

        public QueryStateMachineBuilder withSetSchema(String setSchema) {
            this.setSchema = setSchema;
            return this;
        }

        public QueryStateMachineBuilder withSetAuthorizationUser(String setAuthorizationUser) {
            this.setAuthorizationUser = setAuthorizationUser;
            return this;
        }

        public QueryStateMachineBuilder withSetRoles(Map<String, SelectedRole> setRoles) {
            this.setRoles = ImmutableMap.copyOf(setRoles);
            return this;
        }

        public QueryStateMachineBuilder withWarnings(List<TrinoWarning> warnings) {
            this.warnings = ImmutableList.copyOf(warnings);
            return this;
        }

        public QueryStateMachineBuilder withTransactionId(TransactionId transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public QueryStateMachineBuilder withAddPreparedStatements(Map<String, String> preparedStatements) {
            this.addPreparedStatements = ImmutableMap.copyOf(preparedStatements);
            return this;
        }

        public QueryStateMachine build() {
            if (this.metadata == null) {
                this.metadata = TestMetadataManager.createTestMetadataManager();
            }
            TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
            AccessControlManager accessControl = new AccessControlManager(NodeVersion.UNKNOWN, transactionManager, (EventListenerManager)TestingEventListenerManager.emptyEventListenerManager(), new AccessControlConfig(), OpenTelemetry.noop(), new SecretsResolver((Map)ImmutableMap.of()), "default");
            accessControl.setSystemAccessControls(List.of(AllowAllSystemAccessControl.INSTANCE));
            QueryStateMachine stateMachine = QueryStateMachine.beginWithTicker(Optional.empty(), (String)TestQueryStateMachine.QUERY, Optional.empty(), (Session)SessionTestUtils.TEST_SESSION, (URI)LOCATION, (ResourceGroupId)new ResourceGroupId("test"), (boolean)false, (TransactionManager)transactionManager, (AccessControl)accessControl, (Executor)TestQueryStateMachine.this.executor, (Ticker)this.ticker, (Metadata)this.metadata, (WarningCollector)this.warningCollector, (PlanOptimizersStatsCollector)PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector(), QUERY_TYPE, (boolean)false, (NodeVersion)new NodeVersion("test"));
            stateMachine.setInputs(INPUTS);
            stateMachine.setOutput(OUTPUT);
            stateMachine.setColumns(OUTPUT_FIELD_NAMES, OUTPUT_FIELD_TYPES);
            if (this.setPath != null) {
                stateMachine.setSetPath(this.setPath);
            }
            if (this.setCatalog != null) {
                stateMachine.setSetCatalog(this.setCatalog);
            }
            if (this.setSchema != null) {
                stateMachine.setSetSchema(this.setSchema);
            }
            if (this.setAuthorizationUser != null) {
                stateMachine.setSetAuthorizationUser(this.setAuthorizationUser);
            }
            this.addPreparedStatements.forEach((arg_0, arg_1) -> ((QueryStateMachine)stateMachine).addPreparedStatement(arg_0, arg_1));
            if (this.transactionId != null) {
                stateMachine.setStartedTransactionId(this.transactionId);
            }
            this.setRoles.forEach((arg_0, arg_1) -> ((QueryStateMachine)stateMachine).addSetRole(arg_0, arg_1));
            stateMachine.setUpdateType(TestQueryStateMachine.UPDATE_TYPE);
            for (Map.Entry<String, String> entry : SET_SESSION_PROPERTIES.entrySet()) {
                stateMachine.addSetSessionProperties(entry.getKey(), entry.getValue());
            }
            this.warnings.forEach(warning -> stateMachine.getWarningCollector().add(warning));
            RESET_SESSION_PROPERTIES.forEach(arg_0 -> ((QueryStateMachine)stateMachine).addResetSessionProperties(arg_0));
            return stateMachine;
        }
    }
}

