/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.JsonCodec;
import io.airlift.stats.Distribution;
import io.airlift.stats.TDigest;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.execution.DistributionSnapshot;
import io.trino.execution.StageStats;
import io.trino.plugin.base.metrics.TDigestHistogram;
import io.trino.spi.eventlistener.StageGcStatistics;
import io.trino.spi.metrics.Distribution;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTime;
import org.junit.jupiter.api.Test;

public class TestStageStats {
    private static final StageStats EXPECTED = new StageStats(new DateTime(0L), TestStageStats.getTestDistribution(1), 4, 5, 6, 1, 7, 8, 10, 26, 11, 12.0, 13.0, DataSize.ofBytes((long)14L), DataSize.ofBytes((long)15L), DataSize.ofBytes((long)16L), DataSize.ofBytes((long)17L), DataSize.ofBytes((long)18L), new Duration(19.0, TimeUnit.NANOSECONDS), new Duration(20.0, TimeUnit.NANOSECONDS), new Duration(21.0, TimeUnit.NANOSECONDS), new Duration(22.0, TimeUnit.NANOSECONDS), new Duration(23.0, TimeUnit.NANOSECONDS), false, (Set)ImmutableSet.of(), DataSize.ofBytes((long)191L), DataSize.ofBytes((long)192L), 201L, 202L, new Duration(24.0, TimeUnit.NANOSECONDS), new Duration(25.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)193L), DataSize.ofBytes((long)194L), 203L, 204L, DataSize.ofBytes((long)26L), DataSize.ofBytes((long)27L), 28L, 29L, DataSize.ofBytes((long)30L), DataSize.ofBytes((long)31L), 32L, 33L, new Duration(201.0, TimeUnit.NANOSECONDS), new Duration(202.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)34L), Optional.of(new DistributionSnapshot((Distribution)TestStageStats.getTDigestHistogram(10))), DataSize.ofBytes((long)35L), DataSize.ofBytes((long)36L), 37L, 38L, new Duration(203.0, TimeUnit.NANOSECONDS), new Duration(204.0, TimeUnit.NANOSECONDS), DataSize.ofBytes((long)39L), DataSize.ofBytes((long)40L), new StageGcStatistics(101, 102, 103, 104, 105, 106, 107), (List)ImmutableList.of());

    @Test
    public void testJson() {
        JsonCodec codec = JsonCodec.jsonCodec(StageStats.class);
        String json = codec.toJson((Object)EXPECTED);
        StageStats actual = (StageStats)codec.fromJson(json);
        TestStageStats.assertExpectedStageStats(actual);
    }

    private static void assertExpectedStageStats(StageStats actual) {
        Assertions.assertThat((long)actual.getSchedulingComplete().getMillis()).isEqualTo(0L);
        Assertions.assertThat((double)actual.getGetSplitDistribution().getCount()).isEqualTo(1.0);
        Assertions.assertThat((int)actual.getTotalTasks()).isEqualTo(4);
        Assertions.assertThat((int)actual.getRunningTasks()).isEqualTo(5);
        Assertions.assertThat((int)actual.getCompletedTasks()).isEqualTo(6);
        Assertions.assertThat((int)actual.getFailedTasks()).isEqualTo(1);
        Assertions.assertThat((int)actual.getTotalDrivers()).isEqualTo(7);
        Assertions.assertThat((int)actual.getQueuedDrivers()).isEqualTo(8);
        Assertions.assertThat((int)actual.getRunningDrivers()).isEqualTo(10);
        Assertions.assertThat((int)actual.getBlockedDrivers()).isEqualTo(26);
        Assertions.assertThat((int)actual.getCompletedDrivers()).isEqualTo(11);
        Assertions.assertThat((double)actual.getCumulativeUserMemory()).isEqualTo(12.0);
        Assertions.assertThat((double)actual.getFailedCumulativeUserMemory()).isEqualTo(13.0);
        Assertions.assertThat((Comparable)actual.getUserMemoryReservation()).isEqualTo((Object)DataSize.ofBytes((long)14L));
        Assertions.assertThat((Comparable)actual.getRevocableMemoryReservation()).isEqualTo((Object)DataSize.ofBytes((long)15L));
        Assertions.assertThat((Comparable)actual.getTotalMemoryReservation()).isEqualTo((Object)DataSize.ofBytes((long)16L));
        Assertions.assertThat((Comparable)actual.getPeakUserMemoryReservation()).isEqualTo((Object)DataSize.ofBytes((long)17L));
        Assertions.assertThat((Comparable)actual.getPeakRevocableMemoryReservation()).isEqualTo((Object)DataSize.ofBytes((long)18L));
        Assertions.assertThat((Comparable)actual.getTotalScheduledTime()).isEqualTo((Object)new Duration(19.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getFailedScheduledTime()).isEqualTo((Object)new Duration(20.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getTotalCpuTime()).isEqualTo((Object)new Duration(21.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getFailedCpuTime()).isEqualTo((Object)new Duration(22.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getTotalBlockedTime()).isEqualTo((Object)new Duration(23.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getPhysicalInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)191L));
        Assertions.assertThat((Comparable)actual.getFailedPhysicalInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)192L));
        Assertions.assertThat((long)actual.getPhysicalInputPositions()).isEqualTo(201L);
        Assertions.assertThat((long)actual.getFailedPhysicalInputPositions()).isEqualTo(202L);
        Assertions.assertThat((Comparable)actual.getPhysicalInputReadTime()).isEqualTo((Object)new Duration(24.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getFailedPhysicalInputReadTime()).isEqualTo((Object)new Duration(25.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getInternalNetworkInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)193L));
        Assertions.assertThat((Comparable)actual.getFailedInternalNetworkInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)194L));
        Assertions.assertThat((long)actual.getInternalNetworkInputPositions()).isEqualTo(203L);
        Assertions.assertThat((long)actual.getFailedInternalNetworkInputPositions()).isEqualTo(204L);
        Assertions.assertThat((Comparable)actual.getRawInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)26L));
        Assertions.assertThat((Comparable)actual.getFailedRawInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)27L));
        Assertions.assertThat((long)actual.getRawInputPositions()).isEqualTo(28L);
        Assertions.assertThat((long)actual.getFailedRawInputPositions()).isEqualTo(29L);
        Assertions.assertThat((Comparable)actual.getProcessedInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)30L));
        Assertions.assertThat((Comparable)actual.getFailedProcessedInputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)31L));
        Assertions.assertThat((long)actual.getProcessedInputPositions()).isEqualTo(32L);
        Assertions.assertThat((long)actual.getFailedProcessedInputPositions()).isEqualTo(33L);
        Assertions.assertThat((Comparable)actual.getInputBlockedTime()).isEqualTo((Object)new Duration(201.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getFailedInputBlockedTime()).isEqualTo((Object)new Duration(202.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getBufferedDataSize()).isEqualTo((Object)DataSize.ofBytes((long)34L));
        Assertions.assertThat((double)((DistributionSnapshot)actual.getOutputBufferUtilization().get()).max()).isEqualTo(9.0);
        Assertions.assertThat((Comparable)actual.getOutputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)35L));
        Assertions.assertThat((Comparable)actual.getFailedOutputDataSize()).isEqualTo((Object)DataSize.ofBytes((long)36L));
        Assertions.assertThat((long)actual.getOutputPositions()).isEqualTo(37L);
        Assertions.assertThat((long)actual.getFailedOutputPositions()).isEqualTo(38L);
        Assertions.assertThat((Comparable)actual.getOutputBlockedTime()).isEqualTo((Object)new Duration(203.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getFailedOutputBlockedTime()).isEqualTo((Object)new Duration(204.0, TimeUnit.NANOSECONDS));
        Assertions.assertThat((Comparable)actual.getPhysicalWrittenDataSize()).isEqualTo((Object)DataSize.ofBytes((long)39L));
        Assertions.assertThat((Comparable)actual.getFailedPhysicalWrittenDataSize()).isEqualTo((Object)DataSize.ofBytes((long)40L));
        Assertions.assertThat((int)actual.getGcInfo().getStageId()).isEqualTo(101);
        Assertions.assertThat((int)actual.getGcInfo().getTasks()).isEqualTo(102);
        Assertions.assertThat((int)actual.getGcInfo().getFullGcTasks()).isEqualTo(103);
        Assertions.assertThat((int)actual.getGcInfo().getMinFullGcSec()).isEqualTo(104);
        Assertions.assertThat((int)actual.getGcInfo().getMaxFullGcSec()).isEqualTo(105);
        Assertions.assertThat((int)actual.getGcInfo().getTotalFullGcSec()).isEqualTo(106);
        Assertions.assertThat((int)actual.getGcInfo().getAverageFullGcSec()).isEqualTo(107);
    }

    private static Distribution.DistributionSnapshot getTestDistribution(int count) {
        io.airlift.stats.Distribution distribution = new io.airlift.stats.Distribution();
        for (int i = 0; i < count; ++i) {
            distribution.add((long)i);
        }
        return distribution.snapshot();
    }

    private static TDigestHistogram getTDigestHistogram(int count) {
        TDigest digest = new TDigest();
        for (int i = 0; i < count; ++i) {
            digest.add((double)i);
        }
        return new TDigestHistogram(digest);
    }
}

