/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.trino.operator.ParametricImplementationsGroup;
import io.trino.operator.aggregation.ParametricAggregationImplementation;
import io.trino.operator.scalar.ParametricScalar;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;

class AnnotationEngineAssertions {
    private AnnotationEngineAssertions() {
    }

    public static void assertImplementationCount(ParametricScalar scalar, int exact, int specialized, int generic) {
        AnnotationEngineAssertions.assertImplementationCount(scalar.getImplementations(), exact, specialized, generic);
    }

    public static void assertImplementationCount(ParametricImplementationsGroup<?> implementations, int exact, int specialized, int generic) {
        Assertions.assertThat((Map)implementations.getExactImplementations()).hasSize(exact);
        Assertions.assertThat((List)implementations.getSpecializedImplementations()).hasSize(specialized);
        Assertions.assertThat((List)implementations.getGenericImplementations()).hasSize(generic);
    }

    public static void assertDependencyCount(ParametricAggregationImplementation implementation, int input, int combine, int output) {
        Assertions.assertThat((List)implementation.getInputDependencies()).hasSize(input);
        Assertions.assertThat((List)implementation.getCombineDependencies()).hasSize(combine);
        Assertions.assertThat((List)implementation.getOutputDependencies()).hasSize(output);
    }
}

