/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.jmh.Benchmarks;
import io.trino.operator.FlatHashStrategyCompiler;
import io.trino.operator.GroupByHash;
import io.trino.operator.UpdateMemory;
import io.trino.operator.Work;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.LongArrayBlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.junit.jupiter.api.Test;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.RunnerException;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=3)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkGroupByHashOnSimulatedData {
    private static final int DEFAULT_POSITIONS = 10000000;
    private static final int EXPECTED_GROUP_COUNT = 10000;
    private static final int DEFAULT_PAGE_SIZE = 8192;
    private final FlatHashStrategyCompiler hashStrategyCompiler = new FlatHashStrategyCompiler(new TypeOperators());

    @Benchmark
    @OperationsPerInvocation(value=10000000)
    public Object groupBy(BenchmarkContext data) {
        GroupByHash groupByHash = GroupByHash.createGroupByHash(data.getTypes(), (boolean)false, (int)10000, (boolean)false, (FlatHashStrategyCompiler)this.hashStrategyCompiler, (UpdateMemory)UpdateMemory.NOOP);
        List<int[]> results = this.addInputPages(groupByHash, data.getPages(), data.getWorkType());
        ImmutableList.Builder pages = ImmutableList.builder();
        PageBuilder pageBuilder = new PageBuilder(data.getTypes());
        for (int groupId = 0; groupId < groupByHash.getGroupCount(); ++groupId) {
            pageBuilder.declarePosition();
            groupByHash.appendValuesTo(groupId, pageBuilder);
            if (!pageBuilder.isFull()) continue;
            pages.add((Object)pageBuilder.build());
            pageBuilder.reset();
        }
        pages.add((Object)pageBuilder.build());
        return ImmutableList.of((Object)pages, results);
    }

    @Test
    public void testGroupBy() {
        BenchmarkGroupByHashOnSimulatedData benchmark = new BenchmarkGroupByHashOnSimulatedData();
        for (double nullChance : new double[]{0.0, 0.1, 0.5, 0.9}) {
            for (AggregationDefinition query : AggregationDefinition.values()) {
                BenchmarkContext data = new BenchmarkContext(WorkType.GET_GROUPS, query, nullChance, 10000);
                data.setup();
                benchmark.groupBy(data);
            }
        }
    }

    private List<int[]> addInputPages(GroupByHash groupByHash, List<Page> pages, WorkType workType) {
        ArrayList<int[]> results = new ArrayList<int[]>();
        for (Page page : pages) {
            boolean finished;
            Work work;
            if (workType == WorkType.GET_GROUPS) {
                work = groupByHash.getGroupIds(page);
                do {
                    finished = work.process();
                    results.add((int[])work.getResult());
                } while (!finished);
                continue;
            }
            work = groupByHash.addPage(page);
            while (!(finished = work.process())) {
            }
        }
        return results;
    }

    public static void main(String[] args) throws RunnerException {
        Benchmarks.benchmark(BenchmarkGroupByHashOnSimulatedData.class).withOptions(optionsBuilder -> optionsBuilder.jvmArgs(new String[]{"-Xmx8g"})).run();
    }

    static {
        BenchmarkGroupByHashOnSimulatedData benchmark = new BenchmarkGroupByHashOnSimulatedData();
        for (WorkType workType : WorkType.values()) {
            for (double nullChance : new double[]{0.0, 0.1, 0.5, 0.9}) {
                for (AggregationDefinition query : new AggregationDefinition[]{AggregationDefinition.BIGINT_2_GROUPS, AggregationDefinition.BIGINT_1K_GROUPS, AggregationDefinition.BIGINT_1M_GROUPS}) {
                    BenchmarkContext context = new BenchmarkContext(workType, query, nullChance, 8000);
                    context.setup();
                    benchmark.groupBy(context);
                }
            }
        }
    }

    @State(value=Scope.Thread)
    public static class BenchmarkContext {
        @Param
        private WorkType workType;
        @Param
        private AggregationDefinition query;
        @Param(value={"0", ".1", ".5", ".9"})
        private double nullChance;
        private final int positions;
        private List<Page> pages;
        private List<Type> types;

        public BenchmarkContext() {
            this.positions = 10000000;
        }

        public BenchmarkContext(WorkType workType, AggregationDefinition query, double nullChance, int positions) {
            this.workType = Objects.requireNonNull(workType, "workType is null");
            this.query = Objects.requireNonNull(query, "query is null");
            this.positions = positions;
            this.nullChance = nullChance;
        }

        @Setup
        public void setup() {
            this.types = (List)this.query.getChannels().stream().map(channel -> channel.columnType.type).collect(ImmutableList.toImmutableList());
            this.pages = this.createPages(this.query);
        }

        private List<Page> createPages(AggregationDefinition definition) {
            int i;
            ArrayList<Page> result = new ArrayList<Page>();
            int channelCount = definition.getChannels().size();
            int pageSize = definition.pageSize;
            int pageCount = this.positions / pageSize;
            Block[][] blocks = new Block[channelCount][];
            for (i = 0; i < definition.getChannels().size(); ++i) {
                ChannelDefinition channel2 = definition.getChannels().get(i);
                blocks[i] = channel2.createBlocks(pageCount, pageSize, i, this.nullChance);
            }
            i = 0;
            while (i < pageCount) {
                int pageIndex = i++;
                Block[] pageBlocks = (Block[])IntStream.range(0, channelCount).mapToObj(channel -> blocks[channel][pageIndex]).toArray(Block[]::new);
                result.add(new Page(pageBlocks));
            }
            return result;
        }

        public List<Page> getPages() {
            return this.pages;
        }

        public List<Type> getTypes() {
            return this.types;
        }

        public WorkType getWorkType() {
            return this.workType;
        }
    }

    public static enum WorkType {
        ADD,
        GET_GROUPS;

    }

    public static enum AggregationDefinition {
        BIGINT_2_GROUPS(new ChannelDefinition(ColumnType.BIGINT, 2)),
        BIGINT_10_GROUPS(new ChannelDefinition(ColumnType.BIGINT, 10)),
        BIGINT_1K_GROUPS(new ChannelDefinition(ColumnType.BIGINT, 1000)),
        BIGINT_10K_GROUPS(new ChannelDefinition(ColumnType.BIGINT, 10000)),
        BIGINT_100K_GROUPS(new ChannelDefinition(ColumnType.BIGINT, 100000)),
        BIGINT_1M_GROUPS(new ChannelDefinition(ColumnType.BIGINT, 1000000)),
        BIGINT_10M_GROUPS(new ChannelDefinition(ColumnType.BIGINT, 10000000)),
        BIGINT_2_GROUPS_1_SMALL_DICTIONARY(new ChannelDefinition(ColumnType.BIGINT, 2, 1, 50)),
        BIGINT_2_GROUPS_1_BIG_DICTIONARY(new ChannelDefinition(ColumnType.BIGINT, 2, 1, 10000)),
        BIGINT_2_GROUPS_MULTIPLE_SMALL_DICTIONARY(new ChannelDefinition(ColumnType.BIGINT, 2, 10, 50)),
        BIGINT_2_GROUPS_MULTIPLE_BIG_DICTIONARY(new ChannelDefinition(ColumnType.BIGINT, 2, 10, 10000)),
        BIGINT_10K_GROUPS_1_DICTIONARY(new ChannelDefinition(ColumnType.BIGINT, 10000, 1, 20000)),
        BIGINT_10K_GROUPS_MULTIPLE_DICTIONARY(new ChannelDefinition(ColumnType.BIGINT, 10000, 20, 20000)),
        DOUBLE_10_GROUPS(new ChannelDefinition(ColumnType.DOUBLE, 10)),
        TWO_TINY_VARCHAR_DICTIONARIES(new ChannelDefinition(ColumnType.CHAR_1, 2, 10), new ChannelDefinition(ColumnType.CHAR_1, 2, 10)),
        FIVE_TINY_VARCHAR_DICTIONARIES(new ChannelDefinition(ColumnType.CHAR_1, 2, 10), new ChannelDefinition(ColumnType.CHAR_1, 2, 10), new ChannelDefinition(ColumnType.CHAR_1, 2, 10), new ChannelDefinition(ColumnType.CHAR_1, 2, 10), new ChannelDefinition(ColumnType.CHAR_1, 2, 10)),
        TWO_SMALL_VARCHAR_DICTIONARIES(new ChannelDefinition(ColumnType.CHAR_1, 30, 10), new ChannelDefinition(ColumnType.CHAR_1, 30, 10)),
        TWO_SMALL_VARCHAR_DICTIONARIES_WITH_SMALL_PAGE_SIZE(1000, new ChannelDefinition(ColumnType.CHAR_1, 30, 10), new ChannelDefinition(ColumnType.CHAR_1, 30, 10)),
        VARCHAR_2_GROUPS(new ChannelDefinition(ColumnType.VARCHAR_25, 2)),
        VARCHAR_10_GROUPS(new ChannelDefinition(ColumnType.VARCHAR_25, 10)),
        VARCHAR_1K_GROUPS(new ChannelDefinition(ColumnType.VARCHAR_25, 1000)),
        VARCHAR_10K_GROUPS(new ChannelDefinition(ColumnType.VARCHAR_25, 10000)),
        VARCHAR_100K_GROUPS(new ChannelDefinition(ColumnType.VARCHAR_25, 100000)),
        VARCHAR_1M_GROUPS(new ChannelDefinition(ColumnType.VARCHAR_25, 1000000)),
        VARCHAR_10M_GROUPS(new ChannelDefinition(ColumnType.VARCHAR_25, 10000000)),
        VARCHAR_2_GROUPS_1_SMALL_DICTIONARY(new ChannelDefinition(ColumnType.VARCHAR_25, 2, 1, 50)),
        VARCHAR_2_GROUPS_1_BIG_DICTIONARY(new ChannelDefinition(ColumnType.VARCHAR_25, 2, 1, 10000)),
        VARCHAR_2_GROUPS_MULTIPLE_SMALL_DICTIONARY(new ChannelDefinition(ColumnType.VARCHAR_25, 2, 10, 50)),
        VARCHAR_2_GROUPS_MULTIPLE_BIG_DICTIONARY(new ChannelDefinition(ColumnType.VARCHAR_25, 2, 10, 10000)),
        VARCHAR_10K_GROUPS_1_DICTIONARY(new ChannelDefinition(ColumnType.VARCHAR_25, 10000, 1, 20000)),
        VARCHAR_10K_GROUPS_MULTIPLE_DICTIONARY(new ChannelDefinition(ColumnType.VARCHAR_25, 10000, 20, 20000)),
        TINY_CHAR_10_GROUPS(new ChannelDefinition(ColumnType.CHAR_1, 10)),
        BIG_VARCHAR_10_GROUPS(new ChannelDefinition(ColumnType.VARCHAR_117, 10)),
        BIG_VARCHAR_1M_GROUPS(new ChannelDefinition(ColumnType.VARCHAR_117, 1000000)),
        DOUBLE_BIGINT_100_GROUPS(new ChannelDefinition(ColumnType.BIGINT, 10), new ChannelDefinition(ColumnType.BIGINT, 10)),
        BIGINT_AND_TWO_INTS_5K(new ChannelDefinition(ColumnType.BIGINT, 500), new ChannelDefinition(ColumnType.INT, 10), new ChannelDefinition(ColumnType.INT, 10)),
        FIVE_MIXED_SHORT_COLUMNS_100_GROUPS(new ChannelDefinition(ColumnType.BIGINT, 5), new ChannelDefinition(ColumnType.INT, 5), new ChannelDefinition(ColumnType.VARCHAR_25, 2), new ChannelDefinition(ColumnType.INT, 1), new ChannelDefinition(ColumnType.DOUBLE, 2)),
        FIVE_MIXED_SHORT_COLUMNS_100K_GROUPS(new ChannelDefinition(ColumnType.BIGINT, 5), new ChannelDefinition(ColumnType.INT, 5), new ChannelDefinition(ColumnType.VARCHAR_25, 20), new ChannelDefinition(ColumnType.INT, 10), new ChannelDefinition(ColumnType.DOUBLE, 20)),
        FIVE_MIXED_LONG_COLUMNS_100_GROUPS(new ChannelDefinition(ColumnType.BIGINT, 5), new ChannelDefinition(ColumnType.VARCHAR_117, 5), new ChannelDefinition(ColumnType.VARCHAR_25, 2), new ChannelDefinition(ColumnType.VARCHAR_25, 1), new ChannelDefinition(ColumnType.VARCHAR_117, 2)),
        FIVE_MIXED_LONG_COLUMNS_100K_GROUPS(new ChannelDefinition(ColumnType.BIGINT, 5), new ChannelDefinition(ColumnType.VARCHAR_117, 5), new ChannelDefinition(ColumnType.VARCHAR_25, 20), new ChannelDefinition(ColumnType.VARCHAR_25, 10), new ChannelDefinition(ColumnType.VARCHAR_117, 20)),
        TEN_MIXED_SHORT_COLUMNS_100_GROUPS(new ChannelDefinition(ColumnType.BIGINT, 1), new ChannelDefinition(ColumnType.INT, 2), new ChannelDefinition(ColumnType.BIGINT, 1), new ChannelDefinition(ColumnType.INT, 5), new ChannelDefinition(ColumnType.DOUBLE, 1), new ChannelDefinition(ColumnType.BIGINT, 2), new ChannelDefinition(ColumnType.INT, 1), new ChannelDefinition(ColumnType.VARCHAR_25, 5), new ChannelDefinition(ColumnType.INT, 1), new ChannelDefinition(ColumnType.DOUBLE, 1)),
        TEN_MIXED_SHORT_COLUMNS_100K_GROUPS(new ChannelDefinition(ColumnType.BIGINT, 5), new ChannelDefinition(ColumnType.INT, 2), new ChannelDefinition(ColumnType.BIGINT, 2), new ChannelDefinition(ColumnType.INT, 5), new ChannelDefinition(ColumnType.DOUBLE, 5), new ChannelDefinition(ColumnType.BIGINT, 2), new ChannelDefinition(ColumnType.INT, 2), new ChannelDefinition(ColumnType.VARCHAR_25, 5), new ChannelDefinition(ColumnType.INT, 5), new ChannelDefinition(ColumnType.DOUBLE, 2)),
        TEN_MIXED_LONG_COLUMNS_100_GROUPS(new ChannelDefinition(ColumnType.BIGINT, 1), new ChannelDefinition(ColumnType.VARCHAR_117, 2), new ChannelDefinition(ColumnType.VARCHAR_25, 1), new ChannelDefinition(ColumnType.VARCHAR_117, 5), new ChannelDefinition(ColumnType.DOUBLE, 1), new ChannelDefinition(ColumnType.VARCHAR_25, 2), new ChannelDefinition(ColumnType.VARCHAR_25, 1), new ChannelDefinition(ColumnType.VARCHAR_25, 5), new ChannelDefinition(ColumnType.VARCHAR_117, 1), new ChannelDefinition(ColumnType.DOUBLE, 1)),
        TEN_MIXED_LONG_COLUMNS_100K_GROUPS(new ChannelDefinition(ColumnType.BIGINT, 5), new ChannelDefinition(ColumnType.VARCHAR_117, 2), new ChannelDefinition(ColumnType.VARCHAR_25, 2), new ChannelDefinition(ColumnType.VARCHAR_117, 5), new ChannelDefinition(ColumnType.DOUBLE, 5), new ChannelDefinition(ColumnType.VARCHAR_25, 2), new ChannelDefinition(ColumnType.VARCHAR_25, 2), new ChannelDefinition(ColumnType.VARCHAR_25, 5), new ChannelDefinition(ColumnType.VARCHAR_117, 5), new ChannelDefinition(ColumnType.DOUBLE, 2));

        private final int pageSize;
        private final List<ChannelDefinition> channels;

        private AggregationDefinition(ChannelDefinition ... channels) {
            this(8192, channels);
        }

        private AggregationDefinition(int pageSize, ChannelDefinition ... channels) {
            this.pageSize = pageSize;
            this.channels = (List)Arrays.stream(Objects.requireNonNull(channels, "channels is null")).collect(ImmutableList.toImmutableList());
        }

        public List<ChannelDefinition> getChannels() {
            return this.channels;
        }
    }

    public static class ChannelDefinition {
        private final ColumnType columnType;
        private final int distinctValuesCountInColumn;
        private final int dictionaryPositionsCount;
        private final int numberOfDistinctDictionaries;

        public ChannelDefinition(ColumnType columnType, int distinctValuesCountInColumn) {
            this(columnType, distinctValuesCountInColumn, -1, -1);
        }

        public ChannelDefinition(ColumnType columnType, int distinctValuesCountInColumn, int numberOfDistinctDictionaries) {
            this(columnType, distinctValuesCountInColumn, numberOfDistinctDictionaries, distinctValuesCountInColumn);
        }

        public ChannelDefinition(ColumnType columnType, int distinctValuesCountInColumn, int numberOfDistinctDictionaries, int dictionaryPositionsCount) {
            this.columnType = Objects.requireNonNull(columnType, "columnType is null");
            this.distinctValuesCountInColumn = distinctValuesCountInColumn;
            this.dictionaryPositionsCount = dictionaryPositionsCount;
            this.numberOfDistinctDictionaries = numberOfDistinctDictionaries;
            Preconditions.checkArgument((dictionaryPositionsCount == -1 || dictionaryPositionsCount >= distinctValuesCountInColumn ? 1 : 0) != 0);
        }

        public ColumnType getColumnType() {
            return this.columnType;
        }

        public Block[] createBlocks(int blockCount, int positionsPerBlock, int channel, double nullChance) {
            Block[] blocks = new Block[blockCount];
            if (this.dictionaryPositionsCount == -1) {
                this.createNonDictionaryBlock(blockCount, positionsPerBlock, channel, nullChance, blocks);
            } else {
                this.createDictionaryBlock(blockCount, positionsPerBlock, channel, nullChance, blocks);
            }
            return blocks;
        }

        private void createDictionaryBlock(int blockCount, int positionsPerBlock, int channel, double nullChance, Block[] blocks) {
            Random r = new Random(channel);
            BlockBuilder allValues = this.generateValues(channel, this.dictionaryPositionsCount);
            if (nullChance > 0.0) {
                allValues.appendNull();
            }
            Block[] dictionaries = new Block[this.numberOfDistinctDictionaries];
            for (int i = 0; i < this.numberOfDistinctDictionaries; ++i) {
                dictionaries[i] = allValues.build();
            }
            int[] usedValues = this.nOutOfM(r, this.distinctValuesCountInColumn, this.dictionaryPositionsCount).stream().mapToInt(x -> x).toArray();
            for (int i = 0; i < blockCount; ++i) {
                int[] indexes = new int[positionsPerBlock];
                int dictionaryId = r.nextInt(this.numberOfDistinctDictionaries);
                Block dictionary = dictionaries[dictionaryId];
                for (int j = 0; j < positionsPerBlock; ++j) {
                    indexes[j] = ChannelDefinition.isNull(r, nullChance) ? this.dictionaryPositionsCount : usedValues[r.nextInt(usedValues.length)];
                }
                blocks[i] = DictionaryBlock.create((int)indexes.length, (Block)dictionary, (int[])indexes);
            }
        }

        private void createNonDictionaryBlock(int blockCount, int positionsPerBlock, int channel, double nullChance, Block[] blocks) {
            Block allValues = this.generateValues(channel, this.distinctValuesCountInColumn).build();
            Random r = new Random(channel);
            for (int i = 0; i < blockCount; ++i) {
                BlockBuilder block = this.columnType.getType().createBlockBuilder(null, positionsPerBlock);
                for (int j = 0; j < positionsPerBlock; ++j) {
                    if (ChannelDefinition.isNull(r, nullChance)) {
                        block.appendNull();
                        continue;
                    }
                    int position = r.nextInt(this.distinctValuesCountInColumn);
                    this.columnType.getType().appendTo(allValues, position, block);
                }
                blocks[i] = block.build();
            }
        }

        private BlockBuilder generateValues(int channel, int distinctValueCount) {
            BlockBuilder allValues = this.columnType.getType().createBlockBuilder(null, distinctValueCount);
            this.columnType.getBlockWriter().write(allValues, distinctValueCount, channel);
            return allValues;
        }

        private static boolean isNull(Random random, double nullChance) {
            double value = 0.0;
            while (value == 0.0) {
                value = random.nextDouble();
            }
            return value < nullChance;
        }

        private Set<Integer> nOutOfM(Random r, int n, int m) {
            HashSet<Integer> usedValues = new HashSet<Integer>();
            while (usedValues.size() < n) {
                int left = n - usedValues.size();
                for (int i = 0; i < left; ++i) {
                    usedValues.add(r.nextInt(m));
                }
            }
            return usedValues;
        }
    }

    public static enum ColumnType {
        BIGINT((Type)BigintType.BIGINT, (blockBuilder, positionCount, seed) -> {
            Random r = new Random(seed);
            for (int i = 0; i < positionCount; ++i) {
                BigintType.BIGINT.writeLong(blockBuilder, r.nextLong() >>> 1);
            }
        }),
        INT((Type)IntegerType.INTEGER, (blockBuilder, positionCount, seed) -> {
            Random r = new Random(seed);
            for (int i = 0; i < positionCount; ++i) {
                IntegerType.INTEGER.writeInt(blockBuilder, r.nextInt());
            }
        }),
        DOUBLE((Type)DoubleType.DOUBLE, (blockBuilder, positionCount, seed) -> {
            Random r = new Random(seed);
            for (int i = 0; i < positionCount; ++i) {
                ((LongArrayBlockBuilder)blockBuilder).writeLong(r.nextLong() >>> 1);
            }
        }),
        VARCHAR_25((Type)VarcharType.VARCHAR, (blockBuilder, positionCount, seed) -> ColumnType.writeVarchar(blockBuilder, positionCount, seed, 25)),
        VARCHAR_117((Type)VarcharType.VARCHAR, (blockBuilder, positionCount, seed) -> ColumnType.writeVarchar(blockBuilder, positionCount, seed, 117)),
        CHAR_1((Type)CharType.createCharType((int)1), (blockBuilder, positionCount, seed) -> {
            Random r = new Random(seed);
            for (int i = 0; i < positionCount; ++i) {
                byte value = (byte)r.nextInt();
                while (value == 32) {
                    value = (byte)r.nextInt();
                }
                CharType.createCharType((int)1).writeSlice(blockBuilder, Slices.wrappedBuffer((byte[])new byte[]{value}));
            }
        });

        final Type type;
        final BlockWriter blockWriter;

        private static void writeVarchar(BlockBuilder blockBuilder, int positionCount, long seed, int maxLength) {
            Random random = new Random(seed);
            for (int i = 0; i < positionCount; ++i) {
                VarcharType.VARCHAR.writeSlice(blockBuilder, Slices.random((int)(1 + random.nextInt(maxLength - 1)), (Random)random));
            }
        }

        private ColumnType(Type type, BlockWriter blockWriter) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.blockWriter = Objects.requireNonNull(blockWriter, "blockWriter is null");
        }

        public Type getType() {
            return this.type;
        }

        public BlockWriter getBlockWriter() {
            return this.blockWriter;
        }
    }

    public static interface BlockWriter {
        public void write(BlockBuilder var1, int var2, long var3);
    }
}

