/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.interval;

import io.trino.sql.query.QueryAssertions;
import io.trino.type.SqlIntervalDayTime;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestIntervalDayTime {
    protected QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testLiterals() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '12 10:45:32.123' DAY TO SECOND")))).isEqualTo(TestIntervalDayTime.interval(12, 10, 45, 32, 123));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '12 10:45:32.12' DAY TO SECOND")))).isEqualTo(TestIntervalDayTime.interval(12, 10, 45, 32, 120));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '12 10:45:32' DAY TO SECOND")))).isEqualTo(TestIntervalDayTime.interval(12, 10, 45, 32, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '12 10:45' DAY TO SECOND")))).isEqualTo(TestIntervalDayTime.interval(12, 10, 45, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '12 10' DAY TO SECOND")))).isEqualTo(TestIntervalDayTime.interval(12, 10, 0, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '12' DAY TO SECOND")))).isEqualTo(TestIntervalDayTime.interval(12, 0, 0, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '12 10:45' DAY TO MINUTE")))).isEqualTo(TestIntervalDayTime.interval(12, 10, 45, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '12 10' DAY TO MINUTE")))).isEqualTo(TestIntervalDayTime.interval(12, 10, 0, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '12' DAY TO MINUTE")))).isEqualTo(TestIntervalDayTime.interval(12, 0, 0, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '12 10' DAY TO HOUR")))).isEqualTo(TestIntervalDayTime.interval(12, 10, 0, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '12' DAY TO HOUR")))).isEqualTo(TestIntervalDayTime.interval(12, 0, 0, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '12' DAY")))).isEqualTo(TestIntervalDayTime.interval(12, 0, 0, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '30' DAY")))).isEqualTo(TestIntervalDayTime.interval(30, 0, 0, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '90' DAY")))).isEqualTo(TestIntervalDayTime.interval(90, 0, 0, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '10:45:32.123' HOUR TO SECOND")))).isEqualTo(TestIntervalDayTime.interval(0, 10, 45, 32, 123));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '10:45:32.12' HOUR TO SECOND")))).isEqualTo(TestIntervalDayTime.interval(0, 10, 45, 32, 120));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '10:45:32' HOUR TO SECOND")))).isEqualTo(TestIntervalDayTime.interval(0, 10, 45, 32, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '10:45' HOUR TO SECOND")))).isEqualTo(TestIntervalDayTime.interval(0, 10, 45, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '10' HOUR TO SECOND")))).isEqualTo(TestIntervalDayTime.interval(0, 10, 0, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '10:45' HOUR TO MINUTE")))).isEqualTo(TestIntervalDayTime.interval(0, 10, 45, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '10' HOUR TO MINUTE")))).isEqualTo(TestIntervalDayTime.interval(0, 10, 0, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '10' HOUR")))).isEqualTo(TestIntervalDayTime.interval(0, 10, 0, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '45:32.123' MINUTE TO SECOND")))).isEqualTo(TestIntervalDayTime.interval(0, 0, 45, 32, 123));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '45:32.12' MINUTE TO SECOND")))).isEqualTo(TestIntervalDayTime.interval(0, 0, 45, 32, 120));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '45:32' MINUTE TO SECOND")))).isEqualTo(TestIntervalDayTime.interval(0, 0, 45, 32, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '45' MINUTE TO SECOND")))).isEqualTo(TestIntervalDayTime.interval(0, 0, 45, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '45' MINUTE")))).isEqualTo(TestIntervalDayTime.interval(0, 0, 45, 0, 0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '32.123' SECOND")))).isEqualTo(TestIntervalDayTime.interval(0, 0, 0, 32, 123));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '32.12' SECOND")))).isEqualTo(TestIntervalDayTime.interval(0, 0, 0, 32, 120));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("INTERVAL '32' SECOND")))).isEqualTo(TestIntervalDayTime.interval(0, 0, 0, 32, 0));
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '12X' DAY")::evaluate).hasMessage("line 1:12: Invalid INTERVAL DAY value: 12X");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '12 10' DAY")::evaluate).hasMessage("line 1:12: Invalid INTERVAL DAY value: 12 10");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '12 X' DAY TO HOUR")::evaluate).hasMessage("line 1:12: Invalid INTERVAL DAY TO HOUR value: 12 X");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '12 -10' DAY TO HOUR")::evaluate).hasMessage("line 1:12: Invalid INTERVAL DAY TO HOUR value: 12 -10");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '--12 -10' DAY TO HOUR")::evaluate).hasMessage("line 1:12: Invalid INTERVAL DAY TO HOUR value: --12 -10");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '12' DAY TO DAY")::evaluate).hasMessage("line 1:12: Invalid interval qualifier: DAY TO DAY");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '12-10' DAY TO YEAR")::evaluate).hasMessage("line 1:12: Invalid interval qualifier: DAY TO YEAR");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '12-10' DAY TO MONTH")::evaluate).hasMessage("line 1:12: Invalid interval qualifier: DAY TO MONTH");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '10' HOUR TO HOUR")::evaluate).hasMessage("line 1:12: Invalid interval qualifier: HOUR TO HOUR");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '12-10' HOUR TO YEAR")::evaluate).hasMessage("line 1:12: Invalid interval qualifier: HOUR TO YEAR");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '12-10' HOUR TO MONTH")::evaluate).hasMessage("line 1:12: Invalid interval qualifier: HOUR TO MONTH");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '12-10' HOUR TO DAY")::evaluate).hasMessage("line 1:12: Invalid interval qualifier: HOUR TO DAY");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '45' MINUTE TO MINUTE")::evaluate).hasMessage("line 1:12: Invalid interval qualifier: MINUTE TO MINUTE");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '12-10' MINUTE TO YEAR")::evaluate).hasMessage("line 1:12: Invalid interval qualifier: MINUTE TO YEAR");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '12-10' MINUTE TO MONTH")::evaluate).hasMessage("line 1:12: Invalid interval qualifier: MINUTE TO MONTH");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '12-10' MINUTE TO DAY")::evaluate).hasMessage("line 1:12: Invalid interval qualifier: MINUTE TO DAY");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '12-10' MINUTE TO HOUR")::evaluate).hasMessage("line 1:12: Invalid interval qualifier: MINUTE TO HOUR");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '32' SECOND TO SECOND")::evaluate).hasMessage("line 1:12: Invalid interval qualifier: SECOND TO SECOND");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '12-10' SECOND TO YEAR")::evaluate).hasMessage("line 1:12: Invalid interval qualifier: SECOND TO YEAR");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '12-10' SECOND TO MONTH")::evaluate).hasMessage("line 1:12: Invalid interval qualifier: SECOND TO MONTH");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '12-10' SECOND TO DAY")::evaluate).hasMessage("line 1:12: Invalid interval qualifier: SECOND TO DAY");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '12-10' SECOND TO HOUR")::evaluate).hasMessage("line 1:12: Invalid interval qualifier: SECOND TO HOUR");
        Assertions.assertThatThrownBy(this.assertions.expression("INTERVAL '12-10' SECOND TO MINUTE")::evaluate).hasMessage("line 1:12: Invalid interval qualifier: SECOND TO MINUTE");
    }

    private static SqlIntervalDayTime interval(int day, int hour, int minute, int second, int milliseconds) {
        return new SqlIntervalDayTime(day, hour, minute, second, milliseconds);
    }
}

