/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import io.airlift.json.JsonCodec;
import io.trino.server.QueryProgressStats;
import java.util.OptionalDouble;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestQueryProgressStats {
    @Test
    public void testJson() {
        QueryProgressStats expected = new QueryProgressStats(123456L, 1111L, 22222L, 3333L, 100000L, 34230492L, 1000L, 100000L, false, OptionalDouble.of(33.33));
        JsonCodec codec = JsonCodec.jsonCodec(QueryProgressStats.class);
        String json = codec.toJson((Object)expected);
        QueryProgressStats actual = (QueryProgressStats)codec.fromJson(json);
        Assertions.assertThat((long)actual.getElapsedTimeMillis()).isEqualTo(123456L);
        Assertions.assertThat((long)actual.getQueuedTimeMillis()).isEqualTo(1111L);
        Assertions.assertThat((long)actual.getCpuTimeMillis()).isEqualTo(22222L);
        Assertions.assertThat((long)actual.getScheduledTimeMillis()).isEqualTo(3333L);
        Assertions.assertThat((long)actual.getCurrentMemoryBytes()).isEqualTo(100000L);
        Assertions.assertThat((long)actual.getPeakMemoryBytes()).isEqualTo(34230492L);
        Assertions.assertThat((long)actual.getInputRows()).isEqualTo(1000L);
        Assertions.assertThat((long)actual.getInputBytes()).isEqualTo(100000L);
        Assertions.assertThat((boolean)actual.isBlocked()).isFalse();
        Assertions.assertThat((OptionalDouble)actual.getProgressPercentage()).isEqualTo((Object)OptionalDouble.of(33.33));
    }
}

