/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.analyzer;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.Closer;
import io.airlift.configuration.secrets.SecretsResolver;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.FeaturesConfig;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.SystemSessionProperties;
import io.trino.SystemSessionPropertiesProvider;
import io.trino.client.NodeVersion;
import io.trino.connector.CatalogServiceProvider;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.StaticConnectorFactory;
import io.trino.connector.TestingTableFunctions;
import io.trino.eventlistener.EventListenerManager;
import io.trino.execution.DynamicFilterConfig;
import io.trino.execution.QueryManagerConfig;
import io.trino.execution.TaskManagerConfig;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.scheduler.NodeSchedulerConfig;
import io.trino.execution.warnings.WarningCollector;
import io.trino.memory.MemoryManagerConfig;
import io.trino.memory.NodeMemoryConfig;
import io.trino.metadata.AnalyzePropertyManager;
import io.trino.metadata.CatalogTableFunctions;
import io.trino.metadata.ColumnPropertyManager;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.metadata.MaterializedViewDefinition;
import io.trino.metadata.MaterializedViewPropertyManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.SchemaPropertyManager;
import io.trino.metadata.SessionPropertyManager;
import io.trino.metadata.SqlFunction;
import io.trino.metadata.TableFunctionRegistry;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableProceduresPropertyManager;
import io.trino.metadata.TableProceduresRegistry;
import io.trino.metadata.TablePropertyManager;
import io.trino.metadata.ViewColumn;
import io.trino.metadata.ViewDefinition;
import io.trino.metadata.ViewPropertyManager;
import io.trino.operator.scalar.ApplyFunction;
import io.trino.plugin.base.security.AllowAllSystemAccessControl;
import io.trino.security.AccessControl;
import io.trino.security.AccessControlConfig;
import io.trino.security.AccessControlManager;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SaveMode;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.Identity;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.transaction.IsolationLevel;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.SqlEnvironmentConfig;
import io.trino.sql.analyzer.Analysis;
import io.trino.sql.analyzer.Analyzer;
import io.trino.sql.analyzer.AnalyzerFactory;
import io.trino.sql.analyzer.SessionTimeProvider;
import io.trino.sql.analyzer.StatementAnalyzerFactory;
import io.trino.sql.parser.ParsingException;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.sql.rewrite.ShowQueriesRewrite;
import io.trino.sql.rewrite.StatementRewrite;
import io.trino.sql.tree.Statement;
import io.trino.testing.PlanTester;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingEventListenerManager;
import io.trino.testing.TestingMetadata;
import io.trino.testing.TestingSession;
import io.trino.testing.TransactionBuilder;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.transaction.NoOpTransactionManager;
import io.trino.transaction.TransactionId;
import io.trino.transaction.TransactionManager;
import io.trino.type.InternalTypeManager;
import java.io.Closeable;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestAnalyzer {
    private static final String TPCH_CATALOG = "tpch";
    private static final String SECOND_CATALOG = "c2";
    private static final String THIRD_CATALOG = "c3";
    private static final String CATALOG_FOR_IDENTIFIER_CHAIN_TESTS = "cat";
    private static final Session SETUP_SESSION = TestingSession.testSessionBuilder().setCatalog("c1").setSchema("s1").build();
    private static final Session CLIENT_SESSION = TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("s1").build();
    private static final Session CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS = TestingSession.testSessionBuilder().setCatalog("cat").setSchema("a").build();
    private static final SqlParser SQL_PARSER = new SqlParser();
    private Closer closer;
    private TransactionManager transactionManager;
    private AccessControl accessControl;
    private PlannerContext plannerContext;
    private TablePropertyManager tablePropertyManager;
    private AnalyzePropertyManager analyzePropertyManager;

    @Test
    public void testTooManyArguments() {
        this.assertFails("SELECT greatest(" + Joiner.on((String)", ").join(Collections.nCopies(128, "rand()")) + ")").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TOO_MANY_ARGUMENTS}).hasMessage("line 1:8: Too many arguments for function call greatest()");
    }

    @Test
    public void testNonComparableGroupBy() {
        this.assertFails("SELECT * FROM (SELECT approx_set(1)) GROUP BY 1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:1: HyperLogLog is not comparable, and therefore cannot be used in GROUP BY");
    }

    @Test
    public void testNonComparableWindowPartition() {
        this.assertFails("SELECT row_number() OVER (PARTITION BY t.x) FROM (VALUES(CAST (NULL AS HyperLogLog))) AS t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:40: HyperLogLog is not comparable, and therefore cannot be used in window function PARTITION BY");
    }

    @Test
    public void testNonComparableWindowOrder() {
        this.assertFails("SELECT row_number() OVER (ORDER BY t.x) FROM (VALUES(color('red'))) AS t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:36: color is not orderable, and therefore cannot be used in window function ORDER BY");
    }

    @Test
    public void testNonComparableDistinctAggregation() {
        this.assertFails("SELECT count(DISTINCT x) FROM (SELECT approx_set(1) x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:8: DISTINCT can only be applied to comparable types (actual: HyperLogLog)");
    }

    @Test
    public void testNonComparableDistinct() {
        this.assertFails("SELECT DISTINCT * FROM (SELECT approx_set(1) x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:1: DISTINCT can only be applied to comparable types (actual: HyperLogLog)");
        this.assertFails("SELECT DISTINCT x FROM (SELECT approx_set(1) x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:1: DISTINCT can only be applied to comparable types (actual: HyperLogLog): x");
        this.assertFails("SELECT DISTINCT ROW(1, approx_set(1)).* from t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:1: DISTINCT can only be applied to comparable types (actual: HyperLogLog)");
    }

    @Test
    public void testNonAggregationDistinct() {
        this.assertFails("SELECT lower(DISTINCT a) FROM (VALUES('foo')) AS t1(a)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_NOT_AGGREGATE}).hasMessage("line 1:8: DISTINCT is not supported for non-aggregation functions");
        this.assertFails("SELECT lower(DISTINCT max(a)) FROM (VALUES('foo')) AS t1(a)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_NOT_AGGREGATE}).hasMessage("line 1:8: DISTINCT is not supported for non-aggregation functions");
    }

    @Test
    public void testInSubqueryTypes() {
        this.assertFails("SELECT * FROM (VALUES 'a') t(y) WHERE y IN (VALUES 1)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:41: Value expression and result of subquery must be of the same type: row(varchar(1)) vs row(integer)");
        this.assertFails("SELECT (VALUES true) IN (VALUES 1)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:22: Value expression and result of subquery must be of the same type: row(boolean) vs row(integer)");
    }

    @Test
    public void testScalarSubQuery() {
        this.analyze("SELECT 'a', (VALUES 1) GROUP BY 1");
        this.analyze("SELECT 'a', (SELECT (1))");
        this.analyze("SELECT * FROM t1 WHERE (VALUES 1) = 2");
        this.analyze("SELECT * FROM t1 WHERE (VALUES 1) IN (VALUES 1)");
        this.analyze("SELECT * FROM t1 WHERE (VALUES 1) IN (2)");
        this.analyze("SELECT * FROM (SELECT 1) t1(x) WHERE x IN (SELECT 1)");
    }

    @Test
    public void testRowDereferenceInCorrelatedSubquery() {
        this.assertFails("WITH     t(b) AS (VALUES row(cast(row(1) AS row(a bigint)))),    u(b) AS (VALUES row(cast(row(1, 1) AS row(a bigint, b bigint))))SELECT b FROM t WHERE EXISTS (    SELECT b.a    FROM u    GROUP BY b.b)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessageMatching("line 1:171: 'b.a' must be an aggregate expression or appear in GROUP BY clause");
    }

    @Test
    public void testReferenceToOutputColumnFromOrderByAggregation() {
        this.assertFails("SELECT max(a) AS a FROM (values (1,2)) t(a,b) GROUP BY b ORDER BY max(a+b)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessageMatching("line 1:71: Invalid reference to output projection attribute from ORDER BY aggregation");
        this.assertFails("SELECT DISTINCT a AS a, max(a) AS c from (VALUES (1, 2)) t(a, b) GROUP BY a ORDER BY max(a)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessageMatching("line 1:90: Invalid reference to output projection attribute from ORDER BY aggregation");
        this.assertFails("SELECT CAST(ROW(1) AS ROW(someField BIGINT)) AS a FROM (values (1,2)) t(a,b) GROUP BY b ORDER BY MAX(a.someField)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessageMatching("line 1:102: Invalid reference to output projection attribute from ORDER BY aggregation");
        this.assertFails("SELECT 1 AS x FROM (values (1,2)) t(x, y) GROUP BY y ORDER BY sum(apply(1, z -> x))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessageMatching("line 1:81: Invalid reference to output projection attribute from ORDER BY aggregation");
        this.assertFails("SELECT 1 AS x FROM (values (1,2)) t(x, y) GROUP BY y ORDER BY sum(y) FILTER (WHERE x > 0)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessageMatching("line 1:84: Invalid reference to output projection attribute from ORDER BY aggregation");
    }

    @Test
    public void testHavingReferencesOutputAlias() {
        this.assertFails("SELECT sum(a) x FROM t1 HAVING x > 5").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessage("line 1:32: Column 'x' cannot be resolved");
    }

    @Test
    public void testRowReferencesUnknownField() {
        this.assertFails("SELECT row('a', 'b', 'c').field").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_COLUMN_REFERENCE}).hasMessage("line 1:8: Column reference 'field' is invalid");
    }

    @Test
    public void testSelectAllColumns() {
        this.assertFails("SELECT *").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessage("line 1:8: SELECT * not allowed in queries without FROM clause");
        this.assertFails("SELECT foo.* FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessage("line 1:8: Unable to resolve reference foo");
        this.assertFails("SELECT a.b.c.d.* FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessage("line 1:8: Unable to resolve reference a.b.c.d");
        this.assertFails("SELECT (1, 2).* AS (a) FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISMATCHED_COLUMN_ALIASES}).hasMessage("line 1:21: Column alias list has 1 entries but relation has 2 columns");
        this.assertFails("SELECT non_row.* FROM (VALUES ('true', 1)) t(non_row, b)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessage("line 1:8: Unable to resolve reference non_row");
        this.assertFails("SELECT t.row.non_row.* FROM (VALUES (CAST(ROW('true') AS ROW(non_row boolean)), 1)) t(row, b)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:1: expected expression of type Row");
        this.assertFails("SELECT (SELECT outer_relation.* FROM (VALUES 1) inner_relation) FROM (values 2) outer_relation").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:9: SELECT * from outer scope table not supported with anonymous columns");
        this.assertFails("SELECT t.a FROM (SELECT t.* FROM (VALUES 1) t(a))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessage("line 1:8: Column 't.a' cannot be resolved");
    }

    @Test
    public void testTemporalTableVersion() {
        this.assertFails("SELECT * FROM t1 FOR TIMESTAMP AS OF DATE '2022-01-01'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("This connector does not support versioned tables");
        this.assertFails("SELECT * FROM t1 FOR TIMESTAMP AS OF TIMESTAMP '2022-01-01'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("This connector does not support versioned tables");
        this.assertFails("SELECT * FROM t1 FOR TIMESTAMP AS OF TIMESTAMP '2022-01-01 01:02:03.123456789012'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("This connector does not support versioned tables");
        this.assertFails("SELECT * FROM t1 FOR TIMESTAMP AS OF TIMESTAMP '2022-01-01 UTC'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("This connector does not support versioned tables");
        this.assertFails("SELECT * FROM t1 FOR TIMESTAMP AS OF TIMESTAMP '2022-01-01 01:02:03.123456789012 Asia/Kathmandu'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("This connector does not support versioned tables");
        this.assertFails("SELECT * FROM t1 FOR TIMESTAMP AS OF CURRENT_TIMESTAMP(12) - INTERVAL '0.001' SECOND").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("This connector does not support versioned tables");
        this.assertFails("SELECT * FROM t1 FOR TIMESTAMP AS OF LOCALTIMESTAMP(12) - INTERVAL '0.001' SECOND").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("This connector does not support versioned tables");
        this.assertFails("SELECT * FROM t1 FOR TIMESTAMP AS OF '2022-01-01'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:18: Type varchar(10) invalid. Temporal pointers must be of type Timestamp, Timestamp with Time Zone, or Date.");
        this.assertFails("SELECT * FROM t1 FOR TIMESTAMP AS OF '2022-01-01 01:02:03'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:18: Type varchar(19) invalid. Temporal pointers must be of type Timestamp, Timestamp with Time Zone, or Date.");
        this.assertFails("SELECT * FROM t1 FOR TIMESTAMP AS OF '2022-01-01 01:02:03 UTC'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:18: Type varchar(23) invalid. Temporal pointers must be of type Timestamp, Timestamp with Time Zone, or Date.");
        this.assertFails("SELECT * FROM t1 FOR TIMESTAMP AS OF 1654594283421").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:18: Type bigint invalid. Temporal pointers must be of type Timestamp, Timestamp with Time Zone, or Date.");
        this.assertFails("SELECT * FROM t1 FOR TIMESTAMP AS OF CAST(NULL AS date)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:18: Pointer value cannot be NULL");
        this.assertFails("SELECT * FROM t1 FOR TIMESTAMP AS OF CAST(NULL AS timestamp(3))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:18: Pointer value cannot be NULL");
        this.assertFails("SELECT * FROM t1 FOR TIMESTAMP AS OF CAST(NULL AS timestamp(3) with time zone)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:18: Pointer value cannot be NULL");
        this.assertFails("SELECT * FROM t1 FOR TIMESTAMP AS OF NULL").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:18: Pointer value cannot be NULL");
        this.assertFails("SELECT * FROM t1 FOR TIMESTAMP AS OF CAST(NULL AS bigint)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:18: Type bigint invalid. Temporal pointers must be of type Timestamp, Timestamp with Time Zone, or Date.");
        this.assertFails("SELECT * FROM t1 FOR TIMESTAMP AS OF DATE '2999-01-01'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:18: Pointer value '2999-01-01' is not in the past");
        this.assertFails("SELECT * FROM t1 FOR TIMESTAMP AS OF TIMESTAMP '2999-01-01'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:18: Pointer value '2999-01-01 00:00:00' is not in the past");
        this.assertFails("SELECT * FROM t1 FOR TIMESTAMP AS OF TIMESTAMP '2999-01-01 01:02:03.123456789012'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:18: Pointer value '2999-01-01 01:02:03.123456789012' is not in the past");
        this.assertFails("SELECT * FROM t1 FOR TIMESTAMP AS OF TIMESTAMP '2999-01-01 UTC'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:18: Pointer value '2999-01-01 00:00:00 UTC' is not in the past");
        this.assertFails("SELECT * FROM t1 FOR TIMESTAMP AS OF TIMESTAMP '2999-01-01 01:02:03.123456789012 Asia/Kathmandu'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:18: Pointer value '2999-01-01 01:02:03.123456789012 Asia/Kathmandu' is not in the past");
        this.assertFails("SELECT * FROM t1 FOR TIMESTAMP AS OF CURRENT_TIMESTAMP(12)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessageMatching("line 1:18: Pointer value '.*' is not in the past");
        this.assertFails("SELECT * FROM t1 FOR TIMESTAMP AS OF LOCALTIMESTAMP(12)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessageMatching("line 1:18: Pointer value '.*' is not in the past");
    }

    @Test
    public void testRangeIdTableVersion() {
        this.assertFails("SELECT * FROM t1 FOR VERSION AS OF 123").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("This connector does not support versioned tables");
        this.assertFails("SELECT * FROM t1 FOR VERSION AS OF BIGINT '123'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("This connector does not support versioned tables");
        this.assertFails("SELECT * FROM t1 FOR VERSION AS OF '2022-01-01'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("This connector does not support versioned tables");
        this.assertFails("SELECT * FROM t1 FOR VERSION AS OF DATE '2022-01-01'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("This connector does not support versioned tables");
        this.assertFails("SELECT * FROM t1 FOR VERSION AS OF NULL").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:18: Pointer value cannot be NULL");
        this.assertFails("SELECT * FROM t1 FOR VERSION AS OF CAST(NULL AS bigint)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:18: Pointer value cannot be NULL");
        this.assertFails("SELECT * FROM t1 FOR VERSION AS OF CAST(NULL AS varchar)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:18: Pointer value cannot be NULL");
    }

    @Test
    public void testGroupByWithWildcard() {
        this.assertFails("SELECT * FROM t1 GROUP BY 1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessage("Column 't1.b' not in GROUP BY clause");
        this.assertFails("SELECT u1.*, u2.* FROM (select a, b + 1 from t1) u1 JOIN (select a, b + 2 from t1) u2 ON u1.a = u2.a GROUP BY u1.a, u2.a, 3").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessage("Column 2 not in GROUP BY clause");
    }

    @Test
    public void testAsteriskedIdentifierChainResolution() {
        this.assertFails(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT a.b.* FROM a.b, t1 AS a").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.AMBIGUOUS_NAME}).hasMessage("line 1:8: Reference 'a.b' is ambiguous");
        this.assertFails(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT (SELECT a.b.* FROM (VALUES 1) v) FROM a.b, t1 AS a").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.AMBIGUOUS_NAME}).hasMessage("line 1:16: Reference 'a.b' is ambiguous");
        this.assertFails(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT cat.a.b.* FROM cat.a.b, t2 AS cat").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.AMBIGUOUS_NAME}).hasMessage("line 1:8: Reference 'cat.a.b' is ambiguous");
        this.assertFails(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT (SELECT cat.a.b.* FROM (VALUES 1) v) FROM cat.a.b, t2 AS cat").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.AMBIGUOUS_NAME}).hasMessage("line 1:16: Reference 'cat.a.b' is ambiguous");
        this.analyze(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT (SELECT a.b.* FROM a.b) FROM t1 AS a");
        this.analyze(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT (SELECT a.b.* FROM t5 AS a) FROM a.b");
        this.analyze(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT (SELECT a.b.* FROM (VALUES 1) v) FROM t5 AS a");
        this.analyze(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT (SELECT a.b.* FROM (VALUES 1) v) FROM a.b");
        this.analyze(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT b.* FROM b, t1");
        this.assertFails(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT b.* FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessage("line 1:8: Unable to resolve reference b");
        this.assertFails(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT a.t1.b.* FROM a.t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessage("line 1:8: Unable to resolve reference a.t1.b");
        this.analyze(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT alias.b.* FROM a.t1 as alias");
        this.assertFails(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT cat.a.t1.b.* FROM cat.a.t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessage("line 1:8: Unable to resolve reference cat.a.t1.b");
        this.analyze(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT alias.b.* FROM cat.a.t1 AS alias");
        this.analyze(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT t3.b.f1.* FROM t3");
        this.analyze(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT t4.b.f1.f11.* FROM t4");
        this.analyze(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT b.* FROM cat.a.b");
        this.analyze(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT a.b.* FROM cat.a.b");
        this.analyze(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT b.* FROM a.b");
        this.assertFails(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT a.b.* FROM t4 AS a, t5 AS a").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.AMBIGUOUS_NAME}).hasMessage("line 1:8: Column 'a.b' is ambiguous");
        this.assertFails(CLIENT_SESSION_FOR_IDENTIFIER_CHAIN_TESTS, "SELECT (SELECT a.b.* FROM (VALUES 1) v) FROM t4 AS a, t5 AS a").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.AMBIGUOUS_NAME}).hasMessage("line 1:16: Column 'a.b' is ambiguous");
    }

    @Test
    public void testGroupByInvalidOrdinal() {
        this.assertFails("SELECT * FROM t1 GROUP BY 10").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_COLUMN_REFERENCE}).hasMessage("line 1:27: GROUP BY position 10 is not in select list");
        this.assertFails("SELECT * FROM t1 GROUP BY 0").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_COLUMN_REFERENCE}).hasMessage("line 1:27: GROUP BY position 0 is not in select list");
    }

    @Test
    public void testGroupByAggregation() {
        this.assertFails("SELECT x, sum(y) FROM (VALUES (1, 2)) t(x, y) GROUP BY x, sum(y)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_SCALAR}).hasMessageMatching(".* GROUP BY clause cannot contain aggregations, window functions or grouping operations: .*");
        this.assertFails("SELECT x, sum(y) FROM (VALUES (1, 2)) t(x, y) GROUP BY 1, 2").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_SCALAR}).hasMessageMatching(".* GROUP BY clause cannot contain aggregations, window functions or grouping operations: .*");
    }

    @Test
    public void testGroupByWithSubquerySelectExpression() {
        this.analyze("SELECT (SELECT t1.a) FROM t1 GROUP BY a");
        this.analyze("SELECT (SELECT a) FROM t1 GROUP BY t1.a");
        this.analyze("SELECT (SELECT u.a FROM (values 1) u(a)) FROM t1 u GROUP BY b");
        this.assertFails("SELECT (SELECT u.a from (values 1) x(a)) FROM t1 u GROUP BY b").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessageMatching("line 1:16: Subquery uses 'u.a' which must appear in GROUP BY clause");
        this.assertFails("SELECT (SELECT a+2) FROM t1 GROUP BY a+1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessageMatching("line 1:16: Subquery uses 'a' which must appear in GROUP BY clause");
        this.assertFails("SELECT (SELECT 1 FROM t1 WHERE a = u.a) FROM t1 u GROUP BY b").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessageMatching("line 1:36: Subquery uses 'u.a' which must appear in GROUP BY clause");
        this.assertFails("SELECT (SELECT a as a) FROM t1 GROUP BY b").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessage("line 1:16: Subquery uses 'a' which must appear in GROUP BY clause");
        this.analyze("SELECT (SELECT 1 FROM t1 u WHERE a = u.a) FROM t1 u GROUP BY b");
    }

    @Test
    public void testGroupByWithExistsSelectExpression() {
        this.analyze("SELECT EXISTS(SELECT t1.a) FROM t1 GROUP BY a");
        this.analyze("SELECT EXISTS(SELECT a) FROM t1 GROUP BY t1.a");
        this.analyze("SELECT EXISTS(SELECT u.a FROM (values 1) u(a)) FROM t1 u GROUP BY b");
        this.assertFails("SELECT EXISTS(SELECT u.a from (values 1) x(a)) FROM t1 u GROUP BY b").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessageMatching("line 1:22: Subquery uses 'u.a' which must appear in GROUP BY clause");
        this.assertFails("SELECT EXISTS(SELECT a+2) FROM t1 GROUP BY a+1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessageMatching("line 1:22: Subquery uses 'a' which must appear in GROUP BY clause");
        this.assertFails("SELECT EXISTS(SELECT 1 FROM t1 WHERE a = u.a) FROM t1 u GROUP BY b").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessageMatching("line 1:42: Subquery uses 'u.a' which must appear in GROUP BY clause");
        this.assertFails("SELECT EXISTS(SELECT a as a) FROM t1 GROUP BY b").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessage("line 1:22: Subquery uses 'a' which must appear in GROUP BY clause");
        this.analyze("SELECT EXISTS(SELECT 1 FROM t1 u WHERE a = u.a) FROM t1 u GROUP BY b");
    }

    @Test
    public void testGroupByWithSubquerySelectExpressionWithDereferenceExpression() {
        this.analyze("SELECT (SELECT t.a.someField) FROM (VALUES ROW(CAST(ROW(1) AS ROW(someField BIGINT)), 2)) t(a, b) GROUP BY a");
        this.assertFails("SELECT (SELECT t.a.someField) FROM (VALUES ROW(CAST(ROW(1) AS ROW(someField BIGINT)), 2)) t(a, b) GROUP BY b").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessageMatching("line 1:16: Subquery uses 't.a' which must appear in GROUP BY clause");
    }

    @Test
    public void testOrderByInvalidOrdinal() {
        this.assertFails("SELECT * FROM t1 ORDER BY 10").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_COLUMN_REFERENCE}).hasMessage("line 1:27: ORDER BY position 10 is not in select list");
        this.assertFails("SELECT * FROM t1 ORDER BY 0").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_COLUMN_REFERENCE}).hasMessage("line 1:27: ORDER BY position 0 is not in select list");
    }

    @Test
    public void testOrderByNonComparable() {
        this.assertFails("SELECT x FROM (SELECT approx_set(1) x) ORDER BY 1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:1: Type HyperLogLog is not orderable, and therefore cannot be used in ORDER BY: :input(0)");
        this.assertFails("SELECT * FROM (SELECT approx_set(1) x) ORDER BY 1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:1: Type HyperLogLog is not orderable, and therefore cannot be used in ORDER BY: :input(0)");
        this.assertFails("SELECT x FROM (SELECT approx_set(1) x) ORDER BY x").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:1: Type HyperLogLog is not orderable, and therefore cannot be used in ORDER BY: x");
    }

    @Test
    public void testFetchFirstInvalidRowCount() {
        this.assertFails("SELECT * FROM t1 FETCH FIRST 0 ROWS ONLY").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("line 1:18: FETCH FIRST row count must be positive (actual value: 0)");
    }

    @Test
    public void testFetchFirstWithTiesMissingOrderBy() {
        this.assertFails("SELECT * FROM t1 FETCH FIRST 5 ROWS WITH TIES").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISSING_ORDER_BY}).hasMessage("line 1:18: FETCH FIRST WITH TIES clause requires ORDER BY");
        this.assertFails("SELECT * FROM (SELECT * FROM (values 1, 3, 2) t(a) ORDER BY a) FETCH FIRST 5 ROWS WITH TIES").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISSING_ORDER_BY}).hasMessage("line 1:64: FETCH FIRST WITH TIES clause requires ORDER BY");
    }

    @Test
    public void testNestedAggregation() {
        this.assertFails("SELECT sum(count(*)) FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_AGGREGATION}).hasMessage("line 1:8: Cannot nest aggregations inside aggregation 'sum': [count(*)]");
    }

    @Test
    public void testAggregationsNotAllowed() {
        this.assertFails("SELECT * FROM t1 WHERE sum(a) > 1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_SCALAR}).hasMessage("line 1:31: WHERE clause cannot contain aggregations, window functions or grouping operations: [sum(a)]");
        this.assertFails("SELECT * FROM t1 GROUP BY sum(a)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_SCALAR}).hasMessage("line 1:27: GROUP BY clause cannot contain aggregations, window functions or grouping operations: [sum(a)]");
        this.assertFails("SELECT * FROM t1 JOIN t2 ON sum(t1.a) = t2.a").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_SCALAR}).hasMessage("line 1:39: JOIN clause cannot contain aggregations, window functions or grouping operations: [sum(t1.a)]");
    }

    @Test
    public void testWindowsNotAllowed() {
        this.assertFails("SELECT * FROM t1 WHERE foo() over () > 1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_SCALAR}).hasMessage("line 1:38: WHERE clause cannot contain aggregations, window functions or grouping operations: [foo() OVER ()]");
        this.assertFails("SELECT * FROM t1 WHERE lag(t1.a) > t1.a").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_SCALAR}).hasMessage("line 1:34: WHERE clause cannot contain aggregations, window functions or grouping operations: [lag(t1.a)]");
        this.assertFails("SELECT * FROM t1 WHERE rank() > 1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_SCALAR}).hasMessage("line 1:31: WHERE clause cannot contain aggregations, window functions or grouping operations: [rank()]");
        this.assertFails("SELECT * FROM t1 WHERE first_value(t1.a) > t1.a").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_SCALAR}).hasMessage("line 1:42: WHERE clause cannot contain aggregations, window functions or grouping operations: [first_value(t1.a)]");
        this.assertFails("SELECT * FROM t1 GROUP BY rank() over ()").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_SCALAR}).hasMessage("line 1:27: GROUP BY clause cannot contain aggregations, window functions or grouping operations: [rank() OVER ()]");
        this.assertFails("SELECT * FROM t1 JOIN t2 ON sum(t1.a) over () = t2.a").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_SCALAR}).hasMessage("line 1:47: JOIN clause cannot contain aggregations, window functions or grouping operations: [sum(t1.a) OVER ()]");
        this.assertFails("SELECT 1 FROM (VALUES 1) HAVING count(*) OVER () > 1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_WINDOW}).hasMessage("line 1:33: HAVING clause cannot contain window functions or row pattern measures");
        this.assertFails("SELECT 1 FROM (VALUES 1) HAVING rank() > 1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_WINDOW}).hasMessage("line 1:33: HAVING clause cannot contain window functions or row pattern measures");
        this.assertFails("SELECT * FROM t1 WHERE classy OVER (                                                MEASURES CLASSIFIER() AS classy                                                ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                                PATTERN (A+)                                                DEFINE A AS true                                        ) > 'X'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_SCALAR}).hasMessage("line 1:370: WHERE clause cannot contain aggregations, window functions or grouping operations: [classy OVER (MEASURES CLASSIFIER() AS classy ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING PATTERN((A+)) DEFINE A AS true)]");
        this.assertFails("SELECT * FROM t1 GROUP BY classy OVER (                                               MEASURES CLASSIFIER() AS classy                                                ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                                PATTERN (A+)                                                DEFINE A AS true                                        )").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_SCALAR}).hasMessage("line 1:27: GROUP BY clause cannot contain aggregations, window functions or grouping operations: [classy OVER (MEASURES CLASSIFIER() AS classy ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING PATTERN((A+)) DEFINE A AS true)]");
        this.assertFails("SELECT * FROM t1 JOIN t2 ON classy OVER (                                               MEASURES CLASSIFIER() AS classy                                                ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                                PATTERN (A+)                                                DEFINE A AS true                                        ) = t2.a").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_SCALAR}).hasMessage("line 1:374: JOIN clause cannot contain aggregations, window functions or grouping operations: [classy OVER (MEASURES CLASSIFIER() AS classy ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING PATTERN((A+)) DEFINE A AS true)]");
        this.assertFails("SELECT 1 FROM (VALUES 1) HAVING classy OVER (                                               MEASURES CLASSIFIER() AS classy                                                ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                                PATTERN (A+)                                                DEFINE A AS true                                        ) > 'X'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_WINDOW}).hasMessage("line 1:33: HAVING clause cannot contain window functions or row pattern measures");
    }

    @Test
    public void testGrouping() {
        this.analyze("SELECT a, b, sum(c), grouping(a, b) FROM t1 GROUP BY GROUPING SETS ((a), (a, b))");
        this.analyze("SELECT grouping(t1.a) FROM t1 GROUP BY a");
        this.analyze("SELECT grouping(b) FROM t1 GROUP BY t1.b");
        this.analyze("SELECT grouping(a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a) FROM t1 GROUP BY a");
    }

    @Test
    public void testGroupingNotAllowed() {
        this.assertFails("SELECT a, b, sum(c) FROM t1 WHERE grouping(a, b) GROUP BY GROUPING SETS ((a), (a, b))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_SCALAR}).hasMessage("line 1:35: WHERE clause cannot contain aggregations, window functions or grouping operations: [GROUPING (a, b)]");
        this.assertFails("SELECT a, b, sum(c) FROM t1 GROUP BY grouping(a, b)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_SCALAR}).hasMessage("line 1:38: GROUP BY clause cannot contain aggregations, window functions or grouping operations: [GROUPING (a, b)]");
        this.assertFails("SELECT t1.a, t1.b FROM t1 JOIN t2 ON grouping(t1.a, t1.b) > t2.a").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_SCALAR}).hasMessage("line 1:59: JOIN clause cannot contain aggregations, window functions or grouping operations: [GROUPING (t1.a, t1.b)]");
        this.assertFails("SELECT grouping(a) FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISSING_GROUP_BY}).hasMessage("line 1:1: A GROUPING() operation can only be used with a corresponding GROUPING SET/CUBE/ROLLUP/GROUP BY clause");
        this.assertFails("SELECT * FROM t1 ORDER BY grouping(a)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISSING_GROUP_BY}).hasMessage("line 1:1: A GROUPING() operation can only be used with a corresponding GROUPING SET/CUBE/ROLLUP/GROUP BY clause");
        this.assertFails("SELECT grouping(a) FROM t1 GROUP BY b").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:8: The arguments to GROUPING() must be expressions referenced by the GROUP BY at the associated query level. Mismatch due to a.");
        this.assertFails("SELECT grouping(a.field) FROM (VALUES ROW(CAST(ROW(1) AS ROW(field BIGINT)))) t(a) GROUP BY a.field").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:8: The arguments to GROUPING() must be expressions referenced by the GROUP BY at the associated query level. Mismatch due to a.field.");
        this.assertFails("SELECT a FROM t1 GROUP BY a ORDER BY grouping(a)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("Invalid reference to output of SELECT clause from grouping() expression in ORDER BY");
    }

    @Test
    public void testGroupingTooManyArguments() {
        String grouping = "GROUPING(a, a, a, a, a, a, a, a, a, a, a, a, a, a, a,a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a,a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a, a,a, a)";
        this.assertFails(String.format("SELECT a, b, %s + 1 FROM t1 GROUP BY GROUPING SETS ((a), (a, b))", grouping)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TOO_MANY_ARGUMENTS}).hasMessage("line 1:14: GROUPING supports up to 63 column arguments");
        this.assertFails(String.format("SELECT a, b, %s as g FROM t1 GROUP BY a, b HAVING g > 0", grouping)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TOO_MANY_ARGUMENTS}).hasMessage("line 1:14: GROUPING supports up to 63 column arguments");
        this.assertFails(String.format("SELECT a, b, rank() OVER (PARTITION BY %s) FROM t1 GROUP BY GROUPING SETS ((a), (a, b))", grouping)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TOO_MANY_ARGUMENTS}).hasMessage("line 1:40: GROUPING supports up to 63 column arguments");
        this.assertFails(String.format("SELECT a, b, rank() OVER (PARTITION BY a ORDER BY %s) FROM t1 GROUP BY GROUPING SETS ((a), (a, b))", grouping)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TOO_MANY_ARGUMENTS}).hasMessage("line 1:51: GROUPING supports up to 63 column arguments");
    }

    @Test
    public void testInvalidTable() {
        this.assertFails("SELECT * FROM foo.bar.t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.CATALOG_NOT_FOUND}).hasMessage("line 1:15: Catalog 'foo' not found");
        this.assertFails("SELECT * FROM foo.t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.SCHEMA_NOT_FOUND}).hasMessage("line 1:15: Schema 'foo' does not exist");
        this.assertFails("SELECT * FROM foo").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessage("line 1:15: Table 'tpch.s1.foo' does not exist");
        this.assertFails("SELECT * FROM foo FOR TIMESTAMP AS OF TIMESTAMP '2021-03-01 00:00:01'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("This connector does not support versioned tables");
        this.assertFails("SELECT * FROM foo FOR VERSION AS OF 'version1'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("This connector does not support versioned tables");
        this.assertFails("SELECT * FROM \"table.not.existing\"").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessage("line 1:15: Table 'tpch.s1.\"table.not.existing\"' does not exist");
        this.assertFails("SELECT * FROM \"table' does not exist, or maybe 'view\"").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessage("line 1:15: Table 'tpch.s1.\"table' does not exist, or maybe 'view\"' does not exist");
    }

    @Test
    public void testInvalidSchema() {
        this.assertFails("SHOW TABLES FROM NONEXISTENT_SCHEMA").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.SCHEMA_NOT_FOUND}).hasMessage("line 1:1: Schema 'nonexistent_schema' does not exist");
        this.assertFails("SHOW TABLES IN NONEXISTENT_SCHEMA LIKE '%'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.SCHEMA_NOT_FOUND}).hasMessage("line 1:1: Schema 'nonexistent_schema' does not exist");
        this.assertFails("SELECT * FROM \"a.b.c.d.e.\".\"f.g.h\" ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.SCHEMA_NOT_FOUND}).hasMessage("line 1:15: Schema 'a.b.c.d.e.' does not exist");
    }

    @Test
    public void testNonAggregate() {
        this.assertFails("SELECT 'a', array[b][1] FROM t1 GROUP BY 1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE});
        this.assertFails("SELECT a, sum(b) FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE});
        this.assertFails("SELECT sum(b) / a FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE});
        this.assertFails("SELECT sum(b) / a FROM t1 GROUP BY c").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE});
        this.assertFails("SELECT sum(b) FROM t1 ORDER BY a + 1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE});
        this.assertFails("SELECT a, sum(b) FROM t1 GROUP BY a HAVING c > 5").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE});
        this.assertFails("SELECT count(*) over (PARTITION BY a) FROM t1 GROUP BY b").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE});
        this.assertFails("SELECT count(*) over (ORDER BY a) FROM t1 GROUP BY b").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE});
        this.assertFails("SELECT count(*) over (ORDER BY count(*) ROWS a PRECEDING) FROM t1 GROUP BY b").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE});
        this.assertFails("SELECT count(*) over (ORDER BY count(*) ROWS BETWEEN b PRECEDING AND a PRECEDING) FROM t1 GROUP BY b").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE});
        this.assertFails("SELECT count(*) over (ORDER BY count(*) ROWS BETWEEN a PRECEDING AND UNBOUNDED FOLLOWING) FROM t1 GROUP BY b").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE});
        this.assertFails("SELECT row_number() over() as a from (values (41, 42), (-41, -42)) t(a,b) group by a+b order by a+b").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessageMatching("\\Qline 1:98: '(a + b)' must be an aggregate expression or appear in GROUP BY clause\\E");
    }

    @Test
    public void testInvalidAttribute() {
        this.assertFails("SELECT f FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND});
        this.assertFails("SELECT * FROM t1 ORDER BY f").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND});
        this.assertFails("SELECT count(*) FROM t1 GROUP BY f").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND});
        this.assertFails("SELECT * FROM t1 WHERE f > 1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND});
    }

    @Test
    public void testInvalidAttributeCorrectErrorMessage() {
        this.assertFails("SELECT t.y FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessageMatching("\\Qline 1:8: Column 't.y' cannot be resolved\\E");
    }

    @Test
    public void testOrderByMustAppearInSelectWithDistinct() {
        this.assertFails("SELECT DISTINCT a FROM t1 ORDER BY b").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_IN_DISTINCT});
    }

    @Test
    public void testNonDeterministicOrderBy() {
        this.analyze("SELECT DISTINCT random() as b FROM t1 ORDER BY b");
        this.analyze("SELECT random() FROM t1 ORDER BY random()");
        this.analyze("SELECT a FROM t1 ORDER BY random()");
        this.assertFails("SELECT DISTINCT random() FROM t1 ORDER BY random()").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_IN_DISTINCT});
    }

    @Test
    public void testNonBooleanWhereClause() {
        this.assertFails("SELECT * FROM t1 WHERE a").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
    }

    @Test
    public void testDistinctAggregations() {
        this.analyze("SELECT COUNT(DISTINCT a), SUM(a) FROM t1");
    }

    @Test
    public void testMultipleDistinctAggregations() {
        this.analyze("SELECT COUNT(DISTINCT a), COUNT(DISTINCT b) FROM t1");
    }

    @Test
    public void testOrderByExpressionOnOutputColumn() {
        this.analyze("SELECT a x FROM t1 ORDER BY x + 1");
        this.analyze("SELECT max(a) FROM (values (1,2), (2,1)) t(a,b) GROUP BY b ORDER BY max(b*1e0)");
        this.analyze("SELECT CAST(ROW(1) AS ROW(someField BIGINT)) AS a FROM (values (1,2)) t(a,b) GROUP BY b ORDER BY a.someField");
        this.analyze("SELECT 1 AS x FROM (values (1,2)) t(x, y) GROUP BY y ORDER BY sum(apply(1, x -> x))");
    }

    @Test
    public void testOrderByExpressionOnOutputColumn2() {
        this.analyze("SELECT a x FROM t1 ORDER BY a + 1");
        this.assertFails("SELECT x.c as x\nFROM (VALUES 1) x(c)\nORDER BY x.c").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasLocation(3, 10);
    }

    @Test
    public void testOrderByWithWildcard() {
        this.analyze("SELECT t1.* FROM t1 ORDER BY a");
        this.analyze("SELECT DISTINCT t1.* FROM t1 ORDER BY a");
        this.analyze("SELECT DISTINCT t1.* FROM t1 ORDER BY t1.a");
        this.analyze("SELECT DISTINCT t1.* AS (w, x, y, z) FROM t1 ORDER BY w");
    }

    @Test
    public void testOrderByWithGroupByAndSubquerySelectExpression() {
        this.analyze("SELECT a FROM t1 GROUP BY a ORDER BY (SELECT a)");
        this.assertFails("SELECT a FROM t1 GROUP BY a ORDER BY (SELECT b)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessageMatching("line 1:46: Subquery uses 'b' which must appear in GROUP BY clause");
        this.analyze("SELECT a AS b FROM t1 GROUP BY t1.a ORDER BY (SELECT b)");
        this.assertFails("SELECT a AS b FROM t1 GROUP BY t1.a \nORDER BY MAX((SELECT b))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessageMatching("line 2:22: Invalid reference to output projection attribute from ORDER BY aggregation");
        this.analyze("SELECT a FROM t1 GROUP BY a ORDER BY MAX((SELECT x FROM (VALUES 4) t(x)))");
        this.analyze("SELECT CAST(ROW(1) AS ROW(someField BIGINT)) AS x\nFROM (VALUES (1, 2)) t(a, b)\nGROUP BY b\nORDER BY (SELECT x.someField)");
        this.assertFails("SELECT CAST(ROW(1) AS ROW(someField BIGINT)) AS x\nFROM (VALUES (1, 2)) t(a, b)\nGROUP BY b\nORDER BY MAX((SELECT x.someField))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessageMatching("line 4:22: Invalid reference to output projection attribute from ORDER BY aggregation");
    }

    @Test
    public void testTooManyGroupingElements() {
        Session session = TestingSession.testSessionBuilder((SessionPropertyManager)new SessionPropertyManager((SystemSessionPropertiesProvider)new SystemSessionProperties(new QueryManagerConfig(), new TaskManagerConfig(), new MemoryManagerConfig(), new FeaturesConfig().setMaxGroupingSets(2048), new OptimizerConfig(), new NodeMemoryConfig(), new DynamicFilterConfig(), new NodeSchedulerConfig()))).build();
        this.analyze(session, "SELECT a, b, c, d, e, f, g, h, i, j, k, SUM(l)FROM (VALUES (1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12))\nt (a, b, c, d, e, f, g, h, i, j, k, l)\nGROUP BY CUBE (a, b, c, d, e, f), CUBE (g, h, i, j, k)");
        this.assertFails(session, "SELECT a, b, c, d, e, f, g, h, i, j, k, l, SUM(m)FROM (VALUES (1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13))\nt (a, b, c, d, e, f, g, h, i, j, k, l, m)\nGROUP BY CUBE (a, b, c, d, e, f), CUBE (g, h, i, j, k, l)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TOO_MANY_GROUPING_SETS}).hasMessageMatching("line 3:10: GROUP BY has 4096 grouping sets but can contain at most 2048");
        this.assertFails(session, "SELECT a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v, x, w, y, z, aa, ab, ac, ad, ae, SUM(af)FROM (VALUES (1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32))\nt (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v, x, w, y, z, aa, ab, ac, ad, ae, af)\nGROUP BY CUBE (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v, x, w, y, z, aa, ab, ac, ad, ae)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TOO_MANY_GROUPING_SETS}).hasMessageMatching(String.format("line 3:10: GROUP BY has more than %s grouping sets but can contain at most 2048", Integer.MAX_VALUE));
    }

    @Test
    public void testMismatchedColumnAliasCount() {
        this.assertFails("SELECT * FROM t1 u (x, y)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISMATCHED_COLUMN_ALIASES});
    }

    @Test
    public void testJoinOnConstantExpression() {
        this.analyze("SELECT * FROM t1 JOIN t2 ON 1 = 1");
    }

    @Test
    public void testJoinOnNonBooleanExpression() {
        this.assertFails("SELECT * FROM t1 JOIN t2 ON 5").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
    }

    @Test
    public void testJoinOnAmbiguousName() {
        this.assertFails("SELECT * FROM t1 JOIN t2 ON a = a").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.AMBIGUOUS_NAME});
    }

    @Test
    public void testNonEquiOuterJoin() {
        this.analyze("SELECT * FROM t1 LEFT JOIN t2 ON t1.a + t2.a = 1");
        this.analyze("SELECT * FROM t1 RIGHT JOIN t2 ON t1.a + t2.a = 1");
        this.analyze("SELECT * FROM t1 LEFT JOIN t2 ON t1.a = t2.a OR t1.b = t2.b");
    }

    @Test
    public void testNonBooleanHaving() {
        this.assertFails("SELECT sum(a) FROM t1 HAVING sum(a)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
    }

    @Test
    public void testAmbiguousReferenceInOrderBy() {
        this.assertFails("SELECT a x, b x FROM t1 ORDER BY x").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.AMBIGUOUS_NAME});
        this.assertFails("SELECT a x, a x FROM t1 ORDER BY x").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.AMBIGUOUS_NAME});
        this.assertFails("SELECT a, a FROM t1 ORDER BY a").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.AMBIGUOUS_NAME});
    }

    @Test
    public void testImplicitCrossJoin() {
        this.analyze("SELECT * FROM t1, t2");
    }

    @Test
    public void testNaturalJoinNotSupported() {
        this.assertFails("SELECT * FROM t1 NATURAL JOIN t2").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED});
    }

    @Test
    public void testWindowClause() {
        this.assertFails("SELECT * FROM t1 WINDOW w AS (PARTITION BY a), w AS (PARTITION BY a)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_WINDOW_NAME});
        this.assertFails("SELECT * FROM t1 WINDOW w AS (PARTITION BY a), w AS (ORDER BY b)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_WINDOW_NAME});
        this.assertFails("SELECT * FROM t1 WINDOW w AS (), w1 as (), w AS (w)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_WINDOW_NAME});
    }

    @Test
    public void testWindowNames() {
        this.assertFails("SELECT * FROM t1 WINDOW w AS (), W AS ()").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_WINDOW_NAME});
        this.analyze("SELECT * FROM t1 WINDOW w AS (), \"w\" AS ()");
        this.analyze("SELECT * FROM t1 WINDOW W AS (), \"w\" AS ()");
        this.assertFails("SELECT * FROM t1 WINDOW w AS (), \"W\" AS ()").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_WINDOW_NAME});
        this.analyze("SELECT * FROM t1 WINDOW \"W\" AS (), \"w\" AS ()");
        this.assertFails("SELECT * FROM t1 WINDOW \"w\" AS (), \"w\" AS ()").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_WINDOW_NAME});
        this.analyze("SELECT avg(b) OVER w FROM t1 WINDOW \"W\" AS (PARTITION BY a)");
        this.analyze("SELECT avg(b) OVER \"W\" FROM t1 WINDOW w AS (PARTITION BY a)");
        this.assertFails("SELECT avg(b) OVER w FROM t1 WINDOW \"w\" AS (PARTITION BY a)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_REFERENCE});
        this.analyze("SELECT avg(b) OVER (W ROWS CURRENT ROW) FROM t1 WINDOW \"W\" AS (PARTITION BY a)");
        this.assertFails("SELECT avg(b) OVER (W ROWS CURRENT ROW) FROM t1 WINDOW \"w\" AS (PARTITION BY a)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_REFERENCE});
    }

    @Test
    public void testNamedWindowScope() {
        this.analyze("SELECT * FROM (SELECT * FROM t1 WINDOW w AS (PARTITION BY a)) WINDOW w AS (PARTITION BY a)");
        this.assertFails("SELECT avg(b) OVER w FROM (SELECT * FROM t1 WINDOW w AS (PARTITION BY a)) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_REFERENCE}).hasMessage("line 1:20: Cannot resolve WINDOW name w");
        this.assertFails("SELECT * FROM (SELECT avg(b) OVER w FROM t1) WINDOW w AS (PARTITION BY a) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_REFERENCE}).hasMessage("line 1:35: Cannot resolve WINDOW name w");
        this.analyze("SELECT * FROM t1 WINDOW w AS (PARTITION BY a), w1 AS (w ORDER BY b)");
        this.assertFails("SELECT * FROM t1 WINDOW w1 AS (w ORDER BY b), w AS (PARTITION BY a)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_REFERENCE}).hasMessage("line 1:32: Cannot resolve WINDOW name w");
        this.analyze("SELECT count(*) OVER w FROM t1 WINDOW w AS (PARTITION BY a)");
        this.analyze("SELECT * FROM t1 WINDOW w AS (PARTITION BY a) ORDER BY (count(*) OVER w)");
    }

    @Test
    public void testWindowClauseWithPatternRecognition() {
        this.analyze("SELECT classy OVER w FROM t1                    WINDOW w AS (                                MEASURES CLASSIFIER() AS classy                                 ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                 PATTERN (A+)                                 DEFINE A AS true                                ) ");
        this.analyze("SELECT classy OVER w2 FROM t1                    WINDOW w0 AS (PARTITION BY b),                           w1 AS (w0 ORDER BY c),                           w2 AS (w1                                  MEASURES CLASSIFIER() AS classy                                  ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                  PATTERN (A+)                                  DEFINE A AS true                                 )");
        this.assertFails("SELECT classy OVER w1 FROM t1                    WINDOW w AS (                                MEASURES CLASSIFIER() AS classy                                 ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                 PATTERN (A+)                                 DEFINE A AS true                                ) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_REFERENCE}).hasMessage("line 1:20: Cannot resolve WINDOW name w1");
    }

    @Test
    public void testWindowDefinition() {
        this.analyze("SELECT * FROM t1 WINDOW w1 AS (PARTITION BY a), w2 AS (w1 ORDER BY b), w3 AS (w2 RANGE c PRECEDING),w4 AS (w1 ROWS c PRECEDING)");
        this.assertFails("SELECT * FROM t1 WINDOW w AS (w1 ORDER BY a)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_REFERENCE}).hasMessage("line 1:31: Cannot resolve WINDOW name w1");
        this.assertFails("SELECT * FROM t1 WINDOW w2 AS (w1 ORDER BY a), w1 AS (PARTITION BY b)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_REFERENCE}).hasMessage("line 1:32: Cannot resolve WINDOW name w1");
        this.assertFails("SELECT * FROM t1 WINDOW w1 AS (ORDER BY a), w2 AS (w1 PARTITION BY b)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARTITION_BY}).hasMessage("line 1:68: WINDOW specification with named WINDOW reference cannot specify PARTITION BY");
        this.assertFails("SELECT * FROM t1 WINDOW w1 AS (ORDER BY a), w2 AS (w1 ORDER BY b)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ORDER_BY}).hasMessage("line 1:55: Cannot specify ORDER BY if referenced named WINDOW specifies ORDER BY");
        this.assertFails("SELECT * FROM t1 WINDOW w1 AS (RANGE CURRENT ROW), w2 AS (w1 ORDER BY b)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_REFERENCE}).hasMessage("line 1:59: Cannot reference named WINDOW containing frame specification");
    }

    @Test
    public void testWindowSpecification() {
        this.assertFails("SELECT * FROM (VALUES approx_set(1)) t(a) WINDOW w AS (PARTITION BY a)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:69: HyperLogLog is not comparable, and therefore cannot be used in window function PARTITION BY");
        this.assertFails("SELECT * FROM (VALUES approx_set(1)) t(a) WINDOW w AS (ORDER BY a)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:65: HyperLogLog is not orderable, and therefore cannot be used in window function ORDER BY");
        this.assertFails("SELECT * FROM (VALUES 1) t(a) WINDOW w AS (RANGE UNBOUNDED FOLLOWING)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME}).hasMessage("line 1:44: Window frame start cannot be UNBOUNDED FOLLOWING");
        this.assertFails("SELECT * FROM (VALUES 'x') t(a) WINDOW w AS (ROWS a PRECEDING)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:51: Window frame ROWS start value type must be exact numeric type with scale 0 (actual varchar(1))");
        this.assertFails("SELECT * FROM (VALUES 'x') t(a) WINDOW w AS (RANGE a PRECEDING)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISSING_ORDER_BY}).hasMessage("line 1:46: Window frame of type RANGE PRECEDING or FOLLOWING requires ORDER BY");
        this.assertFails("SELECT * FROM (VALUES (1, 2, 3)) t(a, b, c) WINDOW w AS (ORDER BY a, b RANGE c PRECEDING)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ORDER_BY}).hasMessage("line 1:58: Window frame of type RANGE PRECEDING or FOLLOWING requires single sort item in ORDER BY (actual: 2)");
        this.assertFails("SELECT * FROM (VALUES 'x') t(a) WINDOW w AS (GROUPS a PRECEDING)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISSING_ORDER_BY}).hasMessage("line 1:46: Window frame of type GROUPS PRECEDING or FOLLOWING requires ORDER BY");
        this.assertFails("SELECT * FROM (VALUES 'x') t(a) WINDOW w AS (ROWS a PRECEDING)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:51: Window frame ROWS start value type must be exact numeric type with scale 0 (actual varchar(1))");
        this.assertFails("SELECT * FROM (VALUES 1) t(a) WINDOW w AS (PARTITION BY count(a) OVER ())").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_WINDOW}).hasMessage("line 1:57: Cannot nest window functions or row pattern measures inside window specification");
        this.assertFails("SELECT * FROM (VALUES 1) t(a) WINDOW w AS (ORDER BY count(a) OVER ())").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_WINDOW}).hasMessage("line 1:53: Cannot nest window functions or row pattern measures inside window specification");
        this.assertFails("SELECT * FROM (VALUES 1) t(a) WINDOW w AS (ROWS count(a) OVER () PRECEDING)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_WINDOW}).hasMessage("line 1:49: Cannot nest window functions or row pattern measures inside window specification");
        this.assertFails("SELECT * FROM (VALUES 1) t(a)                        WINDOW w AS (PARTITION BY classy OVER (                                                                MEASURES CLASSIFIER() AS classy                                                                ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                                                PATTERN (A+)                                                                DEFINE A AS true                                                               )                                    )").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_WINDOW}).hasMessage("line 1:80: Cannot nest window functions or row pattern measures inside window specification");
        this.assertFails("SELECT * FROM (VALUES 1) t(a)                        WINDOW w AS (ORDER BY classy OVER (                                                           MEASURES CLASSIFIER() AS classy                                                           ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                                           PATTERN (A+)                                                           DEFINE A AS true                                                          )                                    )").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_WINDOW}).hasMessage("line 1:76: Cannot nest window functions or row pattern measures inside window specification");
        this.assertFails("SELECT * FROM (VALUES 1) t(a)                        WINDOW w AS (ROWS r OVER (                                                  MEASURES A.a AS r                                                  ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                                  PATTERN (A+)                                                  DEFINE A AS true                                                 ) PRECEDING                                    )").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_WINDOW}).hasMessage("line 1:72: Cannot nest window functions or row pattern measures inside window specification");
    }

    @Test
    public void testWindowInFunctionCall() {
        this.analyze("SELECT max(b) OVER w FROM t1 WINDOW w AS (PARTITION BY a)");
        this.analyze("SELECT max(b) OVER w3 FROM t1 WINDOW w1 AS (PARTITION BY a), w2 AS (w1 ORDER BY b), w3 AS (w2 RANGE c PRECEDING)");
        this.assertFails("SELECT max(b) OVER w FROM t1 WINDOW w1 AS (PARTITION BY a)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_REFERENCE}).hasMessage("line 1:20: Cannot resolve WINDOW name w");
        this.assertFails("SELECT max(c) OVER (w PARTITION BY a) FROM t1 WINDOW w AS (ORDER BY b)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARTITION_BY}).hasMessage("line 1:36: WINDOW specification with named WINDOW reference cannot specify PARTITION BY");
        this.assertFails("SELECT max(c) OVER (w ORDER BY a) FROM t1 WINDOW w AS (ORDER BY b)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ORDER_BY}).hasMessage("line 1:23: Cannot specify ORDER BY if referenced named WINDOW specifies ORDER BY");
        this.assertFails("SELECT max(c) OVER (w ORDER BY a) FROM t1 WINDOW w AS (ROWS b PRECEDING)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_REFERENCE}).hasMessage("line 1:21: Cannot reference named WINDOW containing frame specification");
        this.analyze("SELECT max(c) OVER w FROM t1 WINDOW w AS (ROWS b PRECEDING)");
        this.analyze("SELECT * FROM t1 WINDOW w AS (PARTITION BY a) ORDER BY max(b) OVER w");
        this.analyze("SELECT * FROM t1 WINDOW w1 AS (PARTITION BY a), w2 AS (w1 ORDER BY b), w3 AS (w2 RANGE c PRECEDING) ORDER BY max(b) OVER w3");
        this.assertFails("SELECT * FROM t1 WINDOW w1 AS (PARTITION BY a) ORDER BY max(b) OVER w").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_REFERENCE}).hasMessage("line 1:69: Cannot resolve WINDOW name w");
        this.assertFails("SELECT * FROM t1 WINDOW w AS (ORDER BY b) ORDER BY max(c) OVER (w PARTITION BY a)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARTITION_BY}).hasMessage("line 1:80: WINDOW specification with named WINDOW reference cannot specify PARTITION BY");
        this.assertFails("SELECT * FROM t1 WINDOW w AS (ORDER BY b) ORDER BY max(c) OVER (w ORDER BY a)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ORDER_BY}).hasMessage("line 1:67: Cannot specify ORDER BY if referenced named WINDOW specifies ORDER BY");
        this.assertFails("SELECT * FROM t1 WINDOW w AS (ROWS b PRECEDING) ORDER BY max(c) OVER (w ORDER BY a)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_REFERENCE}).hasMessage("line 1:71: Cannot reference named WINDOW containing frame specification");
        this.analyze("SELECT * FROM t1 WINDOW w AS (ROWS b PRECEDING) ORDER BY max(c) OVER w");
        this.assertFails("SELECT (SELECT count(*) OVER w FROM (VALUES 2)) FROM (VALUES 1) t(x) WINDOW w AS (PARTITION BY x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_REFERENCE}).hasMessage("line 1:30: Cannot resolve WINDOW name w");
        this.assertFails("SELECT * FROM (VALUES 1) t(x) WINDOW w AS (PARTITION BY x) ORDER BY (SELECT count(*) OVER w FROM (VALUES 2))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_REFERENCE}).hasMessage("line 1:91: Cannot resolve WINDOW name w");
    }

    @Test
    public void testWindowSpecificationWithMixedScopes() {
        this.analyze("SELECT a old_a, b a FROM (SELECT 'a', 1) t(a, b) WINDOW w AS (PARTITION BY a) ORDER BY max(b) OVER (w ORDER BY a RANGE 1 PRECEDING)");
        this.assertFails("SELECT a old_a, b a FROM (SELECT 'a', 1) t(a, b) WINDOW w AS (PARTITION BY a ORDER BY a) ORDER BY max(b) OVER (w RANGE 1 PRECEDING)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:87: Window frame of type RANGE PRECEDING or FOLLOWING requires that sort item type be numeric, datetime or interval (actual: varchar(1))");
    }

    @Test
    public void testWindowWithGroupBy() {
        this.assertFails("SELECT max(a) FROM (values (1,2)) t(a,b) GROUP BY b WINDOW w AS (ORDER BY a)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessageMatching("line 1:75: 'a' must be an aggregate expression or appear in GROUP BY clause");
        this.assertFails("SELECT max(a) FROM (values (1,2)) t(a,b) GROUP BY b WINDOW w AS (PARTITION BY a)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessageMatching("line 1:79: 'a' must be an aggregate expression or appear in GROUP BY clause");
        this.assertFails("SELECT max(a) FROM (values (1,2)) t(a,b) GROUP BY b WINDOW w AS (ROWS a PRECEDING)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessageMatching("line 1:71: 'a' must be an aggregate expression or appear in GROUP BY clause");
    }

    @Test
    public void testPatternRecognitionWithGroupBy() {
        this.analyze("SELECT m OVER(                      MEASURES CLASSIFIER() AS m                      ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                      PATTERN (A+)                      DEFINE A AS true                     )            FROM (VALUES (1,2)) t(a,b) GROUP BY b");
        this.assertFails("SELECT m OVER(                          MEASURES CLASSIFIER() AS m                          ROWS BETWEEN CURRENT ROW AND a FOLLOWING                          PATTERN (A+)                          DEFINE A AS true                         )            FROM (VALUES (1,2)) t(a,b) GROUP BY b").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessageMatching("line 1:122: Window frame end must be an aggregate expression or appear in GROUP BY clause");
        this.assertFails("SELECT m OVER(                          MEASURES A.a AS m                          ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                          PATTERN (A+)                          DEFINE A AS true                         )            FROM (VALUES (1,2)) t(a,b) GROUP BY b").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessageMatching("line 1:50: Row pattern measure must be an aggregate expression or appear in GROUP BY clause");
        this.assertFails("SELECT m OVER(                          MEASURES CLASSIFIER() AS m                          ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                          PATTERN (A+)                          DEFINE A AS A.a > 0                         )            FROM (VALUES (1,2)) t(a,b) GROUP BY b").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessageMatching("line 1:204: Row pattern variable definition must be an aggregate expression or appear in GROUP BY clause");
    }

    @Test
    public void testNestedWindowFunctions() {
        this.assertFails("SELECT avg(sum(a) OVER ()) FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_WINDOW});
        this.assertFails("SELECT sum(sum(a) OVER ()) OVER () FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_WINDOW});
        this.assertFails("SELECT avg(a) OVER (PARTITION BY sum(b) OVER ()) FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_WINDOW});
        this.assertFails("SELECT avg(a) OVER (ORDER BY sum(b) OVER ()) FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_WINDOW});
    }

    @Test
    public void testNestedMeasures() {
        this.assertFails("SELECT max(classy OVER (                                   MEASURES CLASSIFIER() AS classy                                    ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                    PATTERN (A+)                                    DEFINE A AS true                                   )                      ) FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_WINDOW});
        this.assertFails("SELECT max(classy OVER (                                   MEASURES CLASSIFIER() AS classy                                    ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                    PATTERN (A+)                                    DEFINE A AS true                                   )                      ) OVER () FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_WINDOW});
        this.assertFails("SELECT avg(a) OVER (PARTITION BY classy OVER (                                                         MEASURES CLASSIFIER() AS classy                                                          ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                                          PATTERN (A+)                                                          DEFINE A AS true                                                         )                               ) FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_WINDOW});
        this.assertFails("SELECT avg(a) OVER (ORDER BY classy OVER (                                                         MEASURES CLASSIFIER() AS classy                                                          ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                                          PATTERN (A+)                                                          DEFINE A AS true                                                         )                               ) FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_WINDOW});
    }

    @Test
    public void testWindowAttributes() {
        this.assertFails("SELECT lag(x, 2) OVER() FROM (VALUES 1, 2, 3, 4, 5) t(x) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISSING_ORDER_BY});
        this.assertFails("SELECT lag(x, 2) OVER(ORDER BY x ROWS BETWEEN 1 PRECEDING AND 1 FOLLOWING) FROM (VALUES 1, 2, 3, 4, 5) t(x) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME}).hasMessage("line 1:34: Cannot specify window frame for lag function");
        this.assertFails("SELECT lead(x, 2) OVER() FROM (VALUES 1, 2, 3, 4, 5) t(x) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISSING_ORDER_BY});
        this.assertFails("SELECT lead(x, 2) OVER(ORDER BY x ROWS BETWEEN 1 PRECEDING AND 1 FOLLOWING) FROM (VALUES 1, 2, 3, 4, 5) t(x) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME}).hasMessage("line 1:35: Cannot specify window frame for lead function");
        this.assertFails("SELECT row_number() OVER(ORDER BY x ROWS BETWEEN 1 PRECEDING AND 1 FOLLOWING) FROM (VALUES 1, 2, 3, 4, 5) t(x) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME}).hasMessage("line 1:37: Cannot specify window frame for row_number function");
        this.assertFails("SELECT rank() OVER(ORDER BY x ROWS BETWEEN 1 PRECEDING AND 1 FOLLOWING) FROM (VALUES 1, 2, 3, 4, 5) t(x) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME}).hasMessage("line 1:31: Cannot specify window frame for rank function");
        this.assertFails("SELECT percent_rank() OVER(ORDER BY x ROWS BETWEEN 1 PRECEDING AND 1 FOLLOWING) FROM (VALUES 1, 2, 3, 4, 5) t(x) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME}).hasMessage("line 1:39: Cannot specify window frame for percent_rank function");
        this.assertFails("SELECT dense_rank() OVER(ORDER BY x ROWS BETWEEN 1 PRECEDING AND 1 FOLLOWING) FROM (VALUES 1, 2, 3, 4, 5) t(x) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME}).hasMessage("line 1:37: Cannot specify window frame for dense_rank function");
        this.assertFails("SELECT cume_dist() OVER(ORDER BY x ROWS BETWEEN 1 PRECEDING AND 1 FOLLOWING) FROM (VALUES 1, 2, 3, 4, 5) t(x) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME}).hasMessage("line 1:36: Cannot specify window frame for cume_dist function");
        this.assertFails("SELECT ntile(4) OVER(ORDER BY x ROWS BETWEEN 1 PRECEDING AND 1 FOLLOWING) FROM (VALUES 1, 2, 3, 4, 5) t(x) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME}).hasMessage("line 1:33: Cannot specify window frame for ntile function");
    }

    @Test
    public void testWindowFunctionWithoutOverClause() {
        this.assertFails("SELECT row_number()").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISSING_OVER});
        this.assertFails("SELECT coalesce(lead(a), 0) from (values(0)) t(a)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISSING_OVER});
    }

    @Test
    public void testWindowFrameTypeRows() {
        this.assertFails("SELECT array_agg(x) OVER (ROWS UNBOUNDED FOLLOWING) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME});
        this.assertFails("SELECT array_agg(x) OVER (ROWS 2 FOLLOWING) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME});
        this.assertFails("SELECT array_agg(x) OVER (ROWS BETWEEN UNBOUNDED FOLLOWING AND CURRENT ROW) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME});
        this.assertFails("SELECT array_agg(x) OVER (ROWS BETWEEN CURRENT ROW AND UNBOUNDED PRECEDING) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME});
        this.assertFails("SELECT array_agg(x) OVER (ROWS BETWEEN CURRENT ROW AND 5 PRECEDING) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME});
        this.assertFails("SELECT array_agg(x) OVER (ROWS BETWEEN 2 FOLLOWING AND 5 PRECEDING) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME});
        this.assertFails("SELECT array_agg(x) OVER (ROWS BETWEEN 2 FOLLOWING AND CURRENT ROW) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME});
        this.assertFails("SELECT array_agg(x) OVER (ROWS 5e-1 PRECEDING) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        this.assertFails("SELECT array_agg(x) OVER (ROWS 'foo' PRECEDING) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        this.assertFails("SELECT array_agg(x) OVER (ROWS BETWEEN CURRENT ROW AND 5e-1 FOLLOWING) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        this.assertFails("SELECT array_agg(x) OVER (ROWS BETWEEN CURRENT ROW AND 'foo' FOLLOWING) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        this.analyze("SELECT array_agg(x) OVER (ROWS BETWEEN SMALLINT '1' PRECEDING AND SMALLINT '2' FOLLOWING) FROM (VALUES 1) t(x)");
        this.analyze("SELECT array_agg(x) OVER (ROWS BETWEEN TINYINT '1' PRECEDING AND TINYINT '2' FOLLOWING) FROM (VALUES 1) t(x)");
        this.analyze("SELECT array_agg(x) OVER (ROWS BETWEEN INTEGER '1' PRECEDING AND INTEGER '2' FOLLOWING) FROM (VALUES 1) t(x)");
        this.analyze("SELECT array_agg(x) OVER (ROWS BETWEEN BIGINT '1' PRECEDING AND BIGINT '2' FOLLOWING) FROM (VALUES 1) t(x)");
        this.analyze("SELECT array_agg(x) OVER (ROWS BETWEEN DECIMAL '1' PRECEDING AND DECIMAL '2' FOLLOWING) FROM (VALUES 1) t(x)");
        this.analyze("SELECT array_agg(x) OVER (ROWS BETWEEN CAST(1 AS decimal(38, 0)) PRECEDING AND CAST(2 AS decimal(38, 0)) FOLLOWING) FROM (VALUES 1) t(x)");
    }

    @Test
    public void testWindowFrameTypeRange() {
        this.assertFails("SELECT array_agg(x) OVER (ORDER BY x RANGE UNBOUNDED FOLLOWING) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME});
        this.assertFails("SELECT array_agg(x) OVER (ORDER BY x RANGE BETWEEN UNBOUNDED FOLLOWING AND 2 FOLLOWING) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME});
        this.assertFails("SELECT array_agg(x) OVER (ORDER BY x RANGE BETWEEN UNBOUNDED FOLLOWING AND CURRENT ROW) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME});
        this.assertFails("SELECT array_agg(x) OVER (ORDER BY x RANGE BETWEEN UNBOUNDED FOLLOWING AND 5 PRECEDING) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME});
        this.assertFails("SELECT array_agg(x) OVER (ORDER BY x RANGE BETWEEN UNBOUNDED FOLLOWING AND UNBOUNDED PRECEDING) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME});
        this.assertFails("SELECT array_agg(x) OVER (ORDER BY x RANGE BETWEEN UNBOUNDED FOLLOWING AND UNBOUNDED FOLLOWING) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME});
        this.assertFails("SELECT array_agg(x) OVER (ORDER BY x RANGE 2 FOLLOWING) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME});
        this.assertFails("SELECT array_agg(x) OVER (ORDER BY x RANGE BETWEEN 2 FOLLOWING AND CURRENT ROW) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME});
        this.assertFails("SELECT array_agg(x) OVER (ORDER BY x RANGE BETWEEN 2 FOLLOWING AND 5 PRECEDING) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME});
        this.assertFails("SELECT array_agg(x) OVER (ORDER BY x RANGE BETWEEN 2 FOLLOWING AND UNBOUNDED PRECEDING) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME});
        this.assertFails("SELECT array_agg(x) OVER (ORDER BY x RANGE BETWEEN CURRENT ROW AND 5 PRECEDING) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME});
        this.assertFails("SELECT array_agg(x) OVER (ORDER BY x RANGE BETWEEN CURRENT ROW AND UNBOUNDED PRECEDING) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME});
        this.assertFails("SELECT array_agg(x) OVER (ORDER BY x RANGE BETWEEN 5 PRECEDING AND UNBOUNDED PRECEDING) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME});
        this.analyze("SELECT array_agg(x) OVER (ORDER BY x RANGE UNBOUNDED PRECEDING) FROM (VALUES 1) t(x)");
        this.analyze("SELECT array_agg(x) OVER (ORDER BY x RANGE BETWEEN UNBOUNDED PRECEDING AND 5 PRECEDING) FROM (VALUES 1) t(x)");
        this.analyze("SELECT array_agg(x) OVER (ORDER BY x RANGE BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) FROM (VALUES 1) t(x)");
        this.analyze("SELECT array_agg(x) OVER (ORDER BY x RANGE BETWEEN UNBOUNDED PRECEDING AND 2 FOLLOWING) FROM (VALUES 1) t(x)");
        this.analyze("SELECT array_agg(x) OVER (ORDER BY x RANGE BETWEEN UNBOUNDED PRECEDING AND UNBOUNDED FOLLOWING) FROM (VALUES 1) t(x)");
        this.analyze("SELECT array_agg(x) OVER (ORDER BY x RANGE 5 PRECEDING) FROM (VALUES 1) t(x)");
        this.analyze("SELECT array_agg(x) OVER (ORDER BY x RANGE BETWEEN 5 PRECEDING AND 10 PRECEDING) FROM (VALUES 1) t(x)");
        this.analyze("SELECT array_agg(x) OVER (ORDER BY x RANGE BETWEEN 5 PRECEDING AND 3 PRECEDING) FROM (VALUES 1) t(x)");
        this.analyze("SELECT array_agg(x) OVER (ORDER BY x RANGE BETWEEN 5 PRECEDING AND CURRENT ROW) FROM (VALUES 1) t(x)");
        this.analyze("SELECT array_agg(x) OVER (ORDER BY x RANGE BETWEEN 5 PRECEDING AND 2 FOLLOWING) FROM (VALUES 1) t(x)");
        this.analyze("SELECT array_agg(x) OVER (ORDER BY x RANGE BETWEEN 5 PRECEDING AND UNBOUNDED FOLLOWING) FROM (VALUES 1) t(x)");
        this.analyze("SELECT array_agg(x) OVER (ORDER BY x RANGE CURRENT ROW) FROM (VALUES 1) t(x)");
        this.analyze("SELECT array_agg(x) OVER (ORDER BY x RANGE BETWEEN CURRENT ROW AND CURRENT ROW) FROM (VALUES 1) t(x)");
        this.analyze("SELECT array_agg(x) OVER (ORDER BY x RANGE BETWEEN CURRENT ROW AND 2 FOLLOWING) FROM (VALUES 1) t(x)");
        this.analyze("SELECT array_agg(x) OVER (ORDER BY x RANGE BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) FROM (VALUES 1) t(x)");
        this.analyze("SELECT array_agg(x) OVER (ORDER BY x RANGE BETWEEN 2 FOLLOWING AND 1 FOLLOWING) FROM (VALUES 1) t(x)");
        this.analyze("SELECT array_agg(x) OVER (ORDER BY x RANGE BETWEEN 2 FOLLOWING AND 10 FOLLOWING) FROM (VALUES 1) t(x)");
        this.analyze("SELECT array_agg(x) OVER (ORDER BY x RANGE BETWEEN 2 FOLLOWING AND UNBOUNDED FOLLOWING) FROM (VALUES 1) t(x)");
        this.analyze("SELECT array_agg(x) OVER (ORDER BY x RANGE BETWEEN -x PRECEDING AND 0 * x FOLLOWING) FROM (VALUES 1) t(x)");
        this.analyze("SELECT array_agg(x) OVER (ORDER BY x RANGE BETWEEN CAST(null AS BIGINT) PRECEDING AND CAST(null AS BIGINT) FOLLOWING) FROM (VALUES 1) t(x)");
        this.assertFails("SELECT array_agg(x) OVER (RANGE BETWEEN 1 PRECEDING AND 1 FOLLOWING) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISSING_ORDER_BY}).hasMessage("line 1:27: Window frame of type RANGE PRECEDING or FOLLOWING requires ORDER BY");
        this.assertFails("SELECT array_agg(x) OVER (ORDER BY x DESC, x ASC RANGE BETWEEN 1 PRECEDING AND 1 FOLLOWING) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ORDER_BY}).hasMessage("line 1:27: Window frame of type RANGE PRECEDING or FOLLOWING requires single sort item in ORDER BY (actual: 2)");
        this.assertFails("SELECT array_agg(x) OVER (ORDER BY x RANGE BETWEEN 1 PRECEDING AND 1 FOLLOWING) FROM (VALUES 'a') t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:36: Window frame of type RANGE PRECEDING or FOLLOWING requires that sort item type be numeric, datetime or interval (actual: varchar(1))");
        this.assertFails("SELECT array_agg(x) OVER (ORDER BY x RANGE BETWEEN 'a' PRECEDING AND 'z' FOLLOWING) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:52: Window frame RANGE value type (varchar(1)) not compatible with sort item type (integer)");
        this.assertFails("SELECT array_agg(x) OVER (ORDER BY x RANGE INTERVAL '1' day PRECEDING) FROM (VALUES INTERVAL '1' year) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:44: Window frame RANGE value type (interval day to second) not compatible with sort item type (interval year to month)");
        this.analyze("SELECT array_agg(x) OVER (RANGE BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) FROM (VALUES 1) t(x)");
        this.analyze("SELECT array_agg(x) OVER (ORDER BY y, z RANGE BETWEEN CURRENT ROW AND UNBOUNDED FOLLOWING) FROM (VALUES (1, 'text', true)) t(x, y, z)");
    }

    @Test
    public void testWindowFrameTypeGroups() {
        this.assertFails("SELECT array_agg(x) OVER (ORDER BY x GROUPS UNBOUNDED FOLLOWING) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME});
        this.assertFails("SELECT array_agg(x) OVER (ORDER BY x GROUPS 2 FOLLOWING) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME});
        this.assertFails("SELECT array_agg(x) OVER (ORDER BY x GROUPS BETWEEN UNBOUNDED FOLLOWING AND CURRENT ROW) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME});
        this.assertFails("SELECT array_agg(x) OVER (ORDER BY x GROUPS BETWEEN CURRENT ROW AND UNBOUNDED PRECEDING) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME});
        this.assertFails("SELECT array_agg(x) OVER (ORDER BY x GROUPS BETWEEN CURRENT ROW AND 5 PRECEDING) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME});
        this.assertFails("SELECT array_agg(x) OVER (ORDER BY x GROUPS BETWEEN 2 FOLLOWING AND 5 PRECEDING) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME});
        this.assertFails("SELECT array_agg(x) OVER (ORDER BY x GROUPS BETWEEN 2 FOLLOWING AND CURRENT ROW) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME});
        this.assertFails("SELECT array_agg(x) OVER (GROUPS 2 PRECEDING) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISSING_ORDER_BY});
        this.assertFails("SELECT array_agg(x) OVER (ORDER BY x GROUPS 5e-1 PRECEDING) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        this.assertFails("SELECT array_agg(x) OVER (ORDER BY x GROUPS 'foo' PRECEDING) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        this.assertFails("SELECT array_agg(x) OVER (ORDER BY x GROUPS BETWEEN CURRENT ROW AND 5e-1 FOLLOWING) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        this.assertFails("SELECT array_agg(x) OVER (ORDER BY x GROUPS BETWEEN CURRENT ROW AND 'foo' FOLLOWING) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        this.analyze("SELECT array_agg(x) OVER (ORDER BY x GROUPS BETWEEN SMALLINT '1' PRECEDING AND SMALLINT '2' FOLLOWING) FROM (VALUES 1) t(x)");
        this.analyze("SELECT array_agg(x) OVER (ORDER BY x GROUPS BETWEEN TINYINT '1' PRECEDING AND TINYINT '2' FOLLOWING) FROM (VALUES 1) t(x)");
        this.analyze("SELECT array_agg(x) OVER (ORDER BY x GROUPS BETWEEN INTEGER '1' PRECEDING AND INTEGER '2' FOLLOWING) FROM (VALUES 1) t(x)");
        this.analyze("SELECT array_agg(x) OVER (ORDER BY x GROUPS BETWEEN BIGINT '1' PRECEDING AND BIGINT '2' FOLLOWING) FROM (VALUES 1) t(x)");
        this.analyze("SELECT array_agg(x) OVER (ORDER BY x GROUPS BETWEEN DECIMAL '1' PRECEDING AND DECIMAL '2' FOLLOWING) FROM (VALUES 1) t(x)");
        this.analyze("SELECT array_agg(x) OVER (ORDER BY x GROUPS BETWEEN CAST(1 AS decimal(38, 0)) PRECEDING AND CAST(2 AS decimal(38, 0)) FOLLOWING) FROM (VALUES 1) t(x)");
    }

    @Test
    public void testWindowFrameWithPatternRecognition() {
        this.analyze("SELECT array_agg(x) OVER (                           PARTITION BY x                            ORDER BY y                            MEASURES A.z AS last_z                            ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                            AFTER MATCH SKIP TO NEXT ROW                            SEEK                            PATTERN (A B C)                            SUBSET U = (A, B)                            DEFINE                                B AS false,                                C AS true                          )            FROM (VALUES (1, 2, 3)) t(x, y, z)");
        this.analyze("SELECT array_agg(x) OVER w FROM (VALUES (1, 2, 3)) t(x, y, z)                        WINDOW w AS (                           PARTITION BY x                            ORDER BY y                            MEASURES A.z AS last_z                            ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                            AFTER MATCH SKIP TO NEXT ROW                            SEEK                            PATTERN (A B C)                            SUBSET U = (A, B)                            DEFINE                                B AS false,                                C AS true                       ) ");
    }

    @Test
    public void testInvalidWindowFrameWithPatternRecognition() {
        this.assertFails("SELECT array_agg(x) OVER (                           PARTITION BY x                            ORDER BY y                            MEASURES A.z AS last_z                            ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                            AFTER MATCH SKIP TO NEXT ROW                            SEEK                            PATTERN (A B C)                            SUBSET U = (A, B)                          )            FROM (VALUES (1, 2, 3)) t(x, y, z)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISSING_VARIABLE_DEFINITIONS}).hasMessage("line 1:134: Pattern recognition requires DEFINE clause");
        this.assertFails("SELECT array_agg(x) OVER (                           PARTITION BY x                            ORDER BY y                            MEASURES A.z AS last_z                            RANGE BETWEEN CURRENT ROW AND 5 FOLLOWING                            AFTER MATCH SKIP TO NEXT ROW                            SEEK                            PATTERN (A B C)                            SUBSET U = (A, B)                            DEFINE                                B AS false,                                C AS true                          )            FROM (VALUES (1, 2, 3)) t(x, y, z)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME}).hasMessage("line 1:134: Pattern recognition requires ROWS frame type");
        this.assertFails("SELECT array_agg(x) OVER (                           PARTITION BY x                            ORDER BY y                            MEASURES A.z AS last_z                            ROWS BETWEEN 5 PRECEDING AND 5 FOLLOWING                            AFTER MATCH SKIP TO NEXT ROW                            SEEK                            PATTERN (A B C)                            SUBSET U = (A, B)                            DEFINE                                B AS false,                                C AS true                          )            FROM (VALUES (1, 2, 3)) t(x, y, z)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_FRAME}).hasMessage("line 1:134: Pattern recognition requires frame specified as BETWEEN CURRENT ROW AND ...");
        this.assertFails("SELECT array_agg(x) OVER (                                MEASURES A.z AS last_z                                ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING)            FROM (VALUES (1, 2, 3)) t(x, y, z)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISSING_ROW_PATTERN}).hasMessage("line 1:59: Row pattern measures require PATTERN clause");
        this.assertFails("SELECT array_agg(x) OVER (                               ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                AFTER MATCH SKIP TO NEXT ROW)            FROM (VALUES (1, 2, 3)) t(x, y, z)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISSING_ROW_PATTERN}).hasMessage("line 1:142: AFTER MATCH SKIP clause requires PATTERN clause");
        this.assertFails("SELECT array_agg(x) OVER (                               ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                SEEK)            FROM (VALUES (1, 2, 3)) t(x, y, z)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISSING_ROW_PATTERN}).hasMessage("line 1:130: SEEK modifier requires PATTERN clause");
        this.assertFails("SELECT array_agg(x) OVER (                               ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                SUBSET U = (A, B))            FROM (VALUES (1, 2, 3)) t(x, y, z)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISSING_ROW_PATTERN}).hasMessage("line 1:137: Union variable definitions require PATTERN clause");
        this.assertFails("SELECT array_agg(x) OVER (                               ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                DEFINE B AS false)            FROM (VALUES (1, 2, 3)) t(x, y, z)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISSING_ROW_PATTERN}).hasMessage("line 1:137: Primary pattern variable definitions require PATTERN clause");
    }

    @Test
    public void testSubsetClauseInWindow() {
        this.assertFails("SELECT array_agg(x) OVER (                               ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                PATTERN (A B)                                SUBSET A = (C)                                DEFINE B AS false)            FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LABEL}).hasMessage("line 1:182: union pattern variable name: A is a duplicate of primary pattern variable name");
        this.assertFails("SELECT array_agg(x) OVER (                               ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                PATTERN (A B)                                SUBSET                                    U = (A),                                    U = (B)                                DEFINE B AS false)            FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LABEL}).hasMessage("line 1:261: union pattern variable name: U is declared twice");
        this.assertFails("SELECT array_agg(x) OVER (                               ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                PATTERN (A B)                                SUBSET U = (A, C)                                DEFINE B AS false)            FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LABEL}).hasMessage("line 1:190: subset element: C is not a primary pattern variable");
    }

    @Test
    public void testDefineClauseInWindow() {
        this.assertFails("SELECT array_agg(x) OVER (                               ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                PATTERN (A B)                                DEFINE C AS false)            FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LABEL}).hasMessage("line 1:182: defined variable: C is not a primary pattern variable");
        this.assertFails("SELECT array_agg(x) OVER (                               ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                PATTERN (A B)                                DEFINE                                        A AS true,                                        A AS false)            FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LABEL}).hasMessage("line 1:271: pattern variable with name: A is defined twice");
        this.assertFails("SELECT array_agg(x) OVER (                               ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                PATTERN (A B)                                DEFINE A AS FINAL LAST(A.x) > 0)            FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PROCESSING_MODE}).hasMessage("line 1:187: FINAL semantics is not supported in DEFINE clause");
    }

    @Test
    public void testRangeQuantifiersInWindow() {
        this.assertFails("SELECT array_agg(x) OVER (                               ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                PATTERN (A{,0})                                DEFINE A AS false)            FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("line 1:140: Pattern quantifier upper bound must be greater than or equal to 1");
        this.assertFails("SELECT array_agg(x) OVER (                               ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                PATTERN (A{,3000000000})                                DEFINE A AS false)            FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("line 1:140: Pattern quantifier upper bound must not exceed 2147483647");
        this.assertFails("SELECT array_agg(x) OVER (                               ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                PATTERN (A{100,1})                                DEFINE A AS false)            FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_RANGE}).hasMessage("line 1:140: Pattern quantifier lower bound must not exceed upper bound");
    }

    @Test
    public void testAfterMatchSkipInWindow() {
        this.analyze("SELECT array_agg(x) OVER (                               ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                AFTER MATCH SKIP TO FIRST B                                PATTERN (A B)                                DEFINE A AS false)            FROM (VALUES 1) t(x)");
        this.analyze("SELECT array_agg(x) OVER (                               ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                AFTER MATCH SKIP TO FIRST U                                PATTERN (A B)                                SUBSET U = (B)                                DEFINE A AS false)            FROM (VALUES 1) t(x)");
        this.assertFails("SELECT array_agg(x) OVER (                               ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                AFTER MATCH SKIP TO FIRST C                                PATTERN (A B)                                DEFINE A AS false)            FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LABEL}).hasMessage("line 1:156: C is not a primary or union pattern variable");
    }

    @Test
    public void testPatternSearchModeInWindow() {
        this.analyze("SELECT array_agg(x) OVER (                               ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                INITIAL                                PATTERN (A B)                                DEFINE A AS false)            FROM (VALUES 1) t(x)");
        this.analyze("SELECT array_agg(x) OVER (                               ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                SEEK                                PATTERN (A B)                                DEFINE A AS false)            FROM (VALUES 1) t(x)");
    }

    @Test
    public void testAnchorPatternInWindow() {
        this.assertFails("SELECT array_agg(x) OVER (                               ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                PATTERN (^ A B)                                DEFINE B AS false)            FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ROW_PATTERN}).hasMessage("line 1:139: Anchor pattern syntax is not allowed in window");
        this.assertFails("SELECT array_agg(x) OVER (                               ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                PATTERN (A B $)                                DEFINE B AS false)            FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ROW_PATTERN}).hasMessage("line 1:143: Anchor pattern syntax is not allowed in window");
    }

    @Test
    public void testMatchNumberFunctionInWindow() {
        this.assertFails("SELECT array_agg(x) OVER (                                MEASURES 1 + MATCH_NUMBER() AS m                               ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                PATTERN (A B)                                DEFINE B AS false                              )            FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PATTERN_RECOGNITION_FUNCTION}).hasMessage("line 1:72: MATCH_NUMBER function is not supported in window");
        this.assertFails("SELECT array_agg(x) OVER (                                MEASURES B.x AS m                               ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                PATTERN (A B)                                DEFINE B AS MATCH_NUMBER() > 2                              )            FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PATTERN_RECOGNITION_FUNCTION}).hasMessage("line 1:236: MATCH_NUMBER function is not supported in window");
    }

    @Test
    public void testLabelNamesInWindow() {
        this.analyze("SELECT array_agg(x) OVER (                                MEASURES                                        \"B\".x AS m1,                                        B.x AS m2                                ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                PATTERN (A B)                                DEFINE B AS b.x > 0                              )            FROM (VALUES 1) t(x)");
        this.assertFails("SELECT array_agg(x) OVER (                                ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                PATTERN (A B)                                DEFINE B AS \"b\".x > 0                              )            FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessage("line 1:188: Column 'b.x' cannot be resolved");
    }

    @Test
    public void testMeasureOverWindow() {
        this.assertFails("SELECT last_z OVER () FROM (VALUES 1) t(z) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_MEASURE}).hasMessage("line 1:8: Measure last_z is not defined in the corresponding window");
        this.assertFails("SELECT last_z OVER (                                MEASURES CLASSIFIER() AS classy                                ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                PATTERN (A B)                                DEFINE B AS true                               )            FROM (VALUES 1) t(z)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_MEASURE}).hasMessage("line 1:8: Measure last_z is not defined in the corresponding window");
        this.assertFails("SELECT last_z OVER (                                MEASURES                                         LAST(A.z) AS last_z,                                         LAST(B.z) AS last_z                                ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                PATTERN (A B)                                DEFINE B AS true                               )            FROM (VALUES 1) t(z)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.AMBIGUOUS_NAME}).hasMessage("line 1:8: Measure last_z is defined more than once");
        this.assertFails("SELECT \"last_z\" OVER (                                MEASURES                                         LAST(A.z) AS \"LAST_Z\",                                         LAST(A.z) AS \"Last_Z\",                                         LAST(B.z) AS last_z                                ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                PATTERN (A B)                                DEFINE B AS true                               )            FROM (VALUES 1) t(z)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_MEASURE}).hasMessage("line 1:8: Measure last_z is not defined in the corresponding window");
        this.assertFails("SELECT last_z OVER w FROM (VALUES 1) t(z) WINDOW w AS ()").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_MEASURE}).hasMessage("line 1:8: Measure last_z is not defined in the corresponding window");
        this.assertFails("SELECT last_z OVER w                FROM (VALUES 1) t(z)                WINDOW w AS (                             MEASURES CLASSIFIER() AS classy                             ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                             PATTERN (A B)                             DEFINE B AS true                            )").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_MEASURE}).hasMessage("line 1:8: Measure last_z is not defined in the corresponding window");
        this.assertFails("SELECT last_z OVER w                FROM (VALUES 1) t(z)                WINDOW w AS (                             MEASURES                                      LAST(A.z) AS last_z,                                      LAST(B.z) AS last_z                             ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                             PATTERN (A B)                             DEFINE B AS true                            )").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.AMBIGUOUS_NAME}).hasMessage("line 1:8: Measure last_z is defined more than once");
        this.assertFails("SELECT \"last_z\" OVER w                FROM (VALUES 1) t(z)                WINDOW w AS (                             MEASURES                                      LAST(A.z) AS \"LAST_Z\",                                      LAST(A.z) AS \"Last_Z\",                                      LAST(B.z) AS last_z                             ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                             PATTERN (A B)                             DEFINE B AS true                            )").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_WINDOW_MEASURE}).hasMessage("line 1:8: Measure last_z is not defined in the corresponding window");
    }

    @Test
    public void testDistinctInWindowFunctionParameter() {
        this.assertFails("SELECT a, count(DISTINCT b) OVER () FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED});
    }

    @Test
    public void testGroupByOrdinalsWithWildcard() {
        this.analyze("SELECT t1.*, a FROM t1 GROUP BY 1,2,c,d");
    }

    @Test
    public void testGroupByWithQualifiedName() {
        this.analyze("SELECT a FROM t1 GROUP BY t1.a");
    }

    @Test
    public void testGroupByWithQualifiedName2() {
        this.analyze("SELECT t1.a FROM t1 GROUP BY a");
    }

    @Test
    public void testGroupByWithQualifiedName3() {
        this.analyze("SELECT * FROM t1 GROUP BY t1.a, t1.b, t1.c, t1.d");
    }

    @Test
    public void testGroupByWithRowExpression() {
        this.analyze("SELECT (a, b) FROM t1 GROUP BY a, b");
    }

    @Test
    public void testHaving() {
        this.analyze("SELECT sum(a) FROM t1 HAVING avg(a) - avg(b) > 10");
        this.assertFails("SELECT a FROM t1 HAVING a = 1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessageMatching("line 1:8: 'a' must be an aggregate expression or appear in GROUP BY clause");
    }

    @Test
    public void testWithCaseInsensitiveResolution() {
        this.analyze("WITH AB AS (SELECT * FROM t1) SELECT * FROM ab");
    }

    @Test
    public void testStartTransaction() {
        this.analyze("START TRANSACTION");
        this.analyze("START TRANSACTION ISOLATION LEVEL READ UNCOMMITTED");
        this.analyze("START TRANSACTION ISOLATION LEVEL READ COMMITTED");
        this.analyze("START TRANSACTION ISOLATION LEVEL REPEATABLE READ");
        this.analyze("START TRANSACTION ISOLATION LEVEL SERIALIZABLE");
        this.analyze("START TRANSACTION READ ONLY");
        this.analyze("START TRANSACTION READ WRITE");
        this.analyze("START TRANSACTION ISOLATION LEVEL READ COMMITTED, READ ONLY");
        this.analyze("START TRANSACTION READ ONLY, ISOLATION LEVEL READ COMMITTED");
        this.analyze("START TRANSACTION READ WRITE, ISOLATION LEVEL SERIALIZABLE");
    }

    @Test
    public void testCommit() {
        this.analyze("COMMIT");
        this.analyze("COMMIT WORK");
    }

    @Test
    public void testRollback() {
        this.analyze("ROLLBACK");
        this.analyze("ROLLBACK WORK");
    }

    @Test
    public void testExplainAnalyze() {
        this.analyze("EXPLAIN ANALYZE SELECT * FROM t1");
    }

    @Test
    public void testInsert() {
        this.assertFails("INSERT INTO t6 (a) SELECT b from t6").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        this.analyze("INSERT INTO t1 SELECT * FROM t1");
        this.analyze("INSERT INTO t3 SELECT * FROM t3");
        this.analyze("INSERT INTO t3 SELECT a, b FROM t3");
        this.assertFails("INSERT INTO t1 VALUES (1, 2)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        this.analyze("INSERT INTO t5 (a) VALUES(null)");
        this.analyze("INSERT INTO t5 VALUES (1)");
        this.assertFails("INSERT INTO t5 VALUES (1, 2)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        this.analyze("INSERT INTO t6 (a) SELECT a from t6");
        this.analyze("INSERT INTO t6 (a) SELECT c from t6");
        this.analyze("INSERT INTO t6 (a,b,c,d) SELECT * from t6");
        this.analyze("INSERT INTO t6 (A,B,C,D) SELECT * from t6");
        this.analyze("INSERT INTO t6 (a,b,c,d) SELECT d,b,c,a from t6");
        this.assertFails("INSERT INTO t6 (a) SELECT b from t6").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        this.assertFails("INSERT INTO t6 (unknown) SELECT * FROM t6").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND});
        this.assertFails("INSERT INTO t6 (a, a) SELECT * FROM t6").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_COLUMN_NAME});
        this.assertFails("INSERT INTO t6 (a, A) SELECT * FROM t6").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_COLUMN_NAME});
        this.analyze("INSERT INTO t7 (b) SELECT (a) FROM t7 ");
        this.analyze("INSERT INTO t7 (a) SELECT (b) FROM t7");
        this.analyze("INSERT INTO t7 (d) SELECT (c) FROM t7 ");
        this.analyze("INSERT INTO t7 (c) SELECT (d) FROM t7 ");
        this.analyze("INSERT INTO t7 (d) VALUES (ARRAY[null])");
        this.analyze("INSERT INTO t6 (d) VALUES (1), (2), (3)");
        this.analyze("INSERT INTO t6 (a,b,c,d) VALUES (1, 'a', 1, 1), (2, 'b', 2, 2), (3, 'c', 3, 3), (4, 'd', 4, 4)");
        this.analyze("INSERT INTO t8 (tinyint_column, integer_column, decimal_column, real_column) VALUES (1e0, 1e0, 1e0, 1e0)");
        this.analyze("INSERT INTO t8 (char_column, bounded_varchar_column, unbounded_varchar_column) VALUES (VARCHAR 'aa     ', VARCHAR 'aa     ', VARCHAR 'aa     ')");
        this.analyze("INSERT INTO t8 (tinyint_array_column) SELECT (bigint_array_column) FROM t8");
        this.analyze("INSERT INTO t8 (row_column) VALUES (ROW(ROW(1e0, VARCHAR 'aa     ')))");
        this.analyze("INSERT INTO t8 (date_column) VALUES (TIMESTAMP '2019-11-18 22:13:40')");
        this.assertFails("INSERT INTO t8 (integer_column) VALUES ('text')").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        this.assertFails("INSERT INTO t8 (integer_column) VALUES (true)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        this.assertFails("INSERT INTO t8 (integer_column) VALUES (ROW(ROW(1e0)))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        this.assertFails("INSERT INTO t8 (integer_column) VALUES (TIMESTAMP '2019-11-18 22:13:40')").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        this.assertFails("INSERT INTO t8 (unbounded_varchar_column) VALUES (1)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        this.assertFails("INSERT INTO t8 (nested_bounded_varchar_column) VALUES (ROW(ROW(CAST('aa' AS varchar(10)))))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
    }

    @Test
    public void testInvalidInsert() {
        this.assertFails("INSERT INTO foo VALUES (1)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND});
        this.assertFails("INSERT INTO v1 VALUES (1)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED});
        this.assertFails("INSERT INTO t1 (a) VALUES (1), (1, 2)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        this.assertFails("INSERT INTO t1 (a, b) VALUES (1), (1, 2)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        this.assertFails("INSERT INTO t1 (a, b) VALUES (1, 2), (1, 2), (1, 2, 3)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        this.assertFails("INSERT INTO t1 (a, b) VALUES ('a', 'b'), ('a', 'b', 'c')").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        this.assertFails("INSERT INTO t1 (a, b) VALUES ('a', 'b'), (1, 'b')").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        this.assertFails("INSERT INTO t1 (a, b) VALUES ('a', 'b'), ('a', 'b'), (1, 'b')").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
    }

    @Test
    public void testDuplicateWithQuery() {
        this.assertFails("WITH a AS (SELECT * FROM t1),     a AS (SELECT * FROM t1)SELECT * FROM a").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_NAMED_QUERY});
        this.assertFails("WITH RECURSIVE a(w, x, y, z) AS (SELECT * FROM t1),     a(a, b, c, d) AS (SELECT * FROM t1)SELECT * FROM a").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_NAMED_QUERY});
    }

    @Test
    public void testCaseInsensitiveDuplicateWithQuery() {
        this.assertFails("WITH a AS (SELECT * FROM t1),     A AS (SELECT * FROM t1)SELECT * FROM a").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_NAMED_QUERY});
        this.assertFails("WITH RECURSIVE a(w, x, y, z) AS (SELECT * FROM t1),     A(a, b, c, d) AS (SELECT * FROM t1)SELECT * FROM a").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_NAMED_QUERY});
    }

    @Test
    public void testWithForwardReference() {
        this.assertFails("WITH a AS (SELECT * FROM b),     b AS (SELECT * FROM t1)SELECT * FROM a").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND});
    }

    @Test
    public void testMultipleWithListEntries() {
        this.analyze("WITH a(x) AS (SELECT 1),   b(y) AS (SELECT x + 1 FROM a),   c(z) AS (SELECT y * 10 FROM b)SELECT * FROM a, b, c");
        this.analyze("WITH\n    a(x) AS (SELECT ARRAY[1, 2, 3]),\n    b AS (SELECT * FROM (VALUES 4), UNNEST ((SELECT x FROM a)))\nSELECT * FROM b\n");
        this.analyze("WITH RECURSIVE a(x) AS (SELECT 1),   b(y) AS (       SELECT x FROM a       UNION ALL       SELECT y + 1 FROM b WHERE y < 3),   c(z) AS (       SELECT y FROM b       UNION ALL       SELECT z - 1 FROM c WHERE z > 0)SELECT * FROM a, b, c");
    }

    @Test
    public void testWithQueryInvalidAliases() {
        this.assertFails("WITH a(x) AS (SELECT * FROM t1)SELECT * FROM a").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISMATCHED_COLUMN_ALIASES});
        this.assertFails("WITH a(x, y, z, x) AS (SELECT * FROM t1)SELECT * FROM a").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_COLUMN_NAME});
        this.assertFails("WITH RECURSIVE a(x) AS (SELECT * FROM t1)SELECT * FROM a").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISMATCHED_COLUMN_ALIASES});
        this.assertFails("WITH RECURSIVE a(x, y, z, x) AS (SELECT * FROM t1)SELECT * FROM a").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_COLUMN_NAME});
        this.assertFails("WITH RECURSIVE a AS (SELECT * FROM t1)SELECT * FROM a").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISSING_COLUMN_ALIASES});
        this.assertFails("WITH RECURSIVE t(n, m) AS (          SELECT 1          UNION ALL          SELECT n + 2 FROM t WHERE n < 6          )          SELECT * from t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISMATCHED_COLUMN_ALIASES});
        this.assertFails("WITH RECURSIVE t(n, n) AS (          SELECT 1, 2          UNION ALL          SELECT n + 2, m - 2 FROM t WHERE n < 6          )          SELECT * from t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_COLUMN_NAME});
        this.assertFails("WITH RECURSIVE t AS (          SELECT 1, 2          UNION ALL          SELECT n + 2, m - 2 FROM t WHERE n < 6          )          SELECT * from t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISSING_COLUMN_ALIASES});
    }

    @Test
    public void testRecursiveBaseRelationAliasing() {
        this.analyze("WITH RECURSIVE t(n, m) AS (          SELECT * FROM (VALUES(1, 2), (4, 100))          UNION ALL          SELECT n + 1, m - 1 FROM t WHERE n < 5          )          SELECT * from t");
        this.analyze("WITH RECURSIVE t(n, m) AS (          SELECT * FROM (VALUES(1, 2), (4, 100)) AS t(n, m)          UNION ALL          SELECT n + 1, m - 1 FROM t WHERE n < 5          )          SELECT * from t");
        this.analyze("WITH RECURSIVE t(n, m) AS (          SELECT * FROM (VALUES(1, 2), (4, 100)) AS t1(x1, y1)          UNION ALL          SELECT n + 1, m - 1 FROM t WHERE n < 5          )          SELECT * from t");
        this.analyze("WITH RECURSIVE t(n, m) AS (          SELECT * FROM (VALUES(1, 2), (4, 100)) AS t(m, n)          UNION ALL          SELECT n + 1, m - 1 FROM t WHERE n < 5          )          SELECT * from t");
    }

    @Test
    public void testColumnNumberMismatch() {
        this.assertFails("WITH RECURSIVE t(n) AS (          SELECT 1          UNION ALL          SELECT n + 2, n + 10 FROM t WHERE n < 6          )          SELECT * from t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
        this.assertFails("WITH RECURSIVE t(n, m) AS (          SELECT 1, 2          UNION ALL          SELECT n + 2 FROM t WHERE n < 6          )          SELECT * from t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH});
    }

    @Test
    public void testNestedWith() {
        this.assertFails("WITH RECURSIVE t(n) AS (          SELECT * FROM (WITH RECURSIVE t2(m) AS (SELECT 1) SELECT m FROM t2)          )          SELECT * from t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_RECURSIVE});
        this.analyze("WITH t(n) AS (          SELECT * FROM (WITH RECURSIVE t2(m) AS (SELECT 1) SELECT m FROM t2)          )          SELECT * from t");
        this.analyze("WITH RECURSIVE t(n) AS (          SELECT * FROM (WITH t2(m) AS (SELECT 1) SELECT m FROM t2)          )          SELECT * from t");
        this.assertFails("WITH RECURSIVE t(n) AS (          SELECT 1          UNION ALL          SELECT * FROM (WITH RECURSIVE t2(m) AS (SELECT 4) SELECT m FROM t2 UNION SELECT n + 1 FROM t) t(n) WHERE n < 4          )          SELECT * from t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_RECURSIVE});
        this.analyze("WITH RECURSIVE t(n) AS (          SELECT 1          UNION ALL          SELECT * FROM (WITH t2(m) AS (SELECT 4) SELECT m FROM t2 UNION SELECT n + 1 FROM t) t(n) WHERE n < 4          )          SELECT * from t");
    }

    @Test
    public void testParenthesedRecursionStep() {
        this.analyze("WITH RECURSIVE t(n) AS (          SELECT 1          UNION ALL          (((SELECT n + 2 FROM t WHERE n < 6)))          )          SELECT * from t");
        this.assertFails("WITH RECURSIVE t(n) AS (          SELECT 1          UNION ALL          (((TABLE t)))          )          SELECT * from t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_RECURSIVE_REFERENCE});
        this.assertFails("WITH RECURSIVE t(n) AS (          SELECT 1          UNION ALL          (((SELECT n + 2 FROM t WHERE n < 6) LIMIT 1))          )          SELECT * from t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LIMIT_CLAUSE});
    }

    @Test
    public void testInvalidRecursiveReference() {
        this.assertFails("WITH RECURSIVE t(n) AS (          SELECT 1 FROM T          UNION ALL          SELECT n + 2 FROM t WHERE n < 6          )          SELECT * from t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_RECURSIVE_REFERENCE});
        this.assertFails("WITH RECURSIVE t(n) AS (          SELECT 1          UNION ALL          SELECT a.n + 2 FROM t AS a, t AS b WHERE n < 6          )          SELECT * from t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_RECURSIVE_REFERENCE});
        this.assertFails("WITH RECURSIVE t(n) AS (          SELECT 1          UNION ALL          TABLE T          )          SELECT * from t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_RECURSIVE_REFERENCE});
        this.assertFails("WITH RECURSIVE t(n) AS (          SELECT 1          UNION ALL          SELECT 2 WHERE (SELECT true FROM t)          )          SELECT * from t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_RECURSIVE_REFERENCE});
        this.assertFails("WITH RECURSIVE t(n) AS (          SELECT 1          UNION ALL          SELECT m FROM (VALUES 2) t2(m) WHERE (SELECT true FROM t)          )          SELECT * from t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_RECURSIVE_REFERENCE});
        this.assertFails("WITH RECURSIVE t(n) AS (          SELECT 1          INTERSECT          SELECT n + 2 FROM t WHERE n < 6          )          SELECT * from t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_RECURSIVE_REFERENCE});
    }

    @Test
    public void testWithRecursiveUnsupportedClauses() {
        this.assertFails("WITH RECURSIVE t(n) AS (          WITH t2(m) AS (SELECT 1)          SELECT 1          UNION ALL          SELECT n + 2 FROM t WHERE n < 6          )          SELECT * from t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED});
        this.assertFails("WITH RECURSIVE t(n) AS (          SELECT 1          UNION ALL          SELECT n + 2 FROM t WHERE n < 6          ORDER BY 1          )          SELECT * from t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED});
        this.assertFails("WITH RECURSIVE t(n) AS (          SELECT 1          UNION ALL          SELECT n + 2 FROM t WHERE n < 6          OFFSET 1          )          SELECT * from t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED});
        this.assertFails("WITH RECURSIVE t(n) AS (          SELECT 1          UNION ALL          SELECT n + 2 FROM t WHERE n < 6          LIMIT 1          )          SELECT * from t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LIMIT_CLAUSE});
        this.assertFails("WITH RECURSIVE t(n) AS (          SELECT 1          UNION ALL          SELECT n + 2 FROM t WHERE n < 6          FETCH FIRST 1 ROW ONLY          )          SELECT * from t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LIMIT_CLAUSE});
    }

    @Test
    public void testIllegalClausesInRecursiveTerm() {
        this.assertFails("WITH RECURSIVE t(n) AS (          SELECT 1          UNION ALL          SELECT n + 2 FROM (SELECT 10) u LEFT JOIN t ON true WHERE n < 6          )          SELECT * FROM t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_RECURSIVE_REFERENCE}).hasMessage("line 1:114: recursive reference in right source of LEFT join");
        this.assertFails("WITH RECURSIVE t(n) AS (          SELECT 1          UNION ALL          SELECT n + 2 FROM t RIGHT JOIN (SELECT 10) u ON true WHERE n < 6          )          SELECT * FROM t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_RECURSIVE_REFERENCE}).hasMessage("line 1:90: recursive reference in left source of RIGHT join");
        this.assertFails("WITH RECURSIVE t(n) AS (          SELECT 1          UNION ALL          SELECT n + 2 FROM t FULL JOIN (SELECT 10) u ON true WHERE n < 6          )          SELECT * FROM t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_RECURSIVE_REFERENCE}).hasMessage("line 1:90: recursive reference in left source of FULL join");
        this.assertFails("WITH RECURSIVE t(n) AS (          SELECT 1          UNION ALL          (SELECT n + 2 FROM ((SELECT 10) INTERSECT ALL (TABLE t)) u(n))          )          SELECT * FROM t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_RECURSIVE_REFERENCE}).hasMessage("line 1:119: recursive reference in INTERSECT ALL");
        this.assertFails("WITH RECURSIVE t(n) AS (          SELECT 1          UNION ALL          (SELECT n + 2 FROM ((TABLE t) INTERSECT ALL (SELECT 10)) u(n))          )          SELECT * FROM t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_RECURSIVE_REFERENCE}).hasMessage("line 1:93: recursive reference in INTERSECT ALL");
        this.assertFails("WITH RECURSIVE t(n) AS (          SELECT 1          UNION ALL          (SELECT n + 2 FROM ((SELECT 10) EXCEPT (TABLE t)) u(n))          )          SELECT * FROM t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_RECURSIVE_REFERENCE}).hasMessage("line 1:112: recursive reference in right relation of EXCEPT DISTINCT");
        this.assertFails("WITH RECURSIVE t(n) AS (          SELECT 1          UNION ALL          (SELECT n + 2 FROM ((SELECT 10) EXCEPT ALL (TABLE t)) u(n))          )          SELECT * FROM t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_RECURSIVE_REFERENCE}).hasMessage("line 1:116: recursive reference in right relation of EXCEPT ALL");
        this.assertFails("WITH RECURSIVE t(n) AS (          SELECT 1          UNION ALL          (SELECT n + 2 FROM ((TABLE t) EXCEPT ALL (SELECT 10)) u(n))          )          SELECT * FROM t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_RECURSIVE_REFERENCE}).hasMessage("line 1:93: recursive reference in left relation of EXCEPT ALL");
    }

    @Test
    public void testRecursiveReferenceShadowing() {
        this.assertFails("WITH RECURSIVE t(n) AS (          SELECT 1          UNION ALL          SELECT * FROM (WITH t(m) AS (SELECT 4) SELECT n + 1 FROM t)          )          SELECT * from t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND});
        this.analyze("WITH RECURSIVE t(n) AS (          SELECT 1          UNION ALL          SELECT * FROM (WITH t(n) AS (SELECT 4) SELECT n + 1 FROM t)          )          SELECT * from t");
        this.analyze("WITH RECURSIVE t(n) AS (          SELECT 1          UNION ALL          SELECT * FROM (WITH t2(m) AS (SELECT 4) SELECT m FROM t2 UNION SELECT n + 1 FROM t) t(n) WHERE n < 4          )          SELECT * from t");
        this.assertFails("WITH RECURSIVE t(n) AS (          SELECT 1          UNION ALL          SELECT * FROM (WITH t2(m) AS (TABLE t), t(p) AS (SELECT 1) SELECT m + 1 FROM t2) t(n) WHERE n < 4          )          SELECT * from t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND});
    }

    @Test
    public void testWithRecursiveUncoercibleTypes() {
        this.assertFails("WITH RECURSIVE t(n) AS (          SELECT 1          UNION ALL          SELECT BIGINT '9' FROM t WHERE n < 7          )          SELECT * from t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:72: recursion step relation output type (bigint) is not coercible to recursion base relation output type (integer) at column 1");
        this.assertFails("WITH RECURSIVE t(n, m, p) AS (          SELECT * FROM (VALUES(1, 2, 3))          UNION ALL          SELECT n + 1, BIGINT '9', BIGINT '9' FROM t WHERE n < 7          )          SELECT * from t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:101: recursion step relation output type (bigint) is not coercible to recursion base relation output type (integer) at column 2");
        this.assertFails("WITH RECURSIVE t(n) AS (          SELECT DECIMAL '1'          UNION ALL          SELECT n * 0.9 FROM t WHERE n > 0.7          )          SELECT * from t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:82: recursion step relation output type (decimal(2,1)) is not coercible to recursion base relation output type (decimal(1,0)) at column 1");
        this.assertFails("WITH RECURSIVE t(n) AS (          SELECT * FROM (VALUES('a'), ('b')) AS t(n)          UNION ALL          SELECT n || 'x' FROM t WHERE n < 'axxxx'          )          SELECT * from t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:106: recursion step relation output type (varchar) is not coercible to recursion base relation output type (varchar(1)) at column 1");
        this.assertFails("WITH RECURSIVE t(n, m, o) AS (          SELECT * FROM (VALUES(1, 2, ROW('a', 4)), (5, 6, ROW('a', 8)))          UNION ALL          SELECT t.o.*, ROW('a', 10) FROM t WHERE m < 3          )          SELECT * from t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:132: recursion step relation output type (varchar(1)) is not coercible to recursion base relation output type (integer) at column 1");
    }

    @Test
    public void testExpressions() {
        this.assertFails("SELECT NOT 1 FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:12: Value of logical NOT expression must evaluate to a boolean (actual: integer)");
        this.assertFails("SELECT 1 AND TRUE FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:8: Logical expression term must evaluate to a boolean (actual: integer)");
        this.assertFails("SELECT TRUE AND 1 FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:17: Logical expression term must evaluate to a boolean (actual: integer)");
        this.assertFails("SELECT 1 OR TRUE FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:8: Logical expression term must evaluate to a boolean (actual: integer)");
        this.assertFails("SELECT TRUE OR 1 FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:16: Logical expression term must evaluate to a boolean (actual: integer)");
        this.assertFails("SELECT 1 = 'a' FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:10: Cannot apply operator: integer = varchar(1)");
        this.assertFails("SELECT NULLIF(1, 'a') FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:8: Types are not comparable with NULLIF: integer vs varchar(1)");
        this.assertFails("SELECT CASE WHEN TRUE THEN 'a' ELSE 1 END FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:37: All CASE results must be the same type or coercible to a common type. Cannot find common type between varchar(1) and integer, all types (without duplicates): [varchar(1), integer]");
        this.assertFails("SELECT CASE WHEN '1' THEN 1 ELSE 2 END FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:18: CASE WHEN clause must evaluate to a boolean (actual: varchar(1))");
        this.assertFails("SELECT CASE 1 WHEN 'a' THEN 2 END FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:20: CASE operand type does not match WHEN clause operand type: integer vs varchar(1)");
        this.assertFails("SELECT CASE 1 WHEN 1 THEN 2 ELSE 'a' END FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:34: All CASE results must be the same type or coercible to a common type. Cannot find common type between integer and varchar(1), all types (without duplicates): [integer, varchar(1)]");
        this.assertFails("SELECT COALESCE(1, 'a') FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:20: All COALESCE operands must be the same type or coercible to a common type. Cannot find common type between integer and varchar(1), all types (without duplicates): [integer, varchar(1)]");
        this.assertFails("SELECT CAST(date '2014-01-01' AS bigint)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:8: Cannot cast date to bigint");
        this.assertFails("SELECT TRY_CAST(date '2014-01-01' AS bigint)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:8: Cannot cast date to bigint");
        this.assertFails("SELECT CAST(null AS UNKNOWN)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:8: UNKNOWN is not a valid type");
        this.assertFails("SELECT CAST(1 AS MAP)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:8: Unknown type: MAP");
        this.assertFails("SELECT CAST(1 AS ARRAY)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:8: Unknown type: ARRAY");
        this.assertFails("SELECT CAST(1 AS ROW)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:8: Unknown type: ROW");
        this.assertFails("SELECT -'a' FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:8: Cannot negate varchar(1)");
        this.assertFails("SELECT +'a' FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:8: Unary '+' operator cannot by applied to varchar(1) type");
        this.assertFails("SELECT 'a' + 1 FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:12: Cannot apply operator: varchar(1) + integer");
        this.assertFails("SELECT 1 + 'a'  FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:10: Cannot apply operator: integer + varchar(1)");
        this.assertFails("SELECT 'a' - 1 FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:12: Cannot apply operator: varchar(1) - integer");
        this.assertFails("SELECT 1 - 'a' FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:10: Cannot apply operator: integer - varchar(1)");
        this.assertFails("SELECT 1 LIKE 'a' FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:8: Left side of LIKE expression must evaluate to a varchar (actual: integer)");
        this.assertFails("SELECT 'a' LIKE 1 FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:17: Pattern for LIKE expression must evaluate to a varchar (actual: integer)");
        this.assertFails("SELECT 'a' LIKE 'b' ESCAPE 1 FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:28: Escape for LIKE expression must evaluate to a varchar (actual: integer)");
        this.assertFails("SELECT 'abc' LIKE CHAR 'abc' FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:19: Pattern for LIKE expression must evaluate to a varchar (actual: char(3))");
        this.assertFails("SELECT 'abc' LIKE 'abc' ESCAPE CHAR '#' FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:32: Escape for LIKE expression must evaluate to a varchar (actual: char(1))");
        this.assertFails("SELECT EXTRACt(DAY FROM 'a') FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:25: Cannot extract DAY from varchar(1)");
        this.assertFails("SELECT 1 BETWEEN 'a' AND 2 FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:10: Cannot check if integer is BETWEEN varchar(1) and integer");
        this.assertFails("SELECT 1 BETWEEN 0 AND 'b' FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:10: Cannot check if integer is BETWEEN integer and varchar(1)");
        this.assertFails("SELECT 1 BETWEEN 'a' AND 'b' FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:10: Cannot check if integer is BETWEEN varchar(1) and varchar(1)");
        this.assertFails("SELECT * FROM t1 WHERE 1 IN ('a')").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:30: IN value and list items must be the same type or coercible to a common type. Cannot find common type between integer and varchar(1), all types (without duplicates): [integer, varchar(1)]");
        this.assertFails("SELECT * FROM t1 WHERE 'a' IN (1)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:32: IN value and list items must be the same type or coercible to a common type. Cannot find common type between varchar(1) and integer, all types (without duplicates): [varchar(1), integer]");
        this.assertFails("SELECT * FROM t1 WHERE 'a' IN (1, 'b')").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:32: IN value and list items must be the same type or coercible to a common type. Cannot find common type between varchar(1) and integer, all types (without duplicates): [varchar(1), integer]");
        this.assertFails("SELECT t.x.f1 FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:8: Expression t.x is not of type ROW");
        this.assertFails("SELECT x.f1 FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:8: Expression x is not of type ROW");
        this.assertFails("SELECT ROW(1, 'a')[x]").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_CONSTANT}).hasMessageMatching("line 1:20: Subscript expression on ROW requires a constant index");
        this.assertFails("SELECT ROW(1, 'a')[9999999999]").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessageMatching("line 1:20: Subscript expression on ROW requires integer index, found bigint");
        this.assertFails("SELECT ROW(1, 'a')[-1]").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessageMatching("line 1:20: Invalid subscript index: -1. ROW indices start at 1");
        this.assertFails("SELECT ROW(1, 'a')[0]").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessageMatching("line 1:20: Invalid subscript index: 0. ROW indices start at 1");
        this.assertFails("SELECT ROW(1, 'a')[5]").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessageMatching("line 1:20: Subscript index out of bounds: 5, max value is 2");
    }

    @Test
    public void testLike() {
        this.analyze("SELECT '1' LIKE '1'");
        this.analyze("SELECT CAST('1' as CHAR(1)) LIKE '1'");
    }

    @Test
    @Disabled
    public void testInWithNumericTypes() {
        this.analyze("SELECT * FROM t1 WHERE 1 IN (1, 2, 3.5)");
    }

    @Test
    public void testWildcardWithoutFrom() {
        this.assertFails("SELECT *").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessage("line 1:8: SELECT * not allowed in queries without FROM clause");
    }

    @Test
    public void testReferenceWithoutFrom() {
        this.assertFails("SELECT dummy").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessage("line 1:8: Column 'dummy' cannot be resolved");
    }

    @Test
    public void testGroupBy() {
        this.analyze("SELECT a, SUM(b) FROM t1 GROUP BY a");
    }

    @Test
    public void testGroupByEmpty() {
        this.assertFails("SELECT a FROM t1 GROUP BY ()").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessage("line 1:8: 'a' must be an aggregate expression or appear in GROUP BY clause");
    }

    @Test
    public void testComplexExpressionInGroupingSet() {
        this.assertFails("SELECT 1 FROM (VALUES 1) t(x) GROUP BY ROLLUP(x + 1)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_COLUMN_REFERENCE}).hasMessageMatching("\\Qline 1:49: GROUP BY expression must be a column reference: (x + 1)\\E");
        this.assertFails("SELECT 1 FROM (VALUES 1) t(x) GROUP BY CUBE(x + 1)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_COLUMN_REFERENCE}).hasMessageMatching("\\Qline 1:47: GROUP BY expression must be a column reference: (x + 1)\\E");
        this.assertFails("SELECT 1 FROM (VALUES 1) t(x) GROUP BY GROUPING SETS (x + 1)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_COLUMN_REFERENCE}).hasMessageMatching("\\Qline 1:57: GROUP BY expression must be a column reference: (x + 1)\\E");
        this.assertFails("SELECT 1 FROM (VALUES 1) t(x) GROUP BY ROLLUP(x, x + 1)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_COLUMN_REFERENCE}).hasMessageMatching("\\Qline 1:52: GROUP BY expression must be a column reference: (x + 1)\\E");
        this.assertFails("SELECT 1 FROM (VALUES 1) t(x) GROUP BY CUBE(x, x + 1)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_COLUMN_REFERENCE}).hasMessageMatching("\\Qline 1:50: GROUP BY expression must be a column reference: (x + 1)\\E");
        this.assertFails("SELECT 1 FROM (VALUES 1) t(x) GROUP BY GROUPING SETS (x, x + 1)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_COLUMN_REFERENCE}).hasMessageMatching("\\Qline 1:60: GROUP BY expression must be a column reference: (x + 1)\\E");
    }

    @Test
    public void testSingleGroupingSet() {
        this.analyze("SELECT SUM(b) FROM t1 GROUP BY ()");
        this.analyze("SELECT SUM(b) FROM t1 GROUP BY GROUPING SETS (())");
        this.analyze("SELECT a, SUM(b) FROM t1 GROUP BY GROUPING SETS (a)");
        this.analyze("SELECT a, SUM(b) FROM t1 GROUP BY GROUPING SETS (a)");
        this.analyze("SELECT a, SUM(b) FROM t1 GROUP BY GROUPING SETS ((a, b))");
    }

    @Test
    public void testMultipleGroupingSetMultipleColumns() {
        this.analyze("SELECT a, SUM(b) FROM t1 GROUP BY GROUPING SETS ((a, b), (c, d))");
        this.analyze("SELECT a, SUM(b) FROM t1 GROUP BY a, b, GROUPING SETS ((c, d))");
        this.analyze("SELECT a, SUM(b) FROM t1 GROUP BY GROUPING SETS ((a), (c, d))");
        this.analyze("SELECT a, SUM(b) FROM t1 GROUP BY GROUPING SETS ((a, b)), ROLLUP (c, d)");
        this.analyze("SELECT a, SUM(b) FROM t1 GROUP BY GROUPING SETS ((a, b)), CUBE (c, d)");
    }

    @Test
    public void testAggregateWithWildcard() {
        this.assertFails("SELECT * FROM (SELECT a + 1, b FROM t1) t GROUP BY b ORDER BY 1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessageMatching("Column 1 not in GROUP BY clause");
        this.assertFails("SELECT * FROM (SELECT a, b FROM t1) t GROUP BY b ORDER BY 1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessageMatching("Column 't.a' not in GROUP BY clause");
        this.assertFails("SELECT * FROM (SELECT a, b FROM t1) GROUP BY b ORDER BY 1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessageMatching("Column 'a' not in GROUP BY clause");
        this.assertFails("SELECT * FROM (SELECT a + 1, b FROM t1) GROUP BY b ORDER BY 1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessageMatching("Column 1 not in GROUP BY clause");
    }

    @Test
    public void testGroupByCase() {
        this.assertFails("SELECT CASE a WHEN 1 THEN 'a' ELSE 'b' END, count(*) FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessage("line 1:8: '(CASE a WHEN 1 THEN 'a' ELSE 'b' END)' must be an aggregate expression or appear in GROUP BY clause");
        this.assertFails("SELECT CASE 1 WHEN 2 THEN a ELSE 0 END, count(*) FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessage("line 1:8: '(CASE 1 WHEN 2 THEN a ELSE 0 END)' must be an aggregate expression or appear in GROUP BY clause");
        this.assertFails("SELECT CASE 1 WHEN 2 THEN 0 ELSE a END, count(*) FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessage("line 1:8: '(CASE 1 WHEN 2 THEN 0 ELSE a END)' must be an aggregate expression or appear in GROUP BY clause");
        this.assertFails("SELECT CASE WHEN a = 1 THEN 'a' ELSE 'b' END, count(*) FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessage("line 1:8: '(CASE WHEN (a = 1) THEN 'a' ELSE 'b' END)' must be an aggregate expression or appear in GROUP BY clause");
        this.assertFails("SELECT CASE WHEN true THEN a ELSE 0 END, count(*) FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessage("line 1:8: '(CASE WHEN true THEN a ELSE 0 END)' must be an aggregate expression or appear in GROUP BY clause");
        this.assertFails("SELECT CASE WHEN true THEN 0 ELSE a END, count(*) FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessage("line 1:8: '(CASE WHEN true THEN 0 ELSE a END)' must be an aggregate expression or appear in GROUP BY clause");
    }

    @Test
    public void testGroupingWithWrongColumnsAndNoGroupBy() {
        this.assertFails("SELECT a, SUM(b), GROUPING(a, b, c, d) FROM t1 GROUP BY GROUPING SETS ((a, b), (c))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:19: The arguments to GROUPING() must be expressions referenced by the GROUP BY at the associated query level. Mismatch due to d.");
        this.assertFails("SELECT a, SUM(b), GROUPING(a, b) FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISSING_GROUP_BY}).hasMessage("line 1:1: A GROUPING() operation can only be used with a corresponding GROUPING SET/CUBE/ROLLUP/GROUP BY clause");
    }

    @Test
    public void testMismatchedUnionQueries() {
        this.assertFails("SELECT 1 UNION SELECT 'a'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:10: column 1 in UNION query has incompatible types: integer, varchar(1)");
        this.assertFails("SELECT a FROM t1 UNION SELECT 'a'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:18: column 1 in UNION query has incompatible types: bigint, varchar(1)");
        this.assertFails("(SELECT 1) UNION SELECT 'a'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:12: column 1 in UNION query has incompatible types: integer, varchar(1)");
        this.assertFails("SELECT 1, 2 UNION SELECT 1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:13: UNION query has different number of fields: 2, 1");
        this.assertFails("SELECT 'a' UNION SELECT 'b', 'c'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:12: UNION query has different number of fields: 1, 2");
        this.assertFails("TABLE t2 UNION SELECT 'a'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:10: UNION query has different number of fields: 2, 1");
        this.assertFails("SELECT 123, 'foo' UNION ALL SELECT 'bar', 999").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessageMatching(".* column 1 in UNION query has incompatible types.*");
        this.assertFails("SELECT 123, 123 UNION ALL SELECT 999, 'bar'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessageMatching(".* column 2 in UNION query has incompatible types.*");
    }

    @Test
    public void testUnionUnmatchedOrderByAttribute() {
        this.assertFails("TABLE t2 UNION ALL SELECT c, d FROM t1 ORDER BY c").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessage("line 1:49: Column 'c' cannot be resolved");
    }

    @Test
    public void testSetOperationNonComparableTypes() {
        this.assertFails("(VALUES approx_set(1)) INTERSECT DISTINCT (VALUES approx_set(2))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:24: Type HyperLogLog is not comparable and therefore cannot be used in INTERSECT");
        this.assertFails("(VALUES approx_set(1)) INTERSECT ALL (VALUES approx_set(2))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:24: Type HyperLogLog is not comparable and therefore cannot be used in INTERSECT");
        this.assertFails("(VALUES approx_set(1)) EXCEPT DISTINCT (VALUES approx_set(2))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:24: Type HyperLogLog is not comparable and therefore cannot be used in EXCEPT");
        this.assertFails("(VALUES approx_set(1)) EXCEPT ALL (VALUES approx_set(2))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:24: Type HyperLogLog is not comparable and therefore cannot be used in EXCEPT");
        this.assertFails("(VALUES approx_set(1)) UNION DISTINCT (VALUES approx_set(2))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:24: Type HyperLogLog is not comparable and therefore cannot be used in UNION DISTINCT");
        this.analyze("(VALUES approx_set(1)) UNION ALL (VALUES approx_set(2))");
    }

    @Test
    public void testSetOperation() {
        this.analyze("VALUES (1, 'a') UNION ALL VALUES (2, 'b')");
        this.analyze("VALUES (1, 'a') UNION DISTINCT VALUES (2, 'b')");
        this.analyze("VALUES (1, 'a') INTERSECT ALL VALUES (2, 'b')");
        this.analyze("VALUES (1, 'a') INTERSECT DISTINCT VALUES (2, 'b')");
        this.analyze("VALUES (1, 'a') EXCEPT ALL VALUES (2, 'b')");
        this.analyze("VALUES (1, 'a') EXCEPT DISTINCT VALUES (2, 'b')");
    }

    @Test
    public void testGroupByComplexExpressions() {
        this.assertFails("SELECT IF(a IS NULL, 1, 0) FROM t1 GROUP BY b").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessage("line 1:8: 'IF((a IS NULL), 1, 0)' must be an aggregate expression or appear in GROUP BY clause");
        this.assertFails("SELECT IF(a IS NOT NULL, 1, 0) FROM t1 GROUP BY b").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessage("line 1:8: 'IF((a IS NOT NULL), 1, 0)' must be an aggregate expression or appear in GROUP BY clause");
        this.assertFails("SELECT IF(CAST(a AS VARCHAR) LIKE 'a', 1, 0) FROM t1 GROUP BY b").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessage("line 1:8: 'IF((CAST(a AS VARCHAR) LIKE 'a'), 1, 0)' must be an aggregate expression or appear in GROUP BY clause");
        this.assertFails("SELECT a IN (1, 2, 3) FROM t1 GROUP BY b").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessage("line 1:10: '(a IN (1, 2, 3))' must be an aggregate expression or appear in GROUP BY clause");
        this.assertFails("SELECT 1 IN (a, 2, 3) FROM t1 GROUP BY b").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessage("line 1:10: '(1 IN (a, 2, 3))' must be an aggregate expression or appear in GROUP BY clause");
    }

    @Test
    public void testNonNumericTableSamplePercentage() {
        this.assertFails("SELECT * FROM t1 TABLESAMPLE BERNOULLI ('a')").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:41: Sample percentage should be a numeric expression");
        this.assertFails("SELECT * FROM t1 TABLESAMPLE BERNOULLI (a + 1)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_CONSTANT}).hasMessage("line 1:43: Sample percentage cannot contain column references");
    }

    @Test
    public void testTableSampleOutOfRange() {
        this.assertFails("SELECT * FROM t1 TABLESAMPLE BERNOULLI (-1)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("line 1:41: Sample percentage must be greater than or equal to 0");
        this.assertFails("SELECT * FROM t1 TABLESAMPLE BERNOULLI (-101)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("line 1:41: Sample percentage must be greater than or equal to 0");
    }

    @Test
    public void testCreateTableAsColumns() {
        this.analyze("CREATE TABLE test(a) AS SELECT 123");
        this.analyze("CREATE TABLE test(a, b) AS SELECT 1, 2");
        this.analyze("CREATE TABLE test(a) AS (VALUES 1)");
        this.assertFails("CREATE TABLE test AS SELECT 123").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISSING_COLUMN_NAME}).hasMessage("line 1:1: Column name not specified at position 1");
        this.assertFails("CREATE TABLE test AS SELECT 1 a, 2 a").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_COLUMN_NAME}).hasMessage("line 1:1: Column name 'a' specified more than once");
        this.assertFails("CREATE TABLE test AS SELECT null a").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_TYPE_UNKNOWN}).hasMessage("line 1:1: Column type is unknown: a");
        ((TrinoExceptionAssert)this.assertFails("CREATE TABLE test(x) AS SELECT 1, 2").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISMATCHED_COLUMN_ALIASES}).hasMessage("line 1:19: Column alias list has 1 entries but relation has 2 columns")).hasLocation(1, 19);
        ((TrinoExceptionAssert)this.assertFails("CREATE TABLE test(x, y) AS SELECT 1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISMATCHED_COLUMN_ALIASES}).hasMessage("line 1:19: Column alias list has 2 entries but relation has 1 columns")).hasLocation(1, 19);
        ((TrinoExceptionAssert)this.assertFails("CREATE TABLE test(x, y) AS (VALUES 1)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISMATCHED_COLUMN_ALIASES}).hasMessage("line 1:19: Column alias list has 2 entries but relation has 1 columns")).hasLocation(1, 19);
        ((TrinoExceptionAssert)this.assertFails("CREATE TABLE test(abc, AbC) AS SELECT 1, 2").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_COLUMN_NAME}).hasMessage("line 1:24: Column name 'AbC' specified more than once")).hasLocation(1, 24);
        ((TrinoExceptionAssert)this.assertFails("CREATE TABLE test(x) AS SELECT null").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_TYPE_UNKNOWN}).hasMessage("line 1:1: Column type is unknown at position 1")).hasLocation(1, 1);
        this.assertFails("CREATE TABLE test(x) WITH (p1 = y) AS SELECT null").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessageMatching(".*Column 'y' cannot be resolved");
        this.assertFails("CREATE TABLE test(x) WITH (p1 = 'p1', p2 = 'p2', p1 = 'p3') AS SELECT null").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_PROPERTY}).hasMessageMatching(".* Duplicate property: p1");
        this.assertFails("CREATE TABLE test(x) WITH (p1 = 'p1', \"p1\" = 'p2') AS SELECT null").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_PROPERTY}).hasMessageMatching(".* Duplicate property: p1");
    }

    @Test
    public void testCreateTable() {
        this.analyze("CREATE TABLE test (id bigint)");
        this.analyze("CREATE TABLE test (id bigint) WITH (p1 = 'p1')");
        this.assertFails("CREATE TABLE test (x bigint) WITH (p1 = y)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessageMatching(".*Column 'y' cannot be resolved");
        this.assertFails("CREATE TABLE test (id bigint) WITH (p1 = 'p1', p2 = 'p2', p1 = 'p3')").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_PROPERTY}).hasMessageMatching(".* Duplicate property: p1");
        this.assertFails("CREATE TABLE test (id bigint) WITH (p1 = 'p1', \"p1\" = 'p2')").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_PROPERTY}).hasMessageMatching(".* Duplicate property: p1");
    }

    @Test
    public void testAnalyze() {
        this.analyze("ANALYZE t1");
        this.analyze("ANALYZE t1 WITH (p1 = 'p1')");
        this.assertFails("ANALYZE t1 WITH (p1 = 'p1', p2 = 2, p1 = 'p3')").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_PROPERTY}).hasMessageMatching(".* Duplicate property: p1");
        this.assertFails("ANALYZE t1 WITH (p1 = 'p1', \"p1\" = 'p2')").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_PROPERTY}).hasMessageMatching(".* Duplicate property: p1");
    }

    @Test
    public void testCreateSchema() {
        this.analyze("CREATE SCHEMA test");
        this.analyze("CREATE SCHEMA test WITH (p1 = 'p1')");
        this.assertFails("CREATE SCHEMA test WITH (p1 = y)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessageMatching(".*Column 'y' cannot be resolved");
        this.assertFails("CREATE SCHEMA test WITH (p1 = 'p1', p2 = 'p2', p1 = 'p3')").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_PROPERTY}).hasMessageMatching(".* Duplicate property: p1");
        this.assertFails("CREATE SCHEMA test WITH (p1 = 'p1', \"p1\" = 'p2')").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_PROPERTY}).hasMessageMatching(".* Duplicate property: p1");
    }

    @Test
    public void testCreateViewColumns() {
        this.assertFails("CREATE VIEW test AS SELECT 123").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISSING_COLUMN_NAME}).hasMessage("line 1:1: Column name not specified at position 1");
        this.assertFails("CREATE VIEW test AS SELECT 1 a, 2 a").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_COLUMN_NAME}).hasMessage("line 1:1: Column name 'a' specified more than once");
        this.assertFails("CREATE VIEW test AS SELECT null a").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_TYPE_UNKNOWN}).hasMessage("line 1:1: Column type is unknown: a");
    }

    @Test
    public void testCreateRecursiveView() {
        this.assertFails("CREATE OR REPLACE VIEW v1 AS SELECT * FROM v1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.VIEW_IS_RECURSIVE}).hasMessage("line 1:44: Statement would create a recursive view");
        this.assertFails("CREATE OR REPLACE VIEW mv1 AS SELECT * FROM mv1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.VIEW_IS_RECURSIVE}).hasMessage("line 1:45: Statement would create a recursive view");
    }

    @Test
    public void testCreateMaterializedRecursiveView() {
        this.assertFails("CREATE OR REPLACE MATERIALIZED VIEW v1 AS SELECT * FROM v1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.VIEW_IS_RECURSIVE}).hasMessage("line 1:57: Statement would create a recursive materialized view");
        this.assertFails("CREATE OR REPLACE MATERIALIZED VIEW mv1 AS SELECT * FROM mv1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.VIEW_IS_RECURSIVE}).hasMessage("line 1:58: Statement would create a recursive materialized view");
    }

    @Test
    public void testExistingRecursiveView() {
        this.analyze("SELECT * FROM v1 a JOIN v1 b ON a.a = b.a");
        this.analyze("SELECT * FROM v1 a JOIN (SELECT * from v1) b ON a.a = b.a");
        this.assertFails("SELECT * FROM v5").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_VIEW}).hasMessage("line 1:15: Failed analyzing stored view 'tpch.s1.v5': line 1:15: View is recursive");
    }

    @Test
    public void testShowCreateView() {
        this.analyze("SHOW CREATE VIEW v1");
        this.analyze("SHOW CREATE VIEW v2");
        this.assertFails("SHOW CREATE VIEW t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Relation 'tpch.s1.t1' is a table, not a view");
        this.assertFails("SHOW CREATE VIEW none").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessage("line 1:1: View 'tpch.s1.none' does not exist");
    }

    @Test
    public void testShowCreateDuplicateNames() {
        this.analyze("SHOW CREATE MATERIALIZED VIEW table_view_and_materialized_view");
        this.assertFails("SHOW CREATE VIEW table_view_and_materialized_view").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessageContaining("Relation 'tpch.s1.table_view_and_materialized_view' is a materialized view, not a view");
        this.assertFails("SHOW CREATE TABLE table_view_and_materialized_view").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessageContaining("Relation 'tpch.s1.table_view_and_materialized_view' is a materialized view, not a table");
        this.analyze("SHOW CREATE VIEW table_and_view");
        this.assertFails("SHOW CREATE TABLE table_and_view").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessageContaining("Relation 'tpch.s1.table_and_view' is a view, not a table");
    }

    @Test
    public void testAnalysisDuplicateNames() {
        Analysis analysis = this.analyze("SELECT * FROM table_view_and_materialized_view");
        TableHandle handle = (TableHandle)Iterables.getOnlyElement((Iterable)analysis.getTables());
        Assertions.assertThat((String)((TestingMetadata.TestingTableHandle)handle.connectorHandle()).getTableName().getTableName()).isEqualTo("t1");
        analysis = this.analyze("SELECT * FROM table_and_view");
        handle = (TableHandle)Iterables.getOnlyElement((Iterable)analysis.getTables());
        Assertions.assertThat((String)((TestingMetadata.TestingTableHandle)handle.connectorHandle()).getTableName().getTableName()).isEqualTo("t2");
    }

    @Test
    public void testStaleView() {
        this.assertFails("SELECT * FROM v2").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.VIEW_IS_STALE}).hasMessage("line 1:15: View 'tpch.s1.v2' is stale or in invalid state: column [a] of type bigint projected from query view at position 0 cannot be coerced to column [a] of type varchar stored in view definition");
    }

    @Test
    public void testStoredViewAnalysisScoping() {
        this.analyze("WITH t1 AS (SELECT 123 x) SELECT * FROM v1");
    }

    @Test
    public void testStoredViewResolution() {
        this.analyze("SELECT * FROM c3.s3.v3");
    }

    @Test
    public void testQualifiedViewColumnResolution() {
        this.analyze("SELECT v1.a FROM v1");
        this.analyze("SELECT s1.v1.a FROM s1.v1");
        this.analyze("SELECT tpch.s1.v1.a FROM tpch.s1.v1");
    }

    @Test
    public void testViewWithUppercaseColumn() {
        this.analyze("SELECT * FROM v4");
    }

    @Test
    public void testUse() {
        this.assertFails("USE foo").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: USE statement is not supported");
    }

    @Test
    public void testNotNullInJoinClause() {
        this.analyze("SELECT * FROM (VALUES (1)) a (x) JOIN (VALUES (2)) b ON a.x IS NOT NULL");
    }

    @Test
    public void testIfInJoinClause() {
        this.analyze("SELECT * FROM (VALUES (1)) a (x) JOIN (VALUES (2)) b ON IF(a.x = 1, true, false)");
    }

    @Test
    public void testLiteral() {
        this.assertFails("SELECT BOOLEAN '2'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT BOOLEAN 'a'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT TINYINT ''").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT TINYINT '128'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT TINYINT '-129'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT TINYINT '12.1'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT TINYINT 'a'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT SMALLINT ''").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT SMALLINT '2147483648'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT SMALLINT '-2147483649'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT SMALLINT '12.1'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT SMALLINT 'a'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT INTEGER ''").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT INTEGER '2147483648'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT INTEGER '-2147483649'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT INTEGER '12.1'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT INTEGER 'a'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT BIGINT ''").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT BIGINT '9223372036854775808'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT BIGINT '-9223372036854775809'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT BIGINT '12.1'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT BIGINT 'a'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT REAL ''").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT REAL '1.2.3'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT REAL 'a'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT DOUBLE ''").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT DOUBLE '1.2.3'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT DOUBLE 'a'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT 1234567890123456789012.34567890123456789").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT 0.123456789012345678901234567890123456789").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT .123456789012345678901234567890123456789").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT DECIMAL ''").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT DECIMAL '123456789012345678901234567890123456789'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT DECIMAL '1234567890123456789012.34567890123456789'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT DECIMAL '0.123456789012345678901234567890123456789'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT DECIMAL '.123456789012345678901234567890123456789'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT DECIMAL 'a'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT DATE '20220101'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT DATE 'a'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT DATE 'today'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT DATE '2022-01-01 UTC'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT TIME ''").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT TIME '12'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT TIME '1234567'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT TIME 'a'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT TIMESTAMP ''").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT TIMESTAMP '2012-10-31 01:00:00 PT'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT TIMESTAMP 'a'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT TIMESTAMP 'now'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT INTERVAL 'a' DAY TO SECOND").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT INTERVAL '12.1' DAY TO SECOND").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT INTERVAL '12' YEAR TO DAY").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT INTERVAL '12' SECOND TO MINUTE").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT JSON ''").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT JSON '{}{'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT JSON '{} \"a\"'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT JSON '{}{'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT JSON '{} \"a\"'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT JSON '{}{abc'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT JSON '{}abc'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
        this.assertFails("SELECT JSON ''").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LITERAL});
    }

    @Test
    public void testLambda() {
        this.analyze("SELECT apply(5, x -> abs(x)) from t1");
        this.assertFails("SELECT x -> abs(x) from t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:8: Lambda expression should always be used inside a function");
    }

    @Test
    public void testLambdaCapture() {
        this.analyze("SELECT apply(c1, x -> x + c2) FROM (VALUES (1, 2), (3, 4), (5, 6)) t(c1, c2)");
        this.analyze("SELECT apply(c1 + 10, x -> apply(x + 100, y -> c1)) FROM (VALUES 1) t(c1)");
        this.analyze("SELECT apply(1, x -> apply(10, y -> x)) FROM (VALUES 1000) t(x)");
        this.analyze("SELECT apply(1, x -> apply(10, y -> x)) FROM (VALUES 'abc') t(x)");
        this.analyze("SELECT apply(1, x -> apply(10, y -> apply(100, z -> x))) FROM (VALUES 1000) t(x)");
        this.analyze("SELECT apply(1, x -> apply(10, y -> apply(100, z -> x))) FROM (VALUES 'abc') t(x)");
    }

    @Test
    public void testLambdaInAggregationContext() {
        this.analyze("SELECT apply(sum(x), i -> i * i) FROM (VALUES 1, 2, 3, 4, 5) t(x)");
        this.analyze("SELECT apply(x, i -> i - 1), sum(y) FROM (VALUES (1, 10), (1, 20), (2, 50)) t(x,y) group by x");
        this.analyze("SELECT x, apply(sum(y), i -> i * 10) FROM (VALUES (1, 10), (1, 20), (2, 50)) t(x,y) group by x");
        this.analyze("SELECT apply(8, x -> x + 1) FROM (VALUES (1, 2)) t(x,y) GROUP BY y");
        this.assertFails("SELECT apply(sum(x), i -> i * x) FROM (VALUES 1, 2, 3, 4, 5) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessageMatching(".* must be an aggregate expression or appear in GROUP BY clause");
        this.assertFails("SELECT apply(1, y -> x) FROM (VALUES (1,2)) t(x,y) GROUP BY y").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessageMatching(".* must be an aggregate expression or appear in GROUP BY clause");
        this.assertFails("SELECT apply(1, y -> x.someField) FROM (VALUES (CAST(ROW(1) AS ROW(someField BIGINT)), 2)) t(x,y) GROUP BY y").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessageMatching(".* must be an aggregate expression or appear in GROUP BY clause");
        this.analyze("SELECT apply(CAST(ROW(1) AS ROW(someField BIGINT)), x -> x.someField) FROM (VALUES (1,2)) t(x,y) GROUP BY y");
        this.analyze("SELECT apply(sum(x), x -> x * x) FROM (VALUES 1, 2, 3, 4, 5) t(x)");
        this.analyze("SELECT apply(sum(x), x -> apply(x, x -> x * x)) FROM (VALUES 1, 2, 3, 4, 5) t(x)");
        this.assertFails("SELECT apply(sum(x), x -> x * x) + x FROM (VALUES 1, 2, 3, 4, 5) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessageMatching(".* must be an aggregate expression or appear in GROUP BY clause");
        this.assertFails("SELECT apply(sum(x), x -> apply(x, x -> x * x)) + x FROM (VALUES 1, 2, 3, 4, 5) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessageMatching(".* must be an aggregate expression or appear in GROUP BY clause");
        this.assertFails("SELECT apply(1, y -> x + y) FROM (VALUES (1,2)) t(x, y) GROUP BY x+y").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessageMatching(".* must be an aggregate expression or appear in GROUP BY clause");
        this.assertFails("SELECT apply(1, x -> y + transform(array[1], z -> x)[1]) FROM (VALUES (1, 2)) t(x,y) GROUP BY y + transform(array[1], z -> x)[1]").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessageMatching(".* must be an aggregate expression or appear in GROUP BY clause");
    }

    @Test
    public void testLambdaInSubqueryContext() {
        this.analyze("SELECT apply(x, i -> i * i) FROM (SELECT 10 x)");
        this.analyze("SELECT apply((SELECT 10), i -> i * i)");
        this.analyze("SELECT apply(x, i -> i * x) FROM (SELECT 10 x)");
        this.analyze("SELECT apply(x, y -> y * x) FROM (SELECT 10 x, 3 y)");
        this.analyze("SELECT apply(x, z -> y * x) FROM (SELECT 10 x, 3 y)");
    }

    @Test
    public void testLambdaWithAggregationAndGrouping() {
        this.assertFails("SELECT transform(ARRAY[1], y -> max(x)) FROM (VALUES 10) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_SCALAR}).hasMessageMatching(".* Lambda expression cannot contain aggregations, window functions or grouping operations: .*");
        this.assertFails("SELECT apply(1, x -> max(x)) FROM (VALUES (1,2)) t(x,y) GROUP BY y").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_SCALAR}).hasMessageMatching(".* Lambda expression cannot contain aggregations, window functions or grouping operations: .*");
        this.assertFails("SELECT apply(CAST(ROW(1) AS ROW(someField BIGINT)), x -> max(x.someField)) FROM (VALUES (1,2)) t(x,y) GROUP BY y").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_SCALAR}).hasMessageMatching(".* Lambda expression cannot contain aggregations, window functions or grouping operations: .*");
        this.assertFails("SELECT apply(1, x -> grouping(x)) FROM (VALUES (1, 2)) t(x, y) GROUP BY y").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_SCALAR}).hasMessageMatching(".* Lambda expression cannot contain aggregations, window functions or grouping operations: .*");
    }

    @Test
    public void testLambdaWithSubquery() {
        this.assertFails("SELECT apply(1, i -> (SELECT 3)) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessageMatching(".* Lambda expression cannot contain subqueries");
        this.assertFails("SELECT apply(1, i -> (SELECT i)) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessageMatching(".* Lambda expression cannot contain subqueries");
        this.analyze("SELECT (SELECT apply(0, x -> x + b) FROM (VALUES 1) x(a)) FROM t1 u GROUP BY b");
        this.assertFails("SELECT (SELECT apply(0, x -> x + a) FROM (VALUES 1) x(c)) FROM t1 u GROUP BY b").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessageMatching("line 1:34: Subquery uses 'a' which must appear in GROUP BY clause");
        this.assertFails("SELECT (SELECT apply(0, x -> x + u.a) from (values 1) x(a)) FROM t1 u GROUP BY b").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessageMatching("line 1:34: Subquery uses 'u.a' which must appear in GROUP BY clause");
        this.analyze("SELECT (SELECT apply(0, x -> x + a) FROM (VALUES 1) x(a)) FROM t1 u GROUP BY b");
        this.analyze("SELECT (SELECT apply(0, a -> a + a)) FROM t1 u GROUP BY b");
    }

    @Test
    public void testLambdaWithSubqueryInOrderBy() {
        this.analyze("SELECT a FROM t1 ORDER BY (SELECT apply(0, x -> x + a))");
        this.analyze("SELECT a AS output_column FROM t1 ORDER BY (SELECT apply(0, x -> x + output_column))");
        this.analyze("SELECT count(*) FROM t1 GROUP BY a ORDER BY (SELECT apply(0, x -> x + a))");
        this.analyze("SELECT count(*) AS output_column FROM t1 GROUP BY a ORDER BY (SELECT apply(0, x -> x + output_column))");
        this.assertFails("SELECT count(*) FROM t1 GROUP BY a ORDER BY (SELECT apply(0, x -> x + b))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessageMatching("line 1:71: Subquery uses 'b' which must appear in GROUP BY clause");
    }

    @Test
    public void testLambdaWithInvalidParameterCount() {
        this.assertFails("SELECT apply(5, (x, y) -> 6)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARAMETER_USAGE}).hasMessageMatching("line 1:17: Expected a lambda that takes 1 argument\\(s\\) but got 2");
        this.assertFails("SELECT apply(5, (x, y, z) -> 6)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARAMETER_USAGE}).hasMessageMatching("line 1:17: Expected a lambda that takes 1 argument\\(s\\) but got 3");
        this.assertFails("SELECT TRY(apply(5, (x, y) -> x + 1) / 0)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARAMETER_USAGE}).hasMessageMatching("line 1:21: Expected a lambda that takes 1 argument\\(s\\) but got 2");
        this.assertFails("SELECT TRY(apply(5, (x, y, z) -> x + 1) / 0)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARAMETER_USAGE}).hasMessageMatching("line 1:21: Expected a lambda that takes 1 argument\\(s\\) but got 3");
        this.assertFails("SELECT filter(ARRAY [5, 6], (x, y) -> x = 5)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARAMETER_USAGE}).hasMessageMatching("line 1:29: Expected a lambda that takes 1 argument\\(s\\) but got 2");
        this.assertFails("SELECT filter(ARRAY [5, 6], (x, y, z) -> x = 5)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARAMETER_USAGE}).hasMessageMatching("line 1:29: Expected a lambda that takes 1 argument\\(s\\) but got 3");
        this.assertFails("SELECT map_filter(map(ARRAY [5, 6], ARRAY [5, 6]), (x) -> x = 1)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARAMETER_USAGE}).hasMessageMatching("line 1:52: Expected a lambda that takes 2 argument\\(s\\) but got 1");
        this.assertFails("SELECT map_filter(map(ARRAY [5, 6], ARRAY [5, 6]), (x, y, z) -> x = y + z)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARAMETER_USAGE}).hasMessageMatching("line 1:52: Expected a lambda that takes 2 argument\\(s\\) but got 3");
        this.assertFails("SELECT reduce(ARRAY [5, 20], 0, (s) -> s, s -> s)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARAMETER_USAGE}).hasMessageMatching("line 1:33: Expected a lambda that takes 2 argument\\(s\\) but got 1");
        this.assertFails("SELECT reduce(ARRAY [5, 20], 0, (s, x, z) -> s + x, s -> s + z)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARAMETER_USAGE}).hasMessageMatching("line 1:33: Expected a lambda that takes 2 argument\\(s\\) but got 3");
        this.assertFails("SELECT transform(ARRAY [5, 6], (x, y) -> x + y)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARAMETER_USAGE}).hasMessageMatching("line 1:32: Expected a lambda that takes 1 argument\\(s\\) but got 2");
        this.assertFails("SELECT transform(ARRAY [5, 6], (x, y, z) -> x + y + z)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARAMETER_USAGE}).hasMessageMatching("line 1:32: Expected a lambda that takes 1 argument\\(s\\) but got 3");
        this.assertFails("SELECT transform_keys(map(ARRAY[1], ARRAY [2]), k -> k)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARAMETER_USAGE}).hasMessageMatching("line 1:49: Expected a lambda that takes 2 argument\\(s\\) but got 1");
        this.assertFails("SELECT transform_keys(MAP(ARRAY['a'], ARRAY['b']), (k, v, x) -> k + 1)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARAMETER_USAGE}).hasMessageMatching("line 1:52: Expected a lambda that takes 2 argument\\(s\\) but got 3");
        this.assertFails("SELECT transform_values(map(ARRAY[1], ARRAY [2]), k -> k)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARAMETER_USAGE}).hasMessageMatching("line 1:51: Expected a lambda that takes 2 argument\\(s\\) but got 1");
        this.assertFails("SELECT transform_values(map(ARRAY[1], ARRAY [2]), (k, v, x) -> k + 1)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARAMETER_USAGE}).hasMessageMatching("line 1:51: Expected a lambda that takes 2 argument\\(s\\) but got 3");
        this.assertFails("SELECT zip_with(ARRAY[1], ARRAY['a'], x -> x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARAMETER_USAGE}).hasMessageMatching("line 1:39: Expected a lambda that takes 2 argument\\(s\\) but got 1");
        this.assertFails("SELECT zip_with(ARRAY[1], ARRAY['a'], (x, y, z) -> (x, y, z))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PARAMETER_USAGE}).hasMessageMatching("line 1:39: Expected a lambda that takes 2 argument\\(s\\) but got 3");
    }

    @Test
    public void testInvalidInlineFunction() {
        this.assertFails("WITH FUNCTION test.abc() RETURNS int RETURN 42 SELECT 123").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.SYNTAX_ERROR}).hasMessage("line 1:6: Inline function names cannot be qualified: test.abc");
        this.assertFails("WITH function abc() RETURNS int SECURITY DEFINER RETURN 42 SELECT 123").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:33: Security mode not supported for inline functions");
        this.assertFails("CREATE VIEW test AS\nWITH FUNCTION abc() RETURNS int RETURN 42\nSELECT 123 x\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 2:6: Views cannot contain inline functions");
    }

    @Test
    public void testInvalidDelete() {
        this.assertFails("DELETE FROM foo").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessage("line 1:1: Table 'tpch.s1.foo' does not exist");
        this.assertFails("DELETE FROM v1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Deleting from views is not supported");
        this.assertFails("DELETE FROM v1 WHERE a = 1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Deleting from views is not supported");
        this.assertFails("DELETE FROM mv1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Deleting from materialized views is not supported");
    }

    @Test
    public void testInvalidUpdate() {
        this.assertFails("UPDATE foo SET bar = 'test'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessage("line 1:1: Table 'tpch.s1.foo' does not exist");
        this.assertFails("UPDATE v1 SET a = 2").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Updating views is not supported");
        this.assertFails("UPDATE mv1 SET a = 1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Updating materialized views is not supported");
    }

    @Test
    public void testInvalidMerge() {
        this.assertFails("MERGE INTO foo USING bar ON foo.id = bar.id WHEN MATCHED THEN DELETE").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessage("line 1:1: Table 'tpch.s1.foo' does not exist");
        this.assertFails("MERGE INTO v1 USING t1 ON v1.a = t1.a WHEN MATCHED THEN DELETE").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Merging into views is not supported");
        this.assertFails("MERGE INTO mv1 USING t1 ON mv1.a = t1.a WHEN MATCHED THEN DELETE").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Merging into materialized views is not supported");
    }

    @Test
    public void testInvalidShowTables() {
        this.assertFails("SHOW TABLES FROM a.b.c").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.SYNTAX_ERROR}).hasMessage("line 1:1: Too many parts in schema name: a.b.c");
        Session session = TestingSession.testSessionBuilder().setCatalog(Optional.empty()).setSchema(Optional.empty()).build();
        this.assertFails(session, "SHOW TABLES").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISSING_CATALOG_NAME}).hasMessage("line 1:1: Catalog must be specified when session catalog is not set");
        this.assertFails(session, "SHOW TABLES FROM a").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISSING_CATALOG_NAME}).hasMessage("line 1:1: Catalog must be specified when session catalog is not set");
        this.assertFails(session, "SHOW TABLES FROM c2.unknown").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.SCHEMA_NOT_FOUND}).hasMessage("line 1:1: Schema 'unknown' does not exist");
        session = TestingSession.testSessionBuilder().setCatalog(SECOND_CATALOG).setSchema(Optional.empty()).build();
        this.assertFails(session, "SHOW TABLES").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISSING_SCHEMA_NAME}).hasMessage("line 1:1: Schema must be specified when session schema is not set");
        this.assertFails(session, "SHOW TABLES FROM unknown").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.SCHEMA_NOT_FOUND}).hasMessage("line 1:1: Schema 'unknown' does not exist");
    }

    @Test
    public void testInvalidAtTimeZone() {
        this.assertFails("SELECT 'abc' AT TIME ZONE 'America/Los_Angeles'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:8: Type of value must be a time or timestamp with or without time zone (actual varchar(3))");
    }

    @Test
    public void testValidJoinOnClause() {
        this.analyze("SELECT * FROM (VALUES (2, 2)) a(x,y) JOIN (VALUES (2, 2)) b(x,y) ON TRUE");
        this.analyze("SELECT * FROM (VALUES (2, 2)) a(x,y) JOIN (VALUES (2, 2)) b(x,y) ON 1=1");
        this.analyze("SELECT * FROM (VALUES (2, 2)) a(x,y) JOIN (VALUES (2, 2)) b(x,y) ON a.x=b.x AND a.y=b.y");
        this.analyze("SELECT * FROM (VALUES (2, 2)) a(x,y) JOIN (VALUES (2, 2)) b(x,y) ON NULL");
    }

    @Test
    public void testInValidJoinOnClause() {
        this.assertFails("SELECT * FROM (VALUES (2, 2)) a(x,y) JOIN (VALUES (2, 2)) b(x,y) ON 1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:69: JOIN ON clause must evaluate to a boolean: actual type integer");
        this.assertFails("SELECT * FROM (VALUES (2, 2)) a(x,y) JOIN (VALUES (2, 2)) b(x,y) ON a.x + b.x").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:73: JOIN ON clause must evaluate to a boolean: actual type integer");
        this.assertFails("SELECT * FROM (VALUES (2, 2)) a(x,y) JOIN (VALUES (2, 2)) b(x,y) ON ROW (TRUE)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:69: JOIN ON clause must evaluate to a boolean: actual type row(boolean)");
        this.assertFails("SELECT * FROM (VALUES (2, 2)) a(x,y) JOIN (VALUES (2, 2)) b(x,y) ON (a.x=b.x, a.y=b.y)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:69: JOIN ON clause must evaluate to a boolean: actual type row(boolean, boolean)");
    }

    @Test
    public void testNullAggregationFilter() {
        this.analyze("SELECT count(*) FILTER (WHERE NULL) FROM t1");
        this.analyze("SELECT a, count(*) FILTER (WHERE NULL) FROM t1 GROUP BY a");
    }

    @Test
    public void testInvalidAggregationFilter() {
        this.assertFails("SELECT sum(x) FILTER (WHERE x > 1) OVER (PARTITION BY x) FROM (VALUES (1), (2), (2), (4)) t (x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: FILTER is not yet supported for window functions");
        this.assertFails("SELECT abs(x) FILTER (where y = 1) FROM (VALUES (1, 1)) t(x, y)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_NOT_AGGREGATE}).hasMessage("line 1:8: Filter is only valid for aggregation functions");
        this.assertFails("SELECT abs(x) FILTER (where y = 1) FROM (VALUES (1, 1, 1)) t(x, y, z) GROUP BY z").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_NOT_AGGREGATE}).hasMessage("line 1:8: Filter is only valid for aggregation functions");
        this.assertFails("SELECT count(*) FILTER (WHERE 0) FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:31: Filter expression must evaluate to a boolean (actual: integer)");
        this.assertFails("SELECT a, count(*) FILTER (WHERE 0) FROM t1 GROUP BY a").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:34: Filter expression must evaluate to a boolean (actual: integer)");
    }

    @Test
    public void testAggregationWithOrderBy() {
        this.analyze("SELECT array_agg(DISTINCT x ORDER BY x) FROM (VALUES (1, 2), (3, 4)) t(x, y)");
        this.analyze("SELECT array_agg(x ORDER BY y) FROM (VALUES (1, 2), (3, 4)) t(x, y)");
        this.assertFails("SELECT array_agg(DISTINCT x ORDER BY y) FROM (VALUES (1, 2), (3, 4)) t(x, y)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_IN_DISTINCT}).hasMessage("line 1:38: For aggregate function with DISTINCT, ORDER BY expressions must appear in arguments");
        this.assertFails("SELECT abs(x ORDER BY y) FROM (VALUES (1, 2), (3, 4)) t(x, y)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_NOT_AGGREGATE}).hasMessage("line 1:8: ORDER BY is only valid for aggregation functions");
        this.assertFails("SELECT array_agg(x ORDER BY x) FROM (VALUES MAP(ARRAY['a'], ARRAY['b'])) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:8: ORDER BY can only be applied to orderable types (actual: map(varchar(1), varchar(1)))");
        this.assertFails("SELECT 1 as a, array_agg(x ORDER BY a) FROM (VALUES (1), (2), (3)) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessage("line 1:37: Column 'a' cannot be resolved");
        this.assertFails("SELECT 1 AS c FROM (VALUES (1), (2)) t(x) ORDER BY sum(x order by c)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessage("line 1:67: ORDER BY clause in aggregation function must not reference query output columns");
    }

    @Test
    public void testQuantifiedComparisonExpression() {
        this.analyze("SELECT * FROM t1 WHERE t1.a <= ALL (VALUES 10, 20)");
        this.assertFails("SELECT * FROM t1 WHERE t1.a = ANY (SELECT 1, 2)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:29: Value expression and result of subquery must be of the same type: row(bigint) vs row(integer, integer)");
        this.assertFails("SELECT * FROM t1 WHERE t1.a = SOME (VALUES ('abc'))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:29: Value expression and result of subquery must be of the same type: row(bigint) vs row(varchar(3))");
        this.assertFails("SELECT map(ARRAY[1], ARRAY['hello']) < ALL (VALUES map(ARRAY[1], ARRAY['hello']))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:38: Type [row(map(integer, varchar(5)))] must be orderable in order to be used in quantified comparison");
        this.analyze("SELECT map(ARRAY[1], ARRAY['hello']) = ALL (VALUES map(ARRAY[1], ARRAY['hello']))");
        this.assertFails("SELECT cast(NULL AS HyperLogLog) < ALL (VALUES cast(NULL AS HyperLogLog))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:34: Type [row(HyperLogLog)] must be orderable in order to be used in quantified comparison");
        this.assertFails("SELECT cast(NULL AS HyperLogLog) = ANY (VALUES cast(NULL AS HyperLogLog))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:34: Type [row(HyperLogLog)] must be comparable in order to be used in quantified comparison");
        this.assertFails("SELECT ROW(cast(NULL AS HyperLogLog), 1) = ANY (VALUES ROW(cast(NULL AS HyperLogLog), 1))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:42: Type [row(HyperLogLog, integer)] must be comparable in order to be used in quantified comparison");
        this.assertFails("SELECT cast(NULL AS qdigest(double)) < ALL (VALUES cast(NULL AS qdigest(double)))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:38: Type [row(qdigest(double))] must be orderable in order to be used in quantified comparison");
        this.assertFails("SELECT cast(NULL AS qdigest(double)) = ANY (VALUES cast(NULL AS qdigest(double)))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:38: Type [row(qdigest(double))] must be comparable in order to be used in quantified comparison");
    }

    @Test
    public void testJoinUnnest() {
        this.analyze("SELECT * FROM (VALUES array[2, 2]) a(x) CROSS JOIN UNNEST(x)");
        this.analyze("SELECT * FROM (VALUES array[2, 2]) a(x) LEFT OUTER JOIN UNNEST(x) ON true");
        this.assertFails("SELECT * FROM (VALUES array[2, 2]) a(x) RIGHT OUTER JOIN UNNEST(x) ON true").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_COLUMN_REFERENCE}).hasMessage("line 1:65: LATERAL reference not allowed in RIGHT JOIN");
        this.assertFails("SELECT * FROM (VALUES array[2, 2]) a(x) FULL OUTER JOIN UNNEST(x) ON true").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_COLUMN_REFERENCE}).hasMessage("line 1:64: LATERAL reference not allowed in FULL JOIN");
        this.analyze("SELECT * FROM (VALUES 1), UNNEST(array[2])");
        this.assertFails("SELECT * FROM (VALUES array[2, 2]) a(x) LEFT JOIN UNNEST(x) b(x) USING (x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:15: LEFT JOIN involving UNNEST is only supported with condition ON TRUE");
        this.assertFails("SELECT * FROM (VALUES array[2, 2]) a(x) LEFT JOIN UNNEST(x) ON 1 = 1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:66: LEFT JOIN involving UNNEST is only supported with condition ON TRUE");
        this.assertFails("SELECT * FROM (VALUES array[2, 2]) a(x) LEFT JOIN UNNEST(x) ON false").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:64: LEFT JOIN involving UNNEST is only supported with condition ON TRUE");
    }

    @Test
    public void testJoinLateral() {
        this.analyze("SELECT * FROM (VALUES array[2, 2]) a(x) CROSS JOIN LATERAL(VALUES x)");
        this.analyze("SELECT * FROM (VALUES array[2, 2]) a(x) LEFT OUTER JOIN LATERAL(VALUES x) ON true");
        this.assertFails("SELECT * FROM (VALUES array[2, 2]) a(x) RIGHT OUTER JOIN LATERAL(VALUES x) ON true").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_COLUMN_REFERENCE}).hasMessage("line 1:73: LATERAL reference not allowed in RIGHT JOIN");
        this.assertFails("SELECT * FROM (VALUES array[2, 2]) a(x) FULL OUTER JOIN LATERAL(VALUES x) ON true").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_COLUMN_REFERENCE}).hasMessage("line 1:72: LATERAL reference not allowed in FULL JOIN");
        this.analyze("SELECT * FROM (VALUES 1) FULL OUTER JOIN LATERAL(VALUES 2) ON true");
        this.assertFails("SELECT * FROM (VALUES 1) a(x) FULL OUTER JOIN LATERAL(VALUES 2) b(x) USING (x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:15: FULL JOIN involving LATERAL relation is only supported with condition ON TRUE");
        this.assertFails("SELECT * FROM (VALUES 1) FULL OUTER JOIN LATERAL(VALUES 2) ON 1 = 1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:65: FULL JOIN involving LATERAL relation is only supported with condition ON TRUE");
        this.assertFails("SELECT * FROM (VALUES 1) FULL OUTER JOIN LATERAL(VALUES 2) ON false").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:63: FULL JOIN involving LATERAL relation is only supported with condition ON TRUE");
    }

    @Test
    public void testNullTreatment() {
        this.assertFails("SELECT count() RESPECT NULLS OVER ()").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NULL_TREATMENT_NOT_ALLOWED}).hasMessage("line 1:8: Cannot specify null treatment clause for count function");
        this.assertFails("SELECT count() IGNORE NULLS OVER ()").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NULL_TREATMENT_NOT_ALLOWED}).hasMessage("line 1:8: Cannot specify null treatment clause for count function");
        this.analyze("SELECT lag(1) RESPECT NULLS OVER (ORDER BY x) FROM (VALUES 1) t(x)");
        this.analyze("SELECT lag(1) IGNORE NULLS OVER (ORDER BY x) FROM (VALUES 1) t(x)");
    }

    @Test
    public void testCreateOrReplaceMaterializedView() {
        this.assertFails("CREATE OR REPLACE MATERIALIZED VIEW IF NOT EXISTS mv1 AS SELECT * FROM tab1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: 'CREATE OR REPLACE' and 'IF NOT EXISTS' clauses can not be used together");
    }

    @Test
    public void testValues() {
        this.assertFails("VALUES (1, 2, 3), (1, 2)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:1: Values rows have mismatched sizes: 3 vs 2");
        this.assertFails("VALUES (1, 2), 1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:1: Values rows have mismatched sizes: 2 vs 1");
        this.assertFails("VALUES (1, 2), CAST(ROW(1, 2, 3) AS row(bigint, bigint, bigint))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:1: Values rows have mismatched sizes: 2 vs 3");
        this.assertFails("VALUES (1, 2), ('a', 'b')").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:1: Values rows have mismatched types: row(integer, integer) vs row(varchar(1), varchar(1))");
        this.analyze("VALUES 'a', ('a'), ROW('a'), CAST(ROW('a') AS row(char(5)))");
    }

    @Test
    public void testInputColumnNames() {
        String query = "SELECT *           FROM (VALUES (1, 2, 3)) Ticker(%s)                  MATCH_RECOGNIZE (                    PARTITION BY y                    PATTERN (A B+)                    DEFINE B AS true                  ) AS M";
        this.assertFails(String.format(query, "x, X, y")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.AMBIGUOUS_NAME}).hasMessage("line 1:25: ambiguous column: X in row pattern input relation");
        this.assertFails(String.format(query, "\"x\", \"X\", y")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.AMBIGUOUS_NAME}).hasMessage("line 1:25: ambiguous column: X in row pattern input relation");
        this.assertFails(String.format(query, "x, \"X\", y")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.AMBIGUOUS_NAME}).hasMessage("line 1:25: ambiguous column: X in row pattern input relation");
        this.analyze("SELECT a           FROM t1                  MATCH_RECOGNIZE (                    PARTITION BY a                    ORDER BY b                    MEASURES X.d AS m                    PATTERN (X Y+)                    DEFINE Y AS Y.c > 5                  ) AS M");
        this.analyze("SELECT q           FROM t1 AS t(q, r, s, t)                  MATCH_RECOGNIZE (                    PARTITION BY q                    ORDER BY r                    MEASURES X.t AS m                    PATTERN (X Y+)                    DEFINE Y AS Y.s > 5                  ) AS M");
        this.assertFails("SELECT *           FROM t1 AS t(q, r, s, t)                 MATCH_RECOGNIZE (                    PARTITION BY a                    PATTERN (X Y+)                    DEFINE Y AS true                  ) AS M").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessage("line 1:111: Column a is not present in the input relation");
        this.assertFails("SELECT *           FROM t1 AS t(q, r, s, t)                 MATCH_RECOGNIZE (                    PARTITION BY q                    PATTERN (X Y+)                    DEFINE Y AS Y.a > 5                  ) AS M").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessage("line 1:178: Column a prefixed with label Y cannot be resolved");
        this.analyze("SELECT *           FROM t1 AS t(q, r, S, T)                  MATCH_RECOGNIZE (                    MEASURES                        X.Q AS m1,                        X.r AS m2                   PATTERN (X Y+)                    DEFINE                        X AS Y.S > 5,                        Y AS Y.t < 5                  ) AS M");
    }

    @Test
    public void testInputTableNameVisibility() {
        String query = "SELECT %s           FROM (VALUES (1, 2, 3)) Ticker(x, y, z)                  MATCH_RECOGNIZE (                    PARTITION BY y                    MEASURES CLASSIFIER() AS Measure                    PATTERN (A B+)                    DEFINE B AS true                  ) %s";
        this.assertFails(String.format(query, "Ticker.Measure", "")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessage("line 1:8: Column 'ticker.measure' cannot be resolved");
        this.assertFails(String.format(query, "Ticker.*", "")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_NOT_FOUND}).hasMessage("line 1:8: Unable to resolve reference ticker");
        this.assertFails(String.format(query, "Ticker.y", "")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessage("line 1:8: Column 'ticker.y' cannot be resolved");
        this.assertFails(String.format(query, "Ticker.Measure", "AS M")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessage("line 1:8: Column 'ticker.measure' cannot be resolved");
        this.analyze("SELECT *           FROM (VALUES (1, 2, 3)) Ticker(x, y, z)                  MATCH_RECOGNIZE (                    PARTITION BY Ticker.x                     ORDER BY Ticker.y                     MEASURES CLASSIFIER() AS Measure                    PATTERN (A B+)                    DEFINE B AS true                  ) ");
        query = "SELECT *           FROM (VALUES (1, 2, 3)) Ticker(x, y, z)                  MATCH_RECOGNIZE (                    PARTITION BY Ticker.x                    MEASURES %s                    PATTERN (A B+)                    DEFINE %s                  ) ";
        this.assertFails(String.format(query, "A.Ticker.x AS Measure", "B AS true")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessage("line 1:164: Column ticker.x prefixed with label A cannot be resolved");
        this.assertFails(String.format(query, "Ticker.A.x AS Measure", "B AS true")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessage("line 1:164: Column 'ticker.a.x' cannot be resolved");
        this.assertFails(String.format(query, "1 AS Measure", "B AS Ticker.x > 0")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessage("line 1:242: Column 'ticker.x' cannot be resolved");
        this.analyze("SELECT *           FROM t1                  MATCH_RECOGNIZE (                    PARTITION BY t1.a                    ORDER BY t1.b                    PATTERN (A B+)                    DEFINE B AS true                   ) ");
        this.assertFails(String.format(query, "A.t1.x AS Measure", "B AS true")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessage("line 1:164: Column t1.x prefixed with label A cannot be resolved");
        this.assertFails(String.format(query, "t1.A.x AS Measure", "B AS true")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessage("line 1:164: Column 't1.a.x' cannot be resolved");
        this.assertFails(String.format(query, "1 AS Measure", "B AS t1.x > 0")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessage("line 1:242: Column 't1.x' cannot be resolved");
    }

    @Test
    public void testOutputTableNameAndAliases() {
        String query = "SELECT %s           FROM (VALUES (1, 2, 3)) Ticker(x, y, z)                  MATCH_RECOGNIZE (                    PARTITION BY y                    MEASURES CLASSIFIER() AS Measure                    PATTERN (A B+)                    DEFINE B AS true                  ) %s";
        this.analyze(String.format(query, "M.Measure", "AS M"));
        this.assertFails(String.format(query, "M.renamed", "AS M (renamed)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISMATCHED_COLUMN_ALIASES}).hasMessage("line 1:33: Column alias list has 1 entries but 'M' has 2 columns available");
        this.assertFails(String.format(query, "M.Measure", "AS M (partition, renamed)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessage("line 1:8: Column 'm.measure' cannot be resolved");
        this.analyze(String.format(query, "M.renamed", "AS M (partition, renamed)"));
    }

    @Test
    public void testPartitionBy() {
        this.assertFails("SELECT *           FROM (VALUES 1) Ticker(x)                  MATCH_RECOGNIZE (                    PARTITION BY x + 1                    PATTERN (A B+)                    DEFINE B AS true                  ) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_COLUMN_REFERENCE}).hasMessage("line 1:115: Expected column reference. Actual: (x + 1)");
        this.assertFails("SELECT *           FROM (VALUES approx_set(1)) Ticker(x)                  MATCH_RECOGNIZE (                    PARTITION BY x                    PATTERN (A B+)                    DEFINE B AS true                  ) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:125: HyperLogLog is not comparable, and therefore cannot be used in PARTITION BY");
    }

    @Test
    public void testOrderBy() {
        this.assertFails("SELECT *           FROM (VALUES 1) Ticker(x)                  MATCH_RECOGNIZE (                    ORDER BY x + 1                    PATTERN (A B+)                    DEFINE B AS true                  ) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_COLUMN_REFERENCE}).hasMessage("line 1:111: Expected column reference. Actual: (x + 1)");
        this.assertFails("SELECT *           FROM (VALUES approx_set(1)) Ticker(x)                  MATCH_RECOGNIZE (                    ORDER BY x                    PATTERN (A B+)                    DEFINE B AS true                  ) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:121: HyperLogLog is not orderable, and therefore cannot be used in ORDER BY");
    }

    @Test
    public void testLabelNames() {
        String query = "SELECT *           FROM (VALUES 1) Ticker(x)                  MATCH_RECOGNIZE (                    PARTITION BY x                    %s                    %s                  ) ";
        this.analyze(String.format(query, "PATTERN(A)", "DEFINE a AS true"));
        this.analyze(String.format(query, "PATTERN(a)", "DEFINE A AS true"));
        this.analyze(String.format(query, "PATTERN(\"A\")", "DEFINE a AS true"));
        this.assertFails(String.format(query, "PATTERN(a)", "DEFINE \"a\" AS true")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LABEL}).hasMessage("line 1:171: defined variable: \"a\" is not a primary pattern variable");
        this.assertFails(String.format(query, "PATTERN(A)", "DEFINE \"a\" AS true")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LABEL}).hasMessage("line 1:171: defined variable: \"a\" is not a primary pattern variable");
        this.analyze(String.format(query, "PATTERN(A \"a\")", "DEFINE A AS true, \"a\" as false"));
        this.analyze(String.format(query, "PATTERN(A \"a\")", "DEFINE a AS true, \"a\" as false"));
        this.assertFails(String.format(query, "PATTERN(A \"a\")", "DEFINE A AS true, a as false")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LABEL}).hasMessage("line 1:186: pattern variable with name: a is defined twice");
        this.assertFails(String.format(query, "PATTERN(A \"a\")", "DEFINE \"a\" AS true, \"a\" as false")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LABEL}).hasMessage("line 1:188: pattern variable with name: \"a\" is defined twice");
        this.analyze("SELECT *           FROM (VALUES 1) Ticker(x)                  MATCH_RECOGNIZE (                    PARTITION BY x                    AFTER MATCH SKIP TO LAST \"^\"                    PATTERN (A B+ \"$\")                    SUBSET \"^\" = (A, \"$\")                    DEFINE \"$\" AS true                  ) ");
        this.assertFails("SELECT *           FROM (VALUES 1) Ticker(x)                  MATCH_RECOGNIZE (                    PARTITION BY x                    PATTERN (A B+)                    SUBSET U = (b, \"a\")                    DEFINE A AS true                  ) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LABEL}).hasMessage("line 1:183: subset element: \"a\" is not a primary pattern variable");
        this.analyze("SELECT *           FROM (VALUES 1) Ticker(x)                  MATCH_RECOGNIZE (                    PARTITION BY x                    AFTER MATCH SKIP TO LAST \"A\"                    PATTERN (A B+)                    SUBSET U = (a, b)                    DEFINE A AS true                  ) ");
        this.analyze("SELECT *           FROM (VALUES 1) Ticker(x)                  MATCH_RECOGNIZE (                    MEASURES                        LAST(A.x) AS uppercase_measure,                        LAST(a.x) AS lowercase_measure,                        LAST(\"A\".x) AS delimited_measure                    PATTERN (A+)                    DEFINE A AS true                  ) ");
    }

    @Test
    public void testLabelNamesInExpressions() {
        this.analyze("SELECT M.Measure1, M.Measure2, M.Measure3, M.Measure4, M.Measure5, M.Measure6           FROM (VALUES (1, 1, 9), (1, 2, 8)) Ticker(Symbol, Tradeday, Price)                  MATCH_RECOGNIZE (                    MEASURES                        CLASSIFIER(A) AS Measure1,                        LAST(a.Tradeday) AS Measure2,                        FIRST(\"A\".Price) AS Measure3,                        B.Symbol + 4 AS Measure4,                        b.Symbol + 5 AS Measure5,                        lower(CLASSIFIER(\"B\")) AS Measure6                    PATTERN (a B+)                    DEFINE B AS true                 ) AS M");
    }

    @Test
    public void testSubsetClause() {
        this.assertFails("SELECT *           FROM (VALUES 1) Ticker(x)                  MATCH_RECOGNIZE (                    PARTITION BY x                    PATTERN (A B+)                    SUBSET A = (B)                    DEFINE B AS true                  ) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LABEL}).hasMessage("line 1:175: union pattern variable name: A is a duplicate of primary pattern variable name");
        this.assertFails("SELECT *           FROM (VALUES 1) Ticker(x)                  MATCH_RECOGNIZE (                    PARTITION BY x                    PATTERN (A B+ C)                    SUBSET S = (B),                           S = (C)                    DEFINE B AS true                  ) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LABEL}).hasMessage("line 1:212: union pattern variable name: S is declared twice");
        this.assertFails("SELECT *           FROM (VALUES 1) Ticker(x)                  MATCH_RECOGNIZE (                    PARTITION BY x                    PATTERN (A B+ C)                    SUBSET S = (B, X)                    DEFINE B AS true                  ) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LABEL}).hasMessage("line 1:185: subset element: X is not a primary pattern variable");
    }

    @Test
    public void testDefineClause() {
        this.assertFails("SELECT *           FROM (VALUES 1) Ticker(x)                  MATCH_RECOGNIZE (                    PARTITION BY x                    PATTERN (A B+)                    DEFINE B AS true,                           X AS false                  ) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LABEL}).hasMessage("line 1:212: defined variable: X is not a primary pattern variable");
        this.assertFails("SELECT *           FROM (VALUES 1) Ticker(x)                  MATCH_RECOGNIZE (                    PARTITION BY x                    PATTERN (A B+)                    DEFINE B AS true,                           B AS false                  ) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LABEL}).hasMessage("line 1:212: pattern variable with name: B is defined twice");
        this.assertFails("SELECT *           FROM (VALUES 1) Ticker(x)                  MATCH_RECOGNIZE (                    PARTITION BY x                    PATTERN (A B+)                    DEFINE B AS A.x                  ) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:180: Expression defining a label must be boolean (actual type: integer)");
        this.assertFails("SELECT *           FROM (VALUES 1) Ticker(x)                  MATCH_RECOGNIZE (                    PARTITION BY x                    PATTERN (A B+)                    DEFINE B AS FINAL LAST(A.x) > 5                  ) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PROCESSING_MODE}).hasMessage("line 1:180: FINAL semantics is not supported in DEFINE clause");
        this.analyze("SELECT *           FROM (VALUES 1) Ticker(x)                  MATCH_RECOGNIZE (                    PARTITION BY x                    PATTERN (A B+)                    DEFINE B AS RUNNING LAST(A.x) > 5                  ) ");
    }

    @Test
    public void testNoInitialOrSeek() {
        this.assertFails("SELECT *           FROM (VALUES 1) Ticker(x)                  MATCH_RECOGNIZE (                    PARTITION BY x                    INITIAL PATTERN (A B+)                    DEFINE B AS true                  ) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:134: Pattern search modifier: INITIAL is not allowed in MATCH_RECOGNIZE clause");
        this.assertFails("SELECT *           FROM (VALUES 1) Ticker(x)                  MATCH_RECOGNIZE (                    PARTITION BY x                    SEEK PATTERN (A B+)                    DEFINE B AS true                  ) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:134: Pattern search modifier: SEEK is not allowed in MATCH_RECOGNIZE clause");
    }

    @Test
    public void testPatternExclusions() {
        String query = "SELECT *           FROM (VALUES 1) Ticker(x)                  MATCH_RECOGNIZE (                    PARTITION BY x                    %s                    PATTERN ({- A -} B+)                    DEFINE B AS true                  ) ";
        this.analyze(String.format(query, ""));
        this.analyze(String.format(query, "ONE ROW PER MATCH"));
        this.analyze(String.format(query, "ALL ROWS PER MATCH"));
        this.analyze(String.format(query, "ALL ROWS PER MATCH SHOW EMPTY MATCHES"));
        this.analyze(String.format(query, "ALL ROWS PER MATCH OMIT EMPTY MATCHES"));
        this.assertFails(String.format(query, "ALL ROWS PER MATCH WITH UNMATCHED ROWS")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ROW_PATTERN}).hasMessage("line 1:201: Pattern exclusion syntax is not allowed when ALL ROWS PER MATCH WITH UNMATCHED ROWS is specified");
    }

    @Test
    public void testPatternQuantifiers() {
        String query = "SELECT *           FROM (VALUES 1) Ticker(x)                  MATCH_RECOGNIZE (                    PARTITION BY x                    PATTERN (A %s)                    DEFINE A AS true                  ) ";
        this.analyze(String.format(query, "*"));
        this.analyze(String.format(query, "*?"));
        this.analyze(String.format(query, "+"));
        this.analyze(String.format(query, "+?"));
        this.analyze(String.format(query, "?"));
        this.analyze(String.format(query, "??"));
        this.analyze(String.format(query, "{,}"));
        this.analyze(String.format(query, "{5}"));
        this.assertFails(String.format(query, "{0}")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("line 1:145: Pattern quantifier upper bound must be greater than or equal to 1");
        this.assertFails(String.format(query, "{3000000000}")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("line 1:145: Pattern quantifier lower bound must not exceed 2147483647");
        this.analyze(String.format(query, "{5,}"));
        this.analyze(String.format(query, "{0,}"));
        this.assertFails(String.format(query, "{3000000000,}")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("line 1:145: Pattern quantifier lower bound must not exceed 2147483647");
        this.analyze(String.format(query, "{0,5}"));
        this.assertFails(String.format(query, "{0,0}")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("line 1:145: Pattern quantifier upper bound must be greater than or equal to 1");
        this.assertFails(String.format(query, "{5, 3000000000}")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("line 1:145: Pattern quantifier upper bound must not exceed 2147483647");
        this.assertFails(String.format(query, "{5,1}")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_RANGE}).hasMessage("line 1:145: Pattern quantifier lower bound must not exceed upper bound");
        this.analyze(String.format(query, "{,5}"));
        this.assertFails(String.format(query, "{,0}")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("line 1:145: Pattern quantifier upper bound must be greater than or equal to 1");
        this.assertFails(String.format(query, "{,3000000000}")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("line 1:145: Pattern quantifier upper bound must not exceed 2147483647");
    }

    @Test
    public void testAfterMatchSkipClause() {
        String query = "SELECT *           FROM (VALUES 1) Ticker(x)                  MATCH_RECOGNIZE (                    PARTITION BY x                    %s                    PATTERN (A B+)                    DEFINE B AS true                  ) ";
        this.analyze(String.format(query, ""));
        this.analyze(String.format(query, "AFTER MATCH SKIP PAST LAST ROW"));
        this.analyze(String.format(query, "AFTER MATCH SKIP TO NEXT ROW"));
        this.analyze(String.format(query, "AFTER MATCH SKIP TO FIRST B"));
        this.analyze(String.format(query, "AFTER MATCH SKIP TO LAST B"));
        this.analyze(String.format(query, "AFTER MATCH SKIP TO B"));
        this.assertFails(String.format(query, "AFTER MATCH SKIP TO LAST \"^\"")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LABEL}).hasMessage("line 1:159: \"^\" is not a primary or union pattern variable");
        this.assertFails(String.format(query, "AFTER MATCH SKIP TO LAST X")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_LABEL}).hasMessage("line 1:159: X is not a primary or union pattern variable");
    }

    @Test
    public void testNestedMatchRecognize() {
        this.assertFails("SELECT *           FROM (VALUES 1)                  MATCH_RECOGNIZE (                    MEASURES CLASSIFIER() AS c                    PATTERN (A B+)                    DEFINE B AS EXISTS                                    (SELECT c FROM (VALUES 2) t(a)                                                    MATCH_RECOGNIZE (                                                       MEASURES CLASSIFIER() AS c                                                       PATTERN (X*)                                                       DEFINE X AS true                                                     ) t2                                     )                  ) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_ROW_PATTERN_RECOGNITION}).hasMessage("line 1:239: nested row pattern recognition in row pattern recognition");
        this.assertFails("SELECT *           FROM (VALUES 1)                  MATCH_RECOGNIZE (                    MEASURES EXISTS                                 (SELECT c FROM (VALUES 2) t(a)                                                 MATCH_RECOGNIZE (                                                    MEASURES CLASSIFIER() AS c                                                    PATTERN (X*)                                                    DEFINE X AS true                                                  ) t2                                  ) AS c                   PATTERN (A B+)                    DEFINE B AS true                ) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_ROW_PATTERN_RECOGNITION}).hasMessage("line 1:153: nested row pattern recognition in row pattern recognition");
        this.assertFails("SELECT m OVER(                      MEASURES CLASSIFIER() AS m                     ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                      PATTERN (A+)                      DEFINE A AS EXISTS                                 (SELECT c FROM (VALUES 2) t(a)                                                 MATCH_RECOGNIZE (                                                    MEASURES CLASSIFIER() AS c                                                    PATTERN (X*)                                                    DEFINE X AS true                                                  ) t2                                  )                     ) FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_ROW_PATTERN_RECOGNITION}).hasMessage("line 1:246: nested row pattern recognition in row pattern recognition");
        this.assertFails("SELECT m OVER(                      MEASURES EXISTS                                 (SELECT c FROM (VALUES 2) t(a)                                                 MATCH_RECOGNIZE (                                                    MEASURES CLASSIFIER() AS c                                                    PATTERN (X*)                                                    DEFINE X AS true                                                  ) t2                                  ) AS m                     ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                      PATTERN (A+)                      DEFINE A AS true                     ) FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_ROW_PATTERN_RECOGNITION}).hasMessage("line 1:100: nested row pattern recognition in row pattern recognition");
        this.assertFails("WITH RECURSIVE t(n) AS (          SELECT 1           UNION ALL          SELECT n + 2 FROM t MATCH_RECOGNIZE (                                 MEASURES CLASSIFIER() AS c                                 PATTERN (X*)                                 DEFINE X AS true                               )           WHERE n < 6          )          SELECT * from t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_ROW_PATTERN_RECOGNITION}).hasMessage("line 1:91: nested row pattern recognition in recursive query");
    }

    @Test
    public void testNestedPatternRecognitionInWindow() {
        this.assertFails("SELECT *           FROM (VALUES 1)                  MATCH_RECOGNIZE (                    MEASURES CLASSIFIER() AS c                    PATTERN (A B+)                    DEFINE B AS classy OVER (                                             MEASURES CLASSIFIER() AS classy                                             ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                             PATTERN (X+)                                             DEFINE X AS true                                            ) > 'Z'                 ) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_ROW_PATTERN_RECOGNITION}).hasMessage("line 1:410: nested row pattern recognition in row pattern recognition");
        this.assertFails("SELECT *           FROM (VALUES 1)                  MATCH_RECOGNIZE (                    MEASURES classy OVER (                                          MEASURES CLASSIFIER() AS classy                                          ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                          PATTERN (X+)                                          DEFINE X AS true                                         ) > 'Z' AS c                    PATTERN (A B+)                    DEFINE B AS true                  ) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_ROW_PATTERN_RECOGNITION}).hasMessage("line 1:318: nested row pattern recognition in row pattern recognition");
        this.assertFails("SELECT m OVER(                          MEASURES CLASSIFIER() AS m                         ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                          PATTERN (A+)                          DEFINE A AS classy OVER (                                                   MEASURES CLASSIFIER() AS classy                                                   ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                                   PATTERN (X+)                                                   DEFINE X AS true                                                  ) > 'Z'                        ) FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_WINDOW}).hasMessage("line 1:208: Cannot nest window functions or row pattern measures inside window specification");
        this.assertFails("SELECT m OVER(                          MEASURES classy OVER (                                                MEASURES CLASSIFIER() AS classy                                                ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                                                PATTERN (X+)                                                DEFINE X AS true                                               ) > 'Z' AS m                         ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                          PATTERN (A+)                          DEFINE A AS true                        ) FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_WINDOW}).hasMessage("line 1:50: Cannot nest window functions or row pattern measures inside window specification");
        this.assertFails("WITH RECURSIVE t(n) AS (          SELECT 1           UNION ALL          SELECT n + m OVER w FROM t                WHERE n < 6                WINDOW w AS (                             MEASURES X.n AS m                             ROWS BETWEEN CURRENT ROW AND 5 FOLLOWING                             PATTERN (X*)                             DEFINE X AS true                            )           )           SELECT * from t").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_ROW_PATTERN_RECOGNITION}).hasMessage("line 1:308: nested row pattern recognition in recursive query");
    }

    @Test
    public void testCorrelation() {
        this.assertFails("SELECT (SELECT *                    FROM (VALUES 1) Ticker(x)                          MATCH_RECOGNIZE (                            PARTITION BY x                            PATTERN (A B+)                            DEFINE B AS t1.a > PREV(B.x)                          )                   ) FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessage("line 1:229: Column 't1.a' cannot be resolved");
        this.assertFails("SELECT (SELECT *                    FROM (VALUES 1) Ticker(x)                          MATCH_RECOGNIZE (                            MEASURES t1.a - PREV(B.x) AS m                            PATTERN (A B+)                            DEFINE B AS true                          )                   ) FROM t1").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessage("line 1:142: Column 't1.a' cannot be resolved");
        this.analyze("SELECT (SELECT *                    FROM (VALUES 1) Ticker(x)                          MATCH_RECOGNIZE (                            MEASURES FIRST(B.x) AS m                            PATTERN (A B+)                            DEFINE B AS true                          )                   ) FROM (VALUES 2) b");
    }

    @Test
    public void testSubqueries() {
        this.analyze("SELECT *           FROM (VALUES 1)                  MATCH_RECOGNIZE (                    MEASURES (SELECT 1) AS c                    PATTERN (A B+)                    DEFINE B AS (SELECT true)                  ) ");
        this.assertFails("SELECT *           FROM (VALUES 1) t(x)                  MATCH_RECOGNIZE (                    MEASURES (SELECT A.x) AS c                    PATTERN (A B+)                    DEFINE B AS true                  ) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessage("line 1:112: Column 'a.x' cannot be resolved");
        this.assertFails("SELECT *           FROM (VALUES 1) t(x)                  MATCH_RECOGNIZE (                    MEASURES 1 AS c                    PATTERN (A B+)                    DEFINE B AS (SELECT A.x > 5)                  ) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessage("line 1:184: Column 'a.x' cannot be resolved");
        this.assertFails("SELECT *           FROM (VALUES 1) t(x)                  MATCH_RECOGNIZE (                    MEASURES 1 AS c                    PATTERN (A B+)                    DEFINE B AS (SELECT t.x > 5)                 ) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:184: Reference to column 't.x' from outer scope not allowed in this context");
    }

    @Test
    public void testInPredicateWithSubquery() {
        this.analyze("SELECT *           FROM (VALUES 1) t(x)                  MATCH_RECOGNIZE (                    MEASURES 1 AS c                    PATTERN (A B+)                    DEFINE B AS 5 + x in (SELECT 1)                 ) ");
        this.assertFails("SELECT *           FROM (VALUES 1) t(x)                  MATCH_RECOGNIZE (                    MEASURES 1 AS c                    PATTERN (A B+)                    DEFINE B AS A.x in (SELECT 1)                 ) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:176: IN-PREDICATE with labeled column reference is not yet supported");
        this.assertFails("SELECT *           FROM (VALUES 1) t(x)                  MATCH_RECOGNIZE (                    MEASURES 1 AS c                    PATTERN (A B+)                    DEFINE B AS LAST(x) in (SELECT 1)                 ) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:176: IN-PREDICATE with last function is not yet supported");
        this.assertFails("SELECT *           FROM (VALUES 1) t(x)                  MATCH_RECOGNIZE (                    MEASURES 1 AS c                    PATTERN (A B+)                    DEFINE B AS CLASSIFIER() in (SELECT 1)                 ) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:176: IN-PREDICATE with classifier function is not yet supported");
        this.assertFails("SELECT *           FROM (VALUES 1) t(x)                  MATCH_RECOGNIZE (                    MEASURES 1 AS c                    PATTERN (A B+)                    DEFINE B AS MATCH_NUMBER() in (SELECT 1)                 ) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:176: IN-PREDICATE with match_number function is not yet supported");
    }

    @Test
    public void testInPredicateWithoutSubquery() {
        this.analyze("SELECT *           FROM (VALUES 1) t(x)                  MATCH_RECOGNIZE (                    MEASURES 1 AS c                    PATTERN (A B+)                    DEFINE B AS 5 + x in (1, 2, x)                 ) ");
        this.analyze("SELECT *           FROM (VALUES 1) t(x)                  MATCH_RECOGNIZE (                    MEASURES 1 AS c                    PATTERN (A B+)                    DEFINE B AS A.x in (1, 2, B.x)                 ) ");
        this.analyze("SELECT *           FROM (VALUES 1) t(x)                  MATCH_RECOGNIZE (                    MEASURES 1 AS c                    PATTERN (A B+)                    DEFINE B AS LAST(x) in (1, 2, FIRST(x))                 ) ");
        this.analyze("SELECT *           FROM (VALUES 1) t(x)                  MATCH_RECOGNIZE (                    MEASURES 1 AS c                    PATTERN (A B+)                    DEFINE B AS CLASSIFIER(A) in ('A', 'B', CLASSIFIER(B))                 ) ");
        this.analyze("SELECT *           FROM (VALUES 1) t(x)                  MATCH_RECOGNIZE (                    MEASURES 1 AS c                    PATTERN (A B+)                    DEFINE B AS MATCH_NUMBER() in (1, 2, MATCH_NUMBER())                 ) ");
    }

    @Test
    public void testPatternRecognitionConcatenation() {
        this.analyze("SELECT *            FROM (SELECT *                  FROM (VALUES 1)                        MATCH_RECOGNIZE (                          MEASURES 1 AS c                         PATTERN (A B+)                          DEFINE B AS true                       )                  ) MATCH_RECOGNIZE (                      MEASURES 1 AS c                     PATTERN (A B+)                      DEFINE B AS true                   ) ");
    }

    @Test
    public void testNoOutputColumns() {
        this.assertFails("SELECT 1           FROM (VALUES 2)                  MATCH_RECOGNIZE (                    PATTERN (A B+)                    DEFINE B AS true                  ) ").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TABLE_HAS_NO_COLUMNS}).hasMessage("line 1:25: pattern recognition output table has no columns");
    }

    @Test
    public void testLambdaInPatternRecognition() {
        String query = "SELECT M.Measure           FROM (VALUES (ARRAY[1]), (ARRAY[2])) Ticker(Value)                  MATCH_RECOGNIZE (                    MEASURES %s AS Measure                    PATTERN (A B+)                    DEFINE B AS %s                 ) AS M";
        this.assertFails(String.format(query, "transform(A.Value, x -> x + 100)", "true")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:161: Lambda expression in pattern recognition context is not yet supported");
        this.assertFails(String.format(query, "true", "transform(A.Value, x -> x + 100) = ARRAY[50]")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:242: Lambda expression in pattern recognition context is not yet supported");
    }

    @Test
    public void testTryInPatternRecognition() {
        String query = "SELECT M.Measure           FROM (VALUES (ARRAY[1]), (ARRAY[2])) Ticker(Value)                  MATCH_RECOGNIZE (                    MEASURES %s AS Measure                    PATTERN (A B+)                    DEFINE B AS %s                 ) AS M";
        this.assertFails(String.format(query, "TRY(1)", "true")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:142: TRY expression in pattern recognition context is not yet supported");
        this.assertFails(String.format(query, "sum(TRY(1))", "true")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:146: TRY expression in pattern recognition context is not yet supported");
        this.assertFails(String.format(query, "true", "TRY(1) = 1")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:223: TRY expression in pattern recognition context is not yet supported");
        this.assertFails(String.format(query, "true", "sum(TRY(1)) = 2")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:227: TRY expression in pattern recognition context is not yet supported");
    }

    @Test
    public void testRowPatternRecognitionFunctions() {
        String query = "SELECT M.Measure           FROM (VALUES (1, 1, 9), (1, 2, 8)) Ticker(Symbol, Tradeday, Price)                  MATCH_RECOGNIZE (                    ORDER BY Tradeday                    MEASURES %s AS Measure                    PATTERN (A B+)                    SUBSET U = (A, B)                    DEFINE B AS %s                  ) AS M";
        String define = "true";
        this.assertFails(String.format(query, "LAST(Tradeday) OVER ()", define)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_WINDOW}).hasMessage("line 1:195: Cannot nest window functions or row pattern measures inside pattern recognition expressions");
        this.assertFails(String.format(query, "LAST(Tradeday) FILTER (WHERE true)", define)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PATTERN_RECOGNITION_FUNCTION}).hasMessage("line 1:195: Cannot use FILTER with last pattern recognition function");
        this.assertFails(String.format(query, "LAST(Tradeday ORDER BY Tradeday)", define)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PATTERN_RECOGNITION_FUNCTION}).hasMessage("line 1:195: Cannot use ORDER BY with last pattern recognition function");
        this.assertFails(String.format(query, "LAST(DISTINCT Tradeday)", define)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PATTERN_RECOGNITION_FUNCTION}).hasMessage("line 1:195: Cannot use DISTINCT with last pattern recognition function");
        String measure = "true";
        this.assertFails(String.format(query, measure, "CLASSIFIER(Tradeday) OVER () > 0")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_WINDOW}).hasMessage("line 1:313: Cannot nest window functions or row pattern measures inside pattern recognition expressions");
        this.assertFails(String.format(query, measure, "CLASSIFIER(Tradeday) FILTER (WHERE true) > 0")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PATTERN_RECOGNITION_FUNCTION}).hasMessage("line 1:313: Cannot use FILTER with classifier pattern recognition function");
        this.assertFails(String.format(query, measure, "CLASSIFIER(Tradeday ORDER BY Tradeday) > 0")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PATTERN_RECOGNITION_FUNCTION}).hasMessage("line 1:313: Cannot use ORDER BY with classifier pattern recognition function");
        this.assertFails(String.format(query, measure, "CLASSIFIER(DISTINCT Tradeday) > 0")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PATTERN_RECOGNITION_FUNCTION}).hasMessage("line 1:313: Cannot use DISTINCT with classifier pattern recognition function");
        this.assertFails(String.format(query, "true", "\"PREV\"(Price)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_NOT_FOUND}).hasMessage("line 1:313: Function 'prev' not registered");
        this.assertFails(String.format(query, "\"NEXT\"(Price) > 0", "true")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_NOT_FOUND}).hasMessage("line 1:195: Function 'next' not registered");
        this.assertFails(String.format(query, "true", "\"FIRST\"(Price)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_NOT_FOUND}).hasMessage("line 1:313: Function 'first' not registered");
        this.assertFails(String.format(query, "\"LAST\"(Price) > 0", "true")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_NOT_FOUND}).hasMessage("line 1:195: Function 'last' not registered");
        this.assertFails(String.format(query, "true", "\"CLASSIFIER\"()")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_NOT_FOUND}).hasMessage("line 1:313: Function 'classifier' not registered");
        this.assertFails(String.format(query, "\"MATCH_NUMBER\"() > 0", "true")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_NOT_FOUND}).hasMessage("line 1:195: Function 'match_number' not registered");
    }

    @Test
    public void testRunningAndFinalSemantics() {
        String query = "SELECT M.Measure           FROM (VALUES (1, 1, 9), (1, 2, 8)) Ticker(Symbol, Tradeday, Price)                  MATCH_RECOGNIZE (                    ORDER BY Tradeday                    MEASURES %s AS Measure                    PATTERN (A B+)                    SUBSET U = (A, B)                    DEFINE B AS %s                 ) AS M";
        String define = "true";
        this.analyze(String.format(query, "FINAL FIRST(Tradeday)", define));
        this.analyze(String.format(query, "FINAL LAST(Tradeday)", define));
        this.assertFails(String.format(query, "FINAL PREV(Tradeday)", define)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PROCESSING_MODE}).hasMessage("line 1:195: FINAL semantics is not supported with prev pattern recognition function");
        this.assertFails(String.format(query, "FINAL NEXT(Tradeday)", define)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PROCESSING_MODE}).hasMessage("line 1:195: FINAL semantics is not supported with next pattern recognition function");
        this.assertFails(String.format(query, "FINAL CLASSIFIER(Tradeday)", define)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PROCESSING_MODE}).hasMessage("line 1:195: FINAL semantics is not supported with classifier pattern recognition function");
        this.assertFails(String.format(query, "FINAL MATCH_NUMBER(Tradeday)", define)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PROCESSING_MODE}).hasMessage("line 1:195: FINAL semantics is not supported with match_number pattern recognition function");
        this.assertFails(String.format(query, "FINAL lower(Tradeday)", define)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PROCESSING_MODE}).hasMessage("line 1:195: FINAL semantics is supported only for FIRST(), LAST() and aggregation functions. Actual: lower");
        this.assertFails("SELECT FINAL avg(x) FROM (VALUES 1) t(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PROCESSING_MODE}).hasMessage("line 1:8: FINAL semantics is not supported out of pattern recognition context");
    }

    @Test
    public void testPatternNavigationFunctions() {
        String query = "SELECT M.Measure           FROM (VALUES (1, 1, 9), (1, 2, 8)) Ticker(Symbol, Tradeday, Price)                  MATCH_RECOGNIZE (                    ORDER BY Tradeday                    MEASURES %s AS Measure                    PATTERN (A B+)                    SUBSET U = (A, B)                    DEFINE B AS true                 ) AS M";
        this.assertFails(String.format(query, "PREV()")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("line 1:195: prev pattern recognition function requires 1 or 2 arguments");
        this.assertFails(String.format(query, "PREV(Tradeday, 1, 'another')")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("line 1:195: prev pattern recognition function requires 1 or 2 arguments");
        this.assertFails(String.format(query, "PREV(Tradeday, 'text')")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("line 1:195: prev pattern recognition navigation function requires a number as the second argument");
        this.assertFails(String.format(query, "PREV(Tradeday, -5)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("line 1:195: prev pattern recognition navigation function requires a non-negative number as the second argument (actual: -5)");
        this.assertFails(String.format(query, "PREV(Tradeday, 3000000000)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE}).hasMessage("line 1:195: The second argument of prev pattern recognition navigation function must not exceed 2147483647 (actual: 3000000000)");
        this.assertFails(String.format(query, "LAST(NEXT(Tradeday, 2))")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_NAVIGATION_NESTING}).hasMessage("line 1:200: Cannot nest next pattern navigation function inside last pattern navigation function");
        this.assertFails(String.format(query, "PREV(NEXT(Tradeday, 2))")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_NAVIGATION_NESTING}).hasMessage("line 1:200: Cannot nest next pattern navigation function inside prev pattern navigation function");
        this.analyze(String.format(query, "PREV(LAST(Tradeday, 2), 3)"));
        this.assertFails(String.format(query, "PREV(LAST(Tradeday, 2) + LAST(Tradeday, 3))")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_NAVIGATION_NESTING}).hasMessage("line 1:220: Cannot nest multiple pattern navigation functions inside prev pattern navigation function");
        this.assertFails(String.format(query, "PREV(LAST(Tradeday, 2) + 5)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_NAVIGATION_NESTING}).hasMessage("line 1:200: Immediate nesting is required for pattern navigation functions");
        this.assertFails(String.format(query, "PREV(avg(Price) + 5)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_AGGREGATION}).hasMessage("line 1:200: Cannot nest avg aggregate function inside prev function");
        this.assertFails(String.format(query, "PREV(LAST('no_column'))")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:200: Pattern navigation function 'LAST' must contain at least one column reference or CLASSIFIER()");
        this.analyze(String.format(query, "PREV(LAST(Tradeday + 1))"));
        this.analyze(String.format(query, "PREV(LAST(lower(CLASSIFIER())))"));
        this.analyze(String.format(query, "PREV(LAST(length(CLASSIFIER(A)) + A.Tradeday + 1))"));
        this.analyze(String.format(query, "PREV(LAST(length(CLASSIFIER()) + Tradeday + 1))"));
        this.analyze(String.format(query, "PREV(LAST(A.Tradeday)) + length(CLASSIFIER(B)) + Price + U.Price"));
        this.assertFails(String.format(query, "PREV(LAST(A.Tradeday + Price))")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:200: All labels and classifiers inside the call to 'last' must match");
        this.assertFails(String.format(query, "PREV(LAST(A.Tradeday + B.Price))")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:200: All labels and classifiers inside the call to 'last' must match");
        this.assertFails(String.format(query, "PREV(LAST(concat(CLASSIFIER(A), CLASSIFIER())))")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:200: All labels and classifiers inside the call to 'last' must match");
        this.assertFails(String.format(query, "PREV(LAST(concat(CLASSIFIER(A), CLASSIFIER(B))))")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:200: All labels and classifiers inside the call to 'last' must match");
        this.assertFails(String.format(query, "PREV(LAST(Tradeday + length(CLASSIFIER(B))))")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:200: All labels and classifiers inside the call to 'last' must match");
        this.assertFails(String.format(query, "PREV(LAST(A.Tradeday + length(CLASSIFIER(B))))")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:200: All labels and classifiers inside the call to 'last' must match");
        this.assertFails(String.format(query, "PREV(LAST(A.Tradeday + length(CLASSIFIER())))")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:200: All labels and classifiers inside the call to 'last' must match");
    }

    @Test
    public void testClassifierFunction() {
        String query = "SELECT M.Measure           FROM (VALUES (1, 1, 9), (1, 2, 8)) Ticker(Symbol, Tradeday, Price)                  MATCH_RECOGNIZE (                    ORDER BY Tradeday                    MEASURES %s AS Measure                    PATTERN (A B+)                    SUBSET U = (A, B)                    DEFINE B AS true                 ) AS M";
        this.analyze(String.format(query, "CLASSIFIER(A)"));
        this.analyze(String.format(query, "CLASSIFIER(U)"));
        this.analyze(String.format(query, "CLASSIFIER()"));
        this.assertFails(String.format(query, "CLASSIFIER(A, B)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("line 1:195: CLASSIFIER pattern recognition function takes no arguments or 1 argument");
        this.assertFails(String.format(query, "CLASSIFIER(A.x)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:206: CLASSIFIER function argument should be primary pattern variable or subset name. Actual: DereferenceExpression");
        this.assertFails(String.format(query, "CLASSIFIER(\"$\")")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("line 1:206: $ is not a primary pattern variable or subset name");
        this.assertFails(String.format(query, "CLASSIFIER(C)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("line 1:206: C is not a primary pattern variable or subset name");
    }

    @Test
    public void testMatchNumberFunction() {
        String query = "SELECT M.Measure           FROM (VALUES (1, 1, 9), (1, 2, 8)) Ticker(Symbol, Tradeday, Price)                  MATCH_RECOGNIZE (                    ORDER BY Tradeday                    MEASURES %s AS Measure                    PATTERN (A B+)                    SUBSET U = (A, B)                    DEFINE B AS true                 ) AS M";
        this.analyze(String.format(query, "MATCH_NUMBER()"));
        this.assertFails(String.format(query, "MATCH_NUMBER(A)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("line 1:195: MATCH_NUMBER pattern recognition function takes no arguments");
    }

    @Test
    public void testPatternAggregations() {
        String query = "SELECT M.Measure           FROM (VALUES (1, 1, 1), (2, 2, 2)) Ticker(Symbol, Tradeday, Price)                  MATCH_RECOGNIZE (                    MEASURES %s AS Measure                    PATTERN (A B+)                    SUBSET U = (A, B)                    DEFINE B AS %s                  ) AS M";
        String define = "true";
        this.assertFails(String.format(query, "max(Price) OVER ()", define)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_WINDOW}).hasMessage("line 1:158: Cannot nest window functions or row pattern measures inside pattern recognition expressions");
        this.assertFails(String.format(query, "max(Price) FILTER (WHERE true)", define)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:158: Cannot use FILTER with max aggregate function in pattern recognition context");
        this.assertFails(String.format(query, "max(Price ORDER BY Tradeday)", define)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:158: Cannot use ORDER BY with max aggregate function in pattern recognition context");
        this.assertFails(String.format(query, "LISTAGG(Price) WITHIN GROUP (ORDER BY Tradeday)", define)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:158: Cannot use ORDER BY with listagg aggregate function in pattern recognition context");
        this.assertFails(String.format(query, "max(DISTINCT Price)", define)).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:158: Cannot use DISTINCT with max aggregate function in pattern recognition context");
        String measure = "true";
        this.assertFails(String.format(query, measure, "max(Price) OVER () > 0")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_WINDOW}).hasMessage("line 1:276: Cannot nest window functions or row pattern measures inside pattern recognition expressions");
        this.assertFails(String.format(query, measure, "max(Price) FILTER (WHERE true) > 0")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:276: Cannot use FILTER with max aggregate function in pattern recognition context");
        this.assertFails(String.format(query, measure, "max(Price ORDER BY Tradeday) > 0")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:276: Cannot use ORDER BY with max aggregate function in pattern recognition context");
        this.assertFails(String.format(query, measure, "LISTAGG(Price) WITHIN GROUP (ORDER BY Tradeday) IS NOT NULL")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:276: Cannot use ORDER BY with listagg aggregate function in pattern recognition context");
        this.assertFails(String.format(query, measure, "max(DISTINCT Price) > 0")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:276: Cannot use DISTINCT with max aggregate function in pattern recognition context");
    }

    @Test
    public void testInvalidNestingInPatternAggregations() {
        String query = "SELECT M.Measure           FROM (VALUES (1, 1, 1), (2, 2, 2)) Ticker(Symbol, Tradeday, Price)                  MATCH_RECOGNIZE (                    MEASURES %s AS Measure                    PATTERN (A B+)                    SUBSET U = (A, B)                    DEFINE B AS true                  ) AS M";
        this.assertFails(String.format(query, "max(1 + min(Price))")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NESTED_AGGREGATION}).hasMessage("line 1:166: Cannot nest min aggregate function inside max function");
        this.assertFails(String.format(query, "max(1 + LAST(Price))")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_NAVIGATION_NESTING}).hasMessage("line 1:166: Cannot nest last pattern navigation function inside max function");
    }

    @Test
    public void testLabelsInPatternAggregations() {
        String query = "SELECT M.Measure           FROM (VALUES (1, 1, 1), (2, 2, 2)) Ticker(Symbol, Tradeday, Price)                  MATCH_RECOGNIZE (                    MEASURES %s AS Measure                    PATTERN (A B+)                    SUBSET U = (A, B)                    DEFINE B AS true                 ) AS M";
        this.analyze(String.format(query, "count()"));
        this.analyze(String.format(query, "count(Symbol)"));
        this.analyze(String.format(query, "count(A.Symbol)"));
        this.analyze(String.format(query, "count(U.Symbol)"));
        this.analyze(String.format(query, "count(CLASSIFIER())"));
        this.analyze(String.format(query, "count(CLASSIFIER(A))"));
        this.analyze(String.format(query, "count(CLASSIFIER(U))"));
        this.analyze(String.format(query, "count(Price < 5 OR CLASSIFIER() > 'X')"));
        this.analyze(String.format(query, "count(B.Price < 5 OR CLASSIFIER(B) > 'X')"));
        this.analyze(String.format(query, "count(U.Price < 5 OR CLASSIFIER(U) > 'X')"));
        this.assertFails(String.format(query, "count(B.Price < 5 OR Price > 5)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:158: All labels and classifiers inside the call to 'count' must match");
        this.assertFails(String.format(query, "count(B.Price < 5 OR A.Price > 5)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:158: All labels and classifiers inside the call to 'count' must match");
        this.assertFails(String.format(query, "count(CLASSIFIER(A) < 'X' OR CLASSIFIER(B) > 'Y')")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:158: All labels and classifiers inside the call to 'count' must match");
        this.assertFails(String.format(query, "count(Price < 5 OR CLASSIFIER(B) > 'Y')")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:158: All labels and classifiers inside the call to 'count' must match");
        this.assertFails(String.format(query, "count(A.Price < 5 OR CLASSIFIER(B) > 'Y')")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:158: All labels and classifiers inside the call to 'count' must match");
        this.analyze(String.format(query, "max_by(Price, Symbol)"));
        this.analyze(String.format(query, "max_by(A.Price, A.Symbol)"));
        this.analyze(String.format(query, "max_by(U.Price, U.Symbol)"));
        this.analyze(String.format(query, "max_by(Price, 1)"));
        this.analyze(String.format(query, "max_by(A.Price, 1)"));
        this.analyze(String.format(query, "max_by(U.Price, 1)"));
        this.analyze(String.format(query, "max_by(1, 1)"));
        this.analyze(String.format(query, "max_by(1, Price)"));
        this.analyze(String.format(query, "max_by(1, A.Price)"));
        this.analyze(String.format(query, "max_by(1, U.Price)"));
        this.assertFails(String.format(query, "max_by(U.Price, A.Price)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:158: All labels and classifiers inside the call to 'max_by' must match");
        this.assertFails(String.format(query, "max_by(A.Symbol, A.Price + B.price)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:158: All labels and classifiers inside the call to 'max_by' must match");
    }

    @Test
    public void testRunningAndFinalPatternAggregations() {
        String query = "SELECT M.Measure           FROM (VALUES (1, 1, 1), (2, 2, 2)) Ticker(Symbol, Tradeday, Price)                  MATCH_RECOGNIZE (                    MEASURES %s AS Measure                    PATTERN (A B+)                    SUBSET U = (A, B)                    DEFINE B AS %s                 ) AS M";
        this.analyze(String.format(query, "RUNNING avg(A.Price)", "true"));
        this.analyze(String.format(query, "FINAL avg(A.Price)", "true"));
        this.analyze(String.format(query, "true", "RUNNING avg(A.Price) > 5"));
        this.assertFails(String.format(query, "true", "FINAL avg(A.Price) > 5")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PROCESSING_MODE}).hasMessage("line 1:276: FINAL semantics is not supported in DEFINE clause");
        this.analyze(String.format(query, "RUNNING count(*)", "count(*) >= 0"));
        this.analyze(String.format(query, "FINAL count(*)", "count(*) >= 0"));
        this.analyze(String.format(query, "RUNNING count()", "count() >= 0"));
        this.analyze(String.format(query, "FINAL count()", "count() >= 0"));
        this.analyze(String.format(query, "RUNNING count(A.*)", "count(B.*) >= 0"));
        this.analyze(String.format(query, "FINAL count(U.*)", "count(U.*) >= 0"));
    }

    @Test
    public void testRowPatternCountFunction() {
        String query = "SELECT M.Measure           FROM (VALUES (1, 1, 1), (2, 2, 2)) Ticker(Symbol, Tradeday, Price)                  MATCH_RECOGNIZE (                    MEASURES %s AS Measure                    PATTERN (A B+)                    SUBSET U = (A, B)                    DEFINE A AS true                 ) AS M";
        this.analyze(String.format(query, "count(*)"));
        this.analyze(String.format(query, "count()"));
        this.analyze(String.format(query, "count(B.*)"));
        this.analyze(String.format(query, "count(U.*)"));
        this.assertFails("SELECT count(A.*) FROM (VALUES 1) t(a)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("line 1:14: label.* syntax is only supported as the only argument of row pattern count function");
        this.assertFails(String.format(query, "lower(A.*)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("line 1:164: label.* syntax is only supported as the only argument of row pattern count function");
        this.assertFails(String.format(query, "min(A.*)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("line 1:162: label.* syntax is only supported as the only argument of row pattern count function");
        this.assertFails(String.format(query, "count(X.*)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("line 1:164: X is not a primary pattern variable or subset name");
    }

    @Test
    public void testAnalyzeFreshMaterializedView() {
        this.analyze("SELECT * FROM fresh_materialized_view");
    }

    @Test
    public void testAnalyzeInvalidFreshMaterializedView() {
        this.assertFails("SELECT * FROM fresh_materialized_view_mismatched_column_count").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_VIEW}).hasMessage("line 1:15: storage table column count (2) does not match column count derived from the materialized view query analysis (1)");
        this.assertFails("SELECT * FROM fresh_materialized_view_mismatched_column_name").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_VIEW}).hasMessage("line 1:15: column [b] of type bigint projected from storage table at position 1 has a different name from column [c] of type bigint stored in materialized view definition");
        this.assertFails("SELECT * FROM fresh_materialized_view_mismatched_column_type").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_VIEW}).hasMessage("line 1:15: cannot cast column [b] of type bigint projected from storage table at position 1 into column [b] of type row(tinyint) stored in view definition");
    }

    @Test
    public void testAnalyzeMaterializedViewWithAccessControl() {
        TestingAccessControlManager accessControlManager = new TestingAccessControlManager(this.transactionManager, (EventListenerManager)TestingEventListenerManager.emptyEventListenerManager(), new SecretsResolver((Map)ImmutableMap.of()));
        accessControlManager.setSystemAccessControls(List.of(AllowAllSystemAccessControl.INSTANCE));
        this.analyze("SELECT * FROM fresh_materialized_view");
        accessControlManager.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"t2.a", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.analyze("SELECT * FROM fresh_materialized_view");
        accessControlManager.deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"fresh_materialized_view.a", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertFails(CLIENT_SESSION, "SELECT * FROM fresh_materialized_view", (AccessControl)accessControlManager).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.PERMISSION_DENIED}).hasMessage("Access Denied: Cannot select from columns [a, b] in table or view tpch.s1.fresh_materialized_view");
    }

    @Test
    public void testJsonContextItemType() {
        this.analyze("SELECT JSON_EXISTS(json_column, 'lax $.abs()') FROM (VALUES '-1', 'ala') t(json_column)");
        this.analyze("SELECT JSON_EXISTS(json_column, 'lax $.abs()') FROM (VALUES X'65683F', X'65683E') t(json_column)");
        this.assertFails("SELECT JSON_EXISTS(json_column, 'lax $.abs()') FROM (VALUES -1, -2) t(json_column)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:20: Cannot read input of type integer as JSON using formatting JSON");
    }

    @Test
    public void testJsonContextItemFormat() {
        this.analyze("SELECT JSON_EXISTS(json_column, 'lax $.abs()') FROM (VALUES '-1', 'ala') t(json_column)");
        this.analyze("SELECT JSON_EXISTS(json_column, 'lax $.abs()') FROM (VALUES X'65683F', X'65683E') t(json_column)");
        this.analyze("SELECT JSON_EXISTS(json_column FORMAT JSON, 'lax $.abs()') FROM (VALUES '-1', 'ala') t(json_column)");
        this.analyze("SELECT JSON_EXISTS(json_column FORMAT JSON ENCODING UTF8, 'lax $.abs()') FROM (VALUES X'1A', X'2B') t(json_column)");
        this.analyze("SELECT JSON_EXISTS(json_column FORMAT JSON ENCODING UTF16, 'lax $.abs()') FROM (VALUES X'1A', X'2B') t(json_column)");
        this.analyze("SELECT JSON_EXISTS(json_column FORMAT JSON ENCODING UTF32, 'lax $.abs()') FROM (VALUES X'1A', X'2B') t(json_column)");
        this.assertFails("SELECT JSON_EXISTS(json_column FORMAT JSON ENCODING UTF8, 'lax $.abs()') FROM (VALUES '-1', 'ala') t(json_column)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:20: Cannot read input of type varchar(3) as JSON using formatting JSON ENCODING UTF8");
    }

    @Test
    public void testJsonPathParameterNames() {
        this.analyze("SELECT JSON_EXISTS(                            json_column,                            'lax $.abs()' PASSING                                                    1 AS parameter_1,                                                    'x' AS parameter_2,                                                    true AS parameter_3)        FROM (VALUES '-1', 'ala') t(json_column)");
        this.assertFails("SELECT JSON_EXISTS(                            json_column,                            'lax $.abs()' PASSING                                                    1 AS parameter_1,                                                    'x' AS parameter_2,                                                    true AS parameter_1)        FROM (VALUES '-1', 'ala') t(json_column)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_PARAMETER_NAME}).hasMessage("line 1:309: PARAMETER_1 JSON path parameter is specified more than once");
    }

    @Test
    public void testCaseSensitiveNames() {
        this.analyze("SELECT JSON_EXISTS(json_column, 'lax $some_name' PASSING 1 AS \"some_name\") FROM (VALUES '-1', 'ala') t(json_column)");
        this.analyze("SELECT JSON_EXISTS(json_column, 'lax $SOME_NAME' PASSING 1 AS some_name) FROM (VALUES '-1', 'ala') t(json_column)");
        this.assertFails("SELECT JSON_EXISTS(json_column, 'lax $some_name' PASSING 1 AS some_name) FROM (VALUES '-1', 'ala') t(json_column)").hasMessage("line 1:33: no value passed for parameter some_name. Try quoting \"some_name\" in the PASSING clause to match case");
        this.assertFails("SELECT JSON_EXISTS(json_column, 'lax $some_NAME' PASSING 1 AS some_name) FROM (VALUES '-1', 'ala') t(json_column)").hasMessage("line 1:33: no value passed for parameter some_NAME. Try quoting \"some_NAME\" in the PASSING clause to match case");
        this.assertFails("SELECT JSON_EXISTS(json_column, 'lax $some_name' PASSING 1 AS some_other_name) FROM (VALUES '-1', 'ala') t(json_column)").hasMessage("line 1:33: no value passed for parameter some_name");
    }

    @Test
    public void testJsonPathParameterFormats() {
        this.analyze("SELECT JSON_EXISTS(                            json_column,                            'lax $.abs()' PASSING 'x' FORMAT JSON AS parameter_1)        FROM (VALUES '-1', 'ala') t(json_column)");
        this.analyze("SELECT JSON_EXISTS(                            json_column,                            'lax $.abs()' PASSING X'65683F' FORMAT JSON ENCODING UTF8 AS parameter_1)        FROM (VALUES '-1', 'ala') t(json_column)");
        this.assertFails("SELECT JSON_EXISTS(                            json_column,                            'lax $.abs()' PASSING 1 FORMAT JSON AS parameter_1)        FROM (VALUES '-1', 'ala') t(json_column)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:110: Cannot read input of type integer as JSON using formatting JSON");
        this.assertFails("SELECT JSON_EXISTS(                            json_column,                            'lax $.abs()' PASSING 1 FORMAT JSON ENCODING UTF8 AS parameter_1)        FROM (VALUES '-1', 'ala') t(json_column)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:110: Cannot read input of type integer as JSON using formatting JSON ENCODING UTF8");
        this.analyze("SELECT JSON_EXISTS(                            json_column,                            'lax $.abs()' PASSING JSON_QUERY(json_column, 'lax $.abs()' RETURNING varchar FORMAT JSON) FORMAT JSON AS parameter_1)        FROM (VALUES '-1', 'ala') t(json_column)");
        this.analyze("SELECT JSON_EXISTS(                            json_column,                            'lax $.abs()' PASSING JSON_QUERY(json_column, 'lax $.abs()' RETURNING varbinary FORMAT JSON) FORMAT JSON ENCODING UTF8 AS parameter_1)        FROM (VALUES '-1', 'ala') t(json_column)");
        this.analyze("SELECT JSON_EXISTS(                            json_column,                            'lax $.abs()' PASSING JSON_QUERY(json_column, 'lax $.abs()' RETURNING varchar FORMAT JSON) AS parameter_1)        FROM (VALUES '-1', 'ala') t(json_column)");
    }

    @Test
    public void testJsonPathParameterTypes() {
        this.analyze("SELECT JSON_EXISTS(                            json_column,                            'lax $.abs()' PASSING INTERVAL '2' DAY AS parameter_1)        FROM (VALUES '-1', 'ala') t(json_column)");
        this.analyze("SELECT JSON_EXISTS('[]', 'lax $[2]' PASSING INTERVAL '2' DAY AS parameter_interval)");
        this.analyze("SELECT JSON_EXISTS('[]', 'lax $[2]' PASSING UUID '12151fd2-7586-11e9-8f9e-2a86e4085a59' AS parameter_uuid)");
        this.assertFails("SELECT JSON_EXISTS('[]', 'lax $[2]' PASSING approx_set(1) AS parameter_hll)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:8: Unsupported type of JSON path parameter: HyperLogLog");
    }

    @Test
    public void testJsonValueReturnedType() {
        this.analyze("SELECT JSON_VALUE(                    json_column,                    'lax $.type()'                   RETURNING char(30))        FROM (VALUES '-1', 'ala') t(json_column)");
        this.analyze("SELECT JSON_VALUE(                    json_column,                    'lax $.size()'                   RETURNING bigint)        FROM (VALUES '-1', 'ala') t(json_column)");
        this.assertFails("SELECT JSON_VALUE(                    json_column,                    'lax $.type()'                   RETURNING tdigest)        FROM (VALUES '-1', 'ala') t(json_column)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:8: Invalid return type of function JSON_VALUE: tdigest");
        this.assertFails("SELECT JSON_VALUE(                    json_column,                    'lax $.type()'                   RETURNING some_type(10))        FROM (VALUES '-1', 'ala') t(json_column)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:8: Unknown type: some_type(10)");
    }

    @Test
    public void testJsonValueDefaultValues() {
        this.analyze("SELECT JSON_VALUE(                    json_column,                    'lax $.double()'                   RETURNING double                   DEFAULT 1e0 ON EMPTY)        FROM (VALUES '-1', 'ala') t(json_column)");
        this.analyze("SELECT JSON_VALUE(                    json_column,                    'lax $.double()'                   RETURNING double                   DEFAULT 1.0 ON EMPTY)        FROM (VALUES '-1', 'ala') t(json_column)");
        this.assertFails("SELECT JSON_VALUE(                    json_column,                    'lax $.double()'                   RETURNING double                   DEFAULT 'text' ON EMPTY)        FROM (VALUES '-1', 'ala') t(json_column)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:149: Function JSON_VALUE default ON EMPTY result must evaluate to a double (actual: varchar(4))");
        this.analyze("SELECT JSON_VALUE(                    json_column,                    'lax $.double()'                   RETURNING double                   DEFAULT 1e0 ON ERROR)        FROM (VALUES '-1', 'ala') t(json_column)");
        this.analyze("SELECT JSON_VALUE(                    json_column,                    'lax $.double()'                   RETURNING double                   DEFAULT 1.0 ON ERROR)        FROM (VALUES '-1', 'ala') t(json_column)");
        this.assertFails("SELECT JSON_VALUE(                    json_column,                    'lax $.double()'                   RETURNING double                   DEFAULT 'text' ON ERROR)        FROM (VALUES '-1', 'ala') t(json_column)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:149: Function JSON_VALUE default ON ERROR result must evaluate to a double (actual: varchar(4))");
    }

    @Test
    public void testJsonQueryOutputTypeAndFormat() {
        this.analyze("SELECT JSON_QUERY(                    json_column,                    'lax $.type()'                   RETURNING varchar)        FROM (VALUES '-1', 'ala') t(json_column)");
        this.analyze("SELECT JSON_QUERY(                    json_column,                    'lax $.type()'                   RETURNING varchar FORMAT JSON)        FROM (VALUES '-1', 'ala') t(json_column)");
        this.analyze("SELECT JSON_QUERY(                    json_column,                    'lax $.type()'                   RETURNING char(5) FORMAT JSON)        FROM (VALUES '-1', 'ala') t(json_column)");
        this.analyze("SELECT JSON_QUERY(                    json_column,                    'lax $.type()'                   RETURNING varbinary FORMAT JSON ENCODING UTF8)        FROM (VALUES '-1', 'ala') t(json_column)");
        this.assertFails("SELECT JSON_QUERY(                    json_column,                    'lax $.type()'                   RETURNING some_type(10))        FROM (VALUES '-1', 'ala') t(json_column)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:8: Unknown type: some_type(10)");
        this.assertFails("SELECT JSON_QUERY(                    json_column,                    'lax $.type()'                   RETURNING double)        FROM (VALUES '-1', 'ala') t(json_column)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:8: Cannot output JSON value as double using formatting JSON");
        this.assertFails("SELECT JSON_QUERY(                    json_column,                    'lax $.type()'                   RETURNING varchar FORMAT JSON ENCODING UTF8)        FROM (VALUES '-1', 'ala') t(json_column)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:8: Cannot output JSON value as varchar using formatting JSON ENCODING UTF8");
    }

    @Test
    public void testJsonQueryQuotesBehavior() {
        this.analyze("SELECT JSON_QUERY(                    json_column,                    'lax $.type()'                   OMIT QUOTES ON SCALAR STRING)        FROM (VALUES '-1', 'ala') t(json_column)");
        this.assertFails("SELECT JSON_QUERY(                    json_column,                    'lax $.type()'                    WITH ARRAY WRAPPER                    OMIT QUOTES ON SCALAR STRING)        FROM (VALUES '-1', 'ala') t(json_column)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("line 1:8: OMIT QUOTES behavior specified with WITH UNCONDITIONAL ARRAY WRAPPER behavior");
    }

    @Test
    public void testJsonExistsInAggregationContext() {
        this.analyze("SELECT JSON_EXISTS('-5', 'lax $.abs()') FROM (VALUES '-1', '-2') t(a) GROUP BY a");
        this.analyze("SELECT JSON_EXISTS(a, 'lax $.abs()') FROM (VALUES '-1', '-2') t(a) GROUP BY a");
        this.analyze("SELECT JSON_EXISTS(a, 'lax $.abs() + $some_number' PASSING b AS \"some_number\") FROM (VALUES ('-1', 10, 100), ('-2', 20, 200)) t(a, b, c) GROUP BY a, b");
        this.assertFails("SELECT JSON_EXISTS(c, 'lax $.abs() + $some_number' PASSING b AS \"some_number\") FROM (VALUES ('-1', 10, '100'), ('-2', 20, '200')) t(a, b, c) GROUP BY a, b").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessage("line 1:8: 'JSON_EXISTS(c FORMAT JSON, 'lax $.abs() + $some_number' PASSING b AS \"some_number\" FALSE ON ERROR)' must be an aggregate expression or appear in GROUP BY clause");
        this.assertFails("SELECT JSON_EXISTS(b, 'lax $.abs() + $some_number' PASSING c AS \"some_number\") FROM (VALUES (-1, '10', 100), (-2, '20', 200)) t(a, b, c) GROUP BY a, b").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessage("line 1:8: 'JSON_EXISTS(b FORMAT JSON, 'lax $.abs() + $some_number' PASSING c AS \"some_number\" FALSE ON ERROR)' must be an aggregate expression or appear in GROUP BY clause");
    }

    @Test
    public void testJsonValueInAggregationContext() {
        this.analyze("SELECT JSON_VALUE('-5', 'lax $.abs()') FROM (VALUES '-1', '-2') t(a) GROUP BY a");
        this.analyze("SELECT JSON_VALUE(a, 'lax $.abs()') FROM (VALUES '-1', '-2') t(a) GROUP BY a");
        this.analyze("SELECT JSON_VALUE(a, 'lax $.abs() + $some_number' PASSING b AS \"some_number\") FROM (VALUES ('-1', 10, 100), ('-2', 20, 200)) t(a, b, c) GROUP BY a, b");
        this.analyze("SELECT JSON_VALUE(a, 'lax $.abs() + $some_number' PASSING b AS \"some_number\" DEFAULT lower(b) ON EMPTY DEFAULT upper(b) ON ERROR) FROM (VALUES ('-1', '10', 100), ('-2', '20', 200)) t(a, b, c) GROUP BY a, b");
        this.assertFails("SELECT JSON_VALUE(c, 'lax $.abs() + $some_number' PASSING b AS \"some_number\") FROM (VALUES ('-1', 10, '100'), ('-2', 20, '200')) t(a, b, c) GROUP BY a, b").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessage("line 1:8: 'JSON_VALUE(c FORMAT JSON, 'lax $.abs() + $some_number' PASSING b AS \"some_number\" NULL ON EMPTY NULL ON ERROR)' must be an aggregate expression or appear in GROUP BY clause");
        this.assertFails("SELECT JSON_VALUE(b, 'lax $.abs() + $some_number' PASSING c AS \"some_number\") FROM (VALUES (-1, '10', 100), (-2, '20', 200)) t(a, b, c) GROUP BY a, b").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessage("line 1:8: 'JSON_VALUE(b FORMAT JSON, 'lax $.abs() + $some_number' PASSING c AS \"some_number\" NULL ON EMPTY NULL ON ERROR)' must be an aggregate expression or appear in GROUP BY clause");
        this.assertFails("SELECT JSON_VALUE(b, 'lax $.abs() + $some_number' PASSING b AS \"some_number\" DEFAULT c ON EMPTY) FROM (VALUES (-1, '10', '100'), (-2, '20', '200')) t(a, b, c) GROUP BY a, b").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessage("line 1:8: 'JSON_VALUE(b FORMAT JSON, 'lax $.abs() + $some_number' PASSING b AS \"some_number\" DEFAULT c ON EMPTY NULL ON ERROR)' must be an aggregate expression or appear in GROUP BY clause");
        this.assertFails("SELECT JSON_VALUE(b, 'lax $.abs() + $some_number' PASSING b AS \"some_number\" DEFAULT c ON ERROR) FROM (VALUES (-1, '10', '100'), (-2, '20', '200')) t(a, b, c) GROUP BY a, b").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessage("line 1:8: 'JSON_VALUE(b FORMAT JSON, 'lax $.abs() + $some_number' PASSING b AS \"some_number\" NULL ON EMPTY DEFAULT c ON ERROR)' must be an aggregate expression or appear in GROUP BY clause");
    }

    @Test
    public void testJsonQueryInAggregationContext() {
        this.analyze("SELECT JSON_QUERY('-5', 'lax $.abs()') FROM (VALUES '-1', '-2') t(a) GROUP BY a");
        this.analyze("SELECT JSON_QUERY(a, 'lax $.abs()') FROM (VALUES '-1', '-2') t(a) GROUP BY a");
        this.analyze("SELECT JSON_QUERY(a, 'lax $.abs() + $some_number' PASSING b AS \"some_number\") FROM (VALUES ('-1', 10, 100), ('-2', 20, 200)) t(a, b, c) GROUP BY a, b");
        this.assertFails("SELECT JSON_QUERY(c, 'lax $.abs() + $some_number' PASSING b AS \"some_number\") FROM (VALUES ('-1', 10, '100'), ('-2', 20, '200')) t(a, b, c) GROUP BY a, b").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessage("line 1:8: 'JSON_QUERY(c FORMAT JSON, 'lax $.abs() + $some_number' PASSING b AS \"some_number\" WITHOUT ARRAY WRAPPER NULL ON EMPTY NULL ON ERROR)' must be an aggregate expression or appear in GROUP BY clause");
        this.assertFails("SELECT JSON_QUERY(b, 'lax $.abs() + $some_number' PASSING c AS \"some_number\") FROM (VALUES (-1, '10', 100), (-2, '20', 200)) t(a, b, c) GROUP BY a, b").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessage("line 1:8: 'JSON_QUERY(b FORMAT JSON, 'lax $.abs() + $some_number' PASSING c AS \"some_number\" WITHOUT ARRAY WRAPPER NULL ON EMPTY NULL ON ERROR)' must be an aggregate expression or appear in GROUP BY clause");
    }

    @Test
    public void testJsonObjectInputTypes() {
        this.analyze("SELECT JSON_OBJECT(VARCHAR 'key' : 1)");
        this.analyze("SELECT JSON_OBJECT(CAST('key' AS varchar(100)) : 1)");
        this.analyze("SELECT JSON_OBJECT(CAST('key' AS char(100)) : 1)");
        this.assertFails("SELECT JSON_OBJECT(null : 1)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("line 1:20: Invalid type of JSON object key: unknown");
        this.assertFails("SELECT JSON_OBJECT(0 : 1)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("line 1:20: Invalid type of JSON object key: integer");
        this.analyze("SELECT JSON_OBJECT('key' : 1)");
        this.analyze("SELECT JSON_OBJECT('key' : true)");
        this.analyze("SELECT JSON_OBJECT('key' : 'value')");
        this.analyze("SELECT JSON_OBJECT('key' : DATE '2001-01-31')");
        this.assertFails("SELECT JSON_OBJECT('key' : approx_set(1))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:8: Unsupported type of value passed to JSON_OBJECT function: HyperLogLog");
    }

    @Test
    public void testJsonObjectValueWithFormat() {
        this.analyze("SELECT JSON_OBJECT('key' : '[1, 2, 3]' FORMAT JSON)");
        this.assertFails("SELECT JSON_OBJECT('key' : 1e0 FORMAT JSON)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:28: Cannot read input of type double as JSON using formatting JSON");
        this.analyze("SELECT JSON_OBJECT('key' : '[1, 2, 3]' FORMAT JSON WITHOUT UNIQUE KEYS)");
        this.assertFails("SELECT JSON_OBJECT('key' : '[1, 2, 3]' FORMAT JSON WITH UNIQUE KEYS)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:8: WITH UNIQUE KEYS behavior is not supported for JSON_OBJECT function when input expression has FORMAT");
    }

    @Test
    public void testJsonObjectReturnedTypeAndFormat() {
        this.analyze("SELECT JSON_OBJECT('key' : 1 RETURNING varchar)");
        this.assertFails("SELECT JSON_OBJECT('key' : 1 RETURNING some_type)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:8: Unknown type: some_type");
        this.assertFails("SELECT JSON_OBJECT('key' : 1 RETURNING integer)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:8: Cannot output JSON value as integer using formatting JSON");
        this.assertFails("SELECT JSON_OBJECT('key' : 1 RETURNING integer FORMAT JSON ENCODING UTF16)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:8: Cannot output JSON value as integer using formatting JSON ENCODING UTF16");
    }

    @Test
    public void testJsonObjectInAggregationContext() {
        this.analyze("SELECT JSON_OBJECT('key' : 1) FROM (VALUES ('x', 1), ('y', 2)) t(a, b) GROUP BY a");
        this.analyze("SELECT JSON_OBJECT(a : 1) FROM (VALUES ('x', 1), ('y', 2)) t(a, b) GROUP BY a");
        this.analyze("SELECT JSON_OBJECT('key' : a) FROM (VALUES ('x', 1), ('y', 2)) t(a, b) GROUP BY a");
        this.assertFails("SELECT JSON_OBJECT('key' : a) FROM (VALUES ('x', 1), ('y', 2)) t(a, b) GROUP BY b").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessage("line 1:8: 'JSON_OBJECT(KEY 'key' VALUE a NULL ON NULL WITHOUT UNIQUE KEYS)' must be an aggregate expression or appear in GROUP BY clause");
        this.assertFails("SELECT JSON_OBJECT(a : 1) FROM (VALUES ('x', 1), ('y', 2)) t(a, b) GROUP BY b").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessage("line 1:8: 'JSON_OBJECT(KEY a VALUE 1 NULL ON NULL WITHOUT UNIQUE KEYS)' must be an aggregate expression or appear in GROUP BY clause");
    }

    @Test
    public void testJsonArrayInputTypes() {
        this.analyze("SELECT JSON_ARRAY(1)");
        this.analyze("SELECT JSON_ARRAY(true)");
        this.analyze("SELECT JSON_ARRAY('element')");
        this.analyze("SELECT JSON_ARRAY(DATE '2001-01-31')");
        this.assertFails("SELECT JSON_ARRAY(approx_set(1))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:8: Unsupported type of value passed to JSON_ARRAY function: HyperLogLog");
    }

    @Test
    public void testJsonArrayElementWithFormat() {
        this.analyze("SELECT JSON_ARRAY('{\"key\" : 1}' FORMAT JSON)");
        this.assertFails("SELECT JSON_ARRAY(1e0 FORMAT JSON)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:19: Cannot read input of type double as JSON using formatting JSON");
    }

    @Test
    public void testJsonArrayReturnedTypeAndFormat() {
        this.analyze("SELECT JSON_ARRAY(true RETURNING varchar)");
        this.assertFails("SELECT JSON_ARRAY(true RETURNING some_type)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:8: Unknown type: some_type");
        this.assertFails("SELECT JSON_ARRAY(true RETURNING integer)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:8: Cannot output JSON value as integer using formatting JSON");
        this.assertFails("SELECT JSON_ARRAY(true RETURNING integer FORMAT JSON ENCODING UTF16)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:8: Cannot output JSON value as integer using formatting JSON ENCODING UTF16");
    }

    @Test
    public void testJsonArrayInAggregationContext() {
        this.analyze("SELECT JSON_ARRAY(true) FROM (VALUES ('x', 1), ('y', 2)) t(a, b) GROUP BY a");
        this.analyze("SELECT JSON_ARRAY(a) FROM (VALUES ('x', 1), ('y', 2)) t(a, b) GROUP BY a");
        this.assertFails("SELECT JSON_ARRAY(b) FROM (VALUES ('x', 1), ('y', 2)) t(a, b) GROUP BY a").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_AGGREGATE}).hasMessage("line 1:8: 'JSON_ARRAY(b ABSENT ON NULL)' must be an aggregate expression or appear in GROUP BY clause");
    }

    @Test
    public void testJsonPathName() {
        this.assertFails("SELECT JSON_EXISTS('[1, 2, 3]', 'lax $[2]' AS path_name)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PATH}).hasMessage("line 1:47: JSON path name is not allowed in JSON_EXISTS function");
        this.assertFails("SELECT JSON_QUERY('[1, 2, 3]', 'lax $[2]' AS path_name)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PATH}).hasMessage("line 1:46: JSON path name is not allowed in JSON_QUERY function");
        this.assertFails("SELECT JSON_VALUE('[1, 2, 3]', 'lax $[2]' AS path_name)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PATH}).hasMessage("line 1:46: JSON path name is not allowed in JSON_VALUE function");
    }

    @Test
    public void testTableFunctionNotFound() {
        this.assertFails("SELECT * FROM TABLE(non_existent_table_function())").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_NOT_FOUND}).hasMessage("line 1:21: Table function 'non_existent_table_function' not registered");
    }

    @Test
    public void testTableFunctionArguments() {
        this.assertFails("SELECT * FROM TABLE(system.two_arguments_function(1, 2, 3))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:51: Too many arguments. Expected at most 2 arguments, got 3 arguments");
        this.analyze("SELECT * FROM TABLE(system.two_arguments_function('foo'))");
        this.analyze("SELECT * FROM TABLE(system.two_arguments_function(text => 'foo'))");
        this.analyze("SELECT * FROM TABLE(system.two_arguments_function('foo', 1))");
        this.analyze("SELECT * FROM TABLE(system.two_arguments_function(text => 'foo', number => 1))");
        this.assertFails("SELECT * FROM TABLE(system.two_arguments_function('foo', number => 1))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:51: All arguments must be passed by name or all must be passed positionally");
        this.assertFails("SELECT * FROM TABLE(system.two_arguments_function(text => 'foo', 1))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ARGUMENTS}).hasMessage("line 1:51: All arguments must be passed by name or all must be passed positionally");
        this.assertFails("SELECT * FROM TABLE(system.two_arguments_function(text => 'foo', text => 'bar'))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("line 1:66: Duplicate argument name: TEXT");
        this.assertFails("SELECT * FROM TABLE(system.two_arguments_function(text => 'foo', TeXt => 'bar'))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("line 1:66: Duplicate argument name: TEXT");
        this.assertFails("SELECT * FROM TABLE(system.two_arguments_function(text => 'foo', bar => 'bar'))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("line 1:66: Unexpected argument name: BAR");
        this.assertFails("SELECT * FROM TABLE(system.two_arguments_function(number => 1))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISSING_ARGUMENT}).hasMessage("line 1:51: Missing argument: TEXT");
    }

    @Test
    public void testTableArgument() {
        this.assertFails("SELECT * FROM TABLE(system.table_argument_function(input => my_schema.my_table_function(1)))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:52: Invalid table argument INPUT. Table functions are not allowed as table function arguments");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.analyze("SELECT * FROM TABLE(system.table_argument_function(input => my_schema.my_table_function(arg => 1)))")).isInstanceOf(ParsingException.class)).hasMessageContaining("line 1:93: mismatched input '=>'.");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.analyze("SELECT * FROM TABLE(system.table_argument_function(input => TABLE(my_schema.my_table_function(1))))")).isInstanceOf(ParsingException.class)).hasMessageContaining("line 1:94: mismatched input '('.");
        this.analyze("SELECT * FROM TABLE(system.table_argument_function(input => TABLE(t1)))");
        this.assertFails("SELECT * FROM TABLE(system.table_argument_function(input => t1))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("line 1:52: Invalid argument INPUT. Expected table, got expression");
        this.analyze("SELECT * FROM TABLE(system.table_argument_function(input => TABLE(SELECT * FROM t1)))");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.analyze("SELECT * FROM TABLE(system.table_argument_function(input => SELECT * FROM t1))")).isInstanceOf(ParsingException.class)).hasMessageContaining("line 1:61: mismatched input 'SELECT'.");
        this.analyze("SELECT *\nFROM\nt1\nCROSS JOIN\nLATERAL (SELECT * FROM TABLE(system.table_argument_function(input => TABLE(SELECT 1 WHERE a > 0))))\n");
        this.assertFails("SELECT * FROM TABLE(system.table_argument_function(input => 'foo'))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("line 1:52: Invalid argument INPUT. Expected table, got expression");
        this.assertFails("SELECT * FROM TABLE(system.table_argument_function(input => DESCRIPTOR(x int, y int)))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("line 1:52: Invalid argument INPUT. Expected table, got descriptor");
    }

    @Test
    public void testTableArgumentProperties() {
        this.analyze("SELECT * FROM TABLE(system.table_argument_function(\n    input => TABLE(t1)\n                      PARTITION BY a\n                      KEEP WHEN EMPTY\n                      ORDER BY b))\n");
        this.analyze("SELECT * FROM TABLE(system.table_argument_function(input => TABLE(t1) PARTITION BY \"a\"))");
        this.analyze("SELECT * FROM TABLE(system.table_argument_function(input => TABLE(t1) ORDER BY \"a\"))");
        this.assertFails("SELECT * FROM TABLE(system.table_argument_function(input => TABLE(SELECT CAST(ROW(1) AS ROW(x BIGINT)) a) PARTITION BY a.x))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessage("line 1:120: Column a.x is not present in the input relation");
        this.assertFails("SELECT * FROM TABLE(system.table_argument_function(input => TABLE(SELECT CAST(ROW(1) AS ROW(x BIGINT)) a) ORDER BY a.x))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessage("line 1:116: Column a.x is not present in the input relation");
        this.assertFails("SELECT * FROM TABLE(system.table_argument_row_semantics_function(input => TABLE(t1) PARTITION BY a))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("line 1:66: Invalid argument INPUT. Partitioning specified for table argument with row semantics");
        this.assertFails("SELECT * FROM TABLE(system.table_argument_function(input => TABLE(SELECT 1 a) PARTITION BY b))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessage("line 1:92: Column b is not present in the input relation");
        this.assertFails("SELECT * FROM TABLE(system.table_argument_function(input => TABLE(SELECT 1 a) ORDER BY 1))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_COLUMN_REFERENCE}).hasMessage("line 1:88: Expected column reference. Actual: 1");
        this.assertFails("SELECT * FROM TABLE(system.table_argument_function(input => TABLE(SELECT approx_set(1) a) PARTITION BY a))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:104: HyperLogLog is not comparable, and therefore cannot be used in PARTITION BY");
        this.assertFails("SELECT * FROM TABLE(system.table_argument_row_semantics_function(input => TABLE(t1) ORDER BY a))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("line 1:66: Invalid argument INPUT. Ordering specified for table argument with row semantics");
        this.assertFails("SELECT * FROM TABLE(system.table_argument_function(input => TABLE(SELECT 1 a) ORDER BY b))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessage("line 1:88: Column b is not present in the input relation");
        this.assertFails("SELECT * FROM TABLE(system.table_argument_function(input => TABLE(SELECT 1 a) ORDER BY 1))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_COLUMN_REFERENCE}).hasMessage("line 1:88: Expected column reference. Actual: 1");
        this.assertFails("SELECT * FROM TABLE(system.table_argument_function(input => TABLE(SELECT approx_set(1) a) ORDER BY a))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:100: HyperLogLog is not orderable, and therefore cannot be used in ORDER BY");
        this.assertFails("SELECT * FROM TABLE(system.table_argument_row_semantics_function(input => TABLE(t1) PRUNE WHEN EMPTY))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("line 1:85: Invalid argument INPUT. Empty behavior specified for table argument with row semantics");
        this.assertFails("SELECT * FROM TABLE(system.table_argument_row_semantics_function(input => TABLE(t1) KEEP WHEN EMPTY))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("line 1:85: Invalid argument INPUT. Empty behavior specified for table argument with row semantics");
    }

    @Test
    public void testDescriptorArgument() {
        this.analyze("SELECT * FROM TABLE(system.descriptor_argument_function(schema => DESCRIPTOR(x integer, y boolean)))");
        this.assertFails("SELECT * FROM TABLE(system.descriptor_argument_function(schema => DESCRIPTOR(1 + 2)))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("line 1:57: Invalid descriptor argument SCHEMA. Descriptors should be formatted as 'DESCRIPTOR(name [type], ...)'");
        this.assertFails("SELECT * FROM TABLE(system.descriptor_argument_function(schema => 1))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("line 1:57: Invalid argument SCHEMA. Expected descriptor, got expression");
        this.assertFails("SELECT * FROM TABLE(system.descriptor_argument_function(schema => TABLE(t1)))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("line 1:57: Invalid argument SCHEMA. Expected descriptor, got table");
        this.assertFails("SELECT * FROM TABLE(system.descriptor_argument_function(schema => DESCRIPTOR(x verybigint)))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:80: Unknown type: verybigint");
    }

    @Test
    public void testScalarArgument() {
        this.analyze("SELECT * FROM TABLE(system.two_arguments_function('foo', 1))");
        this.assertFails("SELECT * FROM TABLE(system.two_arguments_function(text => 'a', number => DESCRIPTOR(x integer, y boolean)))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("line 1:64: Invalid argument NUMBER. Expected expression, got descriptor");
        this.assertFails("SELECT * FROM TABLE(system.two_arguments_function(text => 'a', number => DESCRIPTOR(1 + 2)))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("line 1:64: 'descriptor' function is not allowed as a table function argument");
        this.assertFails("SELECT * FROM TABLE(system.two_arguments_function(text => 'a', number => TABLE(t1)))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("line 1:64: Invalid argument NUMBER. Expected expression, got table");
        this.assertFails("SELECT * FROM TABLE(system.two_arguments_function(text => 'a', number => (SELECT 1)))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_CONSTANT}).hasMessage("line 1:74: Constant expression cannot contain a subquery");
    }

    @Test
    public void testCopartitioning() {
        this.analyze("SELECT * FROM TABLE(system.two_table_arguments_function(\n    input1 => TABLE(t1) PARTITION BY (a, b),\n    input2 => TABLE(SELECT 1, 2) t1(x, y) PARTITION BY (x, y)\n    COPARTITION (t1, s1.t1)))\n");
        this.analyze("SELECT * FROM TABLE(system.two_table_arguments_function(\n    input1 => TABLE(tpch.s1.t1) PARTITION BY (a, b),\n    input2 => TABLE(s1.t2) PARTITION BY (a, b)\n    COPARTITION (t1, t2)))\n");
        this.assertFails("SELECT * FROM TABLE(system.two_table_arguments_function(\n    input1 => TABLE(t1) PARTITION BY (a, b),\n    input2 => TABLE(t2) PARTITION BY (a, b)\n    COPARTITION (t1, s1.foo)))\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_COPARTITIONING}).hasMessage("line 4:22: No table argument found for name: s1.foo");
        this.assertFails("SELECT * FROM TABLE(system.two_table_arguments_function(\n    input1 => TABLE(t1) PARTITION BY (a, b),\n    input2 => TABLE(t1) PARTITION BY (a, b)\n    COPARTITION (t1, t2)))\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_COPARTITIONING}).hasMessage("line 4:18: Ambiguous reference: multiple table arguments found for name: t1");
        this.assertFails("SELECT * FROM TABLE(system.two_table_arguments_function(\n    input1 => TABLE(SELECT 1, 2) t1(a, b) PARTITION BY (a, b),\n    input2 => TABLE(SELECT 3, 4) t1(c, d) PARTITION BY (c, d)\n    COPARTITION (t1, t2)))\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_COPARTITIONING}).hasMessage("line 4:18: Ambiguous reference: multiple table arguments found for name: t1");
        this.assertFails("SELECT * FROM TABLE(system.two_table_arguments_function(\n    input1 => TABLE(t1) PARTITION BY (a, b),\n    input2 => TABLE(t2) PARTITION BY (a, b)\n    COPARTITION (t1, t1)))\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_COPARTITIONING}).hasMessage("line 4:22: Multiple references to table argument: t1 in COPARTITION clause");
    }

    @Test
    public void testCopartitionColumns() {
        this.assertFails("SELECT * FROM TABLE(system.two_table_arguments_function(\n    input1 => TABLE(t1),\n    input2 => TABLE(t2) PARTITION BY (a, b)\n    COPARTITION (t1, t2)))\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_COPARTITIONING}).hasMessage("line 2:15: Table tpch.s1.t1 referenced in COPARTITION clause is not partitioned");
        this.assertFails("SELECT * FROM TABLE(system.two_table_arguments_function(\n    input1 => TABLE(t1) PARTITION BY (),\n    input2 => TABLE(t2) PARTITION BY ()\n    COPARTITION (t1, t2)))\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_COPARTITIONING}).hasMessage("line 2:15: No partitioning columns specified for table tpch.s1.t1 referenced in COPARTITION clause");
        this.assertFails("SELECT * FROM TABLE(system.two_table_arguments_function(\n    input1 => TABLE(t1) PARTITION BY (a, b),\n    input2 => TABLE(t2) PARTITION BY (a)\n    COPARTITION (t1, t2)))\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_COPARTITIONING}).hasMessage("line 4:18: Numbers of partitioning columns in copartitioned tables do not match");
        this.assertFails("SELECT * FROM TABLE(system.two_table_arguments_function(\n    input1 => TABLE(SELECT 1) t1(a) PARTITION BY (a),\n    input2 => TABLE(SELECT 'x') t2(b) PARTITION BY (b)\n    COPARTITION (t1, t2)))\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 4:18: Partitioning columns in copartitioned tables have incompatible types");
    }

    @Test
    public void testNullArguments() {
        this.assertFails("SELECT * FROM TABLE(system.table_argument_function(input => null))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("line 1:52: Invalid argument INPUT. Expected table, got expression");
        this.assertFails("SELECT * FROM TABLE(system.descriptor_argument_function(schema => null))").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_FUNCTION_ARGUMENT}).hasMessage("line 1:57: Invalid argument SCHEMA. Expected descriptor, got expression");
        this.analyze("SELECT * FROM TABLE(system.descriptor_argument_function(schema => CAST(null AS DESCRIPTOR)))");
        this.analyze("SELECT * FROM TABLE(system.descriptor_argument_function())");
        this.analyze("SELECT * FROM TABLE(system.two_arguments_function(null, null))");
        this.analyze("SELECT * FROM TABLE(system.two_arguments_function('a'))");
    }

    @Test
    public void testTableFunctionInvocationContext() {
        this.assertFails("SELECT * FROM TABLE(system.only_pass_through_function(TABLE(t1))) f(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_TABLE_FUNCTION_INVOCATION}).hasMessage("line 1:21: Alias specified for table function with ONLY PASS THROUGH return type");
        this.analyze("SELECT * FROM TABLE(system.two_arguments_function('a', 1)) f(x)");
        this.analyze("SELECT * FROM TABLE(system.two_arguments_function('a', 1))");
        this.analyze("SELECT * FROM TABLE(system.monomorphic_static_return_type_function())");
        this.analyze("SELECT * FROM TABLE(system.monomorphic_static_return_type_function()) f(x, y)");
        this.analyze("SELECT * FROM TABLE(system.polymorphic_static_return_type_function(input => TABLE(t1)))");
        this.analyze("SELECT * FROM TABLE(system.polymorphic_static_return_type_function(input => TABLE(t1))) f(x, y)");
        this.assertFails("SELECT * FROM TABLE(system.only_pass_through_function(TABLE(t1))) TABLESAMPLE BERNOULLI (10)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_TABLE_FUNCTION_INVOCATION}).hasMessage("line 1:21: Cannot apply sample to polymorphic table function invocation");
        this.assertFails("SELECT *\nFROM TABLE(system.only_pass_through_function(TABLE(t1)))\nMATCH_RECOGNIZE(\n    PATTERN (a*)\n    DEFINE a AS true)\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_TABLE_FUNCTION_INVOCATION}).hasMessage("line 2:12: Cannot apply row pattern matching to polymorphic table function invocation");
        this.assertFails("SELECT * FROM TABLE(system.two_arguments_function('a', 1)) f(x) TABLESAMPLE BERNOULLI (10)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_TABLE_FUNCTION_INVOCATION}).hasMessage("line 1:15: Cannot apply sample to polymorphic table function invocation");
        this.assertFails("SELECT *\nFROM TABLE(system.two_arguments_function('a', 1)) f(x)\nMATCH_RECOGNIZE(\n    PATTERN (a*)\n    DEFINE a AS true\n) t(y)\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_TABLE_FUNCTION_INVOCATION}).hasMessage("line 2:6: Cannot apply row pattern matching to polymorphic table function invocation");
        this.assertFails("SELECT *\nFROM TABLE(system.only_pass_through_function(TABLE(t1)))\nMATCH_RECOGNIZE(\n    PATTERN (a*)\n    DEFINE a AS true)\nTABLESAMPLE BERNOULLI (10)\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_TABLE_FUNCTION_INVOCATION}).hasMessage("line 2:12: Cannot apply row pattern matching to polymorphic table function invocation");
        this.assertFails("SELECT *\nFROM TABLE(system.two_arguments_function('a', 1)) f(x)\nMATCH_RECOGNIZE(\n    PATTERN (a*)\n    DEFINE a AS true\n) t(y)\nTABLESAMPLE BERNOULLI (10)\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_TABLE_FUNCTION_INVOCATION}).hasMessage("line 2:6: Cannot apply row pattern matching to polymorphic table function invocation");
    }

    @Test
    public void testTableFunctionAliasing() {
        this.assertFails("SELECT * FROM TABLE(system.table_argument_function(TABLE(t1))) T1(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_RANGE_VARIABLE}).hasMessage("line 1:64: Relation alias: T1 is a duplicate of input table name: tpch.s1.t1");
        this.assertFails("SELECT * FROM TABLE(system.table_argument_function(TABLE(SELECT 1) T1(a))) t1(x)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_RANGE_VARIABLE}).hasMessage("line 1:76: Relation alias: t1 is a duplicate of input table name: t1");
        this.analyze("SELECT * FROM TABLE(system.table_argument_function(TABLE(t1) t2)) T1(x)");
        this.analyze("SELECT column FROM TABLE(system.two_arguments_function('a', 1)) table_alias");
        this.analyze("SELECT column_alias FROM TABLE(system.two_arguments_function('a', 1)) table_alias(column_alias)");
        this.analyze("SELECT table_alias.column_alias FROM TABLE(system.two_arguments_function('a', 1)) table_alias(column_alias)");
        this.assertFails("SELECT column FROM TABLE(system.two_arguments_function('a', 1)) table_alias(column_alias)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessage("line 1:8: Column 'column' cannot be resolved");
        this.assertFails("SELECT column FROM TABLE(system.two_arguments_function('a', 1)) table_alias(col1, col2, col3)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISMATCHED_COLUMN_ALIASES}).hasMessage("line 1:20: Column alias list has 3 entries but table function has 1 proper columns");
        this.analyze("SELECT column_alias_1, column_alias_2 FROM TABLE(system.monomorphic_static_return_type_function()) table_alias(column_alias_1, column_alias_2)");
        this.assertFails("SELECT * FROM TABLE(system.monomorphic_static_return_type_function()) table_alias(col, col)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_COLUMN_NAME}).hasMessage("line 1:21: Duplicate name of table function proper column: col");
        this.assertFails("SELECT * FROM TABLE(system.monomorphic_static_return_type_function()) table_alias(col, COL)").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_COLUMN_NAME}).hasMessage("line 1:21: Duplicate name of table function proper column: col");
        this.analyze("SELECT table_alias.x, t1.a, t1.b, t1.c, t1.d FROM TABLE(system.pass_through_function(TABLE(t1))) table_alias");
        this.analyze("SELECT table_alias.x, arg_alias.a, arg_alias.b, arg_alias.c, arg_alias.d FROM TABLE(system.pass_through_function(TABLE(t1) arg_alias)) table_alias");
        this.assertFails("SELECT table_alias.x, t1.a FROM TABLE(system.pass_through_function(TABLE(t1) arg_alias)) table_alias").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessage("line 1:23: Column 't1.a' cannot be resolved");
        this.assertFails("SELECT table_alias.x, table_alias.a FROM TABLE(system.pass_through_function(TABLE(t1))) table_alias").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessage("line 1:23: Column 'table_alias.a' cannot be resolved");
    }

    @Test
    public void testTableFunctionRequiredColumns() {
        this.analyze("SELECT * FROM TABLE(system.required_columns_function(\n    input => TABLE(t1)))\n");
        this.analyze("SELECT * FROM TABLE(system.required_columns_function(\n    input => TABLE(SELECT 1, 2, 3)))\n");
        this.assertFails("SELECT * FROM TABLE(system.required_columns_function(\n    input => TABLE(SELECT 1)))\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR}).hasMessage("Invalid index: 1 of required column from table argument INPUT");
        this.assertFails("SELECT * FROM TABLE(system.required_columns_function(\n    input => TABLE(s1.t5)))\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR}).hasMessage("Invalid index: 1 of required column from table argument INPUT");
    }

    @Test
    public void testJsonTableColumnTypes() {
        this.analyze("SELECT *\nFROM JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $[2]'\n    COLUMNS(\n        o FOR ORDINALITY))\n");
        this.analyze("SELECT *\nFROM JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $'\n    COLUMNS(\n        id BIGINT\n            PATH 'lax $[1]'\n            DEFAULT 0 ON EMPTY\n            ERROR ON ERROR))\n");
        this.analyze("SELECT *\nFROM JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $'\n    COLUMNS(\n        id VARBINARY\n            FORMAT JSON ENCODING UTF16\n            PATH 'lax $[1]'\n            WITHOUT WRAPPER\n            OMIT QUOTES\n            EMPTY ARRAY ON EMPTY\n            NULL ON ERROR))\n");
        this.analyze("SELECT *\nFROM JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $'\n    COLUMNS(\n        NESTED PATH 'lax $[*]' AS nested_path COLUMNS (\n            o FOR ORDINALITY,\n            id BIGINT PATH 'lax $[1]')))\n");
    }

    @Test
    public void testJsonTableColumnAndPathNameUniqueness() {
        this.analyze("SELECT *\nFROM JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $[2]' AS root_path\n    COLUMNS(\n        o FOR ORDINALITY))\n");
        this.analyze("SELECT *\nFROM JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $'\n    COLUMNS(\n        NESTED PATH 'lax $[*]' AS nested_path COLUMNS (\n            o FOR ORDINALITY)))\n");
        this.analyze("SELECT *\nFROM JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $' AS root_path\n    COLUMNS(\n        NESTED PATH 'lax $[*]' AS nested_path COLUMNS (\n            o FOR ORDINALITY)))\n");
        this.assertFails("SELECT *\nFROM JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $' AS some_path\n    COLUMNS(\n        NESTED PATH 'lax $[*]' AS some_path COLUMNS (\n            o FOR ORDINALITY)))\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_COLUMN_OR_PATH_NAME}).hasMessage("line 6:35: All column and path names in JSON_TABLE invocation must be unique");
        this.assertFails("SELECT *\nFROM JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $[2]'\n    COLUMNS(\n        id FOR ORDINALITY,\n        id BIGINT))\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_COLUMN_OR_PATH_NAME}).hasMessage("line 7:9: All column and path names in JSON_TABLE invocation must be unique");
        this.assertFails("SELECT *\nFROM JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $[2]' AS some_name\n    COLUMNS(\n        some_name FOR ORDINALITY))\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_COLUMN_OR_PATH_NAME}).hasMessage("line 6:9: All column and path names in JSON_TABLE invocation must be unique");
        this.assertFails("SELECT *\nFROM JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $'\n    COLUMNS(\n        NESTED PATH 'lax $[*]' AS some_name COLUMNS (\n            some_name FOR ORDINALITY)))\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_COLUMN_OR_PATH_NAME}).hasMessage("line 7:13: All column and path names in JSON_TABLE invocation must be unique");
        this.assertFails("SELECT *\nFROM JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $[2]'\n    COLUMNS(\n        NESTED PATH 'lax $[*]' AS some_name COLUMNS (\n            NESTED PATH 'lax $' AS another_name COLUMNS (\n                NESTED PATH 'lax $' AS yet_another_name COLUMNS (\n                    some_name FOR ORDINALITY)))))\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_COLUMN_OR_PATH_NAME}).hasMessage("line 9:21: All column and path names in JSON_TABLE invocation must be unique");
    }

    @Test
    public void testJsonTableColumnAndPathNameIdentifierSemantics() {
        this.assertFails("SELECT *\nFROM JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $[2]' AS some_name\n    COLUMNS(\n        Some_Name FOR ORDINALITY))\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.DUPLICATE_COLUMN_OR_PATH_NAME}).hasMessage("line 6:9: All column and path names in JSON_TABLE invocation must be unique");
        this.analyze("SELECT *\nFROM JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $[2]' AS some_name\n    COLUMNS(\n        \"some_name\" FOR ORDINALITY))\n");
    }

    @Test
    public void testJsonTableOutputColumns() {
        this.analyze("SELECT a, b, c, d, e\nFROM JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $'\n    COLUMNS(\n        a FOR ORDINALITY,\n        b BIGINT,\n        c VARBINARY FORMAT JSON ENCODING UTF16,\n        NESTED PATH 'lax $[*]' COLUMNS (\n            d FOR ORDINALITY,\n            e BIGINT)))\n");
    }

    @Test
    public void testImplicitJsonPath() {
        this.analyze("SELECT *\nFROM JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $[2]'\n    COLUMNS(Ab BIGINT))\n");
        this.analyze("SELECT *\nFROM JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $[2]'\n    COLUMNS(\"Ab\" BIGINT))\n");
        this.analyze("SELECT *\nFROM JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $[2]'\n    COLUMNS(\"?\" BIGINT))\n");
        this.analyze("SELECT *\nFROM JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $[2]'\n    COLUMNS(\"\"\"\" BIGINT))\n");
    }

    @Test
    public void testJsonTableSpecificPlan() {
        this.assertFails("SELECT *\nFROM JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $[2]'\n    COLUMNS(id BIGINT)\n    PLAN (root_path))\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISSING_PATH_NAME}).hasMessage("line 3:5: All JSON paths must be named when specific plan is given");
        this.assertFails("SELECT *\nFROM JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $[2]' AS root_path\n    COLUMNS(id BIGINT)\n    PLAN (root_path UNION another_path))\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PLAN}).hasMessage("line 6:11: JSON_TABLE plan must either be a single path name or it must be rooted in parent-child relationship (OUTER or INNER)");
        this.assertFails("SELECT *\nFROM JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $' AS root_path\n    COLUMNS(id BIGINT)\n    PLAN (another_path))\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PLAN}).hasMessage("line 6:11: JSON_TABLE plan should contain all JSON paths available at each level of nesting. Paths not included: ROOT_PATH");
        this.assertFails("SELECT *\nFROM JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $' AS root_path\n    COLUMNS(\n        NESTED PATH 'lax $' COLUMNS(id BIGINT))\n    PLAN (root_path OUTER another_path))\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISSING_PATH_NAME}).hasMessage("line 6:21: All JSON paths must be named when specific plan is given");
        this.assertFails("SELECT *\nFROM JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $' AS root_path\n    COLUMNS(\n        NESTED PATH 'lax $' AS nested_path_1 COLUMNS(id_1 BIGINT),\n        NESTED PATH 'lax $' AS nested_path_2 COLUMNS(id_2 BIGINT))\n    PLAN (root_path OUTER (nested_path_1 CROSS another_path)))\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PLAN}).hasMessage("line 8:11: JSON_TABLE plan should contain all JSON paths available at each level of nesting. Paths not included: NESTED_PATH_2");
        this.assertFails("SELECT *\nFROM JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $' AS root_path\n    COLUMNS(\n        NESTED PATH 'lax $' AS nested_path_1 COLUMNS(id_1 BIGINT),\n        NESTED PATH 'lax $' AS nested_path_2 COLUMNS(id_2 BIGINT))\n    PLAN (root_path OUTER (nested_path_1 CROSS another_path CROSS nested_path_2)))\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PLAN}).hasMessage("line 8:11: JSON_TABLE plan includes unavailable JSON path names: ANOTHER_PATH");
        this.assertFails("SELECT *\nFROM JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $' AS root_path\n    COLUMNS(\n        NESTED PATH 'lax $' AS nested_path_1 COLUMNS(id_1 BIGINT),\n        NESTED PATH 'lax $' AS nested_path_2 COLUMNS(\n            id_2 BIGINT,\n            NESTED PATH 'lax $' AS nested_path_3 COLUMNS(id_3 BIGINT)))\n    PLAN (root_path OUTER (nested_path_1 CROSS (nested_path_2 UNION nested_path_3))))\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PLAN}).hasMessage("line 10:11: JSON_TABLE plan includes unavailable JSON path names: NESTED_PATH_3");
        this.assertFails("SELECT *\nFROM JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $' AS root_path\n    COLUMNS(\n        NESTED PATH 'lax $' AS nested_path_1 COLUMNS(id_1 BIGINT),\n        NESTED PATH 'lax $' AS nested_path_2 COLUMNS(id_2 BIGINT))\n    PLAN (root_path OUTER (nested_path_1 CROSS (nested_path_2 UNION nested_path_1))))\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_PLAN}).hasMessage("line 8:69: Duplicate reference to JSON path name in sibling plan: NESTED_PATH_1");
        this.analyze("SELECT *\nFROM JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $' AS root_path\n    COLUMNS(\n        NESTED PATH 'lax $' AS nested_path_1 COLUMNS(id_1 BIGINT),\n        NESTED PATH 'lax $' AS nested_path_2 COLUMNS(\n            id_2 BIGINT,\n            NESTED PATH 'lax $' AS nested_path_3 COLUMNS(id_3 BIGINT)))\n    PLAN (root_path OUTER (nested_path_1 CROSS (nested_path_2 INNER nested_path_3))))\n");
    }

    @Test
    public void testJsonTableDefaultPlan() {
        this.analyze("SELECT *\nFROM JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $[2]'\n    COLUMNS(id BIGINT)\n    PLAN DEFAULT(CROSS, INNER))\n");
        this.assertFails("SELECT *\nFROM JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $' AS root_path\n    COLUMNS(\n        NESTED PATH 'lax $' COLUMNS(id BIGINT))\n    PLAN DEFAULT(OUTER, UNION))\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.MISSING_PATH_NAME}).hasMessage("line 6:21: All nested JSON paths must be named when default plan is given");
    }

    @Test
    public void testJsonTableInJoin() {
        this.analyze("SELECT *\nFROM t1, t2, JSON_TABLE('[1, 2, 3]', 'lax $[2]' COLUMNS(o FOR ORDINALITY))\n");
        this.analyze("SELECT *\n    FROM t1\n    LEFT JOIN\n    JSON_TABLE('[1, 2, 3]', 'lax $[2]' COLUMNS(o FOR ORDINALITY))\n    ON TRUE\n");
        this.assertFails("SELECT *\n    FROM t1\n    RIGHT JOIN\n    JSON_TABLE('[1, 2, 3]', 'lax $[2]' COLUMNS(o FOR ORDINALITY)) t\n    ON t.o > t1.a\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 5:12: RIGHT JOIN involving JSON_TABLE is only supported with condition ON TRUE");
        this.analyze("SELECT *\n    FROM t6\n    LEFT JOIN\n    JSON_TABLE(b, 'lax $[2]' COLUMNS(o FOR ORDINALITY))\n    ON TRUE\n");
        this.analyze("SELECT *\n    FROM t6\n    LEFT JOIN\n    JSON_TABLE('[1, 2, 3]', 'lax $[2]' COLUMNS(x BIGINT DEFAULT a ON EMPTY))\n    ON TRUE\n");
        this.analyze("SELECT *\n    FROM t6\n    LEFT JOIN\n    JSON_TABLE('[1, 2, 3]', 'lax $[2]' PASSING a AS parameter_name COLUMNS(o FOR ORDINALITY))\n    ON TRUE\n");
        this.assertFails("SELECT *\n    FROM t6\n    RIGHT JOIN\n    JSON_TABLE('[1, 2, 3]', 'lax $[2]' PASSING a AS parameter_name COLUMNS(o FOR ORDINALITY))\n    ON TRUE\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_COLUMN_REFERENCE}).hasMessage("line 4:48: LATERAL reference not allowed in RIGHT JOIN");
    }

    @Test
    public void testSubqueryInJsonTable() {
        this.analyze("SELECT *\nFROM JSON_TABLE(\n    (SELECT '[1, 2, 3]'),\n    'lax $[2]' PASSING (SELECT 1) AS parameter_name\n    COLUMNS(\n        x BIGINT DEFAULT (SELECT 2) ON EMPTY))\n");
    }

    @Test
    public void testAggregationInJsonTable() {
        this.assertFails("SELECT *\nFROM JSON_TABLE(\n    CAST(sum(1) AS varchar),\n    'lax $' PASSING 2 AS parameter_name\n    COLUMNS(\n        x BIGINT DEFAULT 3 ON EMPTY DEFAULT 4 ON ERROR))\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_SCALAR}).hasMessage("line 3:5: JSON_TABLE input expression cannot contain aggregations, window functions or grouping operations: [sum(1)]");
        this.assertFails("SELECT *\nFROM JSON_TABLE(\n    '1',\n    'lax $' PASSING avg(2) AS parameter_name\n    COLUMNS(\n        x BIGINT DEFAULT 3 ON EMPTY DEFAULT 4 ON ERROR))\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_SCALAR}).hasMessage("line 4:21: JSON_TABLE path parameter cannot contain aggregations, window functions or grouping operations: [avg(2)]");
        this.assertFails("SELECT *\nFROM JSON_TABLE(\n    '1',\n    'lax $' PASSING 2 AS parameter_name\n    COLUMNS(\n        x BIGINT DEFAULT min(3) ON EMPTY DEFAULT 4 ON ERROR))\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_SCALAR}).hasMessage("line 6:26: default expression for JSON_TABLE column cannot contain aggregations, window functions or grouping operations: [min(3)]");
        this.assertFails("SELECT *\nFROM JSON_TABLE(\n    '1',\n    'lax $' PASSING 2 AS parameter_name\n    COLUMNS(\n        x BIGINT DEFAULT 3 ON EMPTY DEFAULT max(4) ON ERROR))\n").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_SCALAR}).hasMessage("line 6:45: default expression for JSON_TABLE column cannot contain aggregations, window functions or grouping operations: [max(4)]");
    }

    @Test
    public void testAliasJsonTable() {
        this.analyze("SELECT t.y\nFROM JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $[2]'\n    COLUMNS(x BIGINT)) t(y)\n");
        this.analyze("SELECT t.x\nFROM JSON_TABLE(\n    '[1, 2, 3]',\n    'lax $[2]'\n    COLUMNS(x BIGINT)) t\n");
    }

    @Test
    public void testDisallowAggregationFunctionInUnnest() {
        this.assertFails("SELECT a FROM (VALUES (1), (2)) t(a), UNNEST(ARRAY[COUNT(t.a)])").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_SCALAR}).hasMessage("line 1:46: UNNEST cannot contain aggregations, window functions or grouping operations: [COUNT(t.a)]");
    }

    @BeforeAll
    public void setup() {
        this.closer = Closer.create();
        PlanTester planTester = PlanTester.create((Session)SessionTestUtils.TEST_SESSION);
        this.closer.register((Closeable)planTester);
        this.transactionManager = planTester.getTransactionManager();
        AccessControlManager accessControlManager = new AccessControlManager(NodeVersion.UNKNOWN, this.transactionManager, (EventListenerManager)TestingEventListenerManager.emptyEventListenerManager(), new AccessControlConfig(), OpenTelemetry.noop(), new SecretsResolver((Map)ImmutableMap.of()), "default");
        accessControlManager.setSystemAccessControls(List.of(AllowAllSystemAccessControl.INSTANCE));
        this.accessControl = accessControlManager;
        planTester.addFunctions((FunctionBundle)InternalFunctionBundle.builder().functions(new SqlFunction[]{ApplyFunction.APPLY_FUNCTION}).build());
        this.plannerContext = planTester.getPlannerContext();
        Metadata metadata = this.plannerContext.getMetadata();
        TestingMetadata testingConnectorMetadata = new TestingMetadata();
        TestingConnector connector = new TestingConnector((ConnectorMetadata)testingConnectorMetadata);
        planTester.createCatalog(TPCH_CATALOG, (ConnectorFactory)new StaticConnectorFactory("main", connector), (Map)ImmutableMap.of());
        this.tablePropertyManager = planTester.getTablePropertyManager();
        this.analyzePropertyManager = planTester.getAnalyzePropertyManager();
        planTester.createCatalog(SECOND_CATALOG, (ConnectorFactory)MockConnectorFactory.create("second"), (Map)ImmutableMap.of());
        planTester.createCatalog(THIRD_CATALOG, (ConnectorFactory)MockConnectorFactory.create("third"), (Map)ImmutableMap.of());
        SchemaTableName table1 = new SchemaTableName("s1", "t1");
        this.inSetupTransaction(session -> metadata.createTable(session, TPCH_CATALOG, new ConnectorTableMetadata(table1, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("b", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("c", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("d", (Type)BigintType.BIGINT))), SaveMode.FAIL));
        SchemaTableName table2 = new SchemaTableName("s1", "t2");
        this.inSetupTransaction(session -> metadata.createTable(session, TPCH_CATALOG, new ConnectorTableMetadata(table2, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("b", (Type)BigintType.BIGINT))), SaveMode.FAIL));
        SchemaTableName table3 = new SchemaTableName("s1", "t3");
        this.inSetupTransaction(session -> metadata.createTable(session, TPCH_CATALOG, new ConnectorTableMetadata(table3, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("b", (Type)BigintType.BIGINT), (Object)ColumnMetadata.builder().setName("x").setType((Type)BigintType.BIGINT).setHidden(true).build())), SaveMode.FAIL));
        SchemaTableName table5 = new SchemaTableName("s1", "t5");
        this.inSetupTransaction(session -> metadata.createTable(session, TPCH_CATALOG, new ConnectorTableMetadata(table5, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT), (Object)ColumnMetadata.builder().setName("b").setType((Type)BigintType.BIGINT).setHidden(true).build())), SaveMode.FAIL));
        SchemaTableName table6 = new SchemaTableName("s1", "t6");
        this.inSetupTransaction(session -> metadata.createTable(session, TPCH_CATALOG, new ConnectorTableMetadata(table6, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("b", (Type)VarcharType.VARCHAR), (Object)new ColumnMetadata("c", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("d", (Type)BigintType.BIGINT))), SaveMode.FAIL));
        SchemaTableName table7 = new SchemaTableName("s1", "t7");
        this.inSetupTransaction(session -> metadata.createTable(session, TPCH_CATALOG, new ConnectorTableMetadata(table7, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("b", (Type)DoubleType.DOUBLE), (Object)new ColumnMetadata("c", (Type)new ArrayType((Type)BigintType.BIGINT)), (Object)new ColumnMetadata("d", (Type)new ArrayType((Type)DoubleType.DOUBLE)))), SaveMode.FAIL));
        MaterializedViewDefinition materializedViewData1 = new MaterializedViewDefinition("select a from t1", Optional.of(TPCH_CATALOG), Optional.of("s1"), (List)ImmutableList.of((Object)new ViewColumn("a", BigintType.BIGINT.getTypeId(), Optional.empty())), Optional.of(Duration.ZERO), Optional.of("comment"), Identity.ofUser((String)"user"), (List)ImmutableList.of(), Optional.empty());
        this.inSetupTransaction(session -> metadata.createMaterializedView(session, new QualifiedObjectName(TPCH_CATALOG, "s1", "mv1"), materializedViewData1, (Map)ImmutableMap.of(), false, true));
        ViewDefinition viewData1 = new ViewDefinition("select a from t1", Optional.of(TPCH_CATALOG), Optional.of("s1"), (List)ImmutableList.of((Object)new ViewColumn("a", BigintType.BIGINT.getTypeId(), Optional.empty())), Optional.of("comment"), Optional.of(Identity.ofUser((String)"user")), (List)ImmutableList.of());
        this.inSetupTransaction(session -> metadata.createView(session, new QualifiedObjectName(TPCH_CATALOG, "s1", "v1"), viewData1, (Map)ImmutableMap.of(), false));
        ViewDefinition viewData2 = new ViewDefinition("select a from t1", Optional.of(TPCH_CATALOG), Optional.of("s1"), (List)ImmutableList.of((Object)new ViewColumn("a", VarcharType.VARCHAR.getTypeId(), Optional.empty())), Optional.of("comment"), Optional.of(Identity.ofUser((String)"user")), (List)ImmutableList.of());
        this.inSetupTransaction(session -> metadata.createView(session, new QualifiedObjectName(TPCH_CATALOG, "s1", "v2"), viewData2, (Map)ImmutableMap.of(), false));
        ViewDefinition viewData4 = new ViewDefinition("select A from t1", Optional.of(TPCH_CATALOG), Optional.of("s1"), (List)ImmutableList.of((Object)new ViewColumn("a", BigintType.BIGINT.getTypeId(), Optional.empty())), Optional.of("comment"), Optional.of(Identity.ofUser((String)"user")), (List)ImmutableList.of());
        this.inSetupTransaction(session -> metadata.createView(session, new QualifiedObjectName(TPCH_CATALOG, "s1", "v4"), viewData4, (Map)ImmutableMap.of(), false));
        ViewDefinition viewData5 = new ViewDefinition("select * from v5", Optional.of(TPCH_CATALOG), Optional.of("s1"), (List)ImmutableList.of((Object)new ViewColumn("a", BigintType.BIGINT.getTypeId(), Optional.empty())), Optional.of("comment"), Optional.of(Identity.ofUser((String)"user")), (List)ImmutableList.of());
        this.inSetupTransaction(session -> metadata.createView(session, new QualifiedObjectName(TPCH_CATALOG, "s1", "v5"), viewData5, (Map)ImmutableMap.of(), false));
        SchemaTableName table8 = new SchemaTableName("s1", "t8");
        this.inSetupTransaction(session -> metadata.createTable(session, TPCH_CATALOG, new ConnectorTableMetadata(table8, (List)ImmutableList.of((Object)new ColumnMetadata("tinyint_column", (Type)TinyintType.TINYINT), (Object)new ColumnMetadata("integer_column", (Type)IntegerType.INTEGER), (Object)new ColumnMetadata("decimal_column", (Type)DecimalType.createDecimalType((int)5, (int)3)), (Object)new ColumnMetadata("real_column", (Type)RealType.REAL), (Object)new ColumnMetadata("char_column", (Type)CharType.createCharType((int)3)), (Object)new ColumnMetadata("bounded_varchar_column", (Type)VarcharType.createVarcharType((int)3)), (Object)new ColumnMetadata("unbounded_varchar_column", (Type)VarcharType.VARCHAR), (Object)new ColumnMetadata("tinyint_array_column", (Type)new ArrayType((Type)TinyintType.TINYINT)), (Object)new ColumnMetadata("bigint_array_column", (Type)new ArrayType((Type)BigintType.BIGINT)), (Object)new ColumnMetadata("nested_bounded_varchar_column", (Type)RowType.anonymousRow((Type[])new Type[]{VarcharType.createVarcharType((int)3)})), (Object)new ColumnMetadata("row_column", (Type)RowType.anonymousRow((Type[])new Type[]{TinyintType.TINYINT, VarcharType.createUnboundedVarcharType()})), (Object)new ColumnMetadata("date_column", (Type)DateType.DATE), (Object[])new ColumnMetadata[0])), SaveMode.FAIL));
        planTester.createCatalog(CATALOG_FOR_IDENTIFIER_CHAIN_TESTS, (ConnectorFactory)new StaticConnectorFactory("chain", new TestingConnector((ConnectorMetadata)new TestingMetadata())), (Map)ImmutableMap.of());
        Type singleFieldRowType = InternalTypeManager.TESTING_TYPE_MANAGER.fromSqlType("row(f1 bigint)");
        Type rowType = InternalTypeManager.TESTING_TYPE_MANAGER.fromSqlType("row(f1 bigint, f2 bigint)");
        Type nestedRowType = InternalTypeManager.TESTING_TYPE_MANAGER.fromSqlType("row(f1 row(f11 bigint, f12 bigint), f2 boolean)");
        Type doubleNestedRowType = InternalTypeManager.TESTING_TYPE_MANAGER.fromSqlType("row(f1 row(f11 row(f111 bigint, f112 bigint), f12 boolean), f2 boolean)");
        SchemaTableName b = new SchemaTableName("a", "b");
        this.inSetupTransaction(session -> metadata.createTable(session, CATALOG_FOR_IDENTIFIER_CHAIN_TESTS, new ConnectorTableMetadata(b, (List)ImmutableList.of((Object)new ColumnMetadata("x", (Type)VarcharType.VARCHAR))), SaveMode.FAIL));
        SchemaTableName t1 = new SchemaTableName("a", "t1");
        this.inSetupTransaction(session -> metadata.createTable(session, CATALOG_FOR_IDENTIFIER_CHAIN_TESTS, new ConnectorTableMetadata(t1, (List)ImmutableList.of((Object)new ColumnMetadata("b", rowType))), SaveMode.FAIL));
        SchemaTableName t2 = new SchemaTableName("a", "t2");
        this.inSetupTransaction(session -> metadata.createTable(session, CATALOG_FOR_IDENTIFIER_CHAIN_TESTS, new ConnectorTableMetadata(t2, (List)ImmutableList.of((Object)new ColumnMetadata("a", rowType))), SaveMode.FAIL));
        SchemaTableName t3 = new SchemaTableName("a", "t3");
        this.inSetupTransaction(session -> metadata.createTable(session, CATALOG_FOR_IDENTIFIER_CHAIN_TESTS, new ConnectorTableMetadata(t3, (List)ImmutableList.of((Object)new ColumnMetadata("b", nestedRowType), (Object)new ColumnMetadata("c", (Type)BigintType.BIGINT))), SaveMode.FAIL));
        SchemaTableName t4 = new SchemaTableName("a", "t4");
        this.inSetupTransaction(session -> metadata.createTable(session, CATALOG_FOR_IDENTIFIER_CHAIN_TESTS, new ConnectorTableMetadata(t4, (List)ImmutableList.of((Object)new ColumnMetadata("b", doubleNestedRowType), (Object)new ColumnMetadata("c", (Type)BigintType.BIGINT))), SaveMode.FAIL));
        SchemaTableName t5 = new SchemaTableName("a", "t5");
        this.inSetupTransaction(session -> metadata.createTable(session, CATALOG_FOR_IDENTIFIER_CHAIN_TESTS, new ConnectorTableMetadata(t5, (List)ImmutableList.of((Object)new ColumnMetadata("b", singleFieldRowType))), SaveMode.FAIL));
        QualifiedObjectName tableViewAndMaterializedView = new QualifiedObjectName(TPCH_CATALOG, "s1", "table_view_and_materialized_view");
        this.inSetupTransaction(session -> metadata.createMaterializedView(session, tableViewAndMaterializedView, new MaterializedViewDefinition("SELECT a FROM t1", Optional.of(TPCH_CATALOG), Optional.of("s1"), (List)ImmutableList.of((Object)new ViewColumn("a", BigintType.BIGINT.getTypeId(), Optional.empty())), Optional.of(Duration.ZERO), Optional.empty(), Identity.ofUser((String)"some user"), (List)ImmutableList.of(), Optional.of(new CatalogSchemaTableName(TPCH_CATALOG, "s1", "t1"))), (Map)ImmutableMap.of(), false, false));
        ViewDefinition viewDefinition = new ViewDefinition("SELECT a FROM t2", Optional.of(TPCH_CATALOG), Optional.of("s1"), (List)ImmutableList.of((Object)new ViewColumn("a", BigintType.BIGINT.getTypeId(), Optional.empty())), Optional.empty(), Optional.empty(), (List)ImmutableList.of());
        this.inSetupTransaction(session -> metadata.createView(session, tableViewAndMaterializedView, viewDefinition, (Map)ImmutableMap.of(), false));
        this.inSetupTransaction(session -> metadata.createTable(session, CATALOG_FOR_IDENTIFIER_CHAIN_TESTS, new ConnectorTableMetadata(tableViewAndMaterializedView.asSchemaTableName(), (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT))), SaveMode.FAIL));
        QualifiedObjectName tableAndView = new QualifiedObjectName(TPCH_CATALOG, "s1", "table_and_view");
        this.inSetupTransaction(session -> metadata.createView(session, tableAndView, viewDefinition, (Map)ImmutableMap.of(), false));
        this.inSetupTransaction(session -> metadata.createTable(session, CATALOG_FOR_IDENTIFIER_CHAIN_TESTS, new ConnectorTableMetadata(tableAndView.asSchemaTableName(), (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT))), SaveMode.FAIL));
        QualifiedObjectName freshMaterializedView = new QualifiedObjectName(TPCH_CATALOG, "s1", "fresh_materialized_view");
        this.inSetupTransaction(session -> metadata.createMaterializedView(session, freshMaterializedView, new MaterializedViewDefinition("SELECT a, b FROM t1", Optional.of(TPCH_CATALOG), Optional.of("s1"), (List)ImmutableList.of((Object)new ViewColumn("a", BigintType.BIGINT.getTypeId(), Optional.empty()), (Object)new ViewColumn("b", BigintType.BIGINT.getTypeId(), Optional.empty())), Optional.empty(), Optional.empty(), Identity.ofUser((String)"some user"), (List)ImmutableList.of(), Optional.of(new CatalogSchemaTableName(TPCH_CATALOG, "s1", "t3"))), (Map)ImmutableMap.of(), false, false));
        testingConnectorMetadata.markMaterializedViewIsFresh(freshMaterializedView.asSchemaTableName());
        QualifiedObjectName freshMaterializedViewMismatchedColumnCount = new QualifiedObjectName(TPCH_CATALOG, "s1", "fresh_materialized_view_mismatched_column_count");
        this.inSetupTransaction(session -> metadata.createMaterializedView(session, freshMaterializedViewMismatchedColumnCount, new MaterializedViewDefinition("SELECT a FROM t1", Optional.of(TPCH_CATALOG), Optional.of("s1"), (List)ImmutableList.of((Object)new ViewColumn("a", BigintType.BIGINT.getTypeId(), Optional.empty())), Optional.empty(), Optional.empty(), Identity.ofUser((String)"some user"), (List)ImmutableList.of(), Optional.of(new CatalogSchemaTableName(TPCH_CATALOG, "s1", "t2"))), (Map)ImmutableMap.of(), false, false));
        testingConnectorMetadata.markMaterializedViewIsFresh(freshMaterializedViewMismatchedColumnCount.asSchemaTableName());
        QualifiedObjectName freshMaterializedMismatchedColumnName = new QualifiedObjectName(TPCH_CATALOG, "s1", "fresh_materialized_view_mismatched_column_name");
        this.inSetupTransaction(session -> metadata.createMaterializedView(session, freshMaterializedMismatchedColumnName, new MaterializedViewDefinition("SELECT a, b as c FROM t1", Optional.of(TPCH_CATALOG), Optional.of("s1"), (List)ImmutableList.of((Object)new ViewColumn("a", BigintType.BIGINT.getTypeId(), Optional.empty()), (Object)new ViewColumn("c", BigintType.BIGINT.getTypeId(), Optional.empty())), Optional.empty(), Optional.empty(), Identity.ofUser((String)"some user"), (List)ImmutableList.of(), Optional.of(new CatalogSchemaTableName(TPCH_CATALOG, "s1", "t2"))), (Map)ImmutableMap.of(), false, false));
        testingConnectorMetadata.markMaterializedViewIsFresh(freshMaterializedMismatchedColumnName.asSchemaTableName());
        QualifiedObjectName freshMaterializedMismatchedColumnType = new QualifiedObjectName(TPCH_CATALOG, "s1", "fresh_materialized_view_mismatched_column_type");
        this.inSetupTransaction(session -> metadata.createMaterializedView(session, freshMaterializedMismatchedColumnType, new MaterializedViewDefinition("SELECT a, null b FROM t1", Optional.of(TPCH_CATALOG), Optional.of("s1"), (List)ImmutableList.of((Object)new ViewColumn("a", BigintType.BIGINT.getTypeId(), Optional.empty()), (Object)new ViewColumn("b", RowType.anonymousRow((Type[])new Type[]{TinyintType.TINYINT}).getTypeId(), Optional.empty())), Optional.empty(), Optional.empty(), Identity.ofUser((String)"some user"), (List)ImmutableList.of(), Optional.of(new CatalogSchemaTableName(TPCH_CATALOG, "s1", "t2"))), (Map)ImmutableMap.of(), false, false));
        testingConnectorMetadata.markMaterializedViewIsFresh(freshMaterializedMismatchedColumnType.asSchemaTableName());
    }

    @Test
    public void testAlterTableAddRowField() {
        this.assertFails("ALTER TABLE a.t1 ADD COLUMN b.f3 INTEGER NOT NULL").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Adding fields with NOT NULL constraint is unsupported");
        this.assertFails("ALTER TABLE a.t1 ADD COLUMN b.f3 INTEGER WITH(foo='bar')").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Adding fields with column properties is unsupported");
        this.assertFails("ALTER TABLE a.t1 ADD COLUMN b.f3 INTEGER COMMENT 'test comment'").hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Adding fields with COMMENT is unsupported");
    }

    @AfterAll
    public void tearDown() throws Exception {
        this.closer.close();
        this.closer = null;
        this.transactionManager = null;
        this.accessControl = null;
        this.plannerContext = null;
        this.tablePropertyManager = null;
        this.analyzePropertyManager = null;
    }

    private void inSetupTransaction(Consumer<Session> consumer) {
        TransactionBuilder.transaction((TransactionManager)this.transactionManager, (Metadata)this.plannerContext.getMetadata(), (AccessControl)this.accessControl).singleStatement().readUncommitted().execute(SETUP_SESSION, consumer);
    }

    private Analyzer createAnalyzer(Session session, AccessControl accessControl) {
        StatementRewrite statementRewrite = new StatementRewrite((Set)ImmutableSet.of((Object)new ShowQueriesRewrite(new SqlEnvironmentConfig(), this.plannerContext.getMetadata(), SQL_PARSER, accessControl, new SessionPropertyManager(), new SchemaPropertyManager(CatalogServiceProvider.fail()), new ColumnPropertyManager(CatalogServiceProvider.fail()), this.tablePropertyManager, new ViewPropertyManager(catalogName -> ImmutableMap.of()), new MaterializedViewPropertyManager(catalogName -> ImmutableMap.of()))));
        StatementAnalyzerFactory statementAnalyzerFactory = new StatementAnalyzerFactory(this.plannerContext, new SqlParser(), SessionTimeProvider.DEFAULT, accessControl, (TransactionManager)new NoOpTransactionManager(this){

            public ConnectorTransactionHandle getConnectorTransaction(TransactionId transactionId, CatalogHandle catalogHandle) {
                return new ConnectorTransactionHandle(this){};
            }
        }, user -> ImmutableSet.of(), new TableProceduresRegistry(CatalogServiceProvider.fail((String)"procedures are not supported in testing analyzer")), new TableFunctionRegistry(catalogName -> new CatalogTableFunctions((Collection)ImmutableList.of((Object)((Object)new TestingTableFunctions.TwoScalarArgumentsFunction()), (Object)((Object)new TestingTableFunctions.TableArgumentFunction()), (Object)((Object)new TestingTableFunctions.TableArgumentRowSemanticsFunction()), (Object)((Object)new TestingTableFunctions.DescriptorArgumentFunction()), (Object)((Object)new TestingTableFunctions.TwoTableArgumentsFunction()), (Object)((Object)new TestingTableFunctions.OnlyPassThroughFunction()), (Object)((Object)new TestingTableFunctions.MonomorphicStaticReturnTypeFunction()), (Object)((Object)new TestingTableFunctions.PolymorphicStaticReturnTypeFunction()), (Object)((Object)new TestingTableFunctions.PassThroughFunction()), (Object)((Object)new TestingTableFunctions.RequiredColumnsFunction())))), this.tablePropertyManager, this.analyzePropertyManager, new TableProceduresPropertyManager(CatalogServiceProvider.fail((String)"procedures are not supported in testing analyzer")));
        AnalyzerFactory analyzerFactory = new AnalyzerFactory(statementAnalyzerFactory, statementRewrite, this.plannerContext.getTracer());
        return analyzerFactory.createAnalyzer(session, Collections.emptyList(), Collections.emptyMap(), WarningCollector.NOOP, PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector());
    }

    private Analysis analyze(@Language(value="SQL") String query) {
        return this.analyze(CLIENT_SESSION, query);
    }

    private Analysis analyze(Session clientSession, @Language(value="SQL") String query) {
        return this.analyze(clientSession, query, (AccessControl)new AllowAllAccessControl());
    }

    private Analysis analyze(Session clientSession, @Language(value="SQL") String query, AccessControl accessControl) {
        return (Analysis)TransactionBuilder.transaction((TransactionManager)this.transactionManager, (Metadata)this.plannerContext.getMetadata(), (AccessControl)accessControl).singleStatement().readUncommitted().execute(clientSession, session -> {
            Analyzer analyzer = this.createAnalyzer((Session)session, accessControl);
            Statement statement = SQL_PARSER.createStatement(query);
            return analyzer.analyze(statement);
        });
    }

    private TrinoExceptionAssert assertFails(@Language(value="SQL") String query) {
        return this.assertFails(CLIENT_SESSION, query);
    }

    private TrinoExceptionAssert assertFails(Session session, @Language(value="SQL") String query) {
        return this.assertFails(session, query, (AccessControl)new AllowAllAccessControl());
    }

    private TrinoExceptionAssert assertFails(Session session, @Language(value="SQL") String query, AccessControl accessControl) {
        return TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.analyze(session, query, accessControl));
    }

    private static class TestingConnector
    implements Connector {
        private final ConnectorMetadata metadata;

        public TestingConnector(ConnectorMetadata metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        }

        public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
            return new ConnectorTransactionHandle(this){};
        }

        public ConnectorMetadata getMetadata(ConnectorSession session, ConnectorTransactionHandle transaction) {
            return this.metadata;
        }

        public List<PropertyMetadata<?>> getAnalyzeProperties() {
            return ImmutableList.of((Object)PropertyMetadata.stringProperty((String)"p1", (String)"test string property", (String)"", (boolean)false), (Object)PropertyMetadata.integerProperty((String)"p2", (String)"test integer property", (Integer)0, (boolean)false));
        }
    }
}

