/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.jmh.Benchmarks;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.TestMetadataManager;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.project.PageProcessor;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.gen.ExpressionCompiler;
import io.trino.sql.gen.PageFunctionCompiler;
import io.trino.sql.gen.columnar.ColumnarFilterCompiler;
import io.trino.sql.relational.Expressions;
import io.trino.sql.relational.InputReferenceExpression;
import io.trino.sql.relational.SpecialForm;
import io.trino.testing.TestingConnectorSession;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.RunnerException;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@Fork(value=2)
@Warmup(iterations=6, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=6, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkInCodeGenerator {
    @Benchmark
    public List<Optional<Page>> benchmark(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.processor.process(TestingConnectorSession.SESSION, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), data.inputPage));
    }

    @Test
    public void testBenchmarkInCodeGenerator() {
        UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)true, (Object)false).iterator();
        while (unmodifiableIterator.hasNext()) {
            boolean columnarEvaluationEnabled = (Boolean)unmodifiableIterator.next();
            BenchmarkData benchmarkData = new BenchmarkData();
            benchmarkData.columnarEvaluationEnabled = columnarEvaluationEnabled;
            benchmarkData.setup();
            this.benchmark(benchmarkData);
        }
    }

    public static void main(String[] args) throws RunnerException {
        Benchmarks.benchmark(BenchmarkInCodeGenerator.class).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"1", "5", "10", "25", "50", "75", "100", "150", "200", "250", "300", "350", "400", "450", "500", "750", "1000", "10000"})
        private int inListCount = 1;
        @Param(value={"bigint", "double", "varchar"})
        private String type = "bigint";
        @Param(value={"0.0", "0.05", "0.50", "1.0"})
        private double hitRate;
        @Param(value={"true", "false"})
        public boolean columnarEvaluationEnabled;
        private Page inputPage;
        private PageProcessor processor;
        private Type trinoType;

        @Setup
        public void setup() {
            int i;
            Random random = new Random(0L);
            ArrayList<Object> arguments = new ArrayList<Object>(1 + this.inListCount);
            switch (this.type) {
                case "bigint": {
                    this.trinoType = BigintType.BIGINT;
                    break;
                }
                case "double": {
                    this.trinoType = DoubleType.DOUBLE;
                    break;
                }
                case "varchar": {
                    this.trinoType = VarcharType.VARCHAR;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            ArrayList<Number> inList = new ArrayList<Number>();
            arguments.add(Expressions.field((int)0, (Type)this.trinoType));
            switch (this.type) {
                case "bigint": {
                    for (i = 1; i <= this.inListCount; ++i) {
                        int value = random.nextInt();
                        inList.add(Long.valueOf(value));
                        arguments.add(Expressions.constant((Object)value, (Type)BigintType.BIGINT));
                    }
                    break;
                }
                case "double": {
                    for (i = 1; i <= this.inListCount; ++i) {
                        double value = random.nextDouble();
                        inList.add(value);
                        arguments.add(Expressions.constant((Object)value, (Type)DoubleType.DOUBLE));
                    }
                    break;
                }
                case "varchar": {
                    for (i = 1; i <= this.inListCount; ++i) {
                        Slice value = Slices.utf8Slice((String)Long.toString(random.nextLong()));
                        inList.add((Number)value);
                        arguments.add(Expressions.constant((Object)value, (Type)VarcharType.VARCHAR));
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            InputReferenceExpression project = Expressions.field((int)0, (Type)this.trinoType);
            PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)this.trinoType));
            block43: for (i = 0; i < 10000; ++i) {
                pageBuilder.declarePosition();
                if (random.nextDouble() <= this.hitRate) {
                    switch (this.type) {
                        case "bigint": {
                            BigintType.BIGINT.writeLong(pageBuilder.getBlockBuilder(0), ((Long)inList.get(random.nextInt(inList.size()))).longValue());
                            break;
                        }
                        case "double": {
                            DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(0), ((Double)inList.get(random.nextInt(inList.size()))).doubleValue());
                            break;
                        }
                        case "varchar": {
                            VarcharType.VARCHAR.writeSlice(pageBuilder.getBlockBuilder(0), (Slice)inList.get(random.nextInt(inList.size())));
                        }
                    }
                    continue;
                }
                switch (this.type) {
                    case "bigint": {
                        BigintType.BIGINT.writeLong(pageBuilder.getBlockBuilder(0), (long)random.nextInt());
                        continue block43;
                    }
                    case "double": {
                        DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(0), random.nextDouble());
                        continue block43;
                    }
                    case "varchar": {
                        VarcharType.VARCHAR.writeSlice(pageBuilder.getBlockBuilder(0), Slices.utf8Slice((String)Long.toString(random.nextLong())));
                    }
                }
            }
            this.inputPage = pageBuilder.build();
            MetadataManager metadata = TestMetadataManager.createTestMetadataManager();
            ImmutableList functionalDependencies = ImmutableList.of((Object)metadata.resolveOperator(OperatorType.EQUAL, (List)ImmutableList.of((Object)this.trinoType, (Object)this.trinoType)), (Object)metadata.resolveOperator(OperatorType.HASH_CODE, (List)ImmutableList.of((Object)this.trinoType)), (Object)metadata.resolveOperator(OperatorType.INDETERMINATE, (List)ImmutableList.of((Object)this.trinoType)));
            SpecialForm filter = new SpecialForm(SpecialForm.Form.IN, (Type)BooleanType.BOOLEAN, arguments, (List)functionalDependencies);
            FunctionManager functionManager = FunctionManager.createTestingFunctionManager();
            this.processor = (PageProcessor)new ExpressionCompiler(functionManager, new PageFunctionCompiler(functionManager, 0), new ColumnarFilterCompiler(functionManager, 0)).compilePageProcessor(this.columnarEvaluationEnabled, Optional.of(filter), Optional.empty(), (List)ImmutableList.of((Object)project), Optional.empty(), OptionalInt.empty()).apply(DynamicFilter.EMPTY);
        }
    }
}

