/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.connector.system.GlobalSystemConnector;
import io.trino.connector.system.SystemTableHandle;
import io.trino.metadata.TableHandle;
import io.trino.spi.RefreshType;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IsNull;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.IncrementalRefreshVisitor;
import io.trino.sql.planner.plan.ApplyNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.ProjectNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NullLiteral;
import io.trino.testing.TestingTransactionHandle;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TestIncrementalRefreshVisitor {
    TestIncrementalRefreshVisitor() {
    }

    @Test
    public void testIncrementalRefreshForScanFilterProject() {
        PlanNode root = this.getBasePlan();
        RefreshType refreshType = IncrementalRefreshVisitor.canIncrementallyRefresh((PlanNode)root);
        Assertions.assertThat((Comparable)refreshType).isEqualTo((Object)RefreshType.INCREMENTAL);
    }

    @Test
    public void testFullRefreshForLimitNode() {
        PlanNode base = this.getBasePlan();
        LimitNode root = new LimitNode(new PlanNodeId("limitNode"), base, 10L, false);
        RefreshType refreshType = IncrementalRefreshVisitor.canIncrementallyRefresh((PlanNode)root);
        Assertions.assertThat((Comparable)refreshType).isEqualTo((Object)RefreshType.FULL);
    }

    @Test
    public void testFullRefreshForJoinNode() {
        PlanNode left = this.getBasePlan();
        PlanNode right = this.getBasePlan();
        JoinNode root = new JoinNode(new PlanNodeId("joinNode"), JoinType.INNER, left, right, List.of(), left.getOutputSymbols(), right.getOutputSymbols(), false, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of(), Optional.empty());
        RefreshType refreshType = IncrementalRefreshVisitor.canIncrementallyRefresh((PlanNode)root);
        Assertions.assertThat((Comparable)refreshType).isEqualTo((Object)RefreshType.FULL);
    }

    @Test
    public void testFullRefreshForIntermediateApplyNode() {
        TableScanNode tableScanNode = this.getTableScanNode();
        ApplyNode applyNode = new ApplyNode(new PlanNodeId("applyNode"), (PlanNode)tableScanNode, (PlanNode)tableScanNode, Map.of(), List.of(), (Node)new NullLiteral());
        PlanNode root = this.withFilterAndProject((PlanNode)applyNode);
        RefreshType refreshType = IncrementalRefreshVisitor.canIncrementallyRefresh((PlanNode)root);
        Assertions.assertThat((Comparable)refreshType).isEqualTo((Object)RefreshType.FULL);
    }

    private PlanNode getBasePlan() {
        return this.withFilterAndProject((PlanNode)this.getTableScanNode());
    }

    private PlanNode withFilterAndProject(PlanNode baseNode) {
        FilterNode filterNode = new FilterNode(new PlanNodeId("filterNode"), baseNode, (Expression)new IsNull((Expression)new Reference((Type)VarcharType.VARCHAR, "name")));
        return new ProjectNode(new PlanNodeId("projectNode"), (PlanNode)filterNode, Assignments.of());
    }

    private TableScanNode getTableScanNode() {
        TableHandle tableHandle = new TableHandle(GlobalSystemConnector.CATALOG_HANDLE, (ConnectorTableHandle)new SystemTableHandle("jdbc", "tables", TupleDomain.all()), (ConnectorTransactionHandle)TestingTransactionHandle.create());
        return new TableScanNode(new PlanNodeId("tableScan"), tableHandle, (List)ImmutableList.of(), (Map)ImmutableMap.of(), TupleDomain.all(), Optional.empty(), false, Optional.empty());
    }
}

