/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.connector.StaticConnectorFactory;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.MaterializedViewDefinition;
import io.trino.metadata.Metadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.metadata.ViewColumn;
import io.trino.spi.RefreshType;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SaveMode;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.OperatorType;
import io.trino.spi.security.Identity;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.transaction.IsolationLevel;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.TimestampWithTimeZoneParametricType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeParameter;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.testing.PlanTester;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingMetadata;
import io.trino.testing.TestingSession;
import io.trino.type.DateTimes;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMaterializedViews
extends BasePlanTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ADD_BIGINT = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
    private static final String SCHEMA = "tiny";
    private final TestingMetadata testingConnectorMetadata = new TestingMetadata();

    @Override
    protected PlanTester createPlanTester() {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setCatalog("test_catalog").setSchema(SCHEMA).setSystemProperty("task_concurrency", "1");
        PlanTester planTester = PlanTester.create((Session)sessionBuilder.build());
        planTester.createCatalog("test_catalog", (ConnectorFactory)new StaticConnectorFactory("test", new TestMaterializedViewConnector((ConnectorMetadata)this.testingConnectorMetadata)), (Map)ImmutableMap.of());
        TestingTypeManager typeManager = new TestingTypeManager();
        Metadata metadata = planTester.getPlannerContext().getMetadata();
        SchemaTableName testTable = new SchemaTableName(SCHEMA, "test_table");
        planTester.inTransaction(session -> {
            metadata.createTable(session, "test_catalog", new ConnectorTableMetadata(testTable, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("b", (Type)BigintType.BIGINT))), SaveMode.FAIL);
            return null;
        });
        SchemaTableName storageTable = new SchemaTableName(SCHEMA, "storage_table");
        planTester.inTransaction(session -> {
            metadata.createTable(session, "test_catalog", new ConnectorTableMetadata(storageTable, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("b", (Type)BigintType.BIGINT))), SaveMode.FAIL);
            return null;
        });
        SchemaTableName storageTableWithCasts = new SchemaTableName(SCHEMA, "storage_table_with_casts");
        planTester.inTransaction(session -> {
            metadata.createTable(session, "test_catalog", new ConnectorTableMetadata(storageTableWithCasts, (List)ImmutableList.of((Object)new ColumnMetadata("a", (Type)TinyintType.TINYINT), (Object)new ColumnMetadata("b", (Type)VarcharType.VARCHAR))), SaveMode.FAIL);
            return null;
        });
        Type timestampWithTimezone3 = TimestampWithTimeZoneParametricType.TIMESTAMP_WITH_TIME_ZONE.createType((TypeManager)typeManager, (List)ImmutableList.of((Object)TypeParameter.of((long)3L)));
        SchemaTableName timestampTest = new SchemaTableName(SCHEMA, "timestamp_test");
        planTester.inTransaction(session -> {
            metadata.createTable(session, "test_catalog", new ConnectorTableMetadata(timestampTest, (List)ImmutableList.of((Object)new ColumnMetadata("id", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("ts", timestampWithTimezone3))), SaveMode.FAIL);
            return null;
        });
        SchemaTableName timestampTestStorage = new SchemaTableName(SCHEMA, "timestamp_test_storage");
        planTester.inTransaction(session -> {
            metadata.createTable(session, "test_catalog", new ConnectorTableMetadata(timestampTestStorage, (List)ImmutableList.of((Object)new ColumnMetadata("id", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("ts", (Type)VarcharType.VARCHAR))), SaveMode.FAIL);
            return null;
        });
        QualifiedObjectName freshMaterializedView = new QualifiedObjectName("test_catalog", SCHEMA, "fresh_materialized_view");
        MaterializedViewDefinition materializedViewDefinition = new MaterializedViewDefinition("SELECT a, b FROM test_table", Optional.of("test_catalog"), Optional.of(SCHEMA), (List)ImmutableList.of((Object)new ViewColumn("a", BigintType.BIGINT.getTypeId(), Optional.empty()), (Object)new ViewColumn("b", BigintType.BIGINT.getTypeId(), Optional.empty())), Optional.of(TestingMetadata.STALE_MV_STALENESS.plusHours(1L)), Optional.empty(), Identity.ofUser((String)"some user"), (List)ImmutableList.of(), Optional.of(new CatalogSchemaTableName("test_catalog", SCHEMA, "storage_table")));
        planTester.inTransaction(session -> {
            metadata.createMaterializedView(session, freshMaterializedView, materializedViewDefinition, (Map)ImmutableMap.of(), false, false);
            return null;
        });
        this.testingConnectorMetadata.markMaterializedViewIsFresh(freshMaterializedView.asSchemaTableName());
        QualifiedObjectName notFreshMaterializedView = new QualifiedObjectName("test_catalog", SCHEMA, "not_fresh_materialized_view");
        planTester.inTransaction(session -> {
            metadata.createMaterializedView(session, notFreshMaterializedView, materializedViewDefinition, (Map)ImmutableMap.of(), false, false);
            return null;
        });
        MaterializedViewDefinition materializedViewDefinitionWithCasts = new MaterializedViewDefinition("SELECT a, b FROM test_table", Optional.of("test_catalog"), Optional.of(SCHEMA), (List)ImmutableList.of((Object)new ViewColumn("a", BigintType.BIGINT.getTypeId(), Optional.empty()), (Object)new ViewColumn("b", BigintType.BIGINT.getTypeId(), Optional.empty())), Optional.empty(), Optional.empty(), Identity.ofUser((String)"some user"), (List)ImmutableList.of(), Optional.of(new CatalogSchemaTableName("test_catalog", SCHEMA, "storage_table_with_casts")));
        QualifiedObjectName materializedViewWithCasts = new QualifiedObjectName("test_catalog", SCHEMA, "materialized_view_with_casts");
        planTester.inTransaction(session -> {
            metadata.createMaterializedView(session, materializedViewWithCasts, materializedViewDefinitionWithCasts, (Map)ImmutableMap.of(), false, false);
            return null;
        });
        this.testingConnectorMetadata.markMaterializedViewIsFresh(materializedViewWithCasts.asSchemaTableName());
        planTester.inTransaction(session -> {
            metadata.createMaterializedView(session, new QualifiedObjectName("test_catalog", SCHEMA, "stale_materialized_view_with_casts"), materializedViewDefinitionWithCasts, (Map)ImmutableMap.of(), false, false);
            return null;
        });
        MaterializedViewDefinition materializedViewDefinitionWithTimestamp = new MaterializedViewDefinition("SELECT id, ts FROM timestamp_test", Optional.of("test_catalog"), Optional.of(SCHEMA), (List)ImmutableList.of((Object)new ViewColumn("id", BigintType.BIGINT.getTypeId(), Optional.empty()), (Object)new ViewColumn("ts", timestampWithTimezone3.getTypeId(), Optional.empty())), Optional.empty(), Optional.empty(), Identity.ofUser((String)"some user"), (List)ImmutableList.of(), Optional.of(new CatalogSchemaTableName("test_catalog", SCHEMA, "timestamp_test_storage")));
        QualifiedObjectName materializedViewWithTimestamp = new QualifiedObjectName("test_catalog", SCHEMA, "timestamp_mv_test");
        planTester.inTransaction(session -> {
            metadata.createMaterializedView(session, materializedViewWithTimestamp, materializedViewDefinitionWithTimestamp, (Map)ImmutableMap.of(), false, false);
            return null;
        });
        this.testingConnectorMetadata.markMaterializedViewIsFresh(materializedViewWithTimestamp.asSchemaTableName());
        return planTester;
    }

    private void createMaterializedView(String materializedViewName, String query) {
        Metadata metadata = this.getPlanTester().getPlannerContext().getMetadata();
        QualifiedObjectName matViewName = new QualifiedObjectName("test_catalog", SCHEMA, materializedViewName);
        MaterializedViewDefinition matViewDefinition = new MaterializedViewDefinition(query, Optional.of("test_catalog"), Optional.of(SCHEMA), (List)ImmutableList.of((Object)new ViewColumn("a", BigintType.BIGINT.getTypeId(), Optional.empty()), (Object)new ViewColumn("b", BigintType.BIGINT.getTypeId(), Optional.empty())), Optional.of(TestingMetadata.STALE_MV_STALENESS.plusHours(1L)), Optional.empty(), Identity.ofUser((String)"some user"), (List)ImmutableList.of(), Optional.of(new CatalogSchemaTableName("test_catalog", SCHEMA, "storage_table")));
        this.getPlanTester().inTransaction(session -> {
            metadata.createMaterializedView(session, matViewName, matViewDefinition, (Map)ImmutableMap.of(), false, false);
            return null;
        });
    }

    @Test
    public void testFreshMaterializedView() {
        this.assertPlan("SELECT * FROM fresh_materialized_view", PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("storage_table")));
    }

    @Test
    public void testNotFreshMaterializedView() {
        Session defaultSession = this.getPlanTester().getDefaultSession();
        Session futureSession = Session.builder((Session)defaultSession).setStart(Instant.now().plus(1L, ChronoUnit.DAYS)).build();
        this.assertPlan("SELECT * FROM not_fresh_materialized_view", defaultSession, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("storage_table")));
        this.assertPlan("SELECT * FROM not_fresh_materialized_view", futureSession, PlanMatchPattern.anyTree(PlanMatchPattern.tableScan("test_table")));
    }

    @Test
    public void testRefreshTypes() {
        this.createMaterializedView("simple_materialized_view", "SELECT a as new_name, b FROM test_table WHERE a is not null and b > 1");
        Optional<RefreshType> refreshType = this.getRefreshType("simple_materialized_view");
        Assertions.assertThat(refreshType).isPresent();
        Assertions.assertThat((Comparable)refreshType.get()).isEqualTo((Object)RefreshType.INCREMENTAL);
        this.createMaterializedView("aggregation_materialized_view", "SELECT a, count(*) FROM test_table GROUP BY a");
        refreshType = this.getRefreshType("aggregation_materialized_view");
        Assertions.assertThat(refreshType).isPresent();
        Assertions.assertThat((Comparable)refreshType.get()).isEqualTo((Object)RefreshType.FULL);
        this.createMaterializedView("join_materialized_view", "SELECT a.a, b.b FROM test_table a JOIN test_table b on a.a = b.a");
        refreshType = this.getRefreshType("join_materialized_view");
        Assertions.assertThat(refreshType).isPresent();
        Assertions.assertThat((Comparable)refreshType.get()).isEqualTo((Object)RefreshType.FULL);
        this.createMaterializedView("distinct_materialized_view", "SELECT distinct a, b FROM test_table");
        refreshType = this.getRefreshType("distinct_materialized_view");
        Assertions.assertThat(refreshType).isPresent();
        Assertions.assertThat((Comparable)refreshType.get()).isEqualTo((Object)RefreshType.FULL);
        this.createMaterializedView("table_subquery_materialized_view", "SELECT a, b FROM (SELECT a, b FROM (VALUES (1, 2), (3, 4)) t(a, b))");
        refreshType = this.getRefreshType("table_subquery_materialized_view");
        Assertions.assertThat(refreshType).isPresent();
        Assertions.assertThat((Comparable)refreshType.get()).isEqualTo((Object)RefreshType.FULL);
        this.createMaterializedView("where_subquery_materialized_view", "SELECT a, b FROM test_table WHERE b in (SELECT b FROM test_table WHERE a < 0)");
        refreshType = this.getRefreshType("where_subquery_materialized_view");
        Assertions.assertThat(refreshType).isPresent();
        Assertions.assertThat((Comparable)refreshType.get()).isEqualTo((Object)RefreshType.FULL);
        this.createMaterializedView("union_view", "SELECT a, b FROM test_table a WHERE a.b in (6, 9) UNION ALL SELECT a, b FROM test_table b WHERE b.b in (1, 5)");
        refreshType = this.getRefreshType("union_view");
        Assertions.assertThat(refreshType).isPresent();
        Assertions.assertThat((Comparable)refreshType.get()).isEqualTo((Object)RefreshType.FULL);
    }

    @Test
    public void testMaterializedViewWithCasts() {
        TestingAccessControlManager accessControl = this.getPlanTester().getAccessControl();
        accessControl.columnMask(new QualifiedObjectName("test_catalog", SCHEMA, "materialized_view_with_casts"), "a", "user", ViewExpression.builder().expression("a + 1").build());
        this.assertPlan("SELECT * FROM materialized_view_with_casts", PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"A_CAST", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Cast((Expression)new Reference((Type)BigintType.BIGINT, "A"), (Type)BigintType.BIGINT), (Object)new Constant((Type)BigintType.BIGINT, (Object)1L)))), (Object)"B_CAST", (Object)PlanMatchPattern.expression((Expression)new Cast((Expression)new Reference((Type)BigintType.BIGINT, "B"), (Type)BigintType.BIGINT))), PlanMatchPattern.tableScan("storage_table_with_casts", (Map<String, String>)ImmutableMap.of((Object)"A", (Object)"a", (Object)"B", (Object)"b")))));
    }

    @Test
    public void testRefreshMaterializedViewWithCasts() {
        this.assertPlan("REFRESH MATERIALIZED VIEW stale_materialized_view_with_casts", PlanMatchPattern.anyTree(PlanMatchPattern.tableWriter(List.of("A_CAST", "B_CAST"), List.of("a", "b"), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, PlanMatchPattern.project(Map.of("A_CAST", PlanMatchPattern.expression((Expression)new Cast((Expression)new Reference((Type)BigintType.BIGINT, "A"), (Type)TinyintType.TINYINT)), "B_CAST", PlanMatchPattern.expression((Expression)new Cast((Expression)new Reference((Type)BigintType.BIGINT, "B"), (Type)VarcharType.VARCHAR))), PlanMatchPattern.tableScan("test_table", Map.of("A", "a", "B", "b")))))));
        this.assertPlan("REFRESH MATERIALIZED VIEW materialized_view_with_casts", PlanMatchPattern.output(PlanMatchPattern.values(List.of("rows"), List.of(List.of(new Constant((Type)BigintType.BIGINT, (Object)0L))))));
    }

    @Test
    public void testMaterializedViewWithTimestamp() {
        this.assertPlan("SELECT * FROM timestamp_mv_test WHERE ts < TIMESTAMP '2024-01-01 00:00:00.000 America/New_York'", PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"ts_0", (Object)PlanMatchPattern.expression((Expression)new Cast((Expression)new Reference((Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, "ts"), (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS))), PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Cast((Expression)new Reference((Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, "ts"), (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS), (Expression)new Constant((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3), DateTimes.parseTimestampWithTimeZone((int)3, (String)"2024-01-01 00:00:00.000 America/New_York"))), PlanMatchPattern.tableScan("timestamp_test_storage", (Map<String, String>)ImmutableMap.of((Object)"ts", (Object)"ts", (Object)"id", (Object)"id"))))));
    }

    private Optional<RefreshType> getRefreshType(String matViewTable) {
        PlanTester planTester = this.getPlanTester();
        Session session = planTester.getDefaultSession();
        String queryId = (String)planTester.inTransaction(session, transactionSession -> {
            planTester.createPlan(transactionSession, "REFRESH MATERIALIZED VIEW " + matViewTable, planTester.getPlanOptimizers(true), LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, WarningCollector.NOOP, PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector());
            return transactionSession.getQueryId().toString();
        });
        return this.testingConnectorMetadata.getRefreshType(queryId);
    }

    private static class TestMaterializedViewConnector
    implements Connector {
        private final ConnectorMetadata metadata;

        public TestMaterializedViewConnector(ConnectorMetadata metadata) {
            this.metadata = metadata;
        }

        public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
            return new ConnectorTransactionHandle(this){};
        }

        public ConnectorMetadata getMetadata(ConnectorSession session, ConnectorTransactionHandle transaction) {
            return this.metadata;
        }
    }
}

