/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.PlanTestSymbol;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.assertions.WindowFunction;
import io.trino.sql.planner.plan.WindowNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class WindowFunctionProvider
implements ExpectedValueProvider<WindowFunction> {
    private final String name;
    private final WindowNode.Frame frame;
    private final List<PlanTestSymbol> args;
    private final List<PlanMatchPattern.Ordering> orderBy;

    public WindowFunctionProvider(String name, WindowNode.Frame frame, List<PlanTestSymbol> args, List<PlanMatchPattern.Ordering> orderBy) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.frame = Objects.requireNonNull(frame, "frame is null");
        this.args = Objects.requireNonNull(args, "args is null");
        this.orderBy = ImmutableList.copyOf(orderBy);
    }

    public String toString() {
        return "%s(%s%s) %s".formatted(this.name, Joiner.on((String)", ").join(this.args), this.orderBy.isEmpty() ? "" : " ORDER BY " + Joiner.on((String)", ").join(this.orderBy), this.frame);
    }

    @Override
    public WindowFunction getExpectedValue(SymbolAliases aliases) {
        Optional<OrderingScheme> orderingScheme = Optional.empty();
        if (!this.orderBy.isEmpty()) {
            ImmutableList.Builder fields = ImmutableList.builder();
            ImmutableMap.Builder orders = ImmutableMap.builder();
            for (PlanMatchPattern.Ordering ordering : this.orderBy) {
                Reference reference = aliases.get(ordering.getField());
                Symbol symbol = new Symbol(reference.type(), reference.name());
                fields.add((Object)symbol);
                orders.put((Object)symbol, (Object)ordering.getSortOrder());
            }
            orderingScheme = Optional.of(new OrderingScheme((List)fields.build(), (Map)orders.buildOrThrow()));
        }
        return new WindowFunction(this.name, this.frame, PlanMatchPattern.toSymbolReferences(this.args, aliases), orderingScheme);
    }
}

