/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.Plugin;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneWindowColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.FrameBoundType;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.WindowFrameType;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.tree.SortItem;
import io.trino.type.UnknownType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.junit.jupiter.api.Test;

public class TestPruneWindowColumns
extends BaseRuleTest {
    private static final ResolvedFunction MIN_FUNCTION = new TestingFunctionResolution().resolveFunction("min", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));
    private static final List<String> inputSymbolNameList = ImmutableList.of((Object)"orderKey", (Object)"partitionKey", (Object)"hash", (Object)"startValue1", (Object)"startValue2", (Object)"endValue1", (Object)"endValue2", (Object)"input1", (Object)"input2", (Object)"aggOrderInput1", (Object)"aggOrderInput2", (Object)"unused", (Object[])new String[0]);
    private static final Set<String> inputSymbolNameSet = ImmutableSet.copyOf(inputSymbolNameList);
    private static final WindowNode.Frame FRAME1 = new WindowNode.Frame(WindowFrameType.RANGE, FrameBoundType.UNBOUNDED_PRECEDING, Optional.of(new Symbol((Type)UnknownType.UNKNOWN, "startValue1")), Optional.of(new Symbol((Type)UnknownType.UNKNOWN, "orderKey")), FrameBoundType.CURRENT_ROW, Optional.of(new Symbol((Type)UnknownType.UNKNOWN, "endValue1")), Optional.of(new Symbol((Type)UnknownType.UNKNOWN, "orderKey")));
    private static final WindowNode.Frame FRAME2 = new WindowNode.Frame(WindowFrameType.RANGE, FrameBoundType.UNBOUNDED_PRECEDING, Optional.of(new Symbol((Type)UnknownType.UNKNOWN, "startValue2")), Optional.of(new Symbol((Type)UnknownType.UNKNOWN, "orderKey")), FrameBoundType.CURRENT_ROW, Optional.of(new Symbol((Type)UnknownType.UNKNOWN, "endValue2")), Optional.of(new Symbol((Type)UnknownType.UNKNOWN, "orderKey")));

    public TestPruneWindowColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testWindowNotNeeded() {
        this.tester().assertThat((Rule<?>)new PruneWindowColumns()).on(p -> TestPruneWindowColumns.buildProjectedWindow(p, symbol -> inputSymbolNameSet.contains(symbol.name()), (Predicate<Symbol>)Predicates.alwaysTrue())).matches(PlanMatchPattern.strictProject(Maps.asMap(inputSymbolNameSet, symbol -> PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, symbol))), PlanMatchPattern.values(inputSymbolNameList)));
    }

    @Test
    public void testOneFunctionNotNeeded() {
        this.tester().assertThat((Rule<?>)new PruneWindowColumns()).on(p -> TestPruneWindowColumns.buildProjectedWindow(p, symbol -> symbol.name().equals("output2") || symbol.name().equals("unused"), (Predicate<Symbol>)Predicates.alwaysTrue())).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"output2", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "output2")), (Object)"unused", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "unused"))), PlanMatchPattern.window(windowBuilder -> windowBuilder.prePartitionedInputs((Set<String>)ImmutableSet.of()).specification((List<String>)ImmutableList.of((Object)"partitionKey"), (List<String>)ImmutableList.of((Object)"orderKey"), (Map<String, SortOrder>)ImmutableMap.of((Object)"orderKey", (Object)SortOrder.ASC_NULLS_FIRST)).preSortedOrderPrefix(0).addFunction("output2", PlanMatchPattern.windowFunction("min", (List<String>)ImmutableList.of((Object)"input2"), FRAME2, List.of(PlanMatchPattern.sort("aggOrderInput2", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)))).hashSymbol("hash"), PlanMatchPattern.strictProject(Maps.asMap((Set)Sets.difference(inputSymbolNameSet, (Set)ImmutableSet.of((Object)"input1", (Object)"startValue1", (Object)"endValue1", (Object)"aggOrderInput1")), symbol -> PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, symbol))), PlanMatchPattern.values(inputSymbolNameList)))));
    }

    @Test
    public void testAllColumnsNeeded() {
        this.tester().assertThat((Rule<?>)new PruneWindowColumns()).on(p -> TestPruneWindowColumns.buildProjectedWindow(p, (Predicate<Symbol>)Predicates.alwaysTrue(), (Predicate<Symbol>)Predicates.alwaysTrue())).doesNotFire();
    }

    @Test
    public void testUsedInputsNotNeeded() {
        this.tester().assertThat((Rule<?>)new PruneWindowColumns()).on(p -> TestPruneWindowColumns.buildProjectedWindow(p, symbol -> !inputSymbolNameSet.contains(symbol.name()), symbol -> !symbol.name().equals("unused"))).doesNotFire();
    }

    @Test
    public void testUnusedInputNotNeeded() {
        this.tester().assertThat((Rule<?>)new PruneWindowColumns()).on(p -> TestPruneWindowColumns.buildProjectedWindow(p, symbol -> !inputSymbolNameSet.contains(symbol.name()), (Predicate<Symbol>)Predicates.alwaysTrue())).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"output1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "output1")), (Object)"output2", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "output2"))), PlanMatchPattern.window(windowBuilder -> windowBuilder.prePartitionedInputs((Set<String>)ImmutableSet.of()).specification((List<String>)ImmutableList.of((Object)"partitionKey"), (List<String>)ImmutableList.of((Object)"orderKey"), (Map<String, SortOrder>)ImmutableMap.of((Object)"orderKey", (Object)SortOrder.ASC_NULLS_FIRST)).preSortedOrderPrefix(0).addFunction("output1", PlanMatchPattern.windowFunction("min", (List<String>)ImmutableList.of((Object)"input1"), FRAME1, List.of(PlanMatchPattern.sort("aggOrderInput1", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)))).addFunction("output2", PlanMatchPattern.windowFunction("min", (List<String>)ImmutableList.of((Object)"input2"), FRAME2, List.of(PlanMatchPattern.sort("aggOrderInput2", SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)))).hashSymbol("hash"), PlanMatchPattern.strictProject(Maps.asMap((Set)Sets.filter(inputSymbolNameSet, symbolName -> !symbolName.equals("unused")), symbol -> PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, symbol))), PlanMatchPattern.values(inputSymbolNameList)))));
    }

    private static PlanNode buildProjectedWindow(PlanBuilder p, Predicate<Symbol> projectionFilter, Predicate<Symbol> sourceFilter) {
        Symbol orderKey = p.symbol("orderKey");
        Symbol partitionKey = p.symbol("partitionKey");
        Symbol hash = p.symbol("hash");
        Symbol startValue1 = p.symbol("startValue1");
        Symbol startValue2 = p.symbol("startValue2");
        Symbol endValue1 = p.symbol("endValue1");
        Symbol endValue2 = p.symbol("endValue2");
        Symbol input1 = p.symbol("input1");
        Symbol input2 = p.symbol("input2");
        Symbol aggOrderInput1 = p.symbol("aggOrderInput1");
        Symbol aggOrderInput2 = p.symbol("aggOrderInput2");
        Symbol unused = p.symbol("unused");
        Symbol output1 = p.symbol("output1");
        Symbol output2 = p.symbol("output2");
        ImmutableList inputs = ImmutableList.of((Object)orderKey, (Object)partitionKey, (Object)hash, (Object)startValue1, (Object)startValue2, (Object)endValue1, (Object)endValue2, (Object)input1, (Object)input2, (Object)aggOrderInput1, (Object)aggOrderInput2, (Object)unused, (Object[])new Symbol[0]);
        ImmutableList outputs = ImmutableList.builder().addAll((Iterable)inputs).add((Object[])new Symbol[]{output1, output2}).build();
        return p.project(Assignments.identity((Iterable)((Iterable)outputs.stream().filter(projectionFilter).collect(ImmutableList.toImmutableList()))), (PlanNode)p.window(new DataOrganizationSpecification((List)ImmutableList.of((Object)partitionKey), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)orderKey), (Map)ImmutableMap.of((Object)orderKey, (Object)SortOrder.ASC_NULLS_FIRST)))), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)output1, (Object)new WindowNode.Function(MIN_FUNCTION, (List)ImmutableList.of((Object)input1.toSymbolReference()), Optional.of(new OrderingScheme(List.of(aggOrderInput1), Map.of(aggOrderInput1, SortOrder.ASC_NULLS_FIRST))), new WindowNode.Frame(WindowFrameType.RANGE, FrameBoundType.UNBOUNDED_PRECEDING, Optional.of(startValue1), Optional.of(orderKey), FrameBoundType.CURRENT_ROW, Optional.of(endValue1), Optional.of(orderKey)), false), (Object)output2, (Object)new WindowNode.Function(MIN_FUNCTION, (List)ImmutableList.of((Object)input2.toSymbolReference()), Optional.of(new OrderingScheme(List.of(aggOrderInput2), Map.of(aggOrderInput2, SortOrder.ASC_NULLS_FIRST))), new WindowNode.Frame(WindowFrameType.RANGE, FrameBoundType.UNBOUNDED_PRECEDING, Optional.of(startValue2), Optional.of(orderKey), FrameBoundType.CURRENT_ROW, Optional.of(endValue2), Optional.of(orderKey)), false)), hash, (PlanNode)p.values((List)inputs.stream().filter(sourceFilter).collect(ImmutableList.toImmutableList()), (List<List<Expression>>)ImmutableList.of())));
    }
}

