/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.Plugin;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushdownLimitIntoWindow;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.WindowNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestPushdownLimitIntoWindow
extends BaseRuleTest {
    public TestPushdownLimitIntoWindow() {
        super(new Plugin[0]);
    }

    @Test
    public void testLimitAboveWindow() {
        this.assertLimitAboveWindow("row_number");
        this.assertLimitAboveWindow("rank");
    }

    private void assertLimitAboveWindow(String rankingFunctionName) {
        ResolvedFunction ranking = this.tester().getMetadata().resolveBuiltinFunction(rankingFunctionName, TypeSignatureProvider.fromTypes((Type[])new Type[0]));
        this.tester().assertThat((Rule<?>)new PushdownLimitIntoWindow()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumberSymbol = p.symbol("row_number_1");
            OrderingScheme orderingScheme = new OrderingScheme((List)ImmutableList.of((Object)a), (Map)ImmutableMap.of((Object)a, (Object)SortOrder.ASC_NULLS_FIRST));
            return p.limit(3L, (PlanNode)p.window(new DataOrganizationSpecification((List)ImmutableList.of((Object)a), Optional.of(orderingScheme)), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)rowNumberSymbol, (Object)TestPushdownLimitIntoWindow.newWindowNodeFunction(ranking, a)), (PlanNode)p.values(a)));
        }).matches(PlanMatchPattern.limit(3L, PlanMatchPattern.topNRanking(pattern -> pattern.specification((List<String>)ImmutableList.of((Object)"a"), (List<String>)ImmutableList.of((Object)"a"), (Map<String, SortOrder>)ImmutableMap.of((Object)"a", (Object)SortOrder.ASC_NULLS_FIRST)).maxRankingPerPartition(3).partial(false), PlanMatchPattern.values("a"))));
    }

    @Test
    public void testConvertToTopNRowNumber() {
        ResolvedFunction ranking = this.tester().getMetadata().resolveBuiltinFunction("row_number", TypeSignatureProvider.fromTypes((Type[])new Type[0]));
        this.tester().assertThat((Rule<?>)new PushdownLimitIntoWindow()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumberSymbol = p.symbol("row_number_1");
            OrderingScheme orderingScheme = new OrderingScheme((List)ImmutableList.of((Object)a), (Map)ImmutableMap.of((Object)a, (Object)SortOrder.ASC_NULLS_FIRST));
            return p.limit(3L, (PlanNode)p.window(new DataOrganizationSpecification((List)ImmutableList.of(), Optional.of(orderingScheme)), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)rowNumberSymbol, (Object)TestPushdownLimitIntoWindow.newWindowNodeFunction(ranking, a)), (PlanNode)p.values(a)));
        }).matches(PlanMatchPattern.topNRanking(pattern -> pattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"a"), (Map<String, SortOrder>)ImmutableMap.of((Object)"a", (Object)SortOrder.ASC_NULLS_FIRST)).maxRankingPerPartition(3).partial(false), PlanMatchPattern.values("a")));
    }

    @Test
    public void testLimitWithPreSortedInputs() {
        ResolvedFunction ranking = this.tester().getMetadata().resolveBuiltinFunction("row_number", TypeSignatureProvider.fromTypes((Type[])new Type[0]));
        this.tester().assertThat((Rule<?>)new PushdownLimitIntoWindow()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumberSymbol = p.symbol("row_number_1");
            OrderingScheme orderingScheme = new OrderingScheme((List)ImmutableList.of((Object)a), (Map)ImmutableMap.of((Object)a, (Object)SortOrder.ASC_NULLS_FIRST));
            return p.limit(3L, false, (List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.window(new DataOrganizationSpecification((List)ImmutableList.of(), Optional.of(orderingScheme)), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)rowNumberSymbol, (Object)TestPushdownLimitIntoWindow.newWindowNodeFunction(ranking, a)), (PlanNode)p.values(a)));
        }).doesNotFire();
    }

    @Test
    public void testZeroLimit() {
        this.assertZeroLimit("row_number");
        this.assertZeroLimit("rank");
    }

    private void assertZeroLimit(String rankingFunctionName) {
        ResolvedFunction ranking = this.tester().getMetadata().resolveBuiltinFunction(rankingFunctionName, TypeSignatureProvider.fromTypes((Type[])new Type[0]));
        this.tester().assertThat((Rule<?>)new PushdownLimitIntoWindow()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumberSymbol = p.symbol("row_number_1");
            OrderingScheme orderingScheme = new OrderingScheme((List)ImmutableList.of((Object)a), (Map)ImmutableMap.of((Object)a, (Object)SortOrder.ASC_NULLS_FIRST));
            return p.limit(0L, (PlanNode)p.window(new DataOrganizationSpecification((List)ImmutableList.of((Object)a), Optional.of(orderingScheme)), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)rowNumberSymbol, (Object)TestPushdownLimitIntoWindow.newWindowNodeFunction(ranking, a)), (PlanNode)p.values(a)));
        }).doesNotFire();
    }

    @Test
    public void testWindowNotOrdered() {
        this.assertWindowNotOrdered("row_number");
        this.assertWindowNotOrdered("rank");
    }

    private void assertWindowNotOrdered(String rankingFunctionName) {
        ResolvedFunction ranking = this.tester().getMetadata().resolveBuiltinFunction(rankingFunctionName, TypeSignatureProvider.fromTypes((Type[])new Type[0]));
        this.tester().assertThat((Rule<?>)new PushdownLimitIntoWindow()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumberSymbol = p.symbol("row_number_1");
            return p.limit(3L, (PlanNode)p.window(new DataOrganizationSpecification((List)ImmutableList.of((Object)a), Optional.empty()), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)rowNumberSymbol, (Object)TestPushdownLimitIntoWindow.newWindowNodeFunction(ranking, a)), (PlanNode)p.values(a)));
        }).doesNotFire();
    }

    @Test
    public void testMultipleWindowFunctions() {
        ResolvedFunction rowNumberFunction = this.tester().getMetadata().resolveBuiltinFunction("row_number", TypeSignatureProvider.fromTypes((Type[])new Type[0]));
        ResolvedFunction rankFunction = this.tester().getMetadata().resolveBuiltinFunction("rank", TypeSignatureProvider.fromTypes((Type[])new Type[0]));
        this.tester().assertThat((Rule<?>)new PushdownLimitIntoWindow()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol rowNumberSymbol = p.symbol("row_number_1");
            Symbol rankSymbol = p.symbol("rank_1");
            return p.limit(3L, (PlanNode)p.window(new DataOrganizationSpecification((List)ImmutableList.of((Object)a), Optional.empty()), (Map<Symbol, WindowNode.Function>)ImmutableMap.of((Object)rowNumberSymbol, (Object)TestPushdownLimitIntoWindow.newWindowNodeFunction(rowNumberFunction, a), (Object)rankSymbol, (Object)TestPushdownLimitIntoWindow.newWindowNodeFunction(rankFunction, a)), (PlanNode)p.values(a)));
        }).doesNotFire();
    }

    private static WindowNode.Function newWindowNodeFunction(ResolvedFunction resolvedFunction, Symbol symbol) {
        return new WindowNode.Function(resolvedFunction, (List)ImmutableList.of((Object)symbol.toSymbolReference()), Optional.empty(), WindowNode.Frame.DEFAULT_FRAME, false);
    }
}

