/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provider;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.trino.block.BlockJsonSerde;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestMetadataManager;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.TestingBlockEncodingSerde;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolKeyDeserializer;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.FrameBoundType;
import io.trino.sql.planner.plan.PatternRecognitionNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.RowsPerMatch;
import io.trino.sql.planner.plan.SkipToPosition;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.planner.plan.WindowFrameType;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.planner.rowpattern.AggregatedSetDescriptor;
import io.trino.sql.planner.rowpattern.AggregationValuePointer;
import io.trino.sql.planner.rowpattern.ClassifierValuePointer;
import io.trino.sql.planner.rowpattern.ExpressionAndValuePointers;
import io.trino.sql.planner.rowpattern.LogicalIndexPointer;
import io.trino.sql.planner.rowpattern.MatchNumberValuePointer;
import io.trino.sql.planner.rowpattern.ScalarValuePointer;
import io.trino.sql.planner.rowpattern.ValuePointer;
import io.trino.sql.planner.rowpattern.ir.IrConcatenation;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import io.trino.sql.planner.rowpattern.ir.IrRowPattern;
import io.trino.type.TypeDeserializer;
import io.trino.type.TypeSignatureKeyDeserializer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPatternRecognitionNodeSerialization {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction RANDOM = FUNCTIONS.resolveFunction("random", TypeSignatureProvider.fromTypes((Type[])new Type[0]));
    private static final ResolvedFunction NEGATION_BIGINT = FUNCTIONS.resolveOperator(OperatorType.NEGATION, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT));
    private static final ResolvedFunction NEGATION_INTEGER = FUNCTIONS.resolveOperator(OperatorType.NEGATION, (List<? extends Type>)ImmutableList.of((Object)IntegerType.INTEGER));
    private static final JsonCodec<ValuePointer> VALUE_POINTER_CODEC;
    private static final JsonCodec<ExpressionAndValuePointers> EXPRESSION_AND_VALUE_POINTERS_CODEC;
    private static final JsonCodec<PatternRecognitionNode.Measure> MEASURE_CODEC;
    private static final JsonCodec<PatternRecognitionNode> PATTERN_RECOGNITION_NODE_CODEC;

    @Test
    public void testScalarValuePointerRoundtrip() {
        TestPatternRecognitionNodeSerialization.assertJsonRoundTrip(VALUE_POINTER_CODEC, new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of(), false, false, 5, 5), new Symbol((Type)BigintType.BIGINT, "input_symbol")));
        TestPatternRecognitionNodeSerialization.assertJsonRoundTrip(VALUE_POINTER_CODEC, new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("A"), (Object)new IrLabel("B")), true, true, 1, -1), new Symbol((Type)BigintType.BIGINT, "input_symbol")));
    }

    @Test
    public void testAggregationValuePointerRoundtrip() {
        ResolvedFunction countFunction = TestMetadataManager.createTestMetadataManager().resolveBuiltinFunction("count", (List)ImmutableList.of());
        TestPatternRecognitionNodeSerialization.assertJsonRoundTrip(VALUE_POINTER_CODEC, new AggregationValuePointer(countFunction, new AggregatedSetDescriptor((Set)ImmutableSet.of(), false), (List)ImmutableList.of(), Optional.of(new Symbol((Type)VarcharType.VARCHAR, "classifier")), Optional.of(new Symbol((Type)BigintType.BIGINT, "match_number"))));
        ResolvedFunction maxFunction = TestMetadataManager.createTestMetadataManager().resolveBuiltinFunction("max", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));
        TestPatternRecognitionNodeSerialization.assertJsonRoundTrip(VALUE_POINTER_CODEC, new AggregationValuePointer(maxFunction, new AggregatedSetDescriptor((Set)ImmutableSet.of((Object)new IrLabel("A"), (Object)new IrLabel("B")), true), (List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, null)), Optional.of(new Symbol((Type)VarcharType.VARCHAR, "classifier")), Optional.of(new Symbol((Type)BigintType.BIGINT, "match_number"))));
    }

    @Test
    public void testExpressionAndValuePointersRoundtrip() {
        TestPatternRecognitionNodeSerialization.assertJsonRoundTrip(EXPRESSION_AND_VALUE_POINTERS_CODEC, new ExpressionAndValuePointers((Expression)new Constant((Type)BigintType.BIGINT, null), (List)ImmutableList.of()));
        TestPatternRecognitionNodeSerialization.assertJsonRoundTrip(EXPRESSION_AND_VALUE_POINTERS_CODEC, new ExpressionAndValuePointers(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)VarcharType.VARCHAR, "classifier"), (Expression)new Reference((Type)VarcharType.VARCHAR, "x")), (Expression)new Cast((Expression)new Call(RANDOM, (List)ImmutableList.of()), (Type)IntegerType.INTEGER), (Expression)new Call(NEGATION_INTEGER, (List)ImmutableList.of((Object)new Reference((Type)IntegerType.INTEGER, "match_number")))), (List)ImmutableList.of((Object)new ExpressionAndValuePointers.Assignment(new Symbol((Type)VarcharType.VARCHAR, "classifier"), (ValuePointer)new ClassifierValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("A"), (Object)new IrLabel("B")), false, true, 1, -1))), (Object)new ExpressionAndValuePointers.Assignment(new Symbol((Type)BigintType.BIGINT, "x"), (ValuePointer)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("B")), true, false, 2, 1), new Symbol((Type)BigintType.BIGINT, "input_symbol_a"))), (Object)new ExpressionAndValuePointers.Assignment(new Symbol((Type)BigintType.BIGINT, "match_number"), (ValuePointer)new MatchNumberValuePointer()))));
    }

    @Test
    public void testMeasureRoundtrip() {
        TestPatternRecognitionNodeSerialization.assertJsonRoundTrip(MEASURE_CODEC, new PatternRecognitionNode.Measure(new ExpressionAndValuePointers((Expression)new Constant((Type)BigintType.BIGINT, null), (List)ImmutableList.of()), (Type)BooleanType.BOOLEAN));
        TestPatternRecognitionNodeSerialization.assertJsonRoundTrip(MEASURE_CODEC, new PatternRecognitionNode.Measure(new ExpressionAndValuePointers(IrExpressions.ifExpression((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)IntegerType.INTEGER, "match_number"), (Expression)new Reference((Type)IntegerType.INTEGER, "x")), (Expression)new Constant((Type)BigintType.BIGINT, (Object)10L), (Expression)new Call(NEGATION_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "y")))), (List)ImmutableList.of((Object)new ExpressionAndValuePointers.Assignment(new Symbol((Type)BigintType.BIGINT, "match_number"), (ValuePointer)new MatchNumberValuePointer()), (Object)new ExpressionAndValuePointers.Assignment(new Symbol((Type)BigintType.BIGINT, "x"), (ValuePointer)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of(), true, true, 0, 0), new Symbol((Type)BigintType.BIGINT, "input_symbol_a"))), (Object)new ExpressionAndValuePointers.Assignment(new Symbol((Type)BigintType.BIGINT, "y"), (ValuePointer)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("B")), false, true, 1, -1), new Symbol((Type)BigintType.BIGINT, "input_symbol_b"))))), (Type)BigintType.BIGINT));
    }

    @Test
    public void testPatternRecognitionNodeRoundtrip() {
        ResolvedFunction rankFunction = TestMetadataManager.createTestMetadataManager().resolveBuiltinFunction("rank", (List)ImmutableList.of());
        PatternRecognitionNode node = new PatternRecognitionNode(new PlanNodeId("0"), (PlanNode)new ValuesNode(new PlanNodeId("1"), 1), new DataOrganizationSpecification((List)ImmutableList.of(), Optional.empty()), Optional.empty(), (Set)ImmutableSet.of(), 0, (Map)ImmutableMap.of((Object)new Symbol((Type)BigintType.BIGINT, "rank"), (Object)new WindowNode.Function(rankFunction, (List)ImmutableList.of(), Optional.empty(), new WindowNode.Frame(WindowFrameType.ROWS, FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBoundType.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty()), false)), (Map)ImmutableMap.of((Object)new Symbol((Type)BooleanType.BOOLEAN, "measure"), (Object)new PatternRecognitionNode.Measure(new ExpressionAndValuePointers((Expression)new Constant((Type)BooleanType.BOOLEAN, null), (List)ImmutableList.of()), (Type)BooleanType.BOOLEAN)), Optional.of(new WindowNode.Frame(WindowFrameType.ROWS, FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBoundType.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty())), RowsPerMatch.WINDOW, (Set)ImmutableSet.of((Object)new IrLabel("B")), SkipToPosition.LAST, true, (IrRowPattern)new IrConcatenation((List)ImmutableList.of((Object)new IrLabel("A"), (Object)new IrLabel("B"), (Object)new IrLabel("C"))), (Map)ImmutableMap.of((Object)new IrLabel("B"), (Object)new ExpressionAndValuePointers((Expression)new Constant((Type)BigintType.BIGINT, null), (List)ImmutableList.of()), (Object)new IrLabel("C"), (Object)new ExpressionAndValuePointers((Expression)new Constant((Type)BigintType.BIGINT, null), (List)ImmutableList.of())));
        PatternRecognitionNode roundtripNode = (PatternRecognitionNode)PATTERN_RECOGNITION_NODE_CODEC.fromJson(PATTERN_RECOGNITION_NODE_CODEC.toJson((Object)node));
        Assertions.assertThat((Map)roundtripNode.getMeasures()).isEqualTo((Object)node.getMeasures());
        Assertions.assertThat((Comparable)roundtripNode.getRowsPerMatch()).isEqualTo((Object)node.getRowsPerMatch());
        Assertions.assertThat((Collection)roundtripNode.getSkipToLabels()).isEqualTo((Object)node.getSkipToLabels());
        Assertions.assertThat((Comparable)roundtripNode.getSkipToPosition()).isEqualTo((Object)node.getSkipToPosition());
        Assertions.assertThat((boolean)roundtripNode.isInitial()).isEqualTo(node.isInitial());
        Assertions.assertThat((Object)roundtripNode.getPattern()).isEqualTo((Object)node.getPattern());
        Assertions.assertThat((Map)roundtripNode.getVariableDefinitions()).isEqualTo((Object)node.getVariableDefinitions());
    }

    public static <T> void assertJsonRoundTrip(JsonCodec<T> codec, T object) {
        String json = codec.toJson(object);
        Object copy = codec.fromJson(json);
        Assertions.assertThat((Object)copy).isEqualTo(object);
    }

    static {
        ObjectMapperProvider provider = new ObjectMapperProvider();
        provider.setKeyDeserializers((Map)ImmutableMap.builder().put(TypeSignature.class, (Object)new TypeSignatureKeyDeserializer()).put(Symbol.class, (Object)new SymbolKeyDeserializer((TypeManager)new TestingTypeManager())).buildOrThrow());
        provider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)new TypeDeserializer((TypeManager)new TestingTypeManager()), Block.class, (Object)new BlockJsonSerde.Deserializer((BlockEncodingSerde)new TestingBlockEncodingSerde())));
        provider.setJsonSerializers((Map)ImmutableMap.of(Block.class, (Object)new BlockJsonSerde.Serializer((BlockEncodingSerde)new TestingBlockEncodingSerde())));
        VALUE_POINTER_CODEC = new JsonCodecFactory((Provider)provider).jsonCodec(ValuePointer.class);
        EXPRESSION_AND_VALUE_POINTERS_CODEC = new JsonCodecFactory((Provider)provider).jsonCodec(ExpressionAndValuePointers.class);
        MEASURE_CODEC = new JsonCodecFactory((Provider)provider).jsonCodec(PatternRecognitionNode.Measure.class);
        PATTERN_RECOGNITION_NODE_CODEC = new JsonCodecFactory((Provider)provider).jsonCodec(PatternRecognitionNode.class);
    }
}

