/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.assertions.TrinoExceptionAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestDecimalCasts {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testBooleanToDecimalCasts() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(2, 0))").binding("a", "true")))).isEqualTo(SqlDecimal.decimal((String)"01", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(3, 1))").binding("a", "true")))).isEqualTo(SqlDecimal.decimal((String)"01.0", (DecimalType)DecimalType.createDecimalType((int)3, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL)").binding("a", "true")))).isEqualTo(SqlDecimal.decimal((String)"1", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(2))").binding("a", "true")))).isEqualTo(SqlDecimal.decimal((String)"01", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(2, 0))").binding("a", "false")))).isEqualTo(SqlDecimal.decimal((String)"00", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(2))").binding("a", "false")))).isEqualTo(SqlDecimal.decimal((String)"00", (DecimalType)DecimalType.createDecimalType((int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL)").binding("a", "false")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)38)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(18, 0))").binding("a", "true")))).isEqualTo(SqlDecimal.decimal((String)"000000000000000001", (DecimalType)DecimalType.createDecimalType((int)18)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(18, 2))").binding("a", "false")))).isEqualTo(SqlDecimal.decimal((String)"0000000000000000.00", (DecimalType)DecimalType.createDecimalType((int)18, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(20, 10))").binding("a", "true")))).isEqualTo(SqlDecimal.decimal((String)"0000000001.0000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)10)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(20, 10))").binding("a", "false")))).isEqualTo(SqlDecimal.decimal((String)"0000000000.0000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)10)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(30, 20))").binding("a", "true")))).isEqualTo(SqlDecimal.decimal((String)"0000000001.00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)30, (int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(30, 20))").binding("a", "false")))).isEqualTo(SqlDecimal.decimal((String)"0000000000.00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)30, (int)20)));
    }

    @Test
    public void testDecimalToBooleanCasts() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BOOLEAN)").binding("a", "DECIMAL '1.1'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BOOLEAN)").binding("a", "DECIMAL '-1.1'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BOOLEAN)").binding("a", "DECIMAL '0.0'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BOOLEAN)").binding("a", "DECIMAL '1234567890.1234567890'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BOOLEAN)").binding("a", "DECIMAL '-1234567890.1234567890'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BOOLEAN)").binding("a", "DECIMAL '0.0000000000000000000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BOOLEAN)").binding("a", "DECIMAL '00000000000000001.0'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BOOLEAN)").binding("a", "DECIMAL '000000000000000.000'")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BOOLEAN)").binding("a", "DECIMAL '0000000001.00000000000000000000'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BOOLEAN)").binding("a", "DECIMAL '0000000000.00000000000000000000'")))).isEqualTo(false);
    }

    @Test
    public void testBigintToDecimalCasts() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(4,1))").binding("a", "BIGINT '234'")))).isEqualTo(SqlDecimal.decimal((String)"234.0", (DecimalType)DecimalType.createDecimalType((int)4, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(5,2))").binding("a", "BIGINT '234'")))).isEqualTo(SqlDecimal.decimal((String)"234.00", (DecimalType)DecimalType.createDecimalType((int)5, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(4,0))").binding("a", "BIGINT '234'")))).isEqualTo(SqlDecimal.decimal((String)"0234", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(4,1))").binding("a", "BIGINT '-234'")))).isEqualTo(SqlDecimal.decimal((String)"-234.0", (DecimalType)DecimalType.createDecimalType((int)4, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(4,2))").binding("a", "BIGINT '0'")))).isEqualTo(SqlDecimal.decimal((String)"00.00", (DecimalType)DecimalType.createDecimalType((int)4, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(17, 0))").binding("a", "BIGINT '12345678901234567'")))).isEqualTo(SqlDecimal.decimal((String)"12345678901234567", (DecimalType)DecimalType.createDecimalType((int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(18, 0))").binding("a", "BIGINT '123456789012345679'")))).isEqualTo(SqlDecimal.decimal((String)"123456789012345679", (DecimalType)DecimalType.createDecimalType((int)18)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(20, 10))").binding("a", "BIGINT '1234567890'")))).isEqualTo(SqlDecimal.decimal((String)"1234567890.0000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)10)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(20, 10))").binding("a", "BIGINT '-1234567890'")))).isEqualTo(SqlDecimal.decimal((String)"-1234567890.0000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)10)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(30, 20))").binding("a", "BIGINT '1234567890'")))).isEqualTo(SqlDecimal.decimal((String)"1234567890.00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)30, (int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(30, 20))").binding("a", "BIGINT '-1234567890'")))).isEqualTo(SqlDecimal.decimal((String)"-1234567890.00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)30, (int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(17, 10))").binding("a", "BIGINT '-1234567'")))).isEqualTo(SqlDecimal.decimal((String)"-1234567.0000000000", (DecimalType)DecimalType.createDecimalType((int)17, (int)10)));
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(38,37))").binding("a", "BIGINT '10'").evaluate()).hasMessage("Cannot cast BIGINT '10' to DECIMAL(38, 37)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(17,10))").binding("a", "BIGINT '1234567890'").evaluate()).hasMessage("Cannot cast BIGINT '1234567890' to DECIMAL(17, 10)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(2,1))").binding("a", "BIGINT '123'").evaluate()).hasMessage("Cannot cast BIGINT '123' to DECIMAL(2, 1)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(2,1))").binding("a", "BIGINT '-123'").evaluate()).hasMessage("Cannot cast BIGINT '-123' to DECIMAL(2, 1)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(17,1))").binding("a", "BIGINT '123456789012345678'").evaluate()).hasMessage("Cannot cast BIGINT '123456789012345678' to DECIMAL(17, 1)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(20, 10))").binding("a", "BIGINT '12345678901'").evaluate()).hasMessage("Cannot cast BIGINT '12345678901' to DECIMAL(20, 10)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testIntegerToDecimalCasts() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(4,1))").binding("a", "INTEGER '234'")))).isEqualTo(SqlDecimal.decimal((String)"234.0", (DecimalType)DecimalType.createDecimalType((int)4, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(5,2))").binding("a", "INTEGER '234'")))).isEqualTo(SqlDecimal.decimal((String)"234.00", (DecimalType)DecimalType.createDecimalType((int)5, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(4,0))").binding("a", "INTEGER '234'")))).isEqualTo(SqlDecimal.decimal((String)"0234", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(4,1))").binding("a", "INTEGER '-234'")))).isEqualTo(SqlDecimal.decimal((String)"-234.0", (DecimalType)DecimalType.createDecimalType((int)4, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(4,2))").binding("a", "INTEGER '0'")))).isEqualTo(SqlDecimal.decimal((String)"00.00", (DecimalType)DecimalType.createDecimalType((int)4, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(18,8))").binding("a", "INTEGER '1345678901'")))).isEqualTo(SqlDecimal.decimal((String)"1345678901.00000000", (DecimalType)DecimalType.createDecimalType((int)18, (int)8)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(20, 10))").binding("a", "INTEGER '1234567890'")))).isEqualTo(SqlDecimal.decimal((String)"1234567890.0000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)10)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(20, 10))").binding("a", "INTEGER '-1234567890'")))).isEqualTo(SqlDecimal.decimal((String)"-1234567890.0000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)10)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(30, 20))").binding("a", "INTEGER '1234567890'")))).isEqualTo(SqlDecimal.decimal((String)"1234567890.00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)30, (int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(30, 20))").binding("a", "INTEGER '-1234567890'")))).isEqualTo(SqlDecimal.decimal((String)"-1234567890.00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)30, (int)20)));
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(38,37))").binding("a", "INTEGER '10'").evaluate()).hasMessage("Cannot cast INTEGER '10' to DECIMAL(38, 37)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(17,10))").binding("a", "INTEGER '1234567890'").evaluate()).hasMessage("Cannot cast INTEGER '1234567890' to DECIMAL(17, 10)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(2,1))").binding("a", "INTEGER '123'").evaluate()).hasMessage("Cannot cast INTEGER '123' to DECIMAL(2, 1)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(2,1))").binding("a", "INTEGER '-123'").evaluate()).hasMessage("Cannot cast INTEGER '-123' to DECIMAL(2, 1)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testSmallintToDecimalCasts() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(4,1))").binding("a", "SMALLINT '234'")))).isEqualTo(SqlDecimal.decimal((String)"234.0", (DecimalType)DecimalType.createDecimalType((int)4, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(5,2))").binding("a", "SMALLINT '234'")))).isEqualTo(SqlDecimal.decimal((String)"234.00", (DecimalType)DecimalType.createDecimalType((int)5, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(4,0))").binding("a", "SMALLINT '234'")))).isEqualTo(SqlDecimal.decimal((String)"0234", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(4,1))").binding("a", "SMALLINT '-234'")))).isEqualTo(SqlDecimal.decimal((String)"-234.0", (DecimalType)DecimalType.createDecimalType((int)4, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(4,2))").binding("a", "SMALLINT '0'")))).isEqualTo(SqlDecimal.decimal((String)"00.00", (DecimalType)DecimalType.createDecimalType((int)4, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(20, 10))").binding("a", "SMALLINT '1234'")))).isEqualTo(SqlDecimal.decimal((String)"0000001234.0000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)10)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(20, 10))").binding("a", "SMALLINT '-1234'")))).isEqualTo(SqlDecimal.decimal((String)"-0000001234.0000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)10)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(30, 20))").binding("a", "SMALLINT '1234'")))).isEqualTo(SqlDecimal.decimal((String)"0000001234.00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)30, (int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(30, 20))").binding("a", "SMALLINT '-1234'")))).isEqualTo(SqlDecimal.decimal((String)"-0000001234.00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)30, (int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(18,13))").binding("a", "SMALLINT '12345'")))).isEqualTo(SqlDecimal.decimal((String)"12345.0000000000000", (DecimalType)DecimalType.createDecimalType((int)18, (int)13)));
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(38,37))").binding("a", "SMALLINT '10'").evaluate()).hasMessage("Cannot cast SMALLINT '10' to DECIMAL(38, 37)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(17,14))").binding("a", "SMALLINT '1234'").evaluate()).hasMessage("Cannot cast SMALLINT '1234' to DECIMAL(17, 14)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(2,1))").binding("a", "SMALLINT '123'").evaluate()).hasMessage("Cannot cast SMALLINT '123' to DECIMAL(2, 1)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(2,1))").binding("a", "SMALLINT '-123'").evaluate()).hasMessage("Cannot cast SMALLINT '-123' to DECIMAL(2, 1)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testTinyintToDecimalCasts() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(4,1))").binding("a", "TINYINT '23'")))).isEqualTo(SqlDecimal.decimal((String)"023.0", (DecimalType)DecimalType.createDecimalType((int)4, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(5,2))").binding("a", "TINYINT '23'")))).isEqualTo(SqlDecimal.decimal((String)"023.00", (DecimalType)DecimalType.createDecimalType((int)5, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(4,0))").binding("a", "TINYINT '23'")))).isEqualTo(SqlDecimal.decimal((String)"0023", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(4,1))").binding("a", "TINYINT '-23'")))).isEqualTo(SqlDecimal.decimal((String)"-023.0", (DecimalType)DecimalType.createDecimalType((int)4, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(4,2))").binding("a", "TINYINT '0'")))).isEqualTo(SqlDecimal.decimal((String)"00.00", (DecimalType)DecimalType.createDecimalType((int)4, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(20, 10))").binding("a", "TINYINT '123'")))).isEqualTo(SqlDecimal.decimal((String)"0000000123.0000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)10)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(20, 10))").binding("a", "TINYINT '-123'")))).isEqualTo(SqlDecimal.decimal((String)"-0000000123.0000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)10)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(30, 20))").binding("a", "TINYINT '123'")))).isEqualTo(SqlDecimal.decimal((String)"0000000123.00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)30, (int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(30, 20))").binding("a", "TINYINT '-123'")))).isEqualTo(SqlDecimal.decimal((String)"-0000000123.00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)30, (int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(18,15))").binding("a", "TINYINT '123'")))).isEqualTo(SqlDecimal.decimal((String)"123.000000000000000", (DecimalType)DecimalType.createDecimalType((int)18, (int)15)));
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(38,37))").binding("a", "TINYINT '10'").evaluate()).hasMessage("Cannot cast TINYINT '10' to DECIMAL(38, 37)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(17,15))").binding("a", "TINYINT '123'").evaluate()).hasMessage("Cannot cast TINYINT '123' to DECIMAL(17, 15)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(2,1))").binding("a", "TINYINT '123'").evaluate()).hasMessage("Cannot cast TINYINT '123' to DECIMAL(2, 1)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(2,1))").binding("a", "TINYINT '-123'").evaluate()).hasMessage("Cannot cast TINYINT '-123' to DECIMAL(2, 1)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testDecimalToBigintCasts() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BIGINT)").binding("a", "DECIMAL '2.34'")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BIGINT)").binding("a", "DECIMAL '2.5'")))).isEqualTo(3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BIGINT)").binding("a", "DECIMAL '2.49'")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BIGINT)").binding("a", "DECIMAL '20'")))).isEqualTo(20L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BIGINT)").binding("a", "DECIMAL '1'")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BIGINT)").binding("a", "DECIMAL '0'")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BIGINT)").binding("a", "DECIMAL '-20'")))).isEqualTo(-20L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BIGINT)").binding("a", "DECIMAL '-1'")))).isEqualTo(-1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BIGINT)").binding("a", "DECIMAL '-2.49'")))).isEqualTo(-2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BIGINT)").binding("a", "DECIMAL '-2.5'")))).isEqualTo(-3L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BIGINT)").binding("a", "DECIMAL '0.1234567890123456'")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BIGINT)").binding("a", "DECIMAL '0.9999999999999999'")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BIGINT)").binding("a", "DECIMAL '0.00000000000000000000'")))).isEqualTo(0L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BIGINT)").binding("a", "DECIMAL '0.99999999999999999999'")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BIGINT)").binding("a", "DECIMAL '123.999999999999999'")))).isEqualTo(124L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BIGINT)").binding("a", "DECIMAL '999999999999999999'")))).isEqualTo(999999999999999999L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BIGINT)").binding("a", "DECIMAL '1234567890.1234567890'")))).isEqualTo(1234567890L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as BIGINT)").binding("a", "DECIMAL '-1234567890.1234567890'")))).isEqualTo(-1234567890L);
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as BIGINT)").binding("a", "DECIMAL '12345678901234567890'").evaluate()).hasMessage("Cannot cast '12345678901234567890' to BIGINT")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testDecimalToIntegerCasts() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as INTEGER)").binding("a", "DECIMAL '2.34'")))).isEqualTo(2);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as INTEGER)").binding("a", "DECIMAL '2.5'")))).isEqualTo(3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as INTEGER)").binding("a", "DECIMAL '2.49'")))).isEqualTo(2);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as INTEGER)").binding("a", "DECIMAL '20'")))).isEqualTo(20);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as INTEGER)").binding("a", "DECIMAL '1'")))).isEqualTo(1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as INTEGER)").binding("a", "DECIMAL '0'")))).isEqualTo(0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as INTEGER)").binding("a", "DECIMAL '-20'")))).isEqualTo(-20);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as INTEGER)").binding("a", "DECIMAL '-1'")))).isEqualTo(-1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as INTEGER)").binding("a", "DECIMAL '-2.49'")))).isEqualTo(-2);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as INTEGER)").binding("a", "DECIMAL '-2.5'")))).isEqualTo(-3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as INTEGER)").binding("a", "DECIMAL '0.1234567890123456'")))).isEqualTo(0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as INTEGER)").binding("a", "DECIMAL '0.9999999999999999'")))).isEqualTo(1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as INTEGER)").binding("a", "DECIMAL '0.00000000000000000000'")))).isEqualTo(0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as INTEGER)").binding("a", "DECIMAL '0.99999999999999999999'")))).isEqualTo(1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as INTEGER)").binding("a", "DECIMAL '123.999999999999999'")))).isEqualTo(124);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as INTEGER)").binding("a", "DECIMAL '1234567890.1234567890'")))).isEqualTo(1234567890);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as INTEGER)").binding("a", "DECIMAL '-1234567890.1234567890'")))).isEqualTo(-1234567890);
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as INTEGER)").binding("a", "DECIMAL '12345678901234567890'").evaluate()).hasMessage("Cannot cast '12345678901234567890' to INTEGER")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testDecimalToSmallintCasts() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as SMALLINT)").binding("a", "DECIMAL '2.34'")))).isEqualTo((short)2);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as SMALLINT)").binding("a", "DECIMAL '2.5'")))).isEqualTo((short)3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as SMALLINT)").binding("a", "DECIMAL '2.49'")))).isEqualTo((short)2);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as SMALLINT)").binding("a", "DECIMAL '20'")))).isEqualTo((short)20);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as SMALLINT)").binding("a", "DECIMAL '1'")))).isEqualTo((short)1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as SMALLINT)").binding("a", "DECIMAL '0'")))).isEqualTo((short)0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as SMALLINT)").binding("a", "DECIMAL '-20'")))).isEqualTo((short)-20);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as SMALLINT)").binding("a", "DECIMAL '-1'")))).isEqualTo((short)-1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as SMALLINT)").binding("a", "DECIMAL '-2.49'")))).isEqualTo((short)-2);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as SMALLINT)").binding("a", "DECIMAL '-2.5'")))).isEqualTo((short)-3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as SMALLINT)").binding("a", "DECIMAL '0.1234567890123456'")))).isEqualTo((short)0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as SMALLINT)").binding("a", "DECIMAL '0.9999999999999999'")))).isEqualTo((short)1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as SMALLINT)").binding("a", "DECIMAL '0.00000000000000000000'")))).isEqualTo((short)0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as SMALLINT)").binding("a", "DECIMAL '0.99999999999999999999'")))).isEqualTo((short)1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as SMALLINT)").binding("a", "DECIMAL '123.999999999999999'")))).isEqualTo((short)124);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as SMALLINT)").binding("a", "DECIMAL '1234.1234567890'")))).isEqualTo((short)1234);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as SMALLINT)").binding("a", "DECIMAL '-1234.1234567890'")))).isEqualTo((short)-1234);
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as SMALLINT)").binding("a", "DECIMAL '12345678901234567890'").evaluate()).hasMessage("Cannot cast '12345678901234567890' to SMALLINT")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testDecimalToTinyintCasts() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as TINYINT)").binding("a", "DECIMAL '2.34'")))).isEqualTo((byte)2);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as TINYINT)").binding("a", "DECIMAL '2.5'")))).isEqualTo((byte)3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as TINYINT)").binding("a", "DECIMAL '2.49'")))).isEqualTo((byte)2);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as TINYINT)").binding("a", "DECIMAL '20'")))).isEqualTo((byte)20);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as TINYINT)").binding("a", "DECIMAL '1'")))).isEqualTo((byte)1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as TINYINT)").binding("a", "DECIMAL '0'")))).isEqualTo((byte)0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as TINYINT)").binding("a", "DECIMAL '-20'")))).isEqualTo((byte)-20);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as TINYINT)").binding("a", "DECIMAL '-1'")))).isEqualTo((byte)-1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as TINYINT)").binding("a", "DECIMAL '-2.49'")))).isEqualTo((byte)-2);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as TINYINT)").binding("a", "DECIMAL '-2.5'")))).isEqualTo((byte)-3);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as TINYINT)").binding("a", "DECIMAL '0.1234567890123456'")))).isEqualTo((byte)0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as TINYINT)").binding("a", "DECIMAL '0.9999999999999999'")))).isEqualTo((byte)1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as TINYINT)").binding("a", "DECIMAL '0.00000000000000000000'")))).isEqualTo((byte)0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as TINYINT)").binding("a", "DECIMAL '0.99999999999999999999'")))).isEqualTo((byte)1);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as TINYINT)").binding("a", "DECIMAL '123.999999999999999'")))).isEqualTo((byte)124);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as TINYINT)").binding("a", "DECIMAL '12.1234567890'")))).isEqualTo((byte)12);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as TINYINT)").binding("a", "DECIMAL '-12.1234567890'")))).isEqualTo((byte)-12);
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as TINYINT)").binding("a", "DECIMAL '12345678901234567890'").evaluate()).hasMessage("Cannot cast '12345678901234567890' to TINYINT")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testDoubleToShortDecimalCasts() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(4,1))").binding("a", "DOUBLE '234.0'")))).isEqualTo(SqlDecimal.decimal((String)"234.0", (DecimalType)DecimalType.createDecimalType((int)4, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(3,3))").binding("a", "DOUBLE '.01'")))).isEqualTo(SqlDecimal.decimal((String)".010", (DecimalType)DecimalType.createDecimalType((int)3, (int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(3,3))").binding("a", "DOUBLE '.0'")))).isEqualTo(SqlDecimal.decimal((String)".000", (DecimalType)DecimalType.createDecimalType((int)3, (int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(1,0))").binding("a", "DOUBLE '0.0'")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(4,0))").binding("a", "DOUBLE '0.0'")))).isEqualTo(SqlDecimal.decimal((String)"0000", (DecimalType)DecimalType.createDecimalType((int)4, (int)0)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(4,0))").binding("a", "DOUBLE '1000.0'")))).isEqualTo(SqlDecimal.decimal((String)"1000", (DecimalType)DecimalType.createDecimalType((int)4, (int)0)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(7,2))").binding("a", "DOUBLE '1000.01'")))).isEqualTo(SqlDecimal.decimal((String)"01000.01", (DecimalType)DecimalType.createDecimalType((int)7, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(3,0))").binding("a", "DOUBLE '-234.0'")))).isEqualTo(SqlDecimal.decimal((String)"-234", (DecimalType)DecimalType.createDecimalType((int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(16,0))").binding("a", "DOUBLE '1234567890123456.0'")))).isEqualTo(SqlDecimal.decimal((String)"1234567890123456", (DecimalType)DecimalType.createDecimalType((int)16)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(16,0))").binding("a", "DOUBLE '-1234567890123456.0'")))).isEqualTo(SqlDecimal.decimal((String)"-1234567890123456", (DecimalType)DecimalType.createDecimalType((int)16)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(17,0))").binding("a", "DOUBLE '1234567890123456.0'")))).isEqualTo(SqlDecimal.decimal((String)"01234567890123456", (DecimalType)DecimalType.createDecimalType((int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(17,0))").binding("a", "DOUBLE '-1234567890123456.0'")))).isEqualTo(SqlDecimal.decimal((String)"-01234567890123456", (DecimalType)DecimalType.createDecimalType((int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(20,10))").binding("a", "DOUBLE '1234567890.0'")))).isEqualTo(SqlDecimal.decimal((String)"1234567890.0000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)10)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(20,10))").binding("a", "DOUBLE '-1234567890.0'")))).isEqualTo(SqlDecimal.decimal((String)"-1234567890.0000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)10)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(30,20))").binding("a", "DOUBLE '1234567890.0'")))).isEqualTo(SqlDecimal.decimal((String)"1234567890.00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)30, (int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(30,20))").binding("a", "DOUBLE '-1234567890.0'")))).isEqualTo(SqlDecimal.decimal((String)"-1234567890.00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)30, (int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(18,0))").binding("a", "DOUBLE '123456789123456784'")))).isEqualTo(SqlDecimal.decimal((String)"123456789123456780", (DecimalType)DecimalType.createDecimalType((int)18)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(18,9))").binding("a", "DOUBLE '123456789.123456790'")))).isEqualTo(SqlDecimal.decimal((String)"123456789.123456790", (DecimalType)DecimalType.createDecimalType((int)18, (int)9)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(16,0))").binding("a", "DOUBLE '1234567890.49'")))).isEqualTo(SqlDecimal.decimal((String)"0000001234567890", (DecimalType)DecimalType.createDecimalType((int)16)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(16,0))").binding("a", "DOUBLE '1234567890.51'")))).isEqualTo(SqlDecimal.decimal((String)"0000001234567891", (DecimalType)DecimalType.createDecimalType((int)16)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(16,0))").binding("a", "DOUBLE '-1234567890.49'")))).isEqualTo(SqlDecimal.decimal((String)"-0000001234567890", (DecimalType)DecimalType.createDecimalType((int)16)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(16,0))").binding("a", "DOUBLE '-1234567890.51'")))).isEqualTo(SqlDecimal.decimal((String)"-0000001234567891", (DecimalType)DecimalType.createDecimalType((int)16)));
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(17,16))").binding("a", "DOUBLE '100.02'").evaluate()).hasMessage("Cannot cast DOUBLE '100.02' to DECIMAL(17, 16)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(2,0))").binding("a", "DOUBLE '234.0'").evaluate()).hasMessage("Cannot cast DOUBLE '234.0' to DECIMAL(2, 0)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(5,2))").binding("a", "DOUBLE '1000.01'").evaluate()).hasMessage("Cannot cast DOUBLE '1000.01' to DECIMAL(5, 2)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(2,0))").binding("a", "DOUBLE '-234.0'").evaluate()).hasMessage("Cannot cast DOUBLE '-234.0' to DECIMAL(2, 0)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(17,16))").binding("a", "infinity()").evaluate()).hasMessage("Cannot cast DOUBLE 'Infinity' to DECIMAL(17, 16)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(10,5))").binding("a", "nan()").evaluate()).hasMessage("Cannot cast DOUBLE 'NaN' to DECIMAL(10, 5)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(10,1))").binding("a", "infinity()").evaluate()).hasMessage("Cannot cast DOUBLE 'Infinity' to DECIMAL(10, 1)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(1,1))").binding("a", "-infinity()").evaluate()).hasMessage("Cannot cast DOUBLE '-Infinity' to DECIMAL(1, 1)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testDoubleToLongDecimalCasts() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(20,1))").binding("a", "DOUBLE '234.0'")))).isEqualTo(SqlDecimal.decimal((String)"0000000000000000234.0", (DecimalType)DecimalType.createDecimalType((int)20, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(20,5))").binding("a", "DOUBLE '.25'")))).isEqualTo(SqlDecimal.decimal((String)"000000000000000.25000", (DecimalType)DecimalType.createDecimalType((int)20, (int)5)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(20,3))").binding("a", "DOUBLE '.01'")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000.010", (DecimalType)DecimalType.createDecimalType((int)20, (int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(20,3))").binding("a", "DOUBLE '.0'")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000.000", (DecimalType)DecimalType.createDecimalType((int)20, (int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(20,0))").binding("a", "DOUBLE '0.0'")))).isEqualTo(SqlDecimal.decimal((String)"00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(20,2))").binding("a", "DOUBLE '1000.01'")))).isEqualTo(SqlDecimal.decimal((String)"000000000000001000.01", (DecimalType)DecimalType.createDecimalType((int)20, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(20,0))").binding("a", "DOUBLE '-234.0'")))).isEqualTo(SqlDecimal.decimal((String)"-00000000000000000234", (DecimalType)DecimalType.createDecimalType((int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(20,0))").binding("a", "DOUBLE '12345678901234567.0'")))).isEqualTo(SqlDecimal.decimal((String)"00012345678901234568", (DecimalType)DecimalType.createDecimalType((int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(20,0))").binding("a", "DOUBLE '-12345678901234567.0'")))).isEqualTo(SqlDecimal.decimal((String)"-00012345678901234568", (DecimalType)DecimalType.createDecimalType((int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(20,10))").binding("a", "DOUBLE '1234567890.0'")))).isEqualTo(SqlDecimal.decimal((String)"1234567890.0000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)10)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(20,10))").binding("a", "DOUBLE '-1234567890.0'")))).isEqualTo(SqlDecimal.decimal((String)"-1234567890.0000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)10)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(16,0))").binding("a", "DOUBLE '1234567890123456.9'")))).isEqualTo(SqlDecimal.decimal((String)"1234567890123457", (DecimalType)DecimalType.createDecimalType((int)16)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(16,0))").binding("a", "DOUBLE '-1234567890123456.9'")))).isEqualTo(SqlDecimal.decimal((String)"-1234567890123457", (DecimalType)DecimalType.createDecimalType((int)16)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(30,5))").binding("a", "DOUBLE '1234567890123456789012345'")))).isEqualTo(SqlDecimal.decimal((String)"1234567890123456800000000.00000", (DecimalType)DecimalType.createDecimalType((int)30, (int)5)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(30,5))").binding("a", "DOUBLE '-1234567890123456789012345'")))).isEqualTo(SqlDecimal.decimal((String)"-1234567890123456800000000.00000", (DecimalType)DecimalType.createDecimalType((int)30, (int)5)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(30,5))").binding("a", "DOUBLE '1.2345678901234568E24'")))).isEqualTo(SqlDecimal.decimal((String)"1234567890123456800000000.00000", (DecimalType)DecimalType.createDecimalType((int)30, (int)5)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(30,5))").binding("a", "DOUBLE '-1.2345678901234568E24'")))).isEqualTo(SqlDecimal.decimal((String)"-1234567890123456800000000.00000", (DecimalType)DecimalType.createDecimalType((int)30, (int)5)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(30,30))").binding("a", "DOUBLE '.1234567890123456789012345'")))).isEqualTo(SqlDecimal.decimal((String)".123456789012345680000000000000", (DecimalType)DecimalType.createDecimalType((int)30, (int)30)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(30,30))").binding("a", "DOUBLE '-.1234567890123456789012345'")))).isEqualTo(SqlDecimal.decimal((String)"-.123456789012345680000000000000", (DecimalType)DecimalType.createDecimalType((int)30, (int)30)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(CAST(DOUBLE '1234567890123456789012345' AS DECIMAL(30,5)) as DOUBLE) = DOUBLE '1234567890123456789012345'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(CAST(DOUBLE '1.2345678901234568E24' AS DECIMAL(30,5)) as DOUBLE) = DOUBLE '1.2345678901234568E24'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(20,0))").binding("a", "DOUBLE '1234567890.49'")))).isEqualTo(SqlDecimal.decimal((String)"00000000001234567890", (DecimalType)DecimalType.createDecimalType((int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(20,0))").binding("a", "DOUBLE '1234567890.51'")))).isEqualTo(SqlDecimal.decimal((String)"00000000001234567891", (DecimalType)DecimalType.createDecimalType((int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(20,0))").binding("a", "DOUBLE '-1234567890.49'")))).isEqualTo(SqlDecimal.decimal((String)"-00000000001234567890", (DecimalType)DecimalType.createDecimalType((int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(20,0))").binding("a", "DOUBLE '-1234567890.51'")))).isEqualTo(SqlDecimal.decimal((String)"-00000000001234567891", (DecimalType)DecimalType.createDecimalType((int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(10,0))").binding("a", "DOUBLE '1234567890.49'")))).isEqualTo(SqlDecimal.decimal((String)"1234567890", (DecimalType)DecimalType.createDecimalType((int)10)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(10,0))").binding("a", "DOUBLE '1234567890.51'")))).isEqualTo(SqlDecimal.decimal((String)"1234567891", (DecimalType)DecimalType.createDecimalType((int)10)));
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(38,37))").binding("a", "DOUBLE '100.02'").evaluate()).hasMessage("Cannot cast DOUBLE '100.02' to DECIMAL(38, 37)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(20,0))").binding("a", "DOUBLE '234000000000000000000.0'").evaluate()).hasMessage("Cannot cast DOUBLE '2.34E20' to DECIMAL(20, 0)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(20,2))").binding("a", "DOUBLE '1000000000000000000.01'").evaluate()).hasMessage("Cannot cast DOUBLE '1.0E18' to DECIMAL(20, 2)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(20,0))").binding("a", "DOUBLE '-234000000000000000000.0'").evaluate()).hasMessage("Cannot cast DOUBLE '-2.34E20' to DECIMAL(20, 0)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(20, 10))").binding("a", "DOUBLE '12345678901.1'").evaluate()).hasMessage("Cannot cast DOUBLE '1.23456789011E10' to DECIMAL(20, 10)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(38,37))").binding("a", "infinity()").evaluate()).hasMessage("Cannot cast DOUBLE 'Infinity' to DECIMAL(38, 37)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(38,10))").binding("a", "nan()").evaluate()).hasMessage("Cannot cast DOUBLE 'NaN' to DECIMAL(38, 10)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(38,2))").binding("a", "infinity()").evaluate()).hasMessage("Cannot cast DOUBLE 'Infinity' to DECIMAL(38, 2)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(38,1))").binding("a", "-infinity()").evaluate()).hasMessage("Cannot cast DOUBLE '-Infinity' to DECIMAL(38, 1)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(10,5))").binding("a", "nan()").evaluate()).hasMessage("Cannot cast DOUBLE 'NaN' to DECIMAL(10, 5)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(10,1))").binding("a", "infinity()").evaluate()).hasMessage("Cannot cast DOUBLE 'Infinity' to DECIMAL(10, 1)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(1,1))").binding("a", "-infinity()").evaluate()).hasMessage("Cannot cast DOUBLE '-Infinity' to DECIMAL(1, 1)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testDecimalToDoubleCasts() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DOUBLE)").binding("a", "DECIMAL '2.34'")))).isEqualTo(2.34);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DOUBLE)").binding("a", "DECIMAL '0'")))).isEqualTo(0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DOUBLE)").binding("a", "DECIMAL '1'")))).isEqualTo(1.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DOUBLE)").binding("a", "DECIMAL '-2.49'")))).isEqualTo(-2.49);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DOUBLE)").binding("a", "DECIMAL '123456789123456784'")))).isEqualTo(1.2345678912345678E17);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DOUBLE)").binding("a", "DECIMAL '123456789.123456791'")))).isEqualTo(1.2345678912345679E8);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a AS DOUBLE)").binding("a", "CAST(DECIMAL '0' as DECIMAL(20, 2))")))).isEqualTo(0.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a AS DOUBLE)").binding("a", "CAST(DECIMAL '12.12' as DECIMAL(20, 2))")))).isEqualTo(12.12);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DOUBLE)").binding("a", "DECIMAL '1234567890.1234567890'")))).isEqualTo(1.2345678901234567E9);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DOUBLE)").binding("a", "DECIMAL '-1234567890.1234567890'")))).isEqualTo(-1.2345678901234567E9);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DOUBLE)").binding("a", "DECIMAL '1234567890.12345678900000000000'")))).isEqualTo(1.2345678901234567E9);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DOUBLE)").binding("a", "DECIMAL '-1234567890.12345678900000000000'")))).isEqualTo(-1.2345678901234567E9);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DOUBLE)").binding("a", "DECIMAL '-1234567890123456789012345678'")))).isEqualTo(-1.2345678901234569E27);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DOUBLE)").binding("a", "DECIMAL '99999999999999999999999999999999999999'")))).isEqualTo(1.0E38);
    }

    @Test
    public void testFloatToDecimalCasts() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(4,1))").binding("a", "REAL '234.0'")))).isEqualTo(SqlDecimal.decimal((String)"234.0", (DecimalType)DecimalType.createDecimalType((int)4, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(3,3))").binding("a", "REAL '.01'")))).isEqualTo(SqlDecimal.decimal((String)".010", (DecimalType)DecimalType.createDecimalType((int)3, (int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(3,3))").binding("a", "REAL '.0'")))).isEqualTo(SqlDecimal.decimal((String)".000", (DecimalType)DecimalType.createDecimalType((int)3, (int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(1,0))").binding("a", "REAL '0'")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(4,0))").binding("a", "REAL '0'")))).isEqualTo(SqlDecimal.decimal((String)"0000", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(4,0))").binding("a", "REAL '1000'")))).isEqualTo(SqlDecimal.decimal((String)"1000", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(7,2))").binding("a", "REAL '1000.01'")))).isEqualTo(SqlDecimal.decimal((String)"01000.01", (DecimalType)DecimalType.createDecimalType((int)7, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(3,0))").binding("a", "REAL '-234.0'")))).isEqualTo(SqlDecimal.decimal((String)"-234", (DecimalType)DecimalType.createDecimalType((int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(17,0))").binding("a", "REAL '12345678400000000'")))).isEqualTo(SqlDecimal.decimal((String)"12345678000000000", (DecimalType)DecimalType.createDecimalType((int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(17,0))").binding("a", "REAL '-12345678400000000'")))).isEqualTo(SqlDecimal.decimal((String)"-12345678000000000", (DecimalType)DecimalType.createDecimalType((int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(20,10))").binding("a", "REAL '1234567940'")))).isEqualTo(SqlDecimal.decimal((String)"1234568000.0000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)10)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(20,10))").binding("a", "REAL '-1234567940'")))).isEqualTo(SqlDecimal.decimal((String)"-1234568000.0000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)10)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(30,20))").binding("a", "REAL '1234567940'")))).isEqualTo(SqlDecimal.decimal((String)"1234568000.00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)30, (int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(30,20))").binding("a", "REAL '-1234567940'")))).isEqualTo(SqlDecimal.decimal((String)"-1234568000.00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)30, (int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(18,0))").binding("a", "REAL '123456790519087104'")))).isEqualTo(SqlDecimal.decimal((String)"123456790000000000", (DecimalType)DecimalType.createDecimalType((int)18)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(18,0))").binding("a", "REAL '-123456790519087104'")))).isEqualTo(SqlDecimal.decimal((String)"-123456790000000000", (DecimalType)DecimalType.createDecimalType((int)18)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(20,2))").binding("a", "REAL '123456790519087104'")))).isEqualTo(SqlDecimal.decimal((String)"123456790000000000.00", (DecimalType)DecimalType.createDecimalType((int)20, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(20,2))").binding("a", "REAL '-123456790519087104'")))).isEqualTo(SqlDecimal.decimal((String)"-123456790000000000.00", (DecimalType)DecimalType.createDecimalType((int)20, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(18,2))").binding("a", "REAL '1234567905190871'")))).isEqualTo(SqlDecimal.decimal((String)"1234568000000000.00", (DecimalType)DecimalType.createDecimalType((int)18, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(18,2))").binding("a", "REAL '-1234567905190871'")))).isEqualTo(SqlDecimal.decimal((String)"-1234568000000000.00", (DecimalType)DecimalType.createDecimalType((int)18, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(18,9))").binding("a", "REAL '1456213.432632456'")))).isEqualTo(SqlDecimal.decimal((String)"001456213.400000000", (DecimalType)DecimalType.createDecimalType((int)18, (int)9)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(CAST(DOUBLE '123456790519087104' AS DECIMAL(18,0)) as DOUBLE) = DOUBLE '123456790519087104'")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(CAST(DOUBLE '123456790519087104' AS DECIMAL(30,0)) as DOUBLE) = DOUBLE '123456790519087104'")))).isEqualTo(true);
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(38,37))").binding("a", "REAL '100.02'").evaluate()).hasMessage("Cannot cast REAL '100.02' to DECIMAL(38, 37)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(17,16))").binding("a", "REAL '100.02'").evaluate()).hasMessage("Cannot cast REAL '100.02' to DECIMAL(17, 16)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(2,0))").binding("a", "REAL '234.0'").evaluate()).hasMessage("Cannot cast REAL '234.0' to DECIMAL(2, 0)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(5,2))").binding("a", "REAL '1000.01'").evaluate()).hasMessage("Cannot cast REAL '1000.01' to DECIMAL(5, 2)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(2,0))").binding("a", "REAL '-234.0'").evaluate()).hasMessage("Cannot cast REAL '-234.0' to DECIMAL(2, 0)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(20, 10))").binding("a", "REAL '98765430784.0'").evaluate()).hasMessage("Cannot cast REAL '9.876543E10' to DECIMAL(20, 10)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a AS DECIMAL(10,5))").binding("a", "CAST(nan() as REAL)").evaluate()).hasMessage("Cannot cast REAL 'NaN' to DECIMAL(10, 5)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a AS DECIMAL(10,1))").binding("a", "CAST(infinity() as REAL)").evaluate()).hasMessage("Cannot cast REAL 'Infinity' to DECIMAL(10, 1)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a AS DECIMAL(1,1))").binding("a", "CAST(-infinity() as REAL)").evaluate()).hasMessage("Cannot cast REAL '-Infinity' to DECIMAL(1, 1)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a AS DECIMAL(38,10))").binding("a", "CAST(nan() as REAL)").evaluate()).hasMessage("Cannot cast REAL 'NaN' to DECIMAL(38, 10)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a AS DECIMAL(38,2))").binding("a", "CAST(infinity() as REAL)").evaluate()).hasMessage("Cannot cast REAL 'Infinity' to DECIMAL(38, 2)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a AS DECIMAL(38,1))").binding("a", "CAST(-infinity() as REAL)").evaluate()).hasMessage("Cannot cast REAL '-Infinity' to DECIMAL(38, 1)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testDecimalToFloatCasts() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as REAL)").binding("a", "DECIMAL '2.34'")))).isEqualTo(Float.valueOf(2.34f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as REAL)").binding("a", "DECIMAL '0'")))).isEqualTo(Float.valueOf(0.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as REAL)").binding("a", "DECIMAL '-0'")))).isEqualTo(Float.valueOf(0.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as REAL)").binding("a", "DECIMAL '1'")))).isEqualTo(Float.valueOf(1.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as REAL)").binding("a", "DECIMAL '-2.49'")))).isEqualTo(Float.valueOf(-2.49f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as REAL)").binding("a", "DECIMAL '123456790519087104'")))).isEqualTo(Float.valueOf(1.2345679E17f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as REAL)").binding("a", "DECIMAL '121456.213432632456'")))).isEqualTo(Float.valueOf(121456.21f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a AS REAL)").binding("a", "CAST(DECIMAL '0' as DECIMAL(20, 2))")))).isEqualTo(Float.valueOf(0.0f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a AS REAL)").binding("a", "CAST(DECIMAL '12.12' as DECIMAL(20, 2))")))).isEqualTo(Float.valueOf(12.12f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as REAL)").binding("a", "DECIMAL '1234567890.1234567890'")))).isEqualTo(Float.valueOf(1.234568E9f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as REAL)").binding("a", "DECIMAL '-1234567890.1234567890'")))).isEqualTo(Float.valueOf(-1.234568E9f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as REAL)").binding("a", "DECIMAL '1234567890.12345678900000000000'")))).isEqualTo(Float.valueOf(1.234568E9f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as REAL)").binding("a", "DECIMAL '-1234567890.12345678900000000000'")))).isEqualTo(Float.valueOf(-1.234568E9f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as REAL)").binding("a", "DECIMAL '-1234567890123456789012345678'")))).isEqualTo(Float.valueOf(-1.2345679E27f));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as REAL)").binding("a", "DECIMAL '99999999999999999999999999999999999999'")))).isEqualTo(Float.valueOf(1.0E38f));
    }

    @Test
    public void testVarcharToDecimalCasts() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(4,1))").binding("a", "'234.0'")))).isEqualTo(SqlDecimal.decimal((String)"234.0", (DecimalType)DecimalType.createDecimalType((int)4, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(3,3))").binding("a", "'.01'")))).isEqualTo(SqlDecimal.decimal((String)".010", (DecimalType)DecimalType.createDecimalType((int)3, (int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(3,3))").binding("a", "'.0'")))).isEqualTo(SqlDecimal.decimal((String)".000", (DecimalType)DecimalType.createDecimalType((int)3, (int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(1,0))").binding("a", "'0'")))).isEqualTo(SqlDecimal.decimal((String)"0", (DecimalType)DecimalType.createDecimalType((int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(4,0))").binding("a", "'0'")))).isEqualTo(SqlDecimal.decimal((String)"0000", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(4,0))").binding("a", "'1000'")))).isEqualTo(SqlDecimal.decimal((String)"1000", (DecimalType)DecimalType.createDecimalType((int)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(7,2))").binding("a", "'1000.01'")))).isEqualTo(SqlDecimal.decimal((String)"01000.01", (DecimalType)DecimalType.createDecimalType((int)7, (int)2)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(3,0))").binding("a", "'-234.0'")))).isEqualTo(SqlDecimal.decimal((String)"-234", (DecimalType)DecimalType.createDecimalType((int)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(17,0))").binding("a", "'12345678901234567'")))).isEqualTo(SqlDecimal.decimal((String)"12345678901234567", (DecimalType)DecimalType.createDecimalType((int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(18,0))").binding("a", "'123456789012345679'")))).isEqualTo(SqlDecimal.decimal((String)"123456789012345679", (DecimalType)DecimalType.createDecimalType((int)18)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(18,8))").binding("a", "'1234567890.12345679'")))).isEqualTo(SqlDecimal.decimal((String)"1234567890.12345679", (DecimalType)DecimalType.createDecimalType((int)18, (int)8)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(17,0))").binding("a", "'-12345678901234567'")))).isEqualTo(SqlDecimal.decimal((String)"-12345678901234567", (DecimalType)DecimalType.createDecimalType((int)17)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(20,10))").binding("a", "'1234567890'")))).isEqualTo(SqlDecimal.decimal((String)"1234567890.0000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)10)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(20,10))").binding("a", "'-1234567890'")))).isEqualTo(SqlDecimal.decimal((String)"-1234567890.0000000000", (DecimalType)DecimalType.createDecimalType((int)20, (int)10)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(30,20))").binding("a", "'1234567890'")))).isEqualTo(SqlDecimal.decimal((String)"1234567890.00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)30, (int)20)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as DECIMAL(30,20))").binding("a", "'-1234567890'")))).isEqualTo(SqlDecimal.decimal((String)"-1234567890.00000000000000000000", (DecimalType)DecimalType.createDecimalType((int)30, (int)20)));
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(2,0))").binding("a", "'234.0'").evaluate()).hasMessage("Cannot cast VARCHAR '234.0' to DECIMAL(2, 0). Value too large.")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(5,2))").binding("a", "'1000.01'").evaluate()).hasMessage("Cannot cast VARCHAR '1000.01' to DECIMAL(5, 2). Value too large.")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(2,0))").binding("a", "'-234.0'").evaluate()).hasMessage("Cannot cast VARCHAR '-234.0' to DECIMAL(2, 0). Value too large.")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(20, 10))").binding("a", "'12345678901'").evaluate()).hasMessage("Cannot cast VARCHAR '12345678901' to DECIMAL(20, 10). Value too large.")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL(2, 0))").binding("a", "'foo'").evaluate()).hasMessage("Cannot cast VARCHAR 'foo' to DECIMAL(2, 0). Value is not a number.")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as DECIMAL)").binding("a", "'bar'").evaluate()).hasMessage("Cannot cast VARCHAR 'bar' to DECIMAL(38, 0). Value is not a number.")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testDecimalToVarcharCasts() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "DECIMAL '2.34'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("2.34");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "DECIMAL '23400'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("23400");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "DECIMAL '0.0034'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("0.0034");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "DECIMAL '0'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "DECIMAL '0.1234567890123456'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("0.1234567890123456");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "DECIMAL '0.12345678901234567'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("0.12345678901234567");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "DECIMAL '-10'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("-10");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "DECIMAL '-1.0'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("-1.0");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "DECIMAL '-1.00'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("-1.00");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "DECIMAL '-1.00000'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("-1.00000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "DECIMAL '-0.1'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("-0.1");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "DECIMAL '-.001'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("-0.001");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "DECIMAL '-1234567890.1234567'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("-1234567890.1234567");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "DECIMAL '1234567890.1234567890'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1234567890.1234567890");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "DECIMAL '-1234567890.1234567890'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("-1234567890.1234567890");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "DECIMAL '1234567890.12345678900000000000'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("1234567890.12345678900000000000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as VARCHAR)").binding("a", "DECIMAL '-1234567890.12345678900000000000'")))).hasType((Type)VarcharType.VARCHAR).isEqualTo("-1234567890.12345678900000000000");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar(4))").binding("a", "DECIMAL '12.4'")))).hasType((Type)VarcharType.createVarcharType((int)4)).isEqualTo("12.4");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar(50))").binding("a", "DECIMAL '12.4'")))).hasType((Type)VarcharType.createVarcharType((int)50)).isEqualTo("12.4");
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as varchar(3))").binding("a", "DECIMAL '12.4'").evaluate()).hasMessage("Value 12.4 cannot be represented as varchar(3)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar(20))").binding("a", "DECIMAL '100000000000000000.1'")))).hasType((Type)VarcharType.createVarcharType((int)20)).isEqualTo("100000000000000000.1");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as varchar(50))").binding("a", "DECIMAL '100000000000000000.1'")))).hasType((Type)VarcharType.createVarcharType((int)50)).isEqualTo("100000000000000000.1");
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as varchar(19))").binding("a", "DECIMAL '100000000000000000.1'").evaluate()).hasMessage("Value 100000000000000000.1 cannot be represented as varchar(19)")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }
}

