/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.ParameterExtractor;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.SessionPropertyManager;
import io.trino.security.AccessControl;
import io.trino.security.SecurityContext;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.SetSession;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;

public class SetSessionTask
implements DataDefinitionTask<SetSession> {
    private final PlannerContext plannerContext;
    private final AccessControl accessControl;
    private final SessionPropertyManager sessionPropertyManager;

    @Inject
    public SetSessionTask(PlannerContext plannerContext, AccessControl accessControl, SessionPropertyManager sessionPropertyManager) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
    }

    @Override
    public String getName() {
        return "SET SESSION";
    }

    @Override
    public ListenableFuture<Void> execute(SetSession statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Object objectValue;
        PropertyMetadata<?> propertyMetadata;
        Session session = stateMachine.getSession();
        QualifiedName propertyName = statement.getName();
        List parts = propertyName.getParts();
        if (parts.size() > 2) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, (Node)statement, "Invalid session property '%s'", propertyName);
        }
        if (parts.size() == 1) {
            this.accessControl.checkCanSetSystemSessionProperty(session.getIdentity(), session.getQueryId(), (String)parts.get(0));
            propertyMetadata = this.sessionPropertyManager.getSystemSessionPropertyMetadata((String)parts.get(0)).orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, (Node)statement, "Session property '%s' does not exist", statement.getName()));
        } else {
            CatalogHandle catalogHandle = MetadataUtil.getRequiredCatalogHandle(this.plannerContext.getMetadata(), stateMachine.getSession(), (Node)statement, (String)parts.get(0));
            this.accessControl.checkCanSetCatalogSessionProperty(SecurityContext.of(session), (String)parts.get(0), (String)parts.get(1));
            propertyMetadata = this.sessionPropertyManager.getConnectorSessionPropertyMetadata(catalogHandle, (String)parts.get(1)).orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, (Node)statement, "Session property '%s' does not exist", statement.getName()));
        }
        Type type = propertyMetadata.getSqlType();
        try {
            objectValue = SessionPropertyManager.evaluatePropertyValue(statement.getValue(), type, session, this.plannerContext, this.accessControl, ParameterExtractor.bindParameters((Statement)statement, parameters));
        }
        catch (TrinoException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, String.format("Unable to set session property '%s' to '%s': %s", propertyName, statement.getValue(), e.getRawMessage()));
        }
        String value = SessionPropertyManager.serializeSessionProperty(type, objectValue);
        try {
            propertyMetadata.decode(objectValue);
        }
        catch (RuntimeException e) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, (Node)statement, "%s", e.getMessage());
        }
        stateMachine.addSetSessionProperties(propertyName.toString(), value);
        return Futures.immediateVoidFuture();
    }
}

