/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.security.AccessControl;
import io.trino.security.SecurityContext;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.security.AccessDeniedException;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.Use;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;

public class UseTask
implements DataDefinitionTask<Use> {
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public UseTask(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "metadata is null");
    }

    @Override
    public String getName() {
        return "USE";
    }

    @Override
    public ListenableFuture<Void> execute(Use statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        String schema;
        CatalogSchemaName name;
        Session session = stateMachine.getSession();
        String catalog = statement.getCatalog().map(identifier -> identifier.getValue().toLowerCase(Locale.ENGLISH)).orElseGet(() -> session.getCatalog().orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.MISSING_CATALOG_NAME, (Node)statement, "Catalog must be specified when session catalog is not set", new Object[0])));
        SecurityContext securityContext = session.toSecurityContext();
        if (this.metadata.getCatalogHandle(session, catalog).isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.CATALOG_NOT_FOUND, "Catalog '%s' not found".formatted(catalog));
        }
        if (!this.hasCatalogAccess(securityContext, catalog)) {
            AccessDeniedException.denyCatalogAccess((String)catalog);
        }
        if (!this.metadata.schemaExists(session, name = new CatalogSchemaName(catalog, schema = statement.getSchema().getValue().toLowerCase(Locale.ENGLISH)))) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Schema does not exist: " + String.valueOf(name));
        }
        if (!this.hasSchemaAccess(securityContext, catalog, schema)) {
            throw new AccessDeniedException("Cannot access schema: " + String.valueOf(name));
        }
        if (statement.getCatalog().isPresent()) {
            stateMachine.setSetCatalog(catalog);
        }
        stateMachine.setSetSchema(schema);
        return Futures.immediateVoidFuture();
    }

    private boolean hasCatalogAccess(SecurityContext securityContext, String catalog) {
        return !this.accessControl.filterCatalogs(securityContext, (Set<String>)ImmutableSet.of((Object)catalog)).isEmpty();
    }

    private boolean hasSchemaAccess(SecurityContext securityContext, String catalog, String schema) {
        return !this.accessControl.filterSchemas(securityContext, catalog, (Set<String>)ImmutableSet.of((Object)schema)).isEmpty();
    }
}

