/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.metadata.ViewColumn;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.security.Identity;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ViewDefinition {
    private final String originalSql;
    private final Optional<String> catalog;
    private final Optional<String> schema;
    private final List<ViewColumn> columns;
    private final Optional<String> comment;
    private final Optional<Identity> runAsIdentity;
    private final List<CatalogSchemaName> path;

    public ViewDefinition(String originalSql, Optional<String> catalog, Optional<String> schema, List<ViewColumn> columns, Optional<String> comment, Optional<Identity> runAsIdentity, List<CatalogSchemaName> path) {
        this.originalSql = Objects.requireNonNull(originalSql, "originalSql is null");
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.columns = List.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        this.comment = Objects.requireNonNull(comment, "comment is null");
        this.runAsIdentity = Objects.requireNonNull(runAsIdentity, "runAsIdentity is null");
        this.path = Objects.requireNonNull(path, "path is null");
        Preconditions.checkArgument((schema.isEmpty() || catalog.isPresent() ? 1 : 0) != 0, (Object)"catalog must be present if schema is present");
        Preconditions.checkArgument((!columns.isEmpty() ? 1 : 0) != 0, (Object)"columns list is empty");
    }

    public String getOriginalSql() {
        return this.originalSql;
    }

    public Optional<String> getCatalog() {
        return this.catalog;
    }

    public Optional<String> getSchema() {
        return this.schema;
    }

    public List<ViewColumn> getColumns() {
        return this.columns;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    public boolean isRunAsInvoker() {
        return this.runAsIdentity.isEmpty();
    }

    public Optional<Identity> getRunAsIdentity() {
        return this.runAsIdentity;
    }

    public List<CatalogSchemaName> getPath() {
        return this.path;
    }

    public ConnectorViewDefinition toConnectorViewDefinition() {
        return new ConnectorViewDefinition(this.originalSql, this.catalog, this.schema, (List)this.columns.stream().map(column -> new ConnectorViewDefinition.ViewColumn(column.name(), column.type(), column.comment())).collect(ImmutableList.toImmutableList()), this.comment, this.runAsIdentity.map(Identity::getUser), this.runAsIdentity.isEmpty(), this.path);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("originalSql", (Object)this.originalSql).add("catalog", this.catalog.orElse(null)).add("schema", this.schema.orElse(null)).add("columns", this.columns).add("comment", this.comment.orElse(null)).add("runAsIdentity", this.runAsIdentity.orElse(null)).add("path", this.path).toString();
    }
}

