/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.discovery.client.DiscoveryBinder;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.jaxrs.JaxrsBinder;
import io.airlift.json.JsonBinder;
import io.airlift.json.JsonCodecBinder;
import io.airlift.slice.Slice;
import io.airlift.stats.GcMonitor;
import io.airlift.stats.JmxGcMonitor;
import io.airlift.stats.PauseMeter;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.FeaturesConfig;
import io.trino.SystemSessionProperties;
import io.trino.SystemSessionPropertiesProvider;
import io.trino.block.BlockJsonSerde;
import io.trino.client.NodeVersion;
import io.trino.connector.system.SystemConnectorModule;
import io.trino.dispatcher.DispatchManager;
import io.trino.event.SplitMonitor;
import io.trino.execution.DynamicFilterConfig;
import io.trino.execution.ExplainAnalyzeContext;
import io.trino.execution.FailureInjector;
import io.trino.execution.LocationFactory;
import io.trino.execution.MemoryRevokingScheduler;
import io.trino.execution.NoOpFailureInjector;
import io.trino.execution.NodeTaskMap;
import io.trino.execution.QueryManagerConfig;
import io.trino.execution.SqlTaskManager;
import io.trino.execution.TableExecuteContextManager;
import io.trino.execution.TaskManagementExecutor;
import io.trino.execution.TaskManagerConfig;
import io.trino.execution.executor.TaskExecutor;
import io.trino.execution.executor.dedicated.ThreadPerDriverTaskExecutor;
import io.trino.execution.executor.timesharing.MultilevelSplitQueue;
import io.trino.execution.executor.timesharing.TimeSharingTaskExecutor;
import io.trino.execution.scheduler.NodeScheduler;
import io.trino.execution.scheduler.NodeSchedulerConfig;
import io.trino.execution.scheduler.TopologyAwareNodeSelectorModule;
import io.trino.execution.scheduler.UniformNodeSelectorModule;
import io.trino.memory.LocalMemoryManager;
import io.trino.memory.LocalMemoryManagerExporter;
import io.trino.memory.MemoryInfo;
import io.trino.memory.MemoryManagerConfig;
import io.trino.memory.MemoryResource;
import io.trino.memory.NodeMemoryConfig;
import io.trino.metadata.BlockEncodingManager;
import io.trino.metadata.DisabledSystemSecurityMetadata;
import io.trino.metadata.DiscoveryNodeManager;
import io.trino.metadata.ForNodeManager;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.HandleJsonModule;
import io.trino.metadata.InternalBlockEncodingSerde;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.metadata.InternalNodeManager;
import io.trino.metadata.LanguageFunctionManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.ProcedureRegistry;
import io.trino.metadata.SystemFunctionBundle;
import io.trino.metadata.SystemSecurityMetadata;
import io.trino.metadata.TableFunctionRegistry;
import io.trino.metadata.TableProceduresRegistry;
import io.trino.metadata.TypeRegistry;
import io.trino.operator.DirectExchangeClientConfig;
import io.trino.operator.DirectExchangeClientFactory;
import io.trino.operator.DirectExchangeClientSupplier;
import io.trino.operator.FlatHashStrategyCompiler;
import io.trino.operator.ForExchange;
import io.trino.operator.GroupByHashPageIndexerFactory;
import io.trino.operator.PagesIndex;
import io.trino.operator.PagesIndexPageSorter;
import io.trino.operator.RetryPolicy;
import io.trino.operator.index.IndexJoinLookupStats;
import io.trino.operator.index.IndexManager;
import io.trino.operator.scalar.json.JsonExistsFunction;
import io.trino.operator.scalar.json.JsonQueryFunction;
import io.trino.operator.scalar.json.JsonValueFunction;
import io.trino.plugin.base.ClosingBinder;
import io.trino.server.AsyncHttpExecutionMBean;
import io.trino.server.CoordinatorModule;
import io.trino.server.DisableHttpCacheDynamicFeature;
import io.trino.server.ExchangeExecutionMBean;
import io.trino.server.ForAsyncHttp;
import io.trino.server.ForStartup;
import io.trino.server.HttpRequestSessionContextFactory;
import io.trino.server.InternalCommunicationHttpClientModule;
import io.trino.server.InternalCommunicationModule;
import io.trino.server.IoExceptionSuppressingWriterInterceptor;
import io.trino.server.PagesInputStreamFactory;
import io.trino.server.PluginInstaller;
import io.trino.server.PluginManager;
import io.trino.server.ProtocolConfig;
import io.trino.server.ServerConfig;
import io.trino.server.ServerInfoResource;
import io.trino.server.ServerPluginsProvider;
import io.trino.server.ServerPluginsProviderConfig;
import io.trino.server.SessionPropertyDefaults;
import io.trino.server.SliceSerialization;
import io.trino.server.StartupStatus;
import io.trino.server.StatusResource;
import io.trino.server.TaskExecutorResource;
import io.trino.server.TaskResource;
import io.trino.server.ThreadResource;
import io.trino.server.ThrowableMapper;
import io.trino.server.WorkerModule;
import io.trino.server.protocol.PreparedStatementEncoder;
import io.trino.server.protocol.spooling.SpoolingServerModule;
import io.trino.server.remotetask.HttpLocationFactory;
import io.trino.spi.PageIndexerFactory;
import io.trino.spi.PageSorter;
import io.trino.spi.VersionEmbedder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import io.trino.spiller.FileSingleStreamSpillerFactory;
import io.trino.spiller.GenericPartitioningSpillerFactory;
import io.trino.spiller.GenericSpillerFactory;
import io.trino.spiller.LocalSpillManager;
import io.trino.spiller.NodeSpillConfig;
import io.trino.spiller.PartitioningSpillerFactory;
import io.trino.spiller.SingleStreamSpillerFactory;
import io.trino.spiller.SpillerFactory;
import io.trino.spiller.SpillerStats;
import io.trino.split.PageSinkManager;
import io.trino.split.PageSinkProvider;
import io.trino.split.PageSourceManager;
import io.trino.split.PageSourceProviderFactory;
import io.trino.split.SplitManager;
import io.trino.sql.PlannerContext;
import io.trino.sql.SqlEnvironmentConfig;
import io.trino.sql.analyzer.SessionTimeProvider;
import io.trino.sql.analyzer.StatementAnalyzerFactory;
import io.trino.sql.gen.ExpressionCompiler;
import io.trino.sql.gen.JoinCompiler;
import io.trino.sql.gen.JoinFilterFunctionCompiler;
import io.trino.sql.gen.OrderingCompiler;
import io.trino.sql.gen.PageFunctionCompiler;
import io.trino.sql.gen.columnar.ColumnarFilterCompiler;
import io.trino.sql.parser.SqlParser;
import io.trino.sql.planner.CompilerConfig;
import io.trino.sql.planner.LocalExecutionPlanner;
import io.trino.sql.planner.NodePartitioningManager;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.sql.planner.RuleStatsRecorder;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolKeyDeserializer;
import io.trino.tracing.ForTracing;
import io.trino.tracing.TracingMetadata;
import io.trino.type.BlockTypeOperators;
import io.trino.type.InternalTypeManager;
import io.trino.type.JsonPath2016Type;
import io.trino.type.TypeDeserializer;
import io.trino.type.TypeOperatorsCache;
import io.trino.type.TypeSignatureDeserializer;
import io.trino.type.TypeSignatureKeyDeserializer;
import io.trino.util.EmbedVersion;
import io.trino.util.FinalizerService;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.weakref.jmx.guice.ExportBinder;

public class ServerMainModule
extends AbstractConfigurationAwareModule {
    private final String nodeVersion;

    public ServerMainModule(String nodeVersion) {
        this.nodeVersion = Objects.requireNonNull(nodeVersion, "nodeVersion is null");
    }

    protected void setup(Binder binder) {
        ServerConfig serverConfig = (ServerConfig)this.buildConfigObject(ServerConfig.class);
        if (serverConfig.isCoordinator()) {
            this.install((Module)new CoordinatorModule());
        } else {
            this.install(new WorkerModule());
        }
        binder.bind(StartupStatus.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfigDefaults(HttpServerConfig.class, httpServerConfig -> httpServerConfig.setHttp2MaxConcurrentStreams(32768));
        binder.bind(PreparedStatementEncoder.class).in(Scopes.SINGLETON);
        binder.bind(HttpRequestSessionContextFactory.class).in(Scopes.SINGLETON);
        this.install((Module)new InternalCommunicationModule());
        this.install((Module)new SpoolingServerModule());
        QueryManagerConfig queryManagerConfig = (QueryManagerConfig)this.buildConfigObject(QueryManagerConfig.class);
        RetryPolicy retryPolicy = queryManagerConfig.getRetryPolicy();
        ConfigBinder.configBinder((Binder)binder).bindConfig(FeaturesConfig.class);
        if (retryPolicy == RetryPolicy.TASK) {
            ConfigBinder.configBinder((Binder)binder).bindConfigDefaults(FeaturesConfig.class, FeaturesConfig::applyFaultTolerantExecutionDefaults);
        }
        ConfigBinder.configBinder((Binder)binder).bindConfig(OptimizerConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(ProtocolConfig.class);
        binder.bind(SqlParser.class).in(Scopes.SINGLETON);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(ThrowableMapper.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(DisableHttpCacheDynamicFeature.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(SqlEnvironmentConfig.class);
        OptionalBinder.newOptionalBinder((Binder)binder, ExplainAnalyzeContext.class);
        binder.bind(StatementAnalyzerFactory.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, SessionTimeProvider.class).setDefault().toInstance((Object)SessionTimeProvider.DEFAULT);
        binder.bind(GcMonitor.class).to(JmxGcMonitor.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(GcMonitor.class).withGeneratedName();
        Multibinder.newSetBinder((Binder)binder, SystemSessionPropertiesProvider.class).addBinding().to(SystemSessionProperties.class);
        binder.bind(SystemSessionProperties.class).in(Scopes.SINGLETON);
        binder.bind(SessionPropertyDefaults.class).in(Scopes.SINGLETON);
        DiscoveryBinder.discoveryBinder((Binder)binder).bindSelector("trino");
        binder.bind(DiscoveryNodeManager.class).in(Scopes.SINGLETON);
        binder.bind(InternalNodeManager.class).to(DiscoveryNodeManager.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(DiscoveryNodeManager.class).withGeneratedName();
        this.install((Module)InternalCommunicationHttpClientModule.internalHttpClientModule("node-manager", ForNodeManager.class).withConfigDefaults(config -> {
            config.setIdleTimeout(new Duration(30.0, TimeUnit.SECONDS));
            config.setRequestTimeout(new Duration(10.0, TimeUnit.SECONDS));
        }).build());
        ConfigBinder.configBinder((Binder)binder).bindConfig(NodeSchedulerConfig.class);
        binder.bind(NodeScheduler.class).in(Scopes.SINGLETON);
        binder.bind(NodeTaskMap.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(NodeScheduler.class).withGeneratedName();
        this.install(ConditionalModule.conditionalModule(NodeSchedulerConfig.class, config -> NodeSchedulerConfig.NodeSchedulerPolicy.UNIFORM == config.getNodeSchedulerPolicy(), (Module)new UniformNodeSelectorModule()));
        this.install(ConditionalModule.conditionalModule(NodeSchedulerConfig.class, config -> NodeSchedulerConfig.NodeSchedulerPolicy.TOPOLOGY == config.getNodeSchedulerPolicy(), (Module)new TopologyAwareNodeSelectorModule()));
        OptionalBinder.newOptionalBinder((Binder)binder, FailureInjector.class).setDefault().to(NoOpFailureInjector.class).in(Scopes.SINGLETON);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(TaskResource.class);
        ExportBinder.newExporter((Binder)binder).export(TaskResource.class).withGeneratedName();
        binder.bind(TaskManagementExecutor.class).in(Scopes.SINGLETON);
        binder.bind(SqlTaskManager.class).in(Scopes.SINGLETON);
        binder.bind(TableExecuteContextManager.class).in(Scopes.SINGLETON);
        binder.bind(MemoryRevokingScheduler.class).in(Scopes.SINGLETON);
        binder.bind(PauseMeter.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(PauseMeter.class).withGeneratedName();
        ConfigBinder.configBinder((Binder)binder).bindConfig(MemoryManagerConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(NodeMemoryConfig.class);
        binder.bind(LocalMemoryManager.class).in(Scopes.SINGLETON);
        binder.bind(LocalMemoryManagerExporter.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, VersionEmbedder.class).setDefault().to(EmbedVersion.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(SqlTaskManager.class).withGeneratedName();
        binder.bind(MultilevelSplitQueue.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(MultilevelSplitQueue.class).withGeneratedName();
        binder.bind(LocalExecutionPlanner.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(CompilerConfig.class);
        binder.bind(ExpressionCompiler.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(ExpressionCompiler.class).withGeneratedName();
        binder.bind(PageFunctionCompiler.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(PageFunctionCompiler.class).withGeneratedName();
        binder.bind(ColumnarFilterCompiler.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(ColumnarFilterCompiler.class).withGeneratedName();
        ConfigBinder.configBinder((Binder)binder).bindConfig(TaskManagerConfig.class);
        TaskManagerConfig taskManagerConfig = (TaskManagerConfig)this.buildConfigObject(TaskManagerConfig.class);
        if (taskManagerConfig.isThreadPerDriverSchedulerEnabled()) {
            binder.bind(TaskExecutor.class).to(ThreadPerDriverTaskExecutor.class).in(Scopes.SINGLETON);
        } else {
            JaxrsBinder.jaxrsBinder((Binder)binder).bind(TaskExecutorResource.class);
            ExportBinder.newExporter((Binder)binder).export(TaskExecutorResource.class).withGeneratedName();
            ExportBinder.newExporter((Binder)binder).export(TimeSharingTaskExecutor.class).withGeneratedName();
            binder.bind(TaskExecutor.class).to(TimeSharingTaskExecutor.class).in(Scopes.SINGLETON);
            binder.bind(TimeSharingTaskExecutor.class).in(Scopes.SINGLETON);
        }
        if (retryPolicy == RetryPolicy.TASK) {
            ConfigBinder.configBinder((Binder)binder).bindConfigDefaults(TaskManagerConfig.class, TaskManagerConfig::applyFaultTolerantExecutionDefaults);
        }
        binder.bind(IndexJoinLookupStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(IndexJoinLookupStats.class).withGeneratedName();
        binder.bind(AsyncHttpExecutionMBean.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(AsyncHttpExecutionMBean.class).withGeneratedName();
        binder.bind(JoinFilterFunctionCompiler.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(JoinFilterFunctionCompiler.class).withGeneratedName();
        binder.bind(JoinCompiler.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(JoinCompiler.class).withGeneratedName();
        binder.bind(FlatHashStrategyCompiler.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(FlatHashStrategyCompiler.class).withGeneratedName();
        binder.bind(OrderingCompiler.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(OrderingCompiler.class).withGeneratedName();
        binder.bind(PagesIndex.Factory.class).to(PagesIndex.DefaultFactory.class);
        binder.bind(PagesInputStreamFactory.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(IoExceptionSuppressingWriterInterceptor.class);
        binder.bind(DirectExchangeClientSupplier.class).to(DirectExchangeClientFactory.class).in(Scopes.SINGLETON);
        this.install((Module)InternalCommunicationHttpClientModule.internalHttpClientModule("exchange", ForExchange.class).withConfigDefaults(config -> {
            config.setIdleTimeout(new Duration(30.0, TimeUnit.SECONDS));
            config.setRequestTimeout(new Duration(10.0, TimeUnit.SECONDS));
            config.setMaxConnectionsPerServer(64);
            config.setMaxContentLength(DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
            config.setMaxRequestsQueuedPerDestination(65536);
        }).build());
        ConfigBinder.configBinder((Binder)binder).bindConfig(DirectExchangeClientConfig.class);
        binder.bind(ExchangeExecutionMBean.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(ExchangeExecutionMBean.class).withGeneratedName();
        binder.bind(LocationFactory.class).to(HttpLocationFactory.class).in(Scopes.SINGLETON);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(MemoryResource.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(MemoryInfo.class);
        binder.bind(PageSourceManager.class).in(Scopes.SINGLETON);
        binder.bind(PageSourceProviderFactory.class).to(PageSourceManager.class).in(Scopes.SINGLETON);
        binder.bind(PageSinkManager.class).in(Scopes.SINGLETON);
        binder.bind(PageSinkProvider.class).to(PageSinkManager.class).in(Scopes.SINGLETON);
        binder.bind(MetadataManager.class).in(Scopes.SINGLETON);
        binder.bind(Metadata.class).annotatedWith(ForTracing.class).to(MetadataManager.class).in(Scopes.SINGLETON);
        binder.bind(Metadata.class).to(TracingMetadata.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, SystemSecurityMetadata.class).setDefault().to(DisabledSystemSecurityMetadata.class).in(Scopes.SINGLETON);
        binder.bind(GlobalFunctionCatalog.class).in(Scopes.SINGLETON);
        binder.bind(TypeOperatorsCache.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(TypeOperatorsCache.class).as(factory -> factory.generatedNameOf(TypeOperators.class));
        binder.bind(BlockTypeOperators.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(TypeOperatorsCache.class).withGeneratedName();
        binder.bind(ProcedureRegistry.class).in(Scopes.SINGLETON);
        binder.bind(TableProceduresRegistry.class).in(Scopes.SINGLETON);
        binder.bind(TableFunctionRegistry.class).in(Scopes.SINGLETON);
        binder.bind(PlannerContext.class).in(Scopes.SINGLETON);
        binder.bind(LanguageFunctionManager.class).in(Scopes.SINGLETON);
        binder.bind(FunctionManager.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, FunctionBundle.class);
        binder.bind(RegisterFunctionBundles.class).asEagerSingleton();
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Type.class).to(TypeDeserializer.class);
        JsonBinder.jsonBinder((Binder)binder).addKeyDeserializerBinding(Symbol.class).to(SymbolKeyDeserializer.class);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(TypeSignature.class).to(TypeSignatureDeserializer.class);
        JsonBinder.jsonBinder((Binder)binder).addKeyDeserializerBinding(TypeSignature.class).to(TypeSignatureKeyDeserializer.class);
        binder.bind(TypeRegistry.class).in(Scopes.SINGLETON);
        binder.bind(TypeManager.class).to(InternalTypeManager.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, Type.class);
        binder.bind(RegisterJsonPath2016Type.class).asEagerSingleton();
        binder.bind(SplitManager.class).in(Scopes.SINGLETON);
        binder.bind(NodePartitioningManager.class).in(Scopes.SINGLETON);
        binder.bind(IndexManager.class).in(Scopes.SINGLETON);
        binder.install((Module)new HandleJsonModule());
        binder.install((Module)new SystemConnectorModule());
        JsonBinder.jsonBinder((Binder)binder).addSerializerBinding(Slice.class).to(SliceSerialization.SliceSerializer.class);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Slice.class).to(SliceSerialization.SliceDeserializer.class);
        binder.bind(SplitMonitor.class).in(Scopes.SINGLETON);
        binder.bind(NodeVersion.class).toInstance((Object)new NodeVersion(this.nodeVersion));
        DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpAnnouncement("trino").addProperty("node_version", this.nodeVersion).addProperty("coordinator", String.valueOf(serverConfig.isCoordinator()));
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(ServerInfoResource.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(StatusResource.class);
        OptionalBinder.newOptionalBinder((Binder)binder, PluginInstaller.class).setDefault().to(PluginManager.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, PluginManager.PluginsProvider.class).setDefault().to(ServerPluginsProvider.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(ServerPluginsProviderConfig.class);
        binder.bind(BlockEncodingManager.class).in(Scopes.SINGLETON);
        JsonBinder.jsonBinder((Binder)binder).addSerializerBinding(Block.class).to(BlockJsonSerde.Serializer.class);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Block.class).to(BlockJsonSerde.Deserializer.class);
        binder.bind(BlockEncodingSerde.class).to(InternalBlockEncodingSerde.class).in(Scopes.SINGLETON);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(ThreadResource.class);
        binder.bind(PageSorter.class).to(PagesIndexPageSorter.class).in(Scopes.SINGLETON);
        binder.bind(PageIndexerFactory.class).to(GroupByHashPageIndexerFactory.class).in(Scopes.SINGLETON);
        binder.bind(FinalizerService.class).in(Scopes.SINGLETON);
        binder.bind(SpillerFactory.class).to(GenericSpillerFactory.class).in(Scopes.SINGLETON);
        binder.bind(SingleStreamSpillerFactory.class).to(FileSingleStreamSpillerFactory.class).in(Scopes.SINGLETON);
        binder.bind(PartitioningSpillerFactory.class).to(GenericPartitioningSpillerFactory.class).in(Scopes.SINGLETON);
        binder.bind(SpillerStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(SpillerStats.class).withGeneratedName();
        binder.bind(LocalSpillManager.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(NodeSpillConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(DynamicFilterConfig.class);
        OptionalBinder.newOptionalBinder((Binder)binder, DispatchManager.class);
        OptionalBinder.newOptionalBinder((Binder)binder, RuleStatsRecorder.class);
        ClosingBinder.closingBinder((Binder)binder).registerExecutor(Key.get(ScheduledExecutorService.class, ForExchange.class));
        ClosingBinder.closingBinder((Binder)binder).registerExecutor(Key.get(ExecutorService.class, ForAsyncHttp.class));
        ClosingBinder.closingBinder((Binder)binder).registerExecutor(Key.get(ScheduledExecutorService.class, ForAsyncHttp.class));
    }

    @ProvidesIntoSet
    @Singleton
    public static FunctionBundle systemFunctionBundle(FeaturesConfig featuresConfig, TypeOperators typeOperators, BlockTypeOperators blockTypeOperators, NodeVersion nodeVersion) {
        return SystemFunctionBundle.create(featuresConfig, typeOperators, blockTypeOperators, nodeVersion);
    }

    @ProvidesIntoSet
    @Singleton
    public static FunctionBundle jsonFunctionBundle(FunctionManager functionManager, Metadata metadata, TypeManager typeManager) {
        return new InternalFunctionBundle(new JsonExistsFunction(functionManager, metadata, typeManager), new JsonValueFunction(functionManager, metadata, typeManager), new JsonQueryFunction(functionManager, metadata, typeManager));
    }

    @Provides
    @Singleton
    public static TypeOperators createTypeOperators(TypeOperatorsCache typeOperatorsCache) {
        return new TypeOperators((BiFunction)typeOperatorsCache);
    }

    @Provides
    @Singleton
    @ForStartup
    public static Executor createStartupExecutor(ServerConfig config) {
        if (!config.isConcurrentStartup()) {
            return MoreExecutors.directExecutor();
        }
        return new BoundedExecutor((Executor)Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"startup-%s")), Runtime.getRuntime().availableProcessors());
    }

    @Provides
    @Singleton
    @ForExchange
    public static ScheduledExecutorService createExchangeExecutor(DirectExchangeClientConfig config) {
        return Executors.newScheduledThreadPool(config.getClientThreads(), Threads.daemonThreadsNamed((String)"exchange-client-%s"));
    }

    @Provides
    @Singleton
    @ForAsyncHttp
    public static ExecutorService createAsyncHttpResponseCoreExecutor() {
        return Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"async-http-response-%s"));
    }

    @Provides
    @Singleton
    @ForAsyncHttp
    public static BoundedExecutor createAsyncHttpResponseExecutor(@ForAsyncHttp ExecutorService coreExecutor, TaskManagerConfig config) {
        return new BoundedExecutor((Executor)coreExecutor, config.getHttpResponseThreads());
    }

    @Provides
    @Singleton
    @ForAsyncHttp
    public static ScheduledExecutorService createAsyncHttpTimeoutExecutor(TaskManagerConfig config) {
        return Executors.newScheduledThreadPool(config.getHttpTimeoutThreads(), Threads.daemonThreadsNamed((String)"async-http-timeout-%s"));
    }

    private static class RegisterFunctionBundles {
        @Inject
        public RegisterFunctionBundles(GlobalFunctionCatalog globalFunctionCatalog, Set<FunctionBundle> functionBundles) {
            for (FunctionBundle functionBundle : functionBundles) {
                globalFunctionCatalog.addFunctions(functionBundle);
            }
        }
    }

    private static class RegisterJsonPath2016Type {
        @Inject
        public RegisterJsonPath2016Type(BlockEncodingSerde blockEncodingSerde, TypeManager typeManager, TypeRegistry typeRegistry) {
            typeRegistry.addType((Type)new JsonPath2016Type(new TypeDeserializer(typeManager), blockEncodingSerde));
        }
    }
}

