/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen.columnar;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.operator.project.SelectedPositions;
import io.trino.spi.Page;
import io.trino.spi.connector.ConnectorSession;
import io.trino.sql.gen.columnar.ColumnarFilterCompiler;
import io.trino.sql.gen.columnar.FilterEvaluator;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SpecialForm;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public final class OrFilterEvaluator
implements FilterEvaluator {
    private final List<FilterEvaluator> subFilterEvaluators;

    public static Optional<Supplier<FilterEvaluator>> createOrExpressionEvaluator(ColumnarFilterCompiler compiler, SpecialForm specialForm) {
        Preconditions.checkArgument((specialForm.form() == SpecialForm.Form.OR ? 1 : 0) != 0, (String)"specialForm %s should be OR", (Object)specialForm);
        Preconditions.checkArgument((specialForm.arguments().size() >= 2 ? 1 : 0) != 0, (String)"OR expression %s should have at least 2 arguments", (Object)specialForm);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (RowExpression expression : specialForm.arguments()) {
            Optional<Supplier<FilterEvaluator>> subExpressionEvaluator = FilterEvaluator.createColumnarFilterEvaluator(expression, compiler);
            if (subExpressionEvaluator.isEmpty()) {
                return Optional.empty();
            }
            builder.add(subExpressionEvaluator.get());
        }
        ImmutableList subExpressionEvaluators = builder.build();
        return Optional.of(() -> OrFilterEvaluator.lambda$createOrExpressionEvaluator$0((List)subExpressionEvaluators));
    }

    private OrFilterEvaluator(List<FilterEvaluator> subFilterEvaluators) {
        Preconditions.checkArgument((subFilterEvaluators.size() >= 2 ? 1 : 0) != 0, (Object)"must have at least 2 subexpressions to OR");
        this.subFilterEvaluators = subFilterEvaluators;
    }

    @Override
    public FilterEvaluator.SelectionResult evaluate(ConnectorSession session, SelectedPositions activePositions, Page page) {
        long filterTimeNanos = 0L;
        FilterEvaluator.SelectionResult result = this.subFilterEvaluators.getFirst().evaluate(session, activePositions, page);
        SelectedPositions accumulatedPositions = result.selectedPositions();
        filterTimeNanos += result.filterTimeNanos();
        activePositions = activePositions.difference(accumulatedPositions);
        for (int index = 1; index < this.subFilterEvaluators.size() - 1; ++index) {
            FilterEvaluator evaluator = this.subFilterEvaluators.get(index);
            result = evaluator.evaluate(session, activePositions, page);
            SelectedPositions selectedPositions = result.selectedPositions();
            filterTimeNanos += result.filterTimeNanos();
            accumulatedPositions = accumulatedPositions.union(selectedPositions);
            activePositions = activePositions.difference(selectedPositions);
        }
        result = this.subFilterEvaluators.getLast().evaluate(session, activePositions, page);
        accumulatedPositions = accumulatedPositions.union(result.selectedPositions());
        return new FilterEvaluator.SelectionResult(accumulatedPositions, filterTimeNanos += result.filterTimeNanos());
    }

    private static /* synthetic */ FilterEvaluator lambda$createOrExpressionEvaluator$0(List subExpressionEvaluators) {
        return new OrFilterEvaluator((List)subExpressionEvaluators.stream().map(Supplier::get).collect(ImmutableList.toImmutableList()));
    }
}

