/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer.rule;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.Type;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.In;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.optimizer.IrOptimizerRule;
import io.trino.sql.planner.DeterminismEvaluator;
import io.trino.sql.planner.Symbol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class RemoveRedundantInItems
implements IrOptimizerRule {
    private final PlannerContext context;
    private final Metadata metadata;

    public RemoveRedundantInItems(PlannerContext context) {
        this.context = context;
        this.metadata = context.getMetadata();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Optional<Expression> apply(Expression expression, Session session, Map<Symbol, Expression> bindings) {
        Object list;
        if (!(expression instanceof In)) return Optional.empty();
        In in = (In)expression;
        Object object = in.value();
        Expression value = object;
        try {
            list = object = in.valueList();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        ArrayList<Expression> cannotFail = new ArrayList<Expression>();
        ArrayList<Expression> mayFail = new ArrayList<Expression>();
        boolean exactMatchFound = false;
        boolean removed = false;
        HashSet<Expression> seen = new HashSet<Expression>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Expression item = (Expression)iterator.next();
            if (seen.contains(item)) {
                removed = true;
                continue;
            }
            if (IrExpressions.mayFail(this.context, item)) {
                mayFail.add(item);
            } else {
                cannotFail.add(item);
            }
            if (!DeterminismEvaluator.isDeterministic(item)) continue;
            exactMatchFound = exactMatchFound || value.equals(item);
            seen.add(item);
        }
        if (exactMatchFound && mayFail.isEmpty()) {
            ResolvedFunction indeterminate = this.metadata.resolveOperator(OperatorType.INDETERMINATE, (List<? extends Type>)ImmutableList.of((Object)value.type()));
            return Optional.of(IrExpressions.ifExpression(new Call(indeterminate, Collections.singletonList(value)), Booleans.NULL_BOOLEAN, Booleans.TRUE));
        }
        if (!removed && list.size() > 1) {
            return Optional.empty();
        }
        ImmutableList newItems = ImmutableList.builder().addAll(cannotFail).addAll(mayFail).build();
        if (newItems.size() != 1) return Optional.of(new In(value, (List<Expression>)newItems));
        return Optional.of(new Comparison(Comparison.Operator.EQUAL, value, (Expression)newItems.getFirst()));
    }
}

