/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.Immutable;
import io.trino.metadata.ResolvedFunction;
import io.trino.sql.ir.Expression;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.FrameBoundType;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.plan.WindowFrameType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@Immutable
public class WindowNode
extends PlanNode {
    private final PlanNode source;
    private final Set<Symbol> prePartitionedInputs;
    private final DataOrganizationSpecification specification;
    private final int preSortedOrderPrefix;
    private final Map<Symbol, Function> windowFunctions;
    private final Optional<Symbol> hashSymbol;

    @JsonCreator
    public WindowNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="specification") DataOrganizationSpecification specification, @JsonProperty(value="windowFunctions") Map<Symbol, Function> windowFunctions, @JsonProperty(value="hashSymbol") Optional<Symbol> hashSymbol, @JsonProperty(value="prePartitionedInputs") Set<Symbol> prePartitionedInputs, @JsonProperty(value="preSortedOrderPrefix") int preSortedOrderPrefix) {
        super(id);
        Objects.requireNonNull(source, "source is null");
        Objects.requireNonNull(specification, "specification is null");
        Objects.requireNonNull(windowFunctions, "windowFunctions is null");
        Objects.requireNonNull(hashSymbol, "hashSymbol is null");
        Objects.requireNonNull(prePartitionedInputs, "prePartitionedInputs is null");
        prePartitionedInputs = ImmutableSet.copyOf(prePartitionedInputs);
        ImmutableSet partitionBy = ImmutableSet.copyOf(specification.partitionBy());
        Optional<OrderingScheme> orderingScheme = specification.orderingScheme();
        Preconditions.checkArgument((boolean)partitionBy.containsAll((Collection)prePartitionedInputs), (Object)"prePartitionedInputs must be contained in partitionBy");
        Preconditions.checkArgument((preSortedOrderPrefix == 0 || orderingScheme.isPresent() && preSortedOrderPrefix <= orderingScheme.get().orderBy().size() ? 1 : 0) != 0, (Object)"Cannot have sorted more symbols than those requested");
        Preconditions.checkArgument((preSortedOrderPrefix == 0 || partitionBy.equals((Object)prePartitionedInputs) ? 1 : 0) != 0, (Object)"preSortedOrderPrefix can only be greater than zero if all partition symbols are pre-partitioned");
        this.source = source;
        this.prePartitionedInputs = prePartitionedInputs;
        this.specification = specification;
        this.windowFunctions = ImmutableMap.copyOf(windowFunctions);
        this.hashSymbol = hashSymbol;
        this.preSortedOrderPrefix = preSortedOrderPrefix;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.copyOf((Iterable)Iterables.concat(this.source.getOutputSymbols(), this.windowFunctions.keySet()));
    }

    public Set<Symbol> getCreatedSymbols() {
        return ImmutableSet.copyOf(this.windowFunctions.keySet());
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public DataOrganizationSpecification getSpecification() {
        return this.specification;
    }

    public List<Symbol> getPartitionBy() {
        return this.specification.partitionBy();
    }

    public Optional<OrderingScheme> getOrderingScheme() {
        return this.specification.orderingScheme();
    }

    @JsonProperty
    public Map<Symbol, Function> getWindowFunctions() {
        return this.windowFunctions;
    }

    public List<Frame> getFrames() {
        return (List)this.windowFunctions.values().stream().map(Function::getFrame).collect(ImmutableList.toImmutableList());
    }

    @JsonProperty
    public Optional<Symbol> getHashSymbol() {
        return this.hashSymbol;
    }

    @JsonProperty
    public Set<Symbol> getPrePartitionedInputs() {
        return this.prePartitionedInputs;
    }

    @JsonProperty
    public int getPreSortedOrderPrefix() {
        return this.preSortedOrderPrefix;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitWindow(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new WindowNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.specification, this.windowFunctions, this.hashSymbol, this.prePartitionedInputs, this.preSortedOrderPrefix);
    }

    @Immutable
    public static final class Function {
        private final ResolvedFunction resolvedFunction;
        private final List<Expression> arguments;
        private final Optional<OrderingScheme> orderingScheme;
        private final Frame frame;
        private final boolean ignoreNulls;

        @JsonCreator
        public Function(@JsonProperty(value="resolvedFunction") ResolvedFunction resolvedFunction, @JsonProperty(value="arguments") List<Expression> arguments, @JsonProperty(value="orderingScheme") Optional<OrderingScheme> orderingScheme, @JsonProperty(value="frame") Frame frame, @JsonProperty(value="ignoreNulls") boolean ignoreNulls) {
            this.resolvedFunction = Objects.requireNonNull(resolvedFunction, "resolvedFunction is null");
            this.arguments = Objects.requireNonNull(arguments, "arguments is null");
            this.orderingScheme = Objects.requireNonNull(orderingScheme, "orderingScheme is null");
            this.frame = Objects.requireNonNull(frame, "frame is null");
            this.ignoreNulls = ignoreNulls;
        }

        @JsonProperty
        public ResolvedFunction getResolvedFunction() {
            return this.resolvedFunction;
        }

        @JsonProperty
        public List<Expression> getArguments() {
            return this.arguments;
        }

        @JsonProperty
        public Optional<OrderingScheme> getOrderingScheme() {
            return this.orderingScheme;
        }

        @JsonProperty
        public Frame getFrame() {
            return this.frame;
        }

        @JsonProperty
        public boolean isIgnoreNulls() {
            return this.ignoreNulls;
        }

        public int hashCode() {
            return Objects.hash(this.resolvedFunction, this.arguments, this.orderingScheme, this.frame, this.ignoreNulls);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Function other = (Function)obj;
            return Objects.equals(this.resolvedFunction, other.resolvedFunction) && Objects.equals(this.arguments, other.arguments) && Objects.equals(this.orderingScheme, other.orderingScheme) && Objects.equals(this.frame, other.frame) && this.ignoreNulls == other.ignoreNulls;
        }
    }

    @Immutable
    public static class Frame {
        public static final Frame DEFAULT_FRAME = new Frame(WindowFrameType.RANGE, FrameBoundType.UNBOUNDED_PRECEDING, Optional.empty(), Optional.empty(), FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty());
        private final WindowFrameType type;
        private final FrameBoundType startType;
        private final Optional<Symbol> startValue;
        private final Optional<Symbol> sortKeyCoercedForFrameStartComparison;
        private final FrameBoundType endType;
        private final Optional<Symbol> endValue;
        private final Optional<Symbol> sortKeyCoercedForFrameEndComparison;

        @JsonCreator
        public Frame(@JsonProperty(value="type") WindowFrameType type, @JsonProperty(value="startType") FrameBoundType startType, @JsonProperty(value="startValue") Optional<Symbol> startValue, @JsonProperty(value="sortKeyCoercedForFrameStartComparison") Optional<Symbol> sortKeyCoercedForFrameStartComparison, @JsonProperty(value="endType") FrameBoundType endType, @JsonProperty(value="endValue") Optional<Symbol> endValue, @JsonProperty(value="sortKeyCoercedForFrameEndComparison") Optional<Symbol> sortKeyCoercedForFrameEndComparison) {
            this.startType = Objects.requireNonNull(startType, "startType is null");
            this.startValue = Objects.requireNonNull(startValue, "startValue is null");
            this.sortKeyCoercedForFrameStartComparison = Objects.requireNonNull(sortKeyCoercedForFrameStartComparison, "sortKeyCoercedForFrameStartComparison is null");
            this.endType = Objects.requireNonNull(endType, "endType is null");
            this.endValue = Objects.requireNonNull(endValue, "endValue is null");
            this.sortKeyCoercedForFrameEndComparison = Objects.requireNonNull(sortKeyCoercedForFrameEndComparison, "sortKeyCoercedForFrameEndComparison is null");
            this.type = Objects.requireNonNull(type, "type is null");
            if (startValue.isPresent() && type == WindowFrameType.RANGE) {
                Preconditions.checkArgument((boolean)sortKeyCoercedForFrameStartComparison.isPresent(), (Object)"for frame of type RANGE, sortKeyCoercedForFrameStartComparison must be present if startValue is present");
            }
            if (endValue.isPresent() && type == WindowFrameType.RANGE) {
                Preconditions.checkArgument((boolean)sortKeyCoercedForFrameEndComparison.isPresent(), (Object)"for frame of type RANGE, sortKeyCoercedForFrameEndComparison must be present if endValue is present");
            }
        }

        @JsonProperty
        public WindowFrameType getType() {
            return this.type;
        }

        @JsonProperty
        public FrameBoundType getStartType() {
            return this.startType;
        }

        @JsonProperty
        public Optional<Symbol> getStartValue() {
            return this.startValue;
        }

        @JsonProperty
        public Optional<Symbol> getSortKeyCoercedForFrameStartComparison() {
            return this.sortKeyCoercedForFrameStartComparison;
        }

        @JsonProperty
        public FrameBoundType getEndType() {
            return this.endType;
        }

        @JsonProperty
        public Optional<Symbol> getEndValue() {
            return this.endValue;
        }

        @JsonProperty
        public Optional<Symbol> getSortKeyCoercedForFrameEndComparison() {
            return this.sortKeyCoercedForFrameEndComparison;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Frame frame = (Frame)o;
            return this.type == frame.type && this.startType == frame.startType && Objects.equals(this.startValue, frame.startValue) && Objects.equals(this.sortKeyCoercedForFrameStartComparison, frame.sortKeyCoercedForFrameStartComparison) && this.endType == frame.endType && Objects.equals(this.endValue, frame.endValue) && Objects.equals(this.sortKeyCoercedForFrameEndComparison, frame.sortKeyCoercedForFrameEndComparison);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.startType, this.startValue, this.sortKeyCoercedForFrameStartComparison, this.endType, this.endValue, this.sortKeyCoercedForFrameEndComparison});
        }
    }
}

